/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.exist.client.Messages;
import org.exist.client.MimeTypeFileFilter;
import org.exist.security.PermissionDeniedException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class CreateBackupDialog
extends JPanel {
    private static final long serialVersionUID = 4571248257313559856L;
    JComboBox collections;
    JTextField backupTarget;
    final String uri;
    final String user;
    final String passwd;
    Path backupDir;
    final String defaultSelectedCollection;

    public CreateBackupDialog(String uri, String user, String passwd, Path backupDir) throws HeadlessException {
        this(uri, user, passwd, backupDir, null);
    }

    public CreateBackupDialog(String uri, String user, String passwd, Path backupDir, String defaultSelectedCollection) throws HeadlessException {
        super(false);
        this.uri = uri;
        this.user = user;
        this.passwd = passwd;
        this.backupDir = backupDir;
        this.defaultSelectedCollection = defaultSelectedCollection;
        this.setupComponents();
        this.setSize(new Dimension(350, 200));
    }

    private void setupComponents() {
        GridBagLayout grid = new GridBagLayout();
        this.setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel(Messages.getString("CreateBackupDialog.1"));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        Vector<String> v = this.getAllCollections();
        Collections.sort(v);
        this.collections = new JComboBox<String>(v);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.collections, c);
        this.add(this.collections);
        if (this.defaultSelectedCollection != null) {
            for (int i = 0; i < this.collections.getItemCount(); ++i) {
                Object col = this.collections.getItemAt(i);
                if (!col.toString().equals(this.defaultSelectedCollection)) continue;
                this.collections.setSelectedIndex(i);
                break;
            }
        }
        label = new JLabel(Messages.getString("CreateBackupDialog.2"));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.backupTarget = new JTextField(this.backupDir.resolve("eXist-backup.zip").toAbsolutePath().toString(), 40);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.backupTarget, c);
        this.add(this.backupTarget);
        JButton select = new JButton(Messages.getString("CreateBackupDialog.3"));
        select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateBackupDialog.this.actionSelect();
            }
        });
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(select, c);
        select.setToolTipText(Messages.getString("CreateBackupDialog.4"));
        this.add(select);
    }

    private void actionSelect() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/zip"));
        chooser.setSelectedFile(Paths.get("eXist-backup.zip", new String[0]).toFile());
        chooser.setCurrentDirectory(this.backupDir.toFile());
        if (chooser.showDialog(this, Messages.getString("CreateBackupDialog.5")) == 0) {
            this.backupTarget.setText(chooser.getSelectedFile().getAbsolutePath());
            this.backupDir = chooser.getCurrentDirectory().toPath();
        }
    }

    private Vector<String> getAllCollections() {
        Vector<String> list = new Vector<String>();
        try {
            Collection root = DatabaseManager.getCollection((String)(this.uri + "/db"), (String)this.user, (String)this.passwd);
            this.getAllCollections(root, list);
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void getAllCollections(Collection collection, Vector<String> collections) throws XMLDBException {
        collections.add(collection.getName());
        String[] childCollections = collection.listChildCollections();
        Collection child = null;
        for (String childCollection : childCollections) {
            try {
                child = collection.getChildCollection(childCollection);
            }
            catch (XMLDBException xmldbe) {
                if (xmldbe.getCause() instanceof PermissionDeniedException) continue;
                throw xmldbe;
            }
            catch (Exception npe) {
                System.out.println("Corrupted resource/collection skipped: " + child != null ? (child.getName() != null ? child.getName() : "unknown") : "unknown");
                continue;
            }
            try {
                this.getAllCollections(child, collections);
            }
            catch (Exception ee) {
                System.out.println("Corrupted resource/collection skipped: " + child != null ? (child.getName() != null ? child.getName() : "unknown") : "unknown");
            }
        }
    }

    public String getCollection() {
        return (String)this.collections.getSelectedItem();
    }

    public String getBackupTarget() {
        return this.backupTarget.getText();
    }

    public Path getBackupDir() {
        return this.backupDir;
    }
}

