/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.exist.backup.BackupWriter;
import org.exist.util.FileUtils;
import org.exist.xmldb.XmldbURI;

public class FileSystemWriter
implements BackupWriter {
    private final Path rootDir;
    private Path currentDir;
    private Path currentContents;
    private Writer currentContentsOut;
    private OutputStream currentOut;
    private boolean dataWritten = false;

    public FileSystemWriter(String path) throws IOException {
        this(Paths.get(path, new String[0]));
    }

    public FileSystemWriter(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            FileUtils.deleteQuietly(file);
        }
        Files.createDirectories(file, new FileAttribute[0]);
        this.currentDir = file;
        this.rootDir = file;
    }

    @Override
    public void newCollection(String name) throws IOException {
        Path file = XmldbURI.createInternal(name).isAbsolute() ? this.rootDir.resolve(name.replaceAll("^/?(.*)", "$1")) : this.currentDir.resolve(name.replaceAll("^/?(.*)", "$1"));
        if (Files.exists(file, new LinkOption[0])) {
            FileUtils.deleteQuietly(file);
        }
        Files.createDirectories(file, new FileAttribute[0]);
        this.dataWritten = true;
        this.currentDir = file;
    }

    @Override
    public void closeCollection() {
        this.currentDir = this.currentDir.getParent();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Writer newContents() throws IOException {
        this.currentContents = this.currentDir.resolve("__contents__.xml");
        this.currentContentsOut = Files.newBufferedWriter(this.currentContents, StandardCharsets.UTF_8, new OpenOption[0]);
        this.dataWritten = true;
        return this.currentContentsOut;
    }

    @Override
    public void closeContents() throws IOException {
        this.currentContentsOut.close();
    }

    @Override
    public OutputStream newEntry(String name) throws IOException {
        this.currentOut = Files.newOutputStream(this.currentDir.resolve(name), new OpenOption[0]);
        this.dataWritten = true;
        return this.currentOut;
    }

    @Override
    public void closeEntry() throws IOException {
        this.currentOut.close();
    }

    @Override
    public void setProperties(Properties properties) throws IOException {
        if (this.dataWritten) {
            throw new IOException("Backup properties need to be set before any backup data is written");
        }
        Path propFile = this.rootDir.resolve("backup.properties");
        try (OutputStream os = Files.newOutputStream(propFile, new OpenOption[0]);){
            properties.store(os, "Backup properties");
        }
    }

    @Override
    public void addToRoot(String name, Path file) throws IOException {
        Files.copy(file, this.rootDir.resolve(name), StandardCopyOption.ATOMIC_MOVE);
    }
}

