/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.exist.backup.Backup;
import org.exist.backup.CreateBackupDialog;
import org.exist.backup.Restore;
import org.exist.backup.restore.listener.ConsoleRestoreListener;
import org.exist.backup.restore.listener.GuiRestoreListener;
import org.exist.client.ClientFrame;
import org.exist.util.ArgumentUtil;
import org.exist.util.ConfigurationHelper;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Arguments;
import se.softhouse.jargo.CommandLineParser;
import se.softhouse.jargo.ParsedArguments;
import se.softhouse.jargo.StringParsers;

public class Main {
    private static final String USER_PROP = "user";
    private static final String PASSWORD_PROP = "password";
    private static final String URI_PROP = "uri";
    private static final String CONFIGURATION_PROP = "configuration";
    private static final String DRIVER_PROP = "driver";
    private static final String CREATE_DATABASE_PROP = "create-database";
    private static final String BACKUP_DIR_PROP = "backup-dir";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_URI = "xmldb:exist://";
    private static final String DEFAULT_DRIVER = "org.exist.xmldb.DatabaseImpl";
    private static final String DEFAULT_BACKUP_DIR = "backup";
    private static final Argument<?> helpArg = Arguments.helpArgument((String)"-h", (String[])new String[]{"--help"});
    private static final Argument<Boolean> guiArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-U", (String[])new String[]{"--gui"}).description("start in GUI mode")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> quietArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-q", (String[])new String[]{"--quiet"}).description("be quiet. Just print errors.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Map<String, String>> optionArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-o", "--option"}).description("specify extra options: property=value. For available properties see client.properties.")).asKeyValuesWithKeyParser(StringParsers.stringParser()).build();
    private static final Argument<String> userArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-u", "--user"}).description("set user.")).defaultValue((Object)"admin")).build();
    private static final Argument<String> passwordArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-p", "--password"}).description("set the password for connecting to the database.")).build();
    private static final Argument<String> dbaPasswordArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-P", "--dba-password"}).description("if the backup specifies a different password for the admin user, use this option to specify the new password. Otherwise you will get a permission denied")).build();
    private static final Argument<String> backupCollectionArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-b", "--backup"}).description("backup the specified collection.")).build();
    private static final Argument<File> backupOutputDirArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-d", "--dir"}).description("specify the directory to use for backups.")).build();
    private static final Argument<File> restoreArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-r", "--restore"}).description("read the specified __contents__.xml file and restore the resources described there.")).build();
    private static final Argument<Boolean> rebuildExpathRepoArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-R", (String[])new String[]{"--rebuild"}).description("rebuild the EXpath app repository after restore.")).defaultValue(Boolean.valueOf(false)).build();

    private static Properties loadProperties() {
        Properties properties;
        block27: {
            Path propFile = ConfigurationHelper.lookup("backup.properties");
            properties = new Properties();
            try {
                if (Files.isReadable(propFile)) {
                    try (InputStream pin = Files.newInputStream(propFile, new OpenOption[0]);){
                        properties.load(pin);
                        break block27;
                    }
                }
                try (InputStream pin = Main.class.getResourceAsStream("backup.properties");){
                    properties.load(pin);
                }
            }
            catch (IOException e) {
                System.err.println("WARN - Unable to load properties from: " + propFile.toAbsolutePath().toString());
            }
        }
        return properties;
    }

    public static void process(ParsedArguments arguments) {
        Properties properties = Main.loadProperties();
        Preferences preferences = Preferences.userNodeForPackage(Main.class);
        boolean guiMode = ArgumentUtil.getBool(arguments, guiArg);
        boolean quiet = ArgumentUtil.getBool(arguments, quietArg);
        Optional.ofNullable(arguments.get(optionArg)).ifPresent(options -> options.forEach(properties::setProperty));
        properties.setProperty(USER_PROP, (String)arguments.get(userArg));
        String optionPass = (String)arguments.get(passwordArg);
        properties.setProperty(PASSWORD_PROP, optionPass);
        Optional<String> optionDbaPass = ArgumentUtil.getOpt(arguments, dbaPasswordArg);
        Optional<String> backupCollection = ArgumentUtil.getOpt(arguments, backupCollectionArg);
        ArgumentUtil.getOpt(arguments, backupOutputDirArg).ifPresent(backupOutputDir -> properties.setProperty(BACKUP_DIR_PROP, backupOutputDir.getAbsolutePath()));
        Optional<Path> restorePath = ArgumentUtil.getOpt(arguments, restoreArg).map(File::toPath);
        boolean rebuildRepo = ArgumentUtil.getBool(arguments, rebuildExpathRepoArg);
        try {
            Class<?> cl = Class.forName(properties.getProperty(DRIVER_PROP, DEFAULT_DRIVER));
            Database database = (Database)cl.newInstance();
            database.setProperty(CREATE_DATABASE_PROP, "true");
            if (properties.containsKey(CONFIGURATION_PROP)) {
                database.setProperty(CONFIGURATION_PROP, properties.getProperty(CONFIGURATION_PROP));
            }
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | XMLDBException e) {
            Main.reportError(e);
            return;
        }
        if (backupCollection.isPresent()) {
            String collection = backupCollection.get();
            if (collection.isEmpty()) {
                if (guiMode) {
                    CreateBackupDialog dialog = new CreateBackupDialog(properties.getProperty(URI_PROP, DEFAULT_URI), properties.getProperty(USER_PROP, DEFAULT_USER), properties.getProperty(PASSWORD_PROP, DEFAULT_PASSWORD), Paths.get(preferences.get("directory.backup", System.getProperty("user.dir")), new String[0]));
                    if (JOptionPane.showOptionDialog(null, dialog, "Create Backup", 2, 3, null, null, null) == 0) {
                        collection = dialog.getCollection();
                        properties.setProperty(BACKUP_DIR_PROP, dialog.getBackupTarget());
                    }
                } else {
                    collection = "/db";
                }
            }
            if (!collection.isEmpty()) {
                try {
                    Backup backup = new Backup(properties.getProperty(USER_PROP, DEFAULT_USER), properties.getProperty(PASSWORD_PROP, DEFAULT_PASSWORD), Paths.get(properties.getProperty(BACKUP_DIR_PROP, DEFAULT_BACKUP_DIR), new String[0]), XmldbURI.xmldbUriFor(properties.getProperty(URI_PROP, DEFAULT_URI) + collection), properties);
                    backup.backup(guiMode, null);
                }
                catch (Exception e) {
                    Main.reportError(e);
                }
            }
        }
        if (restorePath.isPresent()) {
            Path path = restorePath.get();
            if (!Files.exists(path, new LinkOption[0]) && guiMode) {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                if (chooser.showDialog(null, "Select backup file for restore") == 0) {
                    path = chooser.getSelectedFile().toPath();
                }
            }
            if (Files.exists(path, new LinkOption[0])) {
                String username = properties.getProperty(USER_PROP, DEFAULT_USER);
                String uri = properties.getProperty(URI_PROP, DEFAULT_URI);
                try {
                    if (guiMode) {
                        Main.restoreWithGui(username, optionPass, optionDbaPass, path, uri);
                    } else {
                        Main.restoreWithoutGui(username, optionPass, optionDbaPass, path, uri, rebuildRepo, quiet);
                    }
                }
                catch (Exception e) {
                    Main.reportError(e);
                }
            }
        }
        try {
            String uri = properties.getProperty(URI_PROP, DEFAULT_URI);
            if (!uri.contains("/db") && !uri.endsWith("/db")) {
                uri = uri + "/db";
            }
            Collection root = DatabaseManager.getCollection((String)uri, (String)properties.getProperty(USER_PROP, DEFAULT_USER), (String)optionDbaPass.orElse(optionPass));
            Main.shutdown(root);
        }
        catch (Exception e) {
            Main.reportError(e);
        }
        System.exit(0);
    }

    private static void restoreWithoutGui(String username, String password, Optional<String> dbaPassword, Path f, String uri, boolean rebuildRepo, boolean quiet) {
        block9: {
            ConsoleRestoreListener listener = new ConsoleRestoreListener(quiet);
            Restore restore = new Restore();
            try {
                restore.restore(listener, username, password, dbaPassword.orElse(null), f, uri);
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | SAXException | XMLDBException ioe) {
                listener.error(ioe.getMessage());
            }
            if (listener.hasProblems()) {
                System.err.println(listener.warningsAndErrorsAsString());
            }
            if (rebuildRepo) {
                System.out.println("Rebuilding application repository ...");
                System.out.println("URI: " + uri);
                try {
                    Collection root;
                    String rootURI = uri;
                    if (!rootURI.contains("/db") && !rootURI.endsWith("/db")) {
                        rootURI = rootURI + "/db";
                    }
                    if ((root = DatabaseManager.getCollection((String)rootURI, (String)username, (String)dbaPassword.orElse(password))) != null) {
                        ClientFrame.repairRepository(root);
                        System.out.println("Application repository rebuilt successfully.");
                        break block9;
                    }
                    System.err.println("Failed to retrieve root collection: " + uri);
                }
                catch (XMLDBException e) {
                    Main.reportError(e);
                    System.err.println("Rebuilding application repository failed!");
                }
            } else {
                System.out.println("\nIf you restored collections inside /db/apps, you may want\nto rebuild the application repository. To do so, run the following query\nas admin:\n\nimport module namespace repair=\"http://exist-db.org/xquery/repo/repair\"\nat \"resource:org/exist/xquery/modules/expathrepo/repair.xql\";\nrepair:clean-all(),\nrepair:repair()\n");
            }
        }
    }

    private static void restoreWithGui(final String username, final String password, final Optional<String> dbaPassword, final Path f, final String uri) {
        final GuiRestoreListener listener = new GuiRestoreListener();
        Callable<Void> callable = new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                Restore restore = new Restore();
                try {
                    restore.restore(listener, username, password, dbaPassword.orElse(null), f, uri);
                    listener.hideDialog();
                    if (JOptionPane.showConfirmDialog(null, "Would you like to rebuild the application repository?\nThis is only necessary if application packages were restored.", "Rebuild App Repository?", 0) == 0) {
                        System.out.println("Rebuilding application repository ...");
                        try {
                            String rootURI = uri;
                            if (!rootURI.contains("/db") && !rootURI.endsWith("/db")) {
                                rootURI = rootURI + "/db";
                            }
                            Collection root = DatabaseManager.getCollection((String)rootURI, (String)username, (String)dbaPassword.orElse(password));
                            ClientFrame.repairRepository(root);
                            System.out.println("Application repository rebuilt successfully.");
                        }
                        catch (XMLDBException e) {
                            Main.reportError(e);
                            System.err.println("Rebuilding application repository failed!");
                        }
                    }
                }
                catch (Exception e) {
                    ClientFrame.showErrorMessage(e.getMessage(), null);
                }
                finally {
                    if (listener.hasProblems()) {
                        ClientFrame.showErrorMessage(listener.warningsAndErrorsAsString(), null);
                    }
                }
                return null;
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> future = executor.submit(callable);
        while (!future.isDone() && !future.isCancelled()) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException ee) {
                break;
            }
            catch (TimeoutException timeoutException) {
            }
        }
    }

    private static void reportError(Throwable e) {
        e.printStackTrace();
        if (e.getCause() != null) {
            System.err.println("caused by ");
            e.getCause().printStackTrace();
        }
        System.exit(1);
    }

    private static void shutdown(Collection root) {
        try {
            DatabaseInstanceManager mgr = (DatabaseInstanceManager)root.getService("DatabaseInstanceManager", "1.0");
            if (mgr == null) {
                System.err.println("service is not available");
            } else if (mgr.isLocalInstance()) {
                System.out.println("shutting down database...");
                mgr.shutdown();
            }
        }
        catch (XMLDBException e) {
            System.err.println("database shutdown failed: ");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            ParsedArguments arguments = CommandLineParser.withArguments((Argument[])new Argument[]{userArg, passwordArg, dbaPasswordArg}).andArguments(new Argument[]{backupCollectionArg, backupOutputDirArg}).andArguments(new Argument[]{restoreArg, rebuildExpathRepoArg}).andArguments(new Argument[]{helpArg, guiArg, quietArg, optionArg}).parse(args);
            Main.process(arguments);
        }
        catch (ArgumentException e) {
            System.out.println(e.getMessageAndUsage());
            System.exit(3);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

