/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.FileSystemBackupDescriptor;
import org.exist.backup.ZipArchiveBackupDescriptor;
import org.exist.backup.restore.RestoreHandler;
import org.exist.backup.restore.listener.RestoreListener;
import org.exist.security.Account;
import org.exist.util.EXistInputSource;
import org.exist.util.FileUtils;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class Restore {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(RestoreListener listener, String username, String password, String newAdminPass, Path f, String uri) throws XMLDBException, FileNotFoundException, IOException, SAXException, ParserConfigurationException, URISyntaxException {
        if (newAdminPass != null) {
            password = this.setAdminCredentials(uri, username, password, newAdminPass);
        }
        Stack<BackupDescriptor> descriptors = this.getBackupDescriptors(f);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        SAXParser sax = saxFactory.newSAXParser();
        XMLReader reader = sax.getXMLReader();
        try {
            listener.restoreStarting();
            while (!descriptors.isEmpty()) {
                BackupDescriptor descriptor = descriptors.pop();
                EXistInputSource is = descriptor.getInputSource();
                is.setEncoding("UTF-8");
                RestoreHandler handler = new RestoreHandler(listener, uri, username, password, descriptor);
                reader.setContentHandler(handler);
                reader.parse(is);
            }
        }
        finally {
            listener.restoreFinished();
        }
    }

    private Stack<BackupDescriptor> getBackupDescriptors(Path contents) throws XMLDBException, IOException {
        Stack<BackupDescriptor> descriptors = new Stack<BackupDescriptor>();
        do {
            String previous;
            BackupDescriptor bd = this.getBackupDescriptor(contents);
            descriptors.push(bd);
            BackupDescriptor sysDescriptor = bd.getChildBackupDescriptor("system");
            if (sysDescriptor != null) {
                descriptors.push(sysDescriptor);
                BackupDescriptor secDescriptor = sysDescriptor.getChildBackupDescriptor("security");
                if (secDescriptor != null) {
                    descriptors.push(secDescriptor);
                }
            }
            contents = null;
            Properties properties = bd.getProperties();
            if (properties == null || !"yes".equals(properties.getProperty("incremental", "no")) || (previous = properties.getProperty("previous", "")).length() <= 0 || Files.isReadable(contents = bd.getParentDir().resolve(previous))) continue;
            throw new XMLDBException(4, "Required part of incremental backup not found: " + contents.toAbsolutePath().toString());
        } while (contents != null);
        return descriptors;
    }

    private BackupDescriptor getBackupDescriptor(Path f) throws IOException {
        AbstractBackupDescriptor bd = Files.isDirectory(f, new LinkOption[0]) ? new FileSystemBackupDescriptor(f.resolve("db").resolve("__contents__.xml")) : (FileUtils.fileName(f).toLowerCase().endsWith(".zip") ? new ZipArchiveBackupDescriptor(f) : new FileSystemBackupDescriptor(f));
        return bd;
    }

    private String setAdminCredentials(String uri, String username, String password, String adminPassword) throws XMLDBException, URISyntaxException {
        XmldbURI dbUri = !uri.endsWith("/db") ? XmldbURI.xmldbUriFor(uri + "/db") : XmldbURI.xmldbUriFor(uri);
        Collection root = DatabaseManager.getCollection((String)dbUri.toString(), (String)username, (String)password);
        UserManagementService mgmt = (UserManagementService)root.getService("UserManagementService", "1.0");
        Account dba = mgmt.getAccount("admin");
        if (dba == null) {
            throw new XMLDBException(4, "'admin' account can't be found.");
        }
        dba.setPassword(adminPassword);
        mgmt.updateAccount(dba);
        return adminPassword;
    }
}

