/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.util.EXistInputSource;
import org.exist.util.FileUtils;
import org.exist.util.ZipEntryInputSource;

public class ZipArchiveBackupDescriptor
extends AbstractBackupDescriptor {
    protected ZipFile archive;
    protected ZipEntry descriptor;
    protected String base;

    public ZipArchiveBackupDescriptor(Path fileArchive) throws IOException {
        this.archive = new ZipFile(fileArchive.toFile());
        this.base = "db/";
        this.descriptor = this.archive.getEntry(this.base + "__contents__.xml");
        if (this.descriptor == null || this.descriptor.isDirectory()) {
            this.base = null;
            ZipEntry item = null;
            Enumeration<? extends ZipEntry> zipEnum = this.archive.entries();
            while (zipEnum.hasMoreElements()) {
                item = zipEnum.nextElement();
                if (item.isDirectory() || !item.getName().endsWith("__contents__.xml") || this.base != null && this.base.length() <= item.getName().length()) continue;
                this.descriptor = item;
                this.base = item.getName();
            }
            if (this.base != null) {
                this.base = this.base.substring(0, this.base.length() - "__contents__.xml".length());
            }
        }
        if (this.descriptor == null) {
            throw new FileNotFoundException("Archive " + fileArchive.toAbsolutePath().toString() + " is not a valid eXist backup archive");
        }
    }

    private ZipArchiveBackupDescriptor(ZipFile archive, String base) throws FileNotFoundException {
        this.archive = archive;
        this.base = base;
        this.descriptor = archive.getEntry(base + "__contents__.xml");
        if (this.descriptor == null || this.descriptor.isDirectory()) {
            throw new FileNotFoundException(archive.getName() + " is a bit corrupted (" + base + " descriptor not found): not a valid eXist backup archive");
        }
    }

    @Override
    public BackupDescriptor getChildBackupDescriptor(String describedItem) {
        ZipArchiveBackupDescriptor bd = null;
        try {
            bd = new ZipArchiveBackupDescriptor(this.archive, this.base + describedItem + "/");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bd;
    }

    @Override
    public BackupDescriptor getBackupDescriptor(String describedItem) {
        if (describedItem.length() > 0 && describedItem.charAt(0) == '/') {
            describedItem = describedItem.substring(1);
        }
        if (!describedItem.endsWith("/")) {
            describedItem = describedItem + '/';
        }
        ZipArchiveBackupDescriptor bd = null;
        try {
            bd = new ZipArchiveBackupDescriptor(this.archive, describedItem);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bd;
    }

    @Override
    public EXistInputSource getInputSource() {
        return new ZipEntryInputSource(this.archive, this.descriptor);
    }

    @Override
    public EXistInputSource getInputSource(String describedItem) {
        ZipEntry ze = this.archive.getEntry(this.base + describedItem);
        ZipEntryInputSource retval = null;
        if (ze != null && !ze.isDirectory()) {
            retval = new ZipEntryInputSource(this.archive, ze);
        }
        return retval;
    }

    @Override
    public String getSymbolicPath() {
        return this.archive.getName() + "#" + this.descriptor.getName();
    }

    @Override
    public String getSymbolicPath(String describedItem, boolean isChildDescriptor) {
        String retval = this.archive.getName() + "#" + this.base + describedItem;
        if (isChildDescriptor) {
            retval = retval + "/__contents__.xml";
        }
        return retval;
    }

    @Override
    public Properties getProperties() throws IOException {
        Properties properties = null;
        ZipEntry ze = this.archive.getEntry("backup.properties");
        if (ze != null) {
            properties = new Properties();
            properties.load(this.archive.getInputStream(ze));
        }
        return properties;
    }

    @Override
    public Path getRepoBackup() throws IOException {
        ZipEntry ze = this.archive.getEntry("expathrepo.zip");
        if (ze == null) {
            return null;
        }
        Path temp = Files.createTempFile("expathrepo", "zip", new FileAttribute[0]);
        try (InputStream is = this.archive.getInputStream(ze);){
            Files.copy(is, temp, StandardCopyOption.REPLACE_EXISTING);
        }
        return temp;
    }

    @Override
    public Path getParentDir() {
        return Paths.get(this.archive.getName(), new String[0]).getParent();
    }

    @Override
    public String getName() {
        return FileUtils.fileName(Paths.get(this.archive.getName(), new String[0]));
    }
}

