/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.restore;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.restore.AbstractDeferredPermission;
import org.exist.backup.restore.listener.RestoreListener;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

class CollectionDeferredPermission
extends AbstractDeferredPermission<Collection> {
    private static final Logger LOG = LogManager.getLogger(CollectionDeferredPermission.class);

    public CollectionDeferredPermission(RestoreListener listener, Collection collection, String owner, String group, Integer mode) {
        super(listener, collection, owner, group, mode);
    }

    @Override
    public void apply() {
        try {
            UserManagementService service;
            if (((Collection)this.getTarget()).getName().equals("/db")) {
                service = (UserManagementService)((Collection)this.getTarget()).getService("UserManagementService", "1.0");
            } else {
                Collection parent = ((Collection)this.getTarget()).getParentCollection();
                service = (UserManagementService)parent.getService("UserManagementService", "1.0");
            }
            service.setPermissions((Collection)this.getTarget(), this.getOwner(), this.getGroup(), this.getMode(), this.getAces());
        }
        catch (XMLDBException xe) {
            String name = "unknown";
            try {
                name = ((Collection)this.getTarget()).getName();
            }
            catch (XMLDBException x) {
                LOG.error(x.getMessage(), (Throwable)x);
            }
            String msg = "ERROR: Failed to set permissions on Collection '" + name + "'.";
            LOG.error(msg, (Throwable)xe);
            this.getListener().warn(msg);
        }
    }
}

