/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.restore;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.restore.CollectionDeferredPermission;
import org.exist.backup.restore.DeferredPermission;
import org.exist.backup.restore.ResourceDeferredPermission;
import org.exist.backup.restore.SkippedEntryDeferredPermission;
import org.exist.backup.restore.listener.RestoreListener;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.security.ACLPermission;
import org.exist.util.EXistInputSource;
import org.exist.xmldb.EXistCollection;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.DateTimeValue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class RestoreHandler
extends DefaultHandler {
    private static final Logger LOG = LogManager.getLogger(RestoreHandler.class);
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private static final int STRICT_URI_VERSION = 1;
    private final RestoreListener listener;
    private final String dbBaseUri;
    private final String dbUsername;
    private final String dbPassword;
    private final BackupDescriptor descriptor;
    private int version = 0;
    private EXistCollection currentCollection;
    private Stack<DeferredPermission> deferredPermissions = new Stack();

    public RestoreHandler(RestoreListener listener, String dbBaseUri, String dbUsername, String dbPassword, BackupDescriptor descriptor) {
        this.listener = listener;
        this.dbBaseUri = dbBaseUri;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.descriptor = descriptor;
    }

    @Override
    public void startDocument() throws SAXException {
        this.listener.setCurrentBackup(this.descriptor.getSymbolicPath());
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI != null && !namespaceURI.equals("http://exist.sourceforge.net/NS/exist")) {
            return;
        }
        if ("collection".equals(localName) || "resource".equals(localName)) {
            DeferredPermission df = "collection".equals(localName) ? this.restoreCollectionEntry(atts) : this.restoreResourceEntry(atts);
            this.deferredPermissions.push(df);
        } else if ("subcollection".equals(localName)) {
            this.restoreSubCollectionEntry(atts);
        } else if ("deleted".equals(localName)) {
            this.restoreDeletedEntry(atts);
        } else if ("ace".equals(localName)) {
            this.addACEToDeferredPermissions(atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (namespaceURI.equals("http://exist.sourceforge.net/NS/exist") && ("collection".equals(localName) || "resource".equals(localName))) {
            this.setDeferredPermissions();
        }
        super.endElement(namespaceURI, localName, qName);
    }

    private String getAttr(Attributes atts, String name, String fallback) {
        String value = atts.getValue(name);
        if (value == null) {
            return fallback;
        }
        return value;
    }

    private DeferredPermission restoreCollectionEntry(Attributes atts) throws SAXException {
        String msg;
        String name = atts.getValue("name");
        if (name == null) {
            throw new SAXException("Collection requires a name attribute");
        }
        String owner = this.getAttr(atts, "owner", "SYSTEM");
        String group = this.getAttr(atts, "group", "dba");
        String mode = this.getAttr(atts, "mode", "644");
        String created = atts.getValue("created");
        String strVersion = atts.getValue("version");
        if (strVersion != null) {
            try {
                this.version = Integer.parseInt(strVersion);
            }
            catch (NumberFormatException nfe) {
                msg = "Could not parse version number for Collection '" + name + "', defaulting to version 0";
                this.listener.warn(msg);
                LOG.warn(msg);
                this.version = 0;
            }
        }
        try {
            XmldbURI collUri;
            this.listener.createCollection(name);
            if (this.version >= 1) {
                collUri = XmldbURI.create(name);
            } else {
                try {
                    collUri = URIUtils.encodeXmldbUriFor(name);
                }
                catch (URISyntaxException e) {
                    this.listener.warn("Could not parse document name into a URI: " + e.getMessage());
                    return new SkippedEntryDeferredPermission();
                }
            }
            this.currentCollection = this.mkcol(collUri, this.getDateFromXSDateTimeStringForItem(created, name));
            this.listener.setCurrentCollection(name);
            if (this.currentCollection == null) {
                throw new SAXException("Collection not found: " + collUri);
            }
            CollectionDeferredPermission deferredPermission = name.startsWith("/db/system") ? new CollectionDeferredPermission(this.listener, this.currentCollection, "SYSTEM", "dba", (Integer)Integer.parseInt(mode, 8)) : new CollectionDeferredPermission(this.listener, this.currentCollection, owner, group, (Integer)Integer.parseInt(mode, 8));
            return deferredPermission;
        }
        catch (Exception e) {
            msg = "An unrecoverable error occurred while restoring\ncollection '" + name + "'. Aborting restore!";
            LOG.error(msg, (Throwable)e);
            this.listener.warn(msg);
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void restoreSubCollectionEntry(Attributes atts) throws SAXException {
        String name = atts.getValue("filename") != null ? atts.getValue("filename") : atts.getValue("name");
        try {
            String currentCollectionName = this.currentCollection.getName();
            if ("/db".equals(currentCollectionName) && "system".equals(name) || "/db/system".equals(currentCollectionName) && "security".equals(name)) {
                return;
            }
        }
        catch (XMLDBException xe) {
            throw new RuntimeException(xe.getMessage(), xe);
        }
        BackupDescriptor subDescriptor = this.descriptor.getChildBackupDescriptor(name);
        if (subDescriptor != null) {
            try {
                SAXParser sax = saxFactory.newSAXParser();
                XMLReader reader = sax.getXMLReader();
                EXistInputSource is = subDescriptor.getInputSource();
                is.setEncoding("UTF-8");
                RestoreHandler handler = new RestoreHandler(this.listener, this.dbBaseUri, this.dbUsername, this.dbPassword, subDescriptor);
                reader.setContentHandler(handler);
                reader.parse(is);
            }
            catch (ParserConfigurationException pce) {
                this.listener.error("Could not initalise SAXParser for processing sub-collection: " + this.descriptor.getSymbolicPath(name, false));
            }
            catch (IOException ioe) {
                this.listener.error("Could not read sub-collection for processing: " + ioe.getMessage());
            }
            catch (SAXException se) {
                this.listener.error("SAX exception while reading sub-collection " + subDescriptor.getSymbolicPath() + " for processing: " + se.getMessage());
            }
        } else {
            this.listener.error("Collection " + this.descriptor.getSymbolicPath(name, false) + " does not exist or is not readable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeferredPermission restoreResourceEntry(Attributes atts) throws SAXException {
        XmldbURI docUri;
        String skip = atts.getValue("skip");
        if (skip != null && !"no".equals(skip)) {
            return new SkippedEntryDeferredPermission();
        }
        String name = atts.getValue("name");
        if (name == null) {
            throw new SAXException("Resource requires a name attribute");
        }
        String type = atts.getValue("type") != null ? atts.getValue("type") : "XMLResource";
        String owner = this.getAttr(atts, "owner", "SYSTEM");
        String group = this.getAttr(atts, "group", "dba");
        String perms = this.getAttr(atts, "mode", "644");
        String filename = atts.getValue("filename") != null ? atts.getValue("filename") : name;
        String mimetype = atts.getValue("mimetype");
        String created = atts.getValue("created");
        String modified = atts.getValue("modified");
        String publicid = atts.getValue("publicid");
        String systemid = atts.getValue("systemid");
        String namedoctype = atts.getValue("namedoctype");
        if (this.version >= 1) {
            docUri = XmldbURI.create(name);
        } else {
            try {
                docUri = URIUtils.encodeXmldbUriFor(name);
            }
            catch (URISyntaxException e) {
                String msg = "Could not parse document name into a URI: " + e.getMessage();
                this.listener.error(msg);
                LOG.error(msg, (Throwable)e);
                return new SkippedEntryDeferredPermission();
            }
        }
        EXistInputSource is = this.descriptor.getInputSource(filename);
        if (is == null) {
            String msg = "Failed to restore resource '" + name + "'\nfrom file '" + this.descriptor.getSymbolicPath(name, false) + "'.\nReason: Unable to obtain its EXistInputSource";
            this.listener.warn(msg);
            return new SkippedEntryDeferredPermission();
        }
        try {
            this.listener.setCurrentResource(name);
            if (this.currentCollection instanceof Observable) {
                this.listener.observe((Observable)((Object)this.currentCollection));
            }
            Resource res = this.currentCollection.createResource(docUri.toString(), type);
            if (mimetype != null) {
                ((EXistResource)res).setMimeType(mimetype);
            }
            if (is.getByteStreamLength() > 0L) {
                res.setContent((Object)is);
            } else if ("BinaryResource".equals(type)) {
                res.setContent((Object)"");
            } else {
                res = null;
            }
            if (res == null) {
                this.listener.warn("Failed to restore resource '" + name + "'\nfrom file '" + this.descriptor.getSymbolicPath(name, false) + "'. The resource is empty.");
                SkippedEntryDeferredPermission skippedEntryDeferredPermission = new SkippedEntryDeferredPermission();
                return skippedEntryDeferredPermission;
            }
            Date date_created = null;
            Date date_modified = null;
            if (created != null) {
                try {
                    date_created = new DateTimeValue(created).getDate();
                }
                catch (XPathException xpe) {
                    this.listener.warn("Illegal creation date. Ignoring date...");
                }
            }
            if (modified != null) {
                try {
                    date_modified = new DateTimeValue(modified).getDate();
                }
                catch (XPathException xpe) {
                    this.listener.warn("Illegal modification date. Ignoring date...");
                }
            }
            this.currentCollection.storeResource(res, date_created, date_modified);
            if (publicid != null || systemid != null) {
                DocumentTypeImpl doctype = new DocumentTypeImpl(namedoctype, publicid, systemid);
                try {
                    ((EXistResource)res).setDocType(doctype);
                }
                catch (XMLDBException e1) {
                    LOG.error(e1.getMessage(), (Throwable)e1);
                }
            }
            ResourceDeferredPermission deferredPermission = name.startsWith("/db/system") ? new ResourceDeferredPermission(this.listener, res, "SYSTEM", "dba", (Integer)Integer.parseInt(perms, 8)) : new ResourceDeferredPermission(this.listener, res, owner, group, (Integer)Integer.parseInt(perms, 8));
            this.listener.restored(name);
            ResourceDeferredPermission resourceDeferredPermission = deferredPermission;
            return resourceDeferredPermission;
        }
        catch (Exception e) {
            this.listener.warn("Failed to restore resource '" + name + "'\nfrom file '" + this.descriptor.getSymbolicPath(name, false) + "'.\nReason: " + e.getMessage());
            LOG.error(e.getMessage(), (Throwable)e);
            SkippedEntryDeferredPermission skippedEntryDeferredPermission = new SkippedEntryDeferredPermission();
            return skippedEntryDeferredPermission;
        }
        finally {
            is.close();
        }
    }

    private void restoreDeletedEntry(Attributes atts) {
        String name = atts.getValue("name");
        String type = atts.getValue("type");
        if ("collection".equals(type)) {
            try {
                Collection child = this.currentCollection.getChildCollection(name);
                if (child != null) {
                    this.currentCollection.setTriggersEnabled(false);
                    CollectionManagementService cmgt = (CollectionManagementService)this.currentCollection.getService("CollectionManagementService", "1.0");
                    cmgt.removeCollection(name);
                    this.currentCollection.setTriggersEnabled(true);
                }
            }
            catch (XMLDBException e) {
                this.listener.warn("Failed to remove deleted collection: " + name + ": " + e.getMessage());
            }
        } else if ("resource".equals(type)) {
            try {
                Resource resource = this.currentCollection.getResource(name);
                if (resource != null) {
                    this.currentCollection.setTriggersEnabled(false);
                    this.currentCollection.removeResource(resource);
                    this.currentCollection.setTriggersEnabled(true);
                }
            }
            catch (XMLDBException e) {
                this.listener.warn("Failed to remove deleted resource: " + name + ": " + e.getMessage());
            }
        }
    }

    private void addACEToDeferredPermissions(Attributes atts) {
        int index = Integer.parseInt(atts.getValue("index"));
        ACLPermission.ACE_TARGET target = ACLPermission.ACE_TARGET.valueOf(atts.getValue("target"));
        String who = atts.getValue("who");
        ACLPermission.ACE_ACCESS_TYPE access_type = ACLPermission.ACE_ACCESS_TYPE.valueOf(atts.getValue("access_type"));
        int mode = Integer.parseInt(atts.getValue("mode"), 8);
        this.deferredPermissions.peek().addACE(index, target, who, access_type, mode);
    }

    private void setDeferredPermissions() {
        DeferredPermission deferredPermission = this.deferredPermissions.pop();
        deferredPermission.apply();
    }

    private Date getDateFromXSDateTimeStringForItem(String strXSDateTime, String itemName) {
        Date date_created = null;
        if (strXSDateTime != null) {
            try {
                date_created = new DateTimeValue(strXSDateTime).getDate();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        if (date_created == null) {
            String msg = "Could not parse created date '" + strXSDateTime + "' from backup for: '" + itemName + "', using current time!";
            this.listener.error(msg);
            LOG.error(msg);
            date_created = Calendar.getInstance().getTime();
        }
        return date_created;
    }

    private EXistCollection mkcol(XmldbURI collPath, Date created) throws XMLDBException, URISyntaxException {
        XmldbURI[] allSegments = collPath.getPathSegments();
        XmldbURI[] segments = Arrays.copyOfRange(allSegments, 1, allSegments.length);
        XmldbURI dbUri = !this.dbBaseUri.endsWith("/db") ? XmldbURI.xmldbUriFor(this.dbBaseUri + "/db") : XmldbURI.xmldbUriFor(this.dbBaseUri);
        EXistCollection current = (EXistCollection)DatabaseManager.getCollection((String)dbUri.toString(), (String)this.dbUsername, (String)this.dbPassword);
        XmldbURI p = XmldbURI.ROOT_COLLECTION_URI;
        for (XmldbURI segment : segments) {
            XmldbURI xmldbURI = dbUri.resolveCollectionPath(p = p.append(segment));
            EXistCollection c = (EXistCollection)DatabaseManager.getCollection((String)xmldbURI.toString(), (String)this.dbUsername, (String)this.dbPassword);
            if (c == null) {
                current.setTriggersEnabled(false);
                EXistCollectionManagementService mgtService = (EXistCollectionManagementService)current.getService("CollectionManagementService", "1.0");
                c = (EXistCollection)mgtService.createCollection(segment, created);
                current.setTriggersEnabled(true);
            }
            current = c;
        }
        return current;
    }

    static {
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
    }
}

