/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.restore;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.RestoreHandler;
import org.exist.backup.restore.AbstractDeferredPermission;
import org.exist.backup.restore.DeferredPermission;
import org.exist.backup.restore.SkippedEntryDeferredPermission;
import org.exist.backup.restore.listener.RestoreListener;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.security.ACLPermission;
import org.exist.security.Permission;
import org.exist.security.internal.aider.ACEAider;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.EXistInputSource;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.DateTimeValue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SystemImportHandler
extends DefaultHandler {
    private static final Logger LOG = LogManager.getLogger(SystemImportHandler.class);
    private static final SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private static final int STRICT_URI_VERSION = 1;
    private DBBroker broker;
    private RestoreHandler rh;
    private final RestoreListener listener;
    private final String dbBaseUri;
    private final BackupDescriptor descriptor;
    private int version = 0;
    private Collection currentCollection;
    private Stack<DeferredPermission> deferredPermissions = new Stack();

    public SystemImportHandler(DBBroker broker, RestoreListener listener, String dbBaseUri, BackupDescriptor descriptor) {
        this.broker = broker;
        this.listener = listener;
        this.dbBaseUri = dbBaseUri;
        this.descriptor = descriptor;
        this.rh = broker.getDatabase().getPluginsManager().getRestoreHandler();
    }

    @Override
    public void startDocument() throws SAXException {
        this.listener.setCurrentBackup(this.descriptor.getSymbolicPath());
        this.rh.startDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("collection".equals(localName) || "resource".equals(localName)) {
            DeferredPermission df = "collection".equals(localName) ? this.restoreCollectionEntry(atts) : this.restoreResourceEntry(atts);
            this.deferredPermissions.push(df);
        } else if ("subcollection".equals(localName)) {
            this.restoreSubCollectionEntry(atts);
        } else if ("deleted".equals(localName)) {
            this.restoreDeletedEntry(atts);
        } else if ("ace".equals(localName)) {
            this.addACEToDeferredPermissions(atts);
        } else {
            this.rh.startElement(namespaceURI, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (namespaceURI.equals("http://exist.sourceforge.net/NS/exist") && ("collection".equals(localName) || "resource".equals(localName))) {
            this.setDeferredPermissions();
        }
        this.rh.endElement(namespaceURI, localName, qName);
        super.endElement(namespaceURI, localName, qName);
    }

    private DeferredPermission restoreCollectionEntry(Attributes atts) throws SAXException {
        String msg;
        String name = atts.getValue("name");
        if (name == null) {
            throw new SAXException("Collection requires a name attribute");
        }
        String owner = atts.getValue("owner");
        String group = atts.getValue("group");
        String mode = atts.getValue("mode");
        String created = atts.getValue("created");
        String strVersion = atts.getValue("version");
        if (strVersion != null) {
            try {
                this.version = Integer.parseInt(strVersion);
            }
            catch (NumberFormatException nfe) {
                msg = "Could not parse version number for Collection '" + name + "', defaulting to version 0";
                this.listener.warn(msg);
                LOG.warn(msg);
                this.version = 0;
            }
        }
        try {
            XmldbURI collUri;
            this.listener.createCollection(name);
            if (this.version >= 1) {
                collUri = XmldbURI.create(name);
            } else {
                try {
                    collUri = URIUtils.encodeXmldbUriFor(name);
                }
                catch (URISyntaxException e) {
                    this.listener.warn("Could not parse document name into a URI: " + e.getMessage());
                    return new SkippedEntryDeferredPermission();
                }
            }
            TransactionManager txnManager = this.broker.getDatabase().getTransactionManager();
            try (Txn txn = txnManager.beginTransaction();){
                this.currentCollection = this.broker.getOrCreateCollection(txn, collUri);
                this.rh.startCollectionRestore(this.currentCollection, atts);
                this.broker.saveCollection(txn, this.currentCollection);
                txnManager.commit(txn);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            this.currentCollection = this.mkcol(collUri, this.getDateFromXSDateTimeStringForItem(created, name));
            this.listener.setCurrentCollection(name);
            if (this.currentCollection == null) {
                throw new SAXException("Collection not found: " + collUri);
            }
            CollectionDeferredPermission deferredPermission = name.startsWith("/db/system") ? new CollectionDeferredPermission(this.listener, this.currentCollection, "SYSTEM", "dba", Integer.parseInt(mode, 8)) : new CollectionDeferredPermission(this.listener, this.currentCollection, owner, group, Integer.parseInt(mode, 8));
            this.rh.endCollectionRestore(this.currentCollection);
            return deferredPermission;
        }
        catch (Exception e) {
            msg = "An unrecoverable error occurred while restoring\ncollection '" + name + "'. Aborting restore!";
            LOG.error(msg, (Throwable)e);
            this.listener.warn(msg);
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void restoreSubCollectionEntry(Attributes atts) throws SAXException {
        String name = atts.getValue("filename") != null ? atts.getValue("filename") : atts.getValue("name");
        BackupDescriptor subDescriptor = this.descriptor.getChildBackupDescriptor(name);
        if (subDescriptor != null) {
            try {
                SAXParser sax = saxFactory.newSAXParser();
                XMLReader reader = sax.getXMLReader();
                EXistInputSource is = subDescriptor.getInputSource();
                is.setEncoding("UTF-8");
                SystemImportHandler handler = new SystemImportHandler(this.broker, this.listener, this.dbBaseUri, subDescriptor);
                reader.setContentHandler(handler);
                reader.parse(is);
            }
            catch (SAXParseException e) {
                throw new SAXException("Could not process collection: " + this.descriptor.getSymbolicPath(name, false), e);
            }
            catch (ParserConfigurationException pce) {
                throw new SAXException("Could not initalise SAXParser for processing sub-collection: " + this.descriptor.getSymbolicPath(name, false), pce);
            }
            catch (IOException ioe) {
                throw new SAXException("Could not read sub-collection for processing: " + ioe.getMessage(), ioe);
            }
        } else {
            this.listener.error("Collection " + this.descriptor.getSymbolicPath(name, false) + " does not exist or is not readable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private DeferredPermission restoreResourceEntry(Attributes atts) throws SAXException {
        XmldbURI docUri;
        String skip = atts.getValue("skip");
        if (skip != null && !"no".equals(skip)) {
            return new SkippedEntryDeferredPermission();
        }
        String name = atts.getValue("name");
        if (name == null) {
            throw new SAXException("Resource requires a name attribute");
        }
        String type = atts.getValue("type") != null ? atts.getValue("type") : "XMLResource";
        String owner = atts.getValue("owner");
        String group = atts.getValue("group");
        String perms = atts.getValue("mode");
        String filename = atts.getValue("filename") != null ? atts.getValue("filename") : name;
        String mimetype = atts.getValue("mimetype");
        String created = atts.getValue("created");
        String modified = atts.getValue("modified");
        String publicid = atts.getValue("publicid");
        String systemid = atts.getValue("systemid");
        String namedoctype = atts.getValue("namedoctype");
        Date date_created = null;
        Date date_modified = null;
        if (created != null) {
            try {
                date_created = new DateTimeValue(created).getDate();
            }
            catch (XPathException xpe) {
                this.listener.warn("Illegal creation date. Ignoring date...");
            }
        }
        if (modified != null) {
            try {
                date_modified = new DateTimeValue(modified).getDate();
            }
            catch (XPathException xpe) {
                this.listener.warn("Illegal modification date. Ignoring date...");
            }
        }
        if (this.version >= 1) {
            docUri = XmldbURI.create(name);
        } else {
            try {
                docUri = URIUtils.encodeXmldbUriFor(name);
            }
            catch (URISyntaxException e) {
                String msg = "Could not parse document name into a URI: " + e.getMessage();
                this.listener.error(msg);
                LOG.error(msg, (Throwable)e);
                return new SkippedEntryDeferredPermission();
            }
        }
        EXistInputSource is = this.descriptor.getInputSource(filename);
        if (is == null) {
            String msg = "Failed to restore resource '" + name + "'\nfrom file '" + this.descriptor.getSymbolicPath(name, false) + "'.\nReason: Unable to obtain its EXistInputSource";
            this.listener.warn(msg);
            throw new RuntimeException(msg);
        }
        try {
            ResourceDeferredPermission resourceDeferredPermission;
            Throwable throwable;
            Txn txn;
            block39: {
                block40: {
                    this.listener.setCurrentResource(name);
                    if (this.currentCollection != null) {
                        this.listener.observe(this.currentCollection.getObservable());
                    }
                    TransactionManager txnManager = this.broker.getDatabase().getTransactionManager();
                    DocumentImpl resource = null;
                    txn = txnManager.beginTransaction();
                    throwable = null;
                    if ("XMLResource".equals(type)) {
                        IndexInfo info = this.currentCollection.validateXMLResource(txn, this.broker, docUri, is);
                        resource = info.getDocument();
                        DocumentMetadata meta = resource.getMetadata();
                        meta.setMimeType(mimetype);
                        meta.setCreated(date_created.getTime());
                        meta.setLastModified(date_modified.getTime());
                        if (publicid != null || systemid != null) {
                            DocumentTypeImpl docType = new DocumentTypeImpl(namedoctype, publicid, systemid);
                            meta.setDocType(docType);
                        }
                        this.rh.startDocumentRestore(resource, atts);
                        this.currentCollection.store(txn, this.broker, info, is);
                    } else {
                        resource = this.currentCollection.validateBinaryResource(txn, this.broker, docUri);
                        this.rh.startDocumentRestore(resource, atts);
                        resource = this.currentCollection.addBinaryResource(txn, this.broker, (BinaryDocument)resource, is.getByteStream(), mimetype, is.getByteStreamLength(), date_created, date_modified);
                    }
                    txnManager.commit(txn);
                    ResourceDeferredPermission deferredPermission = name.startsWith("/db/system") ? new ResourceDeferredPermission(this.listener, resource, "SYSTEM", "dba", Integer.parseInt(perms, 8)) : new ResourceDeferredPermission(this.listener, resource, owner, group, Integer.parseInt(perms, 8));
                    this.rh.endDocumentRestore(resource);
                    this.listener.restored(name);
                    resourceDeferredPermission = deferredPermission;
                    if (txn == null) break block39;
                    if (throwable == null) break block40;
                    try {
                        txn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block39;
                }
                txn.close();
            }
            return resourceDeferredPermission;
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (txn != null) {
                                if (throwable != null) {
                                    try {
                                        txn.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    txn.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                catch (Exception e) {
                    this.listener.warn("Failed to restore resource '" + name + "'\nfrom file '" + this.descriptor.getSymbolicPath(name, false) + "'.\nReason: " + e.getMessage());
                    LOG.error(e.getMessage(), (Throwable)e);
                    SkippedEntryDeferredPermission skippedEntryDeferredPermission = new SkippedEntryDeferredPermission();
                    return skippedEntryDeferredPermission;
                }
            }
        }
        finally {
            is.close();
        }
    }

    private void restoreDeletedEntry(Attributes atts) {
        block37: {
            String name = atts.getValue("name");
            String type = atts.getValue("type");
            if ("collection".equals(type)) {
                try {
                    Collection col = this.broker.getCollection(this.currentCollection.getURI().append(name));
                    if (col == null) break block37;
                    TransactionManager txnManager = this.broker.getDatabase().getTransactionManager();
                    try (Txn txn = txnManager.beginTransaction();){
                        this.broker.removeCollection(txn, col);
                        txnManager.commit(txn);
                    }
                    catch (Exception e) {
                        this.listener.warn("Failed to remove deleted collection: " + name + ": " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    this.listener.warn("Failed to remove deleted collection: " + name + ": " + e.getMessage());
                }
            } else if ("resource".equals(type)) {
                try {
                    XmldbURI uri = XmldbURI.create(name);
                    DocumentImpl doc = this.currentCollection.getDocument(this.broker, uri);
                    if (doc == null) break block37;
                    TransactionManager txnManager = this.broker.getDatabase().getTransactionManager();
                    try (Txn txn = txnManager.beginTransaction();){
                        if (doc.getResourceType() == 1) {
                            this.currentCollection.removeBinaryResource(txn, this.broker, uri);
                        } else {
                            this.currentCollection.removeXMLResource(txn, this.broker, uri);
                        }
                        txnManager.commit(txn);
                    }
                    catch (Exception e) {
                        this.listener.warn("Failed to remove deleted resource: " + name + ": " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    this.listener.warn("Failed to remove deleted resource: " + name + ": " + e.getMessage());
                }
            }
        }
    }

    private void addACEToDeferredPermissions(Attributes atts) {
        int index = Integer.parseInt(atts.getValue("index"));
        ACLPermission.ACE_TARGET target = ACLPermission.ACE_TARGET.valueOf(atts.getValue("target"));
        String who = atts.getValue("who");
        ACLPermission.ACE_ACCESS_TYPE access_type = ACLPermission.ACE_ACCESS_TYPE.valueOf(atts.getValue("access_type"));
        int mode = Integer.parseInt(atts.getValue("mode"), 8);
        this.deferredPermissions.peek().addACE(index, target, who, access_type, mode);
    }

    private void setDeferredPermissions() {
        DeferredPermission deferredPermission = this.deferredPermissions.pop();
        deferredPermission.apply();
    }

    private Date getDateFromXSDateTimeStringForItem(String strXSDateTime, String itemName) {
        Date date_created = null;
        if (strXSDateTime != null) {
            try {
                date_created = new DateTimeValue(strXSDateTime).getDate();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        if (date_created == null) {
            String msg = "Could not parse created date '" + strXSDateTime + "' from backup for: '" + itemName + "', using current time!";
            this.listener.error(msg);
            LOG.error(msg);
            date_created = Calendar.getInstance().getTime();
        }
        return date_created;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection mkcol(XmldbURI collPath, Date created) throws SAXException {
        TransactionManager txnManager = this.broker.getDatabase().getTransactionManager();
        try (Txn txn = txnManager.beginTransaction();){
            Collection col = this.broker.getOrCreateCollection(txn, collPath);
            txnManager.commit(txn);
            Collection collection = col;
            return collection;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    static {
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
    }

    class ResourceDeferredPermission
    extends AbstractDeferredPermission<DocumentImpl> {
        public ResourceDeferredPermission(RestoreListener listener, DocumentImpl resource, String owner, String group, Integer mode) {
            super(listener, resource, owner, group, mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply() {
            try {
                ((DocumentImpl)this.getTarget()).getUpdateLock().acquire(Lock.LockMode.WRITE_LOCK);
                TransactionManager txnManager = SystemImportHandler.this.broker.getDatabase().getTransactionManager();
                try (Txn txn = txnManager.beginTransaction();){
                    Permission permission = ((DocumentImpl)this.getTarget()).getPermissions();
                    permission.setOwner(this.getOwner());
                    permission.setGroup(this.getGroup());
                    permission.setMode(this.getMode());
                    if (permission instanceof ACLPermission) {
                        ACLPermission aclPermission = (ACLPermission)((Object)permission);
                        aclPermission.clear();
                        for (ACEAider ace : this.getAces()) {
                            aclPermission.addACE(ace.getAccessType(), ace.getTarget(), ace.getWho(), ace.getMode());
                        }
                    }
                    SystemImportHandler.this.broker.storeXMLResource(txn, (DocumentImpl)this.getTarget());
                    txnManager.commit(txn);
                }
                finally {
                    ((DocumentImpl)this.getTarget()).getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
                }
            }
            catch (Exception xe) {
                String msg = "ERROR: Failed to set permissions on Document '" + ((DocumentImpl)this.getTarget()).getURI() + "'.";
                LOG.error(msg, (Throwable)xe);
                this.getListener().warn(msg);
            }
        }
    }

    class CollectionDeferredPermission
    extends AbstractDeferredPermission<Collection> {
        public CollectionDeferredPermission(RestoreListener listener, Collection collection, String owner, String group, Integer mode) {
            super(listener, collection, owner, group, mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply() {
            try {
                ((Collection)this.getTarget()).getLock().acquire(Lock.LockMode.WRITE_LOCK);
                TransactionManager txnManager = SystemImportHandler.this.broker.getDatabase().getTransactionManager();
                try (Txn txn = txnManager.beginTransaction();){
                    Permission permission = ((Collection)this.getTarget()).getPermissions();
                    permission.setOwner(this.getOwner());
                    permission.setGroup(this.getGroup());
                    permission.setMode(this.getMode());
                    if (permission instanceof ACLPermission) {
                        ACLPermission aclPermission = (ACLPermission)((Object)permission);
                        aclPermission.clear();
                        for (ACEAider ace : this.getAces()) {
                            aclPermission.addACE(ace.getAccessType(), ace.getTarget(), ace.getWho(), ace.getMode());
                        }
                    }
                    SystemImportHandler.this.broker.saveCollection(txn, (Collection)this.getTarget());
                    txnManager.commit(txn);
                }
                finally {
                    ((Collection)this.getTarget()).release(Lock.LockMode.WRITE_LOCK);
                }
            }
            catch (Exception xe) {
                String msg = "ERROR: Failed to set permissions on Collection '" + ((Collection)this.getTarget()).getURI() + "'.";
                LOG.error(msg, (Throwable)xe);
                this.getListener().warn(msg);
            }
        }
    }
}

