/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.restore.listener;

import java.util.Observable;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.exist.backup.RestoreDialog;
import org.exist.backup.restore.listener.AbstractRestoreListener;

public class GuiRestoreListener
extends AbstractRestoreListener {
    private final RestoreDialog dialog;

    public GuiRestoreListener() {
        this(null);
    }

    public GuiRestoreListener(JFrame parent) {
        this.dialog = new RestoreDialog(parent, "Restoring data ...", false);
        this.dialog.setVisible(true);
    }

    @Override
    public void info(String message) {
        SwingUtilities.invokeLater(() -> this.dialog.displayMessage(message));
    }

    @Override
    public void warn(String message) {
        super.warn(message);
        SwingUtilities.invokeLater(() -> this.dialog.displayMessage(message));
    }

    @Override
    public void error(String message) {
        super.error(message);
        SwingUtilities.invokeLater(() -> this.dialog.displayMessage(message));
    }

    @Override
    public void observe(Observable observable) {
        SwingUtilities.invokeLater(() -> observable.addObserver(this.dialog.getObserver()));
    }

    @Override
    public void setCurrentBackup(String currentBackup) {
        super.setCurrentBackup(currentBackup);
        SwingUtilities.invokeLater(() -> this.dialog.setBackup(currentBackup));
    }

    @Override
    public void setCurrentCollection(String currentCollectionName) {
        super.setCurrentCollection(currentCollectionName);
        SwingUtilities.invokeLater(() -> this.dialog.setCollection(currentCollectionName));
    }

    @Override
    public void setCurrentResource(String currentResourceName) {
        super.setCurrentResource(currentResourceName);
        SwingUtilities.invokeLater(() -> this.dialog.setResource(currentResourceName));
    }

    public void hideDialog() {
        this.dialog.setVisible(false);
    }
}

