/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.xquery;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.FileSystemBackupDescriptor;
import org.exist.backup.ZipArchiveBackupDescriptor;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.util.FileUtils;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.helpers.AttributesImpl;

public class ListBackups
extends BasicFunction {
    private static final String returnText = "an XML fragment listing all eXist backups found in the specified backup directory: <directory> <backup file=\"filename\"> <key>value</key><key>value</key></backup> <backup file=\"filename\"> <key>value</key><key>value</key></backup> </directory> Where key is a property name and value is a property value for the given .zip file.";
    public static final FunctionSignature signature = new FunctionSignature(new QName("list", "http://exist-db.org/xquery/backups", "backups"), "Returns an XML fragment listing all eXist backups found in a specified backup directory.", new SequenceType[]{new FunctionParameterSequenceType("directory", 22, 2, "The path to the directory to show the list of backups on.")}, new FunctionReturnSequenceType(-1, 2, "an XML fragment listing all eXist backups found in the specified backup directory: <directory> <backup file=\"filename\"> <key>value</key><key>value</key></backup> <backup file=\"filename\"> <key>value</key><key>value</key></backup> </directory> Where key is a property name and value is a property value for the given .zip file."));
    public static final QName DIRECTORY_ELEMENT = new QName("directory", "http://exist.sourceforge.net/NS/exist", "");
    public static final QName BACKUP_ELEMENT = new QName("backup", "http://exist.sourceforge.net/NS/exist", "");

    public ListBackups(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getEffectiveUser().hasDbaRole()) {
            throw new XPathException("You must be a DBA to list available backups");
        }
        String exportDir = args[0].getStringValue();
        Path dir = Paths.get(exportDir, new String[0]);
        if (!dir.isAbsolute()) {
            dir = ((Path)this.context.getBroker().getConfiguration().getProperty("db-connection.data-dir")).resolve(exportDir);
        }
        this.context.pushDocumentContext();
        try {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            int nodeNr = builder.startElement(DIRECTORY_ELEMENT, null);
            if (Files.isDirectory(dir, new LinkOption[0]) && Files.isReadable(dir)) {
                Pattern pattern = Pattern.compile("(full|inc)(\\d{8}-\\d{4}).*");
                Matcher matcher = pattern.matcher("");
                List<Path> files = FileUtils.list(dir);
                for (Path file : files) {
                    matcher.reset(FileUtils.fileName(file));
                    if (!matcher.matches()) continue;
                    try {
                        Properties properties;
                        AbstractBackupDescriptor descriptor;
                        if (FileUtils.fileName(file).endsWith(".zip")) {
                            descriptor = new ZipArchiveBackupDescriptor(file);
                        } else {
                            Path descriptorFile = file.resolve("db").resolve("__contents__.xml");
                            descriptor = new FileSystemBackupDescriptor(descriptorFile);
                        }
                        if ((properties = descriptor.getProperties()) == null) continue;
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addAttribute("", "file", "file", "CDATA", FileUtils.fileName(file));
                        builder.startElement(BACKUP_ELEMENT, attrs);
                        Iterator<Object> iter = properties.keySet().iterator();
                        while (iter.hasNext()) {
                            String key = iter.next().toString();
                            builder.startElement(new QName(key, "http://exist.sourceforge.net/NS/exist", ""), null);
                            builder.characters((String)properties.get(key));
                            builder.endElement();
                        }
                        builder.endElement();
                    }
                    catch (IOException iOException) {}
                }
            }
            builder.endElement();
            NodeImpl nodeImpl = builder.getDocument().getNode(nodeNr);
            return nodeImpl;
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, (Throwable)ioe);
        }
        finally {
            this.context.popDocumentContext();
        }
    }
}

