/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.exist.util.ArgumentUtil;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.util.URIUtils;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Arguments;
import se.softhouse.jargo.CommandLineParser;
import se.softhouse.jargo.ParsedArguments;
import se.softhouse.jargo.StringParsers;

public class CommandlineOptions {
    private static final Argument<?> helpArg = Arguments.helpArgument((String)"-h", (String[])new String[]{"--help"});
    private static final Argument<Boolean> quietArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-q", (String[])new String[]{"--quiet"}).description("be quiet. Just print errors.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> verboseArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-v", (String[])new String[]{"--verbose"}).description("be verbose. Display progress information on put.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<File> outputFileArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-O", "--output"}).description("write output of command into given file (use with -x, -g).")).build();
    private static final Argument<Map<String, String>> optionArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-o", "--option"}).description("specify extra options: property=value. For available properties see client.properties.")).asKeyValuesWithKeyParser(StringParsers.stringParser()).build();
    private static final Argument<String> userArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-u", "--user"}).description("set username.")).defaultValue(null)).build();
    private static final Argument<String> passwordArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-P", "--password"}).description("specify password.")).build();
    private static final Argument<Boolean> useSslArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-S", (String[])new String[]{"--use-ssl"}).description("Use SSL by default for remote connections")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> embeddedArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-l", (String[])new String[]{"--local"}).description("launch a local database instance. Otherwise client will connect to URI specified in client.properties.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<File> embeddedConfigArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-C", "--config"}).description("specify alternate configuration file. Implies -l.")).build();
    private static final Argument<Boolean> noEmbeddedModeArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-N", (String[])new String[]{"--no-embedded-mode"}).description("do not make embedded mode available")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> noGuiArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-s", (String[])new String[]{"--no-gui"}).description("don't start client with GUI. Just use the shell.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> guiQueryDialogArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-Q", (String[])new String[]{"--query"}).description("directly open the query gui")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<String> mkColArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-m", "--mkcol"}).description("create a collection (and any missing parent collection). Implies -c.")).build();
    private static final Argument<String> rmColArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-R", "--rmcol"}).description("remove entire collection")).build();
    private static final Argument<String> setColArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-c", "--collection"}).description("set target collection.")).build();
    private static final Argument<List<File>> parseDocsArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-p", "--parse"}).description("store files or directories given as extra args on command line.")).variableArity().build();
    private static final Argument<String> getDocArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-g", "--get"}).description("retrieve a document.")).build();
    private static final Argument<String> rmDocArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-r", "--remove"}).description("remove a document.")).build();
    public static final String XPATH_STDIN = "<<STDIN";
    private static final Argument<String> xpathArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-x", "--xpath"}).description("execute XPath query given as argument. Without argument reads query from stdin.")).build();
    private static final Argument<List<File>> loadQueriesArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-F", "--file"}).description("load queries from file and execute in random order.")).variableArity().build();
    private static final Argument<Integer> howManyResultsArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.integerArgument((String[])new String[]{"-n", "--howmany"}).description("max. number of query results to be displayed.")).build();
    private static final Argument<File> traceQueriesArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-T", "--trace"}).description("log queries to the file specified by the argument (for debugging).")).build();
    private static final Argument<String> setDocArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.stringArgument((String[])new String[]{"-f", "--resource"}).description("specify a resource contained in the current collection. Use in conjunction with --xupdate to specify the resource to update.")).build();
    private static final Argument<File> xupdateArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-X", "--xupdate"}).description("process XUpdate commands. Commands are read from the file specified in the argument.")).build();
    private static final Argument<Boolean> reindexArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-i", (String[])new String[]{"--reindex"}).description("reindex the collection specified in the collection argument --collection")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> reindexRecurseDirsArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-d", (String[])new String[]{"--recurse-dirs"}).description("recurse into subdirectories during index?")).defaultValue(Boolean.valueOf(false)).build();
    final boolean quiet;
    final boolean verbose;
    final Optional<Path> outputFile;
    final Map<String, String> options;
    final Optional<String> username;
    final Optional<String> password;
    final boolean useSSL;
    final boolean embedded;
    final Optional<Path> embeddedConfig;
    final boolean noEmbeddedMode;
    final boolean startGUI;
    final boolean openQueryGUI;
    final Optional<XmldbURI> mkCol;
    final Optional<XmldbURI> rmCol;
    final Optional<XmldbURI> setCol;
    final List<Path> parseDocs;
    final Optional<XmldbURI> getDoc;
    final Optional<String> rmDoc;
    final Optional<String> xpath;
    final List<Path> queryFiles;
    final Optional<Integer> howManyResults;
    final Optional<Path> traceQueriesFile;
    final Optional<String> setDoc;
    final Optional<Path> xupdateFile;
    final boolean reindex;
    final boolean reindexRecurse;

    private static Optional<XmldbURI> optUri(ParsedArguments parsedArguments, Argument<String> argument) throws URISyntaxException {
        Optional<String> uriStr = ArgumentUtil.getOpt(parsedArguments, argument);
        if (uriStr.isPresent()) {
            return Optional.of(URIUtils.encodeXmldbUriFor(uriStr.get()));
        }
        return Optional.empty();
    }

    public static CommandlineOptions parse(String[] args) throws ArgumentException, URISyntaxException {
        ParsedArguments arguments = CommandLineParser.withArguments((Argument[])new Argument[]{userArg, passwordArg, useSslArg, embeddedArg, embeddedConfigArg, noEmbeddedModeArg}).andArguments(new Argument[]{noGuiArg, guiQueryDialogArg}).andArguments(new Argument[]{mkColArg, rmColArg, setColArg}).andArguments(new Argument[]{parseDocsArg, getDocArg, rmDocArg}).andArguments(new Argument[]{xpathArg, loadQueriesArg, howManyResultsArg, traceQueriesArg}).andArguments(new Argument[]{setDocArg, xupdateArg}).andArguments(new Argument[]{reindexArg, reindexRecurseDirsArg}).andArguments(new Argument[]{helpArg, quietArg, verboseArg, outputFileArg, optionArg}).parse(args);
        boolean quiet = ArgumentUtil.getBool(arguments, quietArg);
        boolean verbose = ArgumentUtil.getBool(arguments, verboseArg);
        Optional<Path> outputFile = ArgumentUtil.getPathOpt(arguments, outputFileArg);
        Map options = (Map)arguments.get(optionArg);
        Optional<String> username = ArgumentUtil.getOpt(arguments, userArg);
        Optional<String> password = ArgumentUtil.getOpt(arguments, passwordArg);
        boolean useSSL = ArgumentUtil.getBool(arguments, useSslArg);
        boolean embedded = ArgumentUtil.getBool(arguments, embeddedArg);
        Optional<Path> embeddedConfig = ArgumentUtil.getPathOpt(arguments, embeddedConfigArg);
        boolean noEmbeddedMode = ArgumentUtil.getBool(arguments, noEmbeddedModeArg);
        boolean startGUI = !ArgumentUtil.getBool(arguments, noGuiArg);
        boolean openQueryGUI = ArgumentUtil.getBool(arguments, guiQueryDialogArg);
        Optional<XmldbURI> mkCol = CommandlineOptions.optUri(arguments, mkColArg);
        Optional<XmldbURI> rmCol = CommandlineOptions.optUri(arguments, rmColArg);
        Optional<XmldbURI> setCol = CommandlineOptions.optUri(arguments, setColArg);
        List<Path> parseDocs = ArgumentUtil.getPathsOpt(arguments, parseDocsArg);
        Optional<XmldbURI> getDoc = CommandlineOptions.optUri(arguments, getDocArg);
        Optional<String> rmDoc = ArgumentUtil.getOpt(arguments, rmDocArg);
        Optional<String> maybeXpath = ArgumentUtil.getOpt(arguments, xpathArg);
        Optional<String> xpath = maybeXpath.isPresent() ? (maybeXpath.get().isEmpty() ? Optional.of(XPATH_STDIN) : maybeXpath) : Optional.empty();
        List<Path> queryFiles = ArgumentUtil.getPathsOpt(arguments, loadQueriesArg);
        Optional<Integer> howManyResults = ArgumentUtil.getOpt(arguments, howManyResultsArg);
        Optional<Path> traceQueriesFile = ArgumentUtil.getPathOpt(arguments, traceQueriesArg);
        Optional<String> setDoc = ArgumentUtil.getOpt(arguments, setDocArg);
        Optional<Path> xupdateFile = ArgumentUtil.getPathOpt(arguments, xupdateArg);
        boolean reindex = ArgumentUtil.getBool(arguments, reindexArg);
        boolean reindexRecurse = ArgumentUtil.getBool(arguments, reindexRecurseDirsArg);
        return new CommandlineOptions(quiet, verbose, outputFile, options, username, password, useSSL, embedded, embeddedConfig, noEmbeddedMode, startGUI, openQueryGUI, mkCol, rmCol, setCol, parseDocs, getDoc, rmDoc, xpath, queryFiles, howManyResults, traceQueriesFile, setDoc, xupdateFile, reindex, reindexRecurse);
    }

    public CommandlineOptions(boolean quiet, boolean verbose, Optional<Path> outputFile, Map<String, String> options, Optional<String> username, Optional<String> password, boolean useSSL, boolean embedded, Optional<Path> embeddedConfig, boolean noEmbeddedMode, boolean startGUI, boolean openQueryGUI, Optional<XmldbURI> mkCol, Optional<XmldbURI> rmCol, Optional<XmldbURI> setCol, List<Path> parseDocs, Optional<XmldbURI> getDoc, Optional<String> rmDoc, Optional<String> xpath, List<Path> queryFiles, Optional<Integer> howManyResults, Optional<Path> traceQueriesFile, Optional<String> setDoc, Optional<Path> xupdateFile, boolean reindex, boolean reindexRecurse) {
        this.quiet = quiet;
        this.verbose = verbose;
        this.outputFile = outputFile;
        this.options = options;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
        this.embedded = embedded;
        this.embeddedConfig = embeddedConfig;
        this.noEmbeddedMode = noEmbeddedMode;
        this.startGUI = startGUI;
        this.openQueryGUI = openQueryGUI;
        this.mkCol = mkCol;
        this.rmCol = rmCol;
        this.setCol = setCol;
        this.parseDocs = parseDocs;
        this.getDoc = getDoc;
        this.rmDoc = rmDoc;
        this.xpath = xpath;
        this.queryFiles = queryFiles;
        this.howManyResults = howManyResults;
        this.traceQueriesFile = traceQueriesFile;
        this.setDoc = setDoc;
        this.xupdateFile = xupdateFile;
        this.reindex = reindex;
        this.reindexRecurse = reindexRecurse;
    }
}

