/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.exist.client.CollectionXConf;
import org.exist.client.InteractiveClient;
import org.exist.client.PrettyXmldbURI;
import org.exist.client.ResourceDescriptor;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

class IndexDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String[] CONFIG_TYPE = new String[]{"qname", "path"};
    private static final String[] INDEX_TYPES = new String[]{"xs:boolean", "xs:integer", "xs:dateTime", "xs:string"};
    private CollectionXConf cx = null;
    private JComboBox cmbCollections;
    private JTable tblRangeIndexes;
    private RangeIndexTableModel rangeIndexModel;
    private InteractiveClient client;

    public IndexDialog(String title, InteractiveClient client) {
        super(title);
        this.client = client;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IndexDialog.this.saveChanges(true);
                IndexDialog.this.setVisible(false);
                IndexDialog.this.dispose();
            }
        };
        this.addWindowListener(windowListener);
        this.setupComponents();
        this.actionGetIndexes("/db");
    }

    private void setupComponents() {
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        JLabel label = new JLabel("Collection");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        ArrayList alCollections = new ArrayList();
        try {
            Collection root = this.client.getCollection("/db");
            ArrayList alAllCollections = this.getCollections(root, new ArrayList());
            for (int i = 0; i < alAllCollections.size(); ++i) {
                if (!alAllCollections.get(i).toString().contains("/db/system/config")) continue;
                alCollections.add(alAllCollections.get(i));
            }
        }
        catch (XMLDBException e2) {
            return;
        }
        this.cmbCollections = new JComboBox<Object>(alCollections.toArray());
        this.cmbCollections.addActionListener(e -> {
            this.saveChanges(true);
            JComboBox cb = (JComboBox)e.getSource();
            this.actionGetIndexes(cb.getSelectedItem().toString());
        });
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        grid.setConstraints(this.cmbCollections, c);
        this.getContentPane().add(this.cmbCollections);
        JPanel panelRangeIndexes = new JPanel();
        panelRangeIndexes.setBorder(new TitledBorder("Range Indexes"));
        GridBagLayout panelRangeIndexesGrid = new GridBagLayout();
        panelRangeIndexes.setLayout(panelRangeIndexesGrid);
        this.rangeIndexModel = new RangeIndexTableModel();
        this.tblRangeIndexes = new JTable(this.rangeIndexModel);
        this.tblRangeIndexes.setAutoResizeMode(1);
        this.tblRangeIndexes.setRowHeight(20);
        this.tblRangeIndexes.setSelectionMode(0);
        TableColumn colxsType = this.tblRangeIndexes.getColumnModel().getColumn(2);
        colxsType.setCellEditor(new ComboBoxCellEditor(INDEX_TYPES));
        colxsType.setCellRenderer(new ComboBoxCellRenderer(INDEX_TYPES));
        colxsType = this.tblRangeIndexes.getColumnModel().getColumn(0);
        colxsType.setCellEditor(new ComboBoxCellEditor(CONFIG_TYPE));
        colxsType.setCellRenderer(new ComboBoxCellRenderer(CONFIG_TYPE));
        JScrollPane scrollRangeIndexes = new JScrollPane(this.tblRangeIndexes);
        scrollRangeIndexes.setPreferredSize(new Dimension(350, 150));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelRangeIndexesGrid.setConstraints(scrollRangeIndexes, c);
        panelRangeIndexes.add(scrollRangeIndexes);
        Box rangeIndexToolbarBox = Box.createHorizontalBox();
        JButton btnAddRangeIndex = new JButton("Add");
        btnAddRangeIndex.addActionListener(e -> this.actionAddRangeIndex());
        rangeIndexToolbarBox.add(btnAddRangeIndex);
        JButton btnDeleteRangeIndex = new JButton("Delete");
        btnDeleteRangeIndex.addActionListener(e -> this.actionDeleteRangeIndex());
        rangeIndexToolbarBox.add(btnDeleteRangeIndex);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelRangeIndexesGrid.setConstraints(rangeIndexToolbarBox, c);
        panelRangeIndexes.add(rangeIndexToolbarBox);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.3333333432674408;
        grid.setConstraints(panelRangeIndexes, c);
        this.getContentPane().add(panelRangeIndexes);
        Box mainBtnBox = Box.createHorizontalBox();
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        JButton saveBtn = new JButton("Save");
        saveBtn.addActionListener(e -> {
            this.saveChanges(false);
            this.setVisible(false);
            this.dispose();
        });
        mainBtnBox.add(saveBtn);
        mainBtnBox.add(cancelBtn);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        grid.setConstraints(mainBtnBox, c);
        this.getContentPane().add(mainBtnBox);
        this.pack();
    }

    private void saveChanges(boolean ask) {
        if (this.cx.hasChanged()) {
            int result;
            boolean doSave = true;
            if (ask) {
                result = JOptionPane.showConfirmDialog(this.getContentPane(), "The configuration for the collection has changed, would you like to save the changes?", "Save Changes", 0);
                boolean bl = doSave = result == 0;
            }
            if (doSave) {
                if (this.cx.Save()) {
                    result = JOptionPane.showConfirmDialog(this.getContentPane(), "Your changes have been saved, but will not take effect until the collection is reindexed!\n Would you like to reindex " + this.cmbCollections.getSelectedItem() + " and sub-collections now?", "Reindex", 0);
                    if (result == 0) {
                        Runnable runnable = () -> {
                            try {
                                IndexQueryService service = (IndexQueryService)this.client.current.getService("IndexQueryService", "1.0");
                                ArrayList subCollections = this.getCollections(this.client.getCollection((String)this.cmbCollections.getSelectedItem()), new ArrayList());
                                for (int i = 0; i < subCollections.size(); ++i) {
                                    service.reindexCollection(((ResourceDescriptor)subCollections.get(i)).getName());
                                }
                                JOptionPane.showMessageDialog(this.getContentPane(), "Reindex Complete");
                            }
                            catch (XMLDBException e) {
                                JOptionPane.showMessageDialog(this.getContentPane(), "Reindex failed!");
                            }
                        };
                    }
                } else {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Unable to save changes!");
                }
            }
        }
    }

    private ArrayList getCollections(Collection root, ArrayList collectionsList) throws XMLDBException {
        String[] childCollections;
        collectionsList.add(new PrettyXmldbURI(XmldbURI.create(root.getName())));
        for (String childCollection : childCollections = root.listChildCollections()) {
            Collection child = root.getChildCollection(childCollection);
            this.getCollections(child, collectionsList);
        }
        return collectionsList;
    }

    private void actionAddRangeIndex() {
        this.rangeIndexModel.addRow();
    }

    private void actionDeleteRangeIndex() {
        int iSelectedRow = this.tblRangeIndexes.getSelectedRow();
        if (iSelectedRow > -1) {
            this.rangeIndexModel.removeRow(iSelectedRow);
        }
    }

    private void actionGetIndexes(String collectionName) {
        try {
            this.cx = new CollectionXConf(collectionName, this.client);
            this.rangeIndexModel.fireTableDataChanged();
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
    }

    class RangeIndexTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{"Type", "XPath", "xsType"};

        public RangeIndexTableModel() {
            this.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    IndexDialog.this.cx.updateRangeIndex(rowIndex, aValue.toString(), null, null);
                    break;
                }
                case 1: {
                    IndexDialog.this.cx.updateRangeIndex(rowIndex, null, aValue.toString(), null);
                    break;
                }
                case 2: {
                    IndexDialog.this.cx.updateRangeIndex(rowIndex, null, null, aValue.toString());
                    break;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void removeRow(int rowIndex) {
            IndexDialog.this.cx.deleteRangeIndex(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void addRow() {
            IndexDialog.this.cx.addRangeIndex("qname", "", "xs:string");
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount() + 1);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return IndexDialog.this.cx != null ? IndexDialog.this.cx.getRangeIndexCount() : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return IndexDialog.this.cx.getRangeIndex(rowIndex).getType();
                }
                case 1: {
                    return IndexDialog.this.cx.getRangeIndex(rowIndex).getXPath();
                }
                case 2: {
                    return IndexDialog.this.cx.getRangeIndex(rowIndex).getxsType();
                }
            }
            return null;
        }
    }

    public static class ComboBoxCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public ComboBoxCellEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    public static class ComboBoxCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ComboBoxCellRenderer(String[] items) {
            super(items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

