/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.Terminal;
import org.exist.SystemProperties;
import org.exist.client.ClientFrame;
import org.exist.client.CommandlineOptions;
import org.exist.client.DocumentView;
import org.exist.client.QueryDialog;
import org.exist.client.ResourceDescriptor;
import org.exist.client.UploadDialog;
import org.exist.dom.persistent.XMLUtil;
import org.exist.security.ACLPermission;
import org.exist.security.Account;
import org.exist.security.Permission;
import org.exist.security.internal.aider.UserAider;
import org.exist.storage.ElementIndex;
import org.exist.util.CollectionScanner;
import org.exist.util.ConfigurationHelper;
import org.exist.util.DirectoryScanner;
import org.exist.util.FileUtils;
import org.exist.util.GZIPInputSource;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.Occurrences;
import org.exist.util.ProgressBar;
import org.exist.util.ProgressIndicator;
import org.exist.util.ZipEntryInputSource;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.EXistXPathQueryService;
import org.exist.xmldb.ExtendedResource;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XUpdateQueryService;
import se.softhouse.jargo.ArgumentException;

public class InteractiveClient {
    private static final String ANSI_CYAN = "\u001b[0;36m";
    private static final String ANSI_WHITE = "\u001b[0;37m";
    private static final String EOL = System.getProperty("line.separator");
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String URI = "uri";
    public static final String PERMISSIONS = "permissions";
    public static final String INDENT = "indent";
    public static final String ENCODING = "encoding";
    public static final String COLORS = "colors";
    public static final String EDITOR = "editor";
    public static final String EXPAND_XINCLUDES = "expand-xincludes";
    public static final String CONFIGURATION = "configuration";
    public static final String DRIVER = "driver";
    public static final String SSL_ENABLE = "ssl-enable";
    public static final String CREATE_DATABASE = "create-database";
    public static final String LOCAL_MODE = "local-mode-opt";
    public static final String NO_EMBED_MODE = "NO_EMBED_MODE";
    protected static final String EDIT_CMD = "emacsclient -t $file";
    protected static final Charset ENCODING_DEFAULT = StandardCharsets.UTF_8;
    protected static final String URI_DEFAULT = "xmldb:exist://localhost:8080/exist/xmlrpc";
    protected static final String SSL_ENABLE_DEFAULT = "FALSE";
    protected static final String LOCAL_MODE_DEFAULT = "FALSE";
    protected static final String NO_EMBED_MODE_DEFAULT = "FALSE";
    protected static final String USER_DEFAULT = "admin";
    protected static final Properties defaultProps = new Properties();
    protected static final int[] colSizes = new int[]{10, 10, 10, -1};
    protected static final String driver = "org.exist.xmldb.DatabaseImpl";
    protected static String configuration = null;
    protected final TreeSet<String> completitions;
    protected final LinkedList<String> queryHistory;
    protected Path queryHistoryFile;
    protected Path historyFile;
    protected ConsoleReader console;
    protected Collection current;
    protected int nextInSet;
    protected Properties properties;
    protected String[] resources;
    protected ResourceSet result;
    protected final Map<String, String> namespaceMappings;
    protected int filesCount;
    protected long totalLength;
    protected ClientFrame frame;
    private static boolean havePluggableCommands = false;
    private CommandlineOptions options;
    protected XmldbURI path;
    private Optional<Writer> lazyTraceWriter;

    public InteractiveClient() {
        defaultProps.setProperty(DRIVER, driver);
        defaultProps.setProperty(URI, URI_DEFAULT);
        defaultProps.setProperty(USER, USER_DEFAULT);
        defaultProps.setProperty(EDITOR, EDIT_CMD);
        defaultProps.setProperty(INDENT, "true");
        defaultProps.setProperty(ENCODING, ENCODING_DEFAULT.name());
        defaultProps.setProperty(COLORS, "false");
        defaultProps.setProperty(PERMISSIONS, "false");
        defaultProps.setProperty(EXPAND_XINCLUDES, "true");
        defaultProps.setProperty(SSL_ENABLE, "FALSE");
        this.completitions = new TreeSet();
        this.queryHistory = new LinkedList();
        this.console = null;
        this.current = null;
        this.nextInSet = 1;
        this.resources = null;
        this.result = null;
        this.namespaceMappings = new HashMap<String, String>();
        this.filesCount = 0;
        this.totalLength = 0L;
        this.path = XmldbURI.ROOT_COLLECTION_URI;
        this.lazyTraceWriter = Optional.empty();
    }

    protected void displayHelp() {
        this.messageln("--- general commands ---");
        this.messageln("ls                   list collection contents");
        this.messageln("cd [collection|..]   change current collection");
        this.messageln("put [file pattern]   upload file or directory to the database");
        this.messageln("putgz [file pattern] upload possibly gzip compressed file or directory to the database");
        this.messageln("putzip [file pattern] upload the contents of a ZIP archive to the database");
        this.messageln("edit [resource] open the resource for editing");
        this.messageln("mkcol collection     create new sub-collection in current collection");
        this.messageln("rm document          remove document from current collection");
        this.messageln("rmcol collection     remove collection");
        this.messageln("set [key=value]      set property. Calling set without ");
        this.messageln("                     argument shows current settings.");
        this.messageln(EOL + "--- search commands ---");
        this.messageln("find xpath-expr      execute the given XPath expression.");
        this.messageln("show [position]      display query result value at position.");
        this.messageln(EOL + "--- user management (may require dba rights) ---");
        this.messageln("users                list existing users.");
        this.messageln("adduser username     create a new user.");
        this.messageln("passwd username      change password for user. ");
        this.messageln("chown user group [resource]");
        this.messageln("                     change resource ownership. chown without");
        this.messageln("                     resource changes ownership of the current");
        this.messageln("                     collection.");
        this.messageln("chmod [resource] permissions");
        this.messageln("                     change resource permissions. Format:");
        this.messageln("                     [user|group|other]=[+|-][read|write|execute].");
        this.messageln("                     chmod without resource changes permissions for");
        this.messageln("                     the current collection.");
        this.messageln("lock resource        put a write lock on the specified resource.");
        this.messageln("unlock resource      remove a write lock from the specified resource.");
        if (havePluggableCommands) {
            this.messageln("svn                  subversion command-line client.");
            this.messageln("threads              threads debug information.");
        }
        this.messageln("quit                 quit the program");
    }

    public static void main(String[] args) {
        try {
            InteractiveClient client = new InteractiveClient();
            if (!client.run(args)) {
                System.exit(1);
            }
        }
        catch (ArgumentException e) {
            System.out.println(e.getMessageAndUsage());
            System.exit(3);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void connect() throws Exception {
        System.out.println("Connecting to database...");
        String uri = this.properties.getProperty(URI);
        if (this.options.startGUI && this.frame != null) {
            this.frame.setStatus("connecting to " + uri);
        }
        Class<?> cl = Class.forName(this.properties.getProperty(DRIVER));
        Database database = (Database)cl.newInstance();
        database.setProperty(CREATE_DATABASE, "true");
        database.setProperty(SSL_ENABLE, this.properties.getProperty(SSL_ENABLE));
        String configProp = this.properties.getProperty(CONFIGURATION);
        if (configProp != null && !configProp.isEmpty()) {
            database.setProperty(CONFIGURATION, configProp);
        }
        DatabaseManager.registerDatabase((Database)database);
        String collectionUri = uri + this.path;
        this.current = DatabaseManager.getCollection((String)collectionUri, (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
        if (this.options.startGUI && this.frame != null) {
            this.frame.setStatus("connected to " + uri + " as user " + this.properties.getProperty(USER));
        }
        System.out.println("Connected :-)");
    }

    protected Collection getCollection() {
        return this.current;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void reloadCollection() throws XMLDBException {
        this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
        this.getResources();
    }

    protected void setProperties() throws XMLDBException {
        for (String string : this.properties.keySet()) {
            this.current.setProperty(string, this.properties.getProperty(string));
        }
    }

    private String getOwnerName(Permission perm) {
        if (perm.getOwner() == null) {
            return "?";
        }
        return perm.getOwner().getName();
    }

    private String getGroupName(Permission perm) {
        if (perm.getOwner() == null) {
            return "?";
        }
        return perm.getGroup().getName();
    }

    protected void getResources() throws XMLDBException {
        Permission perm;
        int i;
        if (this.current == null) {
            return;
        }
        this.setProperties();
        UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
        String[] childCollections = this.current.listChildCollections();
        String[] childResources = this.current.listResources();
        this.resources = new String[childCollections.length + childResources.length];
        ArrayList<ResourceDescriptor> tableData = new ArrayList<ResourceDescriptor>(this.resources.length);
        String[] cols = new String[4];
        for (i = 0; i < childCollections.length; ++i) {
            perm = mgtService.getSubCollectionPermissions(this.current, childCollections[i]);
            if ("true".equals(this.properties.getProperty(PERMISSIONS))) {
                cols[0] = perm.toString();
                cols[1] = this.getOwnerName(perm);
                cols[2] = this.getGroupName(perm);
                cols[3] = childCollections[i];
                this.resources[i] = 'd' + InteractiveClient.formatString(cols, colSizes);
            } else {
                this.resources[i] = childCollections[i];
            }
            Date created = mgtService.getSubCollectionCreationTime(this.current, childCollections[i]);
            if (this.options.startGUI) {
                try {
                    tableData.add(new ResourceDescriptor.Collection(XmldbURI.xmldbUriFor(childCollections[i]), this.getOwnerName(perm), this.getGroupName(perm), "c" + (perm instanceof ACLPermission && ((ACLPermission)((Object)perm)).getACECount() > 0 ? perm.toString() + '+' : perm.toString()), created));
                }
                catch (URISyntaxException e) {
                    this.errorln("could not parse collection name into a valid URI: " + e.getMessage());
                }
            }
            this.completitions.add(childCollections[i]);
        }
        for (int j = 0; j < childResources.length; ++j) {
            Resource res = this.current.getResource(childResources[j]);
            perm = mgtService.getPermissions(res);
            if (perm == null) {
                System.out.println("null");
            }
            this.resources[i] = "true".equals(this.properties.getProperty(PERMISSIONS)) ? '-' + perm.toString() + '\t' + perm.getOwner().getName() + '\t' + perm.getGroup().getName() + '\t' + childResources[j] : childResources[j];
            Date lastModificationTime = ((EXistResource)res).getLastModificationTime();
            int n = i;
            this.resources[n] = this.resources[n] + "\t" + lastModificationTime;
            if (this.options.startGUI) {
                try {
                    tableData.add(new ResourceDescriptor.Document(XmldbURI.xmldbUriFor(childResources[j]), this.getOwnerName(perm), this.getGroupName(perm), "-" + (perm instanceof ACLPermission && ((ACLPermission)((Object)perm)).getACECount() > 0 ? perm.toString() + '+' : perm.toString()), lastModificationTime));
                }
                catch (URISyntaxException e) {
                    this.errorln("could not parse document name into a valid URI: " + e.getMessage());
                }
            }
            this.completitions.add(childResources[j]);
            ++i;
        }
        if (this.options.startGUI) {
            this.frame.setResources(tableData);
        }
    }

    protected void more(String str) {
        LineNumberReader reader = new LineNumberReader(new StringReader(str));
        try {
            String line;
            while (System.in.available() > 0) {
                System.in.read();
            }
            while ((line = reader.readLine()) != null) {
                if (reader.getLineNumber() % 24 == 0) {
                    System.out.print("line: " + reader.getLineNumber() + "; press [return] for more or [q] for quit.");
                    int ch = System.in.read();
                    if (ch == 113 || ch == 81) {
                        return;
                    }
                }
                System.out.println(line);
            }
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe);
        }
    }

    protected boolean process(String line) {
        String[] args;
        if (this.options.startGUI) {
            this.frame.setPath(this.path);
        }
        if (line.startsWith("find")) {
            args = new String[]{"find", line.substring(5)};
        } else {
            StreamTokenizer tok = new StreamTokenizer(new StringReader(line));
            tok.resetSyntax();
            tok.wordChars(33, Short.MAX_VALUE);
            tok.quoteChar(34);
            tok.whitespaceChars(32, 32);
            ArrayList<String> argList = new ArrayList<String>(3);
            try {
                int token;
                while ((token = tok.nextToken()) != -1) {
                    if (token != -3 && token != 34) continue;
                    argList.add(tok.sval);
                }
            }
            catch (IOException e) {
                System.err.println("Could not parse command line.");
                return true;
            }
            args = new String[argList.size()];
            argList.toArray(args);
        }
        if (args.length == 0) {
            return true;
        }
        try {
            XmldbURI newPath = this.path;
            XmldbURI currUri = XmldbURI.xmldbUriFor(this.properties.getProperty(URI)).resolveCollectionPath(this.path);
            if (args[0].equalsIgnoreCase("ls")) {
                int i;
                this.getResources();
                if ("true".equals(this.properties.getProperty(PERMISSIONS))) {
                    for (i = 0; i < this.resources.length; ++i) {
                        this.messageln(this.resources[i]);
                    }
                } else {
                    for (i = 0; i < this.resources.length; ++i) {
                        StringBuilder buf = new StringBuilder();
                        int k = 0;
                        int j = 0;
                        while (i < this.resources.length && j < 5) {
                            buf.append(this.resources[i]);
                            buf.append('\t');
                            k = j++;
                            ++i;
                        }
                        if (k == 4 && i < this.resources.length) {
                            --i;
                        }
                        this.messageln(buf.toString());
                    }
                }
            } else if (args[0].equalsIgnoreCase("cd")) {
                Collection temp;
                this.completitions.clear();
                XmldbURI collectionPath = args.length < 2 || args[1] == null ? XmldbURI.ROOT_COLLECTION_URI : XmldbURI.xmldbUriFor(args[1]);
                collectionPath = currUri.resolveCollectionPath(collectionPath);
                if (collectionPath.numSegments() == 0) {
                    collectionPath = currUri.resolveCollectionPath(XmldbURI.ROOT_COLLECTION_URI);
                    this.messageln("cannot go above " + XmldbURI.ROOT_COLLECTION_URI.toString());
                }
                if ((temp = DatabaseManager.getCollection((String)collectionPath.toString(), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD))) != null) {
                    this.current = temp;
                    newPath = collectionPath.toCollectionPathURI();
                    if (this.options.startGUI) {
                        this.frame.setPath(collectionPath.toCollectionPathURI());
                    }
                } else {
                    this.messageln("no such collection.");
                }
                this.getResources();
            } else if (args[0].equalsIgnoreCase("cp")) {
                XmldbURI dest;
                XmldbURI src;
                if (args.length != 3) {
                    this.messageln("cp requires two arguments.");
                    return true;
                }
                try {
                    src = XmldbURI.xmldbUriFor(args[1]);
                    dest = XmldbURI.xmldbUriFor(args[2]);
                }
                catch (URISyntaxException e) {
                    this.errorln("could not parse collection name into a valid URI: " + e.getMessage());
                    return false;
                }
                this.copy(src, dest);
                this.getResources();
            } else if (args[0].equalsIgnoreCase("edit")) {
                if (args.length == 2) {
                    XmldbURI resource;
                    try {
                        resource = XmldbURI.xmldbUriFor(args[1]);
                    }
                    catch (URISyntaxException e) {
                        this.errorln("could not parse resource name into a valid URI: " + e.getMessage());
                        return false;
                    }
                    this.editResource(resource);
                } else {
                    this.messageln("Please specify a resource.");
                }
            } else {
                if (args[0].equalsIgnoreCase("get")) {
                    XmldbURI resource;
                    if (args.length < 2) {
                        System.err.println("wrong number of arguments.");
                        return true;
                    }
                    try {
                        resource = XmldbURI.xmldbUriFor(args[1]);
                    }
                    catch (URISyntaxException e) {
                        this.errorln("could not parse resource name into a valid URI: " + e.getMessage());
                        return false;
                    }
                    Resource res = this.retrieve(resource);
                    if (res != null) {
                        String data = "XMLResource".equals(res.getResourceType()) ? (String)res.getContent() : new String((byte[])res.getContent());
                        if (this.options.startGUI) {
                            this.frame.setEditable(false);
                            this.frame.display(data);
                            this.frame.setEditable(true);
                        } else {
                            String content = data;
                            this.more(content);
                        }
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("find")) {
                    if (args.length < 2) {
                        this.messageln("no query argument found.");
                        return true;
                    }
                    this.messageln(args[1]);
                    long start = System.currentTimeMillis();
                    this.result = this.find(args[1]);
                    if (this.result == null) {
                        this.messageln("nothing found");
                    } else {
                        this.messageln("found " + this.result.getSize() + " hits in " + (System.currentTimeMillis() - start) + "ms.");
                    }
                    this.nextInSet = 1;
                } else if (args[0].equalsIgnoreCase("run")) {
                    if (args.length < 2) {
                        this.messageln("please specify a query file.");
                        return true;
                    }
                    try (BufferedReader reader = Files.newBufferedReader(Paths.get(args[1], new String[0]));){
                        String nextLine;
                        StringBuilder buf = new StringBuilder();
                        while ((nextLine = reader.readLine()) != null) {
                            buf.append(nextLine);
                            buf.append(EOL);
                        }
                        args[1] = buf.toString();
                        long start = System.currentTimeMillis();
                        this.result = this.find(args[1]);
                        if (this.result == null) {
                            this.messageln("nothing found");
                        } else {
                            this.messageln("found " + this.result.getSize() + " hits in " + (System.currentTimeMillis() - start) + "ms.");
                        }
                        this.nextInSet = 1;
                    }
                    catch (Exception e) {
                        this.errorln("An error occurred: " + e.getMessage());
                    }
                } else {
                    if (args[0].equalsIgnoreCase("show")) {
                        if (this.result == null) {
                            this.messageln("no result set.");
                            return true;
                        }
                        try {
                            int start = this.nextInSet;
                            int count = 1;
                            if (args.length > 1) {
                                start = Integer.parseInt(args[1]);
                            }
                            if (args.length > 2) {
                                count = Integer.parseInt(args[2]);
                            }
                            int s = (int)this.result.getSize();
                            if (start < 1 || start > s) {
                                this.messageln("start offset out of range");
                                return true;
                            }
                            if (--start + count > s) {
                                count = s - start;
                            }
                            this.nextInSet = start + count + 1;
                            for (int i = start; i < start + count; ++i) {
                                Resource r = this.result.getResource((long)i);
                                if (this.options.startGUI) {
                                    this.frame.display((String)r.getContent());
                                    continue;
                                }
                                this.more((String)r.getContent());
                            }
                            this.messageln("displayed items " + (start + 1) + " to " + (start + count) + " of " + this.result.getSize());
                        }
                        catch (NumberFormatException nfe) {
                            this.errorln("wrong argument");
                            return true;
                        }
                    }
                    if (args[0].equalsIgnoreCase("mkcol")) {
                        XmldbURI collUri;
                        if (args.length < 2) {
                            this.messageln("missing argument.");
                            return true;
                        }
                        try {
                            collUri = XmldbURI.xmldbUriFor(args[1]);
                        }
                        catch (URISyntaxException e) {
                            this.errorln("could not parse collection name into a valid URI: " + e.getMessage());
                            return false;
                        }
                        EXistCollectionManagementService mgtService = (EXistCollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
                        Collection newCollection = mgtService.createCollection(collUri);
                        if (newCollection == null) {
                            this.messageln("could not create collection.");
                        } else {
                            this.messageln("created collection.");
                        }
                        this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
                        this.getResources();
                    } else {
                        boolean r;
                        if (args[0].equalsIgnoreCase("put")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            r = this.parse(Paths.get(args[1], new String[0]));
                            this.getResources();
                            return r;
                        }
                        if (args[0].equalsIgnoreCase("putzip")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            r = this.parseZip(args[1]);
                            this.getResources();
                            return r;
                        }
                        if (args[0].equalsIgnoreCase("putgz")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            r = this.parseGZip(args[1]);
                            this.getResources();
                            return r;
                        }
                        if (args[0].equalsIgnoreCase("blob")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            this.storeBinary(args[1]);
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("rm")) {
                            if (args.length < 2) {
                                this.messageln("missing argument.");
                                return true;
                            }
                            this.remove(args[1]);
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("rmcol")) {
                            XmldbURI collUri;
                            if (args.length < 2) {
                                this.messageln("wrong argument count.");
                                return true;
                            }
                            try {
                                collUri = XmldbURI.xmldbUriFor(args[1]);
                            }
                            catch (URISyntaxException e) {
                                this.errorln("could not parse collection name into a valid URI: " + e.getMessage());
                                return false;
                            }
                            this.rmcol(collUri);
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("adduser")) {
                            if (args.length < 2) {
                                System.err.println("Usage: adduser name");
                                return true;
                            }
                            if (this.options.startGUI) {
                                this.messageln("command not supported in GUI mode. Please use the \"Edit users\" menu option.");
                                return true;
                            }
                            try {
                                String p2;
                                String p1;
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                while (!(p1 = this.console.readLine("password: ", Character.valueOf('*'))).equals(p2 = this.console.readLine("re-enter password: ", Character.valueOf('*')))) {
                                    this.messageln("Entered passwords differ. Try again...");
                                }
                                UserAider user = new UserAider(args[1]);
                                user.setPassword(p1);
                                String groups = this.console.readLine("enter groups: ");
                                StringTokenizer tok = new StringTokenizer(groups, " ,");
                                while (tok.hasMoreTokens()) {
                                    String group = tok.nextToken();
                                    if (group.length() <= 0) continue;
                                    user.addGroup(group);
                                }
                                if (user.getGroups().length == 0) {
                                    this.messageln("No groups specified, will be a member of the 'guest' group!");
                                    user.addGroup("guest");
                                }
                                mgtService.addAccount(user);
                                this.messageln("User '" + user.getName() + "' created.");
                            }
                            catch (Exception e) {
                                this.errorln("ERROR: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else if (args[0].equalsIgnoreCase("users")) {
                            UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                            Account[] users = mgtService.getAccounts();
                            this.messageln("User\t\tGroups");
                            this.messageln("-----------------------------------------");
                            for (int i = 0; i < users.length; ++i) {
                                System.out.print(users[i].getName() + "\t\t");
                                String[] groups = users[i].getGroups();
                                for (int j = 0; j < groups.length; ++j) {
                                    System.out.print(groups[j]);
                                    if (j + 1 >= groups.length) continue;
                                    System.out.print(", ");
                                }
                                System.out.println();
                            }
                        } else if (args[0].equalsIgnoreCase("passwd")) {
                            if (this.options.startGUI) {
                                this.messageln("command not supported in GUI mode. Please use the \"Edit users\" menu option.");
                                return true;
                            }
                            if (args.length < 2) {
                                this.messageln("Usage: passwd username");
                                return true;
                            }
                            try {
                                String p2;
                                String p1;
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                Account user = mgtService.getAccount(args[1]);
                                if (user == null) {
                                    this.messageln("no such user.");
                                    return true;
                                }
                                while (!(p1 = this.console.readLine("password: ", Character.valueOf('*'))).equals(p2 = this.console.readLine("re-enter password: ", Character.valueOf('*')))) {
                                    System.out.println(EOL + "entered passwords differ. Try again...");
                                }
                                user.setPassword(p1);
                                mgtService.updateAccount(user);
                                this.properties.setProperty(PASSWORD, p1);
                            }
                            catch (Exception e) {
                                this.errorln("ERROR: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else if (args[0].equalsIgnoreCase("chmod")) {
                            if (args.length < 2) {
                                System.out.println("Usage: chmod [resource] mode");
                                return true;
                            }
                            if (args.length == 3) {
                                System.out.println("trying collection: " + args[1]);
                                Collection temp = this.current.getChildCollection(args[1]);
                                if (temp == null) {
                                    System.out.println(EOL + "trying resource: " + args[1]);
                                    Resource r2 = this.current.getResource(args[1]);
                                    if (r2 != null) {
                                        UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                        mgtService.chmod(r2, args[2]);
                                    } else {
                                        System.err.println("Resource " + args[1] + " not found.");
                                    }
                                } else {
                                    UserManagementService mgtService = (UserManagementService)temp.getService("UserManagementService", "1.0");
                                    mgtService.chmod(args[2]);
                                }
                            } else {
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                mgtService.chmod(args[1]);
                            }
                            this.current = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + this.path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
                            this.getResources();
                        } else if (args[0].equalsIgnoreCase("chown")) {
                            if (args.length < 3) {
                                System.out.println("Usage: chown username group [resource]");
                                return true;
                            }
                            Collection temp = args.length == 4 ? this.current.getChildCollection(args[3]) : this.current;
                            if (temp != null) {
                                UserManagementService mgtService = (UserManagementService)temp.getService("UserManagementService", "1.0");
                                Account u = mgtService.getAccount(args[1]);
                                if (u == null) {
                                    System.out.println("unknown user");
                                    return true;
                                }
                                mgtService.chown(u, args[2]);
                                System.out.println("owner changed.");
                                this.getResources();
                                return true;
                            }
                            Resource res = this.current.getResource(args[3]);
                            if (res != null) {
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                Account u = mgtService.getAccount(args[1]);
                                if (u == null) {
                                    System.out.println("unknown user");
                                    return true;
                                }
                                mgtService.chown(res, u, args[2]);
                                this.getResources();
                                return true;
                            }
                            System.err.println("Resource " + args[3] + " not found.");
                        } else if (args[0].equalsIgnoreCase("lock") || args[0].equalsIgnoreCase("unlock")) {
                            if (args.length < 2) {
                                this.messageln("Usage: lock resource");
                                return true;
                            }
                            Resource res = this.current.getResource(args[1]);
                            if (res != null) {
                                UserManagementService mgtService = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                                Account user = mgtService.getAccount(this.properties.getProperty(USER, "guest"));
                                if (args[0].equalsIgnoreCase("lock")) {
                                    mgtService.lockResource(res, user);
                                } else {
                                    mgtService.unlockResource(res);
                                }
                            }
                        } else {
                            if (args[0].equalsIgnoreCase("elements")) {
                                System.out.println("Element occurrences in collection " + this.current.getName());
                                System.out.println("-------------------------------------------------------");
                                IndexQueryService service = (IndexQueryService)this.current.getService("IndexQueryService", "1.0");
                                Occurrences[] elements = service.getIndexedElements(true);
                                for (int i = 0; i < elements.length; ++i) {
                                    System.out.println(InteractiveClient.formatString(elements[i].getTerm().toString(), Integer.toString(elements[i].getOccurrences()), 50));
                                }
                                return true;
                            }
                            if (args[0].equalsIgnoreCase("xupdate")) {
                                if (this.options.startGUI) {
                                    this.messageln("command not supported in GUI mode.");
                                    return true;
                                }
                                StringBuilder command = new StringBuilder();
                                try {
                                    String lastLine;
                                    while ((lastLine = this.console.readLine("| ")) != null && lastLine.length() != 0) {
                                        command.append(lastLine);
                                    }
                                }
                                catch (IOException lastLine) {
                                    // empty catch block
                                }
                                String xupdate = "<xu:modifications version=\"1.0\" xmlns:xu=\"http://www.xmldb.org/xupdate\">" + command.toString() + "</xu:modifications>";
                                XUpdateQueryService service = (XUpdateQueryService)this.current.getService("XUpdateQueryService", "1.0");
                                long mods = service.update(xupdate);
                                System.out.println(mods + " modifications processed.");
                            } else if (args[0].equalsIgnoreCase("map")) {
                                String prefix;
                                StringTokenizer tok = new StringTokenizer(args[1], "= ");
                                if (args[1].startsWith("=")) {
                                    prefix = "";
                                } else {
                                    if (tok.countTokens() < 2) {
                                        this.messageln("please specify a namespace/prefix mapping as: prefix=namespaceURI");
                                        return true;
                                    }
                                    prefix = tok.nextToken();
                                }
                                String uri = tok.nextToken();
                                this.namespaceMappings.put(prefix, uri);
                            } else if (args[0].equalsIgnoreCase("set")) {
                                if (args.length == 1) {
                                    this.properties.list(System.out);
                                } else {
                                    try {
                                        StringTokenizer tok = new StringTokenizer(args[1], "= ");
                                        if (tok.countTokens() < 2) {
                                            System.err.println("please specify a key=value pair");
                                            return true;
                                        }
                                        String key = tok.nextToken();
                                        String val = tok.nextToken();
                                        this.properties.setProperty(key, val);
                                        this.current.setProperty(key, val);
                                        this.getResources();
                                    }
                                    catch (Exception e) {
                                        System.err.println("Exception: " + e.getMessage());
                                    }
                                }
                            } else {
                                if (args[0].equalsIgnoreCase("shutdown")) {
                                    DatabaseInstanceManager mgr = (DatabaseInstanceManager)this.current.getService("DatabaseInstanceManager", "1.0");
                                    if (mgr == null) {
                                        this.messageln("Service is not available");
                                        return true;
                                    }
                                    mgr.shutdown();
                                    return true;
                                }
                                if (args[0].equalsIgnoreCase("help") || "?".equals(args[0])) {
                                    this.displayHelp();
                                } else {
                                    if (args[0].equalsIgnoreCase("quit")) {
                                        return false;
                                    }
                                    if (havePluggableCommands) {
                                        EXistCollectionManagementService mgtService = (EXistCollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
                                        try {
                                            mgtService.runCommand(args);
                                        }
                                        catch (XMLDBException e) {
                                            if (e.getCause() != null && e.getCause().getClass().getName().equals("org.exist.plugin.command.CommandNotFoundException")) {
                                                this.messageln("unknown command: '" + args[0] + "'");
                                                return true;
                                            }
                                            throw e;
                                        }
                                    } else {
                                        this.messageln("unknown command: '" + args[0] + "'");
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.path = newPath;
            return true;
        }
        catch (Throwable e) {
            if (this.options.startGUI) {
                ClientFrame.showErrorMessage(InteractiveClient.getExceptionMessage(e), e);
            } else {
                this.errorln(InteractiveClient.getExceptionMessage(e));
                e.printStackTrace();
            }
            return true;
        }
    }

    private void editResource(XmldbURI name) {
        try {
            Resource doc = this.retrieve(name, this.properties.getProperty(INDENT, "yes"));
            DocumentView view = new DocumentView(this, name, doc, this.properties);
            view.setSize(new Dimension(640, 400));
            view.viewDocument();
        }
        catch (XMLDBException ex) {
            this.errorln("XMLDB error: " + ex.getMessage());
        }
    }

    private Optional<Writer> getTraceWriter() {
        if (this.options.traceQueriesFile.isPresent()) {
            if (!this.lazyTraceWriter.isPresent()) {
                try {
                    BufferedWriter traceWriter = Files.newBufferedWriter(this.options.traceQueriesFile.get(), StandardCharsets.UTF_8, new OpenOption[0]);
                    traceWriter.write("<?xml version=\"1.0\"?>" + EOL);
                    traceWriter.write("<query-log>" + EOL);
                    this.lazyTraceWriter = Optional.of(traceWriter);
                }
                catch (IOException ioe) {
                    this.errorln("Cannot open file " + this.options.traceQueriesFile.get());
                    return Optional.empty();
                }
            }
            return this.lazyTraceWriter;
        }
        return Optional.empty();
    }

    private ResourceSet find(String xpath) throws XMLDBException {
        if (xpath.substring(xpath.length() - EOL.length()).equals(EOL)) {
            xpath = xpath.substring(0, xpath.length() - EOL.length());
        }
        String xpathCopy = xpath;
        this.getTraceWriter().ifPresent(writer -> {
            try {
                writer.write("<query>");
                writer.write(xpathCopy);
                writer.write("</query>");
                writer.write(EOL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        String sortBy = null;
        int p = xpath.indexOf(" sort by ");
        if (p != -1) {
            String xp = xpath.substring(0, p);
            sortBy = xpath.substring(p + " sort by ".length());
            xpath = xp;
            System.out.println("XPath =   " + xpath);
            System.out.println("Sort-by = " + sortBy);
        }
        EXistXPathQueryService service = (EXistXPathQueryService)this.current.getService("XPathQueryService", "1.0");
        service.setProperty(INDENT, this.properties.getProperty(INDENT));
        service.setProperty(ENCODING, this.properties.getProperty(ENCODING));
        for (Map.Entry<String, String> mapping : this.namespaceMappings.entrySet()) {
            service.setNamespace(mapping.getKey(), mapping.getValue());
        }
        return sortBy == null ? service.query(xpath) : service.query(xpath, sortBy);
    }

    protected final Resource retrieve(XmldbURI resource) throws XMLDBException {
        return this.retrieve(resource, this.properties.getProperty(INDENT));
    }

    protected final Resource retrieve(XmldbURI resource, String indent) throws XMLDBException {
        Resource res = this.current.getResource(resource.toString());
        if (res == null) {
            this.messageln("document not found.");
            return null;
        }
        return res;
    }

    private void remove(String pattern) throws XMLDBException {
        Collection collection = this.current;
        if (pattern.startsWith("/")) {
            System.err.println("path pattern should be relative to current collection");
            return;
        }
        Resource res = collection.getResource(pattern);
        Resource[] resources = res == null ? CollectionScanner.scan(collection, "", pattern) : new Resource[]{res};
        for (int i = 0; i < resources.length; ++i) {
            this.message("removing document " + resources[i].getId() + " ...");
            Collection parent = resources[i].getParentCollection();
            parent.removeResource(resources[i]);
            this.messageln("done.");
        }
    }

    private void xupdate(Optional<String> resource, Path file) throws XMLDBException, IOException {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            this.messageln("cannot read file " + file.normalize().toAbsolutePath().toString());
            return;
        }
        String commands = XMLUtil.readFile(file, StandardCharsets.UTF_8);
        XUpdateQueryService service = (XUpdateQueryService)this.current.getService("XUpdateQueryService", "1.0");
        long modifications = resource.isPresent() ? service.updateResource(resource.get(), commands) : service.update(commands);
        this.messageln(modifications + " modifications processed successfully.");
    }

    private void rmcol(XmldbURI collection) throws XMLDBException {
        EXistCollectionManagementService mgtService = (EXistCollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
        this.message("removing collection " + collection + " ...");
        mgtService.removeCollection(collection);
        this.messageln("done.");
    }

    private void copy(XmldbURI source, XmldbURI destination) throws XMLDBException {
        try {
            Resource srcDoc;
            EXistCollectionManagementService mgtService = (EXistCollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
            XmldbURI destName = destination.lastSegment();
            Collection destCol = this.resolveCollection(destination);
            if (destCol == null) {
                destination = destination.numSegments() == 1 ? XmldbURI.xmldbUriFor(this.current.getName()) : destination.removeLastSegment();
            }
            if ((srcDoc = this.resolveResource(source)) != null) {
                XmldbURI resourcePath = XmldbURI.xmldbUriFor(srcDoc.getParentCollection().getName()).append(srcDoc.getId());
                this.messageln("Copying resource '" + resourcePath + "' to '" + destination + "'");
                mgtService.copyResource(resourcePath, destination, destName);
            } else {
                this.messageln("Copying collection '" + source + "' to '" + destination + "'");
                mgtService.copy(source, destination, destName);
            }
        }
        catch (URISyntaxException e) {
            this.errorln("could not parse name into a valid URI: " + e.getMessage());
        }
    }

    private void reindex() throws XMLDBException {
        IndexQueryService service = (IndexQueryService)this.current.getService("IndexQueryService", "1.0");
        this.message("reindexing collection " + this.current.getName());
        service.reindexCollection();
        this.messageln("done.");
    }

    private void storeBinary(String fileName) throws XMLDBException {
        Path file = Paths.get(fileName, new String[0]).normalize();
        if (Files.isReadable(file)) {
            MimeType mime = MimeTable.getInstance().getContentTypeFor(FileUtils.fileName(file));
            BinaryResource resource = (BinaryResource)this.current.createResource(FileUtils.fileName(file), "BinaryResource");
            resource.setContent((Object)file);
            ((EXistResource)resource).setMimeType(mime == null ? "application/octet-stream" : mime.getName());
            this.current.storeResource((Resource)resource);
        }
    }

    private synchronized boolean findRecursive(Collection collection, Path dir, XmldbURI base) throws XMLDBException {
        try {
            List<Path> files = FileUtils.list(dir);
            int i = 0;
            for (Path file : files) {
                XmldbURI next = base.append(FileUtils.fileName(file));
                try {
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        this.messageln("entering directory " + file.toAbsolutePath());
                        Collection c = collection.getChildCollection(FileUtils.fileName(file));
                        if (c == null) {
                            EXistCollectionManagementService mgtService = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                            c = mgtService.createCollection(XmldbURI.xmldbUriFor(FileUtils.fileName(file)));
                        }
                        if (c instanceof Observable && this.options.verbose) {
                            ProgressObserver observer = new ProgressObserver();
                            ((Observable)c).addObserver(observer);
                        }
                        this.findRecursive(c, file, next);
                    } else {
                        long start1 = System.currentTimeMillis();
                        MimeType mimeType = MimeTable.getInstance().getContentTypeFor(FileUtils.fileName(file));
                        if (mimeType == null) {
                            this.messageln("File " + FileUtils.fileName(file) + " has an unknown suffix. Cannot determine file type.");
                            mimeType = MimeType.BINARY_TYPE;
                        }
                        this.message("storing document " + FileUtils.fileName(file) + " (" + i + " of " + files.size() + ") ...");
                        Resource document = collection.createResource(FileUtils.fileName(file), mimeType.getXMLDBType());
                        document.setContent((Object)file);
                        ((EXistResource)document).setMimeType(mimeType.getName());
                        collection.storeResource(document);
                        ++this.filesCount;
                        this.messageln(" " + FileUtils.sizeQuietly(file) + " bytes in " + (System.currentTimeMillis() - start1) + "ms.");
                    }
                }
                catch (URISyntaxException e) {
                    this.errorln("uri syntax exception parsing " + file.toAbsolutePath() + ": " + e.getMessage());
                }
                ++i;
            }
            return true;
        }
        catch (IOException e) {
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    protected synchronized boolean parse(Path file) throws XMLDBException {
        try {
            if (this.current instanceof Observable && this.options.verbose) {
                ProgressObserver observer = new ProgressObserver();
                ((Observable)this.current).addObserver(observer);
            }
            List<Object> files = new ArrayList();
            if (Files.isReadable(file)) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    if (this.options.reindexRecurse) {
                        this.filesCount = 0;
                        long start = System.currentTimeMillis();
                        boolean result = this.findRecursive(this.current, file, this.path);
                        this.messageln("storing " + this.filesCount + " files took " + (System.currentTimeMillis() - start) / 1000L + "sec.");
                        return result;
                    }
                    files = FileUtils.list(file);
                } else {
                    files.add(file);
                }
            } else {
                files = DirectoryScanner.scanDir(file.toString());
            }
            long start0 = System.currentTimeMillis();
            long bytes = 0L;
            for (int i = 0; i < files.size(); ++i) {
                if (Files.isDirectory((Path)files.get(i), new LinkOption[0])) continue;
                long start = System.currentTimeMillis();
                MimeType mimeType = MimeTable.getInstance().getContentTypeFor(FileUtils.fileName((Path)files.get(i)));
                if (mimeType == null) {
                    mimeType = MimeType.BINARY_TYPE;
                }
                Resource document = this.current.createResource(FileUtils.fileName((Path)files.get(i)), mimeType.getXMLDBType());
                this.message("storing document " + FileUtils.fileName((Path)files.get(i)) + " (" + (i + 1) + " of " + files.size() + ") ...");
                document.setContent(files.get(i));
                ((EXistResource)document).setMimeType(mimeType.getName());
                this.current.storeResource(document);
                this.messageln("done.");
                this.messageln("parsing " + FileUtils.sizeQuietly((Path)files.get(i)) + " bytes took " + (System.currentTimeMillis() - start) + "ms." + EOL);
                bytes += FileUtils.sizeQuietly((Path)files.get(i));
            }
            this.messageln("parsed " + bytes + " bytes in " + (System.currentTimeMillis() - start0) + "ms.");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new XMLDBException(0, (Throwable)e);
        }
    }

    private synchronized boolean findGZipRecursive(Collection collection, Path dir, XmldbURI base) throws XMLDBException, IOException {
        List<Path> files = FileUtils.list(dir);
        int i = 0;
        for (Path file : files) {
            ++i;
            XmldbURI next = base.append(FileUtils.fileName(file));
            try {
                MimeType mimeType;
                String compressedName;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.messageln("entering directory " + file.toAbsolutePath().toString());
                    Collection c = collection.getChildCollection(FileUtils.fileName(file));
                    if (c == null) {
                        EXistCollectionManagementService mgtService = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                        c = mgtService.createCollection(XmldbURI.xmldbUriFor(FileUtils.fileName(file)));
                    }
                    if (c instanceof Observable && this.options.verbose) {
                        ProgressObserver observer = new ProgressObserver();
                        ((Observable)c).addObserver(observer);
                    }
                    this.findGZipRecursive(c, file, next);
                    continue;
                }
                long start1 = System.currentTimeMillis();
                String localName = compressedName = FileUtils.fileName(file);
                String[] cSuffix = new String[]{".gz", ".Z"};
                boolean isCompressed = false;
                for (int isuf = 0; isuf < cSuffix.length; ++isuf) {
                    String suf = cSuffix[isuf];
                    if (!localName.endsWith(suf)) continue;
                    localName = compressedName.substring(0, localName.length() - suf.length());
                    isCompressed = true;
                    break;
                }
                if ((mimeType = MimeTable.getInstance().getContentTypeFor(localName)) == null) {
                    this.messageln("File " + compressedName + " has an unknown suffix. Cannot determine file type.");
                    mimeType = MimeType.BINARY_TYPE;
                }
                this.message("storing document " + compressedName + " (" + i + " of " + files.size() + ") ...");
                Resource document = collection.createResource(compressedName, mimeType.getXMLDBType());
                document.setContent(isCompressed ? new GZIPInputSource(file) : file);
                ((EXistResource)document).setMimeType(mimeType.getName());
                collection.storeResource(document);
                ++this.filesCount;
                this.messageln(" " + Files.size(file) + (isCompressed ? " compressed" : "") + " bytes in " + (System.currentTimeMillis() - start1) + "ms.");
            }
            catch (URISyntaxException e) {
                this.errorln("uri syntax exception parsing " + file.toAbsolutePath().toString() + ": " + e.getMessage());
            }
        }
        return true;
    }

    protected synchronized boolean parseGZip(String fileName) throws XMLDBException, IOException {
        List<Path> files;
        fileName = fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        Path file = Paths.get(fileName, new String[0]);
        if (this.current instanceof Observable && this.options.verbose) {
            ProgressObserver observer = new ProgressObserver();
            ((Observable)this.current).addObserver(observer);
        }
        if (Files.isReadable(file)) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                if (this.options.reindexRecurse) {
                    this.filesCount = 0;
                    long start = System.currentTimeMillis();
                    boolean result = this.findGZipRecursive(this.current, file, this.path);
                    this.messageln("storing " + this.filesCount + " compressed files took " + (System.currentTimeMillis() - start) / 1000L + "sec.");
                    return result;
                }
                files = FileUtils.list(file);
            } else {
                files = new ArrayList<Path>();
                files.add(file);
            }
        } else {
            files = DirectoryScanner.scanDir(fileName);
        }
        long start0 = System.currentTimeMillis();
        long bytes = 0L;
        int i = 0;
        for (Path p : files) {
            MimeType mimeType;
            String compressedName;
            ++i;
            if (Files.isDirectory(p, new LinkOption[0])) continue;
            long start = System.currentTimeMillis();
            String localName = compressedName = FileUtils.fileName(p);
            String[] cSuffix = new String[]{".gz", ".Z"};
            boolean isCompressed = false;
            for (int isuf = 0; isuf < cSuffix.length; ++isuf) {
                String suf = cSuffix[isuf];
                if (!localName.endsWith(suf)) continue;
                localName = compressedName.substring(0, localName.length() - suf.length());
                isCompressed = true;
                break;
            }
            if ((mimeType = MimeTable.getInstance().getContentTypeFor(localName)) == null) {
                mimeType = MimeType.BINARY_TYPE;
            }
            Resource document = this.current.createResource(compressedName, mimeType.getXMLDBType());
            this.message("storing document " + compressedName + " (" + i + " of " + Files.size(p) + ") ...");
            document.setContent(isCompressed ? new GZIPInputSource(p) : p);
            ((EXistResource)document).setMimeType(mimeType.getName());
            this.current.storeResource(document);
            this.messageln("done.");
            this.messageln("parsing " + Files.size(p) + (isCompressed ? " compressed" : "") + " bytes took " + (System.currentTimeMillis() - start) + "ms." + EOL);
            bytes += Files.size(p);
        }
        this.messageln("parsed " + bytes + " compressed bytes in " + (System.currentTimeMillis() - start0) + "ms.");
        return true;
    }

    protected synchronized boolean parseZip(String fileName) throws XMLDBException {
        fileName = fileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        try {
            ZipFile zfile = new ZipFile(fileName);
            if (this.current instanceof Observable && this.options.verbose) {
                ProgressObserver observer = new ProgressObserver();
                ((Observable)this.current).addObserver(observer);
            }
            long start0 = System.currentTimeMillis();
            long bytes = 0L;
            Enumeration<? extends ZipEntry> e = zfile.entries();
            int number = 0;
            Collection base = this.current;
            String baseStr = "";
            while (e.hasMoreElements()) {
                int i;
                ++number;
                ZipEntry ze = e.nextElement();
                String zeName = ze.getName().replace('\\', '/');
                String[] pathSteps = zeName.split("/");
                StringBuilder currStr = new StringBuilder(pathSteps[0]);
                for (i = 1; i < pathSteps.length - 1; ++i) {
                    currStr.append("/").append(pathSteps[i]);
                }
                if (!baseStr.equals(currStr)) {
                    base = this.current;
                    for (i = 0; i < pathSteps.length - 1; ++i) {
                        Collection c = base.getChildCollection(pathSteps[i]);
                        if (c == null) {
                            EXistCollectionManagementService mgtService = (EXistCollectionManagementService)base.getService("CollectionManagementService", "1.0");
                            c = mgtService.createCollection(XmldbURI.xmldbUriFor(pathSteps[i]));
                        }
                        base = c;
                    }
                    if (base instanceof Observable && this.options.verbose) {
                        ProgressObserver observer = new ProgressObserver();
                        ((Observable)base).addObserver(observer);
                    }
                    baseStr = currStr.toString();
                    this.messageln("entering directory " + baseStr);
                }
                if (ze.isDirectory()) continue;
                String localName = pathSteps[pathSteps.length - 1];
                long start = System.currentTimeMillis();
                MimeType mimeType = MimeTable.getInstance().getContentTypeFor(localName);
                if (mimeType == null) {
                    mimeType = MimeType.BINARY_TYPE;
                }
                Resource document = base.createResource(localName, mimeType.getXMLDBType());
                this.message("storing Zip-entry document " + localName + " (" + number + " of " + zfile.size() + ") ...");
                document.setContent((Object)new ZipEntryInputSource(zfile, ze));
                ((EXistResource)document).setMimeType(mimeType.getName());
                base.storeResource(document);
                this.messageln("done.");
                this.messageln("parsing " + ze.getSize() + " bytes took " + (System.currentTimeMillis() - start) + "ms." + EOL);
                bytes += ze.getSize();
            }
            this.messageln("parsed " + bytes + " bytes in " + (System.currentTimeMillis() - start0) + "ms.");
        }
        catch (URISyntaxException e) {
            this.errorln("uri syntax exception parsing a ZIP entry from " + fileName + ": " + e.getMessage());
        }
        catch (IOException e) {
            this.errorln("could not parse ZIP file " + fileName + ": " + e.getMessage());
        }
        return true;
    }

    protected synchronized boolean parse(List<Path> files, UploadDialog upload) throws XMLDBException {
        Collection uploadRootCollection = this.current;
        if (!upload.isVisible()) {
            upload.setVisible(true);
        }
        if (uploadRootCollection instanceof Observable) {
            ((Observable)uploadRootCollection).addObserver(upload.getObserver());
        }
        upload.setTotalSize(FileUtils.sizeQuietly(files));
        for (Path file : files) {
            if (upload.isCancelled()) break;
            this.store(uploadRootCollection, file, upload);
        }
        if (uploadRootCollection instanceof Observable) {
            ((Observable)uploadRootCollection).deleteObservers();
        }
        upload.uploadCompleted();
        return true;
    }

    private void store(Collection collection, Path file, UploadDialog upload) {
        XmldbURI filenameUri;
        if (upload.isCancelled()) {
            return;
        }
        if (!Files.isReadable(file)) {
            upload.showMessage(file.toAbsolutePath() + " impossible to read ");
            return;
        }
        try {
            filenameUri = XmldbURI.xmldbUriFor(FileUtils.fileName(file));
        }
        catch (URISyntaxException e1) {
            upload.showMessage(file.toAbsolutePath() + " could not be encoded as a URI");
            return;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            Collection c = null;
            try {
                c = collection.getChildCollection(filenameUri.toString());
                if (c == null) {
                    EXistCollectionManagementService mgtService = (EXistCollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                    c = mgtService.createCollection(filenameUri);
                }
            }
            catch (XMLDBException e) {
                upload.showMessage("Impossible to create a collection " + file.toAbsolutePath() + ": " + e.getMessage());
                e.printStackTrace();
            }
            upload.setCurrentDir(file.toAbsolutePath().toString());
            if (c instanceof Observable) {
                ((Observable)c).addObserver(upload.getObserver());
            }
            Collection childCollection = c;
            try (Stream<Path> children = Files.list(file);){
                children.forEach(child -> this.store(childCollection, (Path)child, upload));
            }
            catch (IOException e) {
                upload.showMessage("Impossible to upload " + file.toAbsolutePath() + ": " + e.getMessage());
                e.printStackTrace();
            }
            return;
        }
        if (!Files.isDirectory(file, new LinkOption[0])) {
            upload.reset();
            upload.setCurrent(FileUtils.fileName(file));
            long fileSize = FileUtils.sizeQuietly(file);
            upload.setCurrentSize(fileSize);
            MimeType mimeType = MimeTable.getInstance().getContentTypeFor(FileUtils.fileName(file));
            if (mimeType == null) {
                upload.showMessage(file.toAbsolutePath() + " - unknown suffix. No matching mime-type found in : " + MimeTable.getInstance().getSrc());
                mimeType = MimeType.BINARY_TYPE;
            }
            try {
                Resource res = collection.createResource(filenameUri.toString(), mimeType.getXMLDBType());
                ((EXistResource)res).setMimeType(mimeType.getName());
                res.setContent((Object)file);
                collection.storeResource(res);
                ++this.filesCount;
                this.totalLength += fileSize;
                upload.setStoredSize(this.totalLength);
            }
            catch (XMLDBException e) {
                upload.showMessage("Impossible to store a resource " + file.toAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    private void mkcol(XmldbURI collPath) throws XMLDBException {
        this.messageln("creating '" + collPath + "'");
        XmldbURI[] segments = collPath.getPathSegments();
        XmldbURI p = XmldbURI.ROOT_COLLECTION_URI;
        for (int i = 1; i < segments.length; ++i) {
            p = p.append(segments[i]);
            Collection c = DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + p), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
            if (c == null) {
                EXistCollectionManagementService mgtService = (EXistCollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
                this.current = mgtService.createCollection(segments[i]);
                continue;
            }
            this.current = c;
        }
        this.path = p;
    }

    protected Collection getCollection(String path) throws XMLDBException {
        return DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
    }

    private Properties loadClientProperties() {
        Properties properties;
        block27: {
            Path propFile = ConfigurationHelper.lookup("client.properties");
            properties = new Properties();
            try {
                if (Files.isReadable(propFile)) {
                    try (InputStream pin = Files.newInputStream(propFile, new OpenOption[0]);){
                        properties.load(pin);
                        break block27;
                    }
                }
                try (InputStream pin = InteractiveClient.class.getResourceAsStream("client.properties");){
                    properties.load(pin);
                }
            }
            catch (IOException | NullPointerException e) {
                System.err.println("WARN - Unable to load properties from: " + propFile.toAbsolutePath().toString());
            }
        }
        return properties;
    }

    protected void setPropertiesFromCommandLine(CommandlineOptions options, Properties props) {
        boolean needPassword;
        options.options.forEach(this.properties::setProperty);
        options.username.ifPresent(username -> props.setProperty(USER, (String)username));
        options.password.ifPresent(password -> props.setProperty(PASSWORD, (String)password));
        boolean bl = needPassword = options.username.isPresent() && !options.password.isPresent();
        if (options.useSSL) {
            props.setProperty(SSL_ENABLE, "TRUE");
        }
        if (options.embedded) {
            props.setProperty(LOCAL_MODE, "TRUE");
            props.setProperty(URI, XmldbURI.EMBEDDED_SERVER_URI.toString());
        }
        options.embeddedConfig.ifPresent(config -> this.properties.setProperty(CONFIGURATION, config.toAbsolutePath().toString()));
        if (options.noEmbeddedMode) {
            props.setProperty(NO_EMBED_MODE, "TRUE");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processCommandLineActions() throws Exception {
        boolean foundCollection;
        if (this.options.reindex) {
            if (!this.options.setCol.isPresent()) {
                System.err.println("Please specify target collection with --collection");
                this.shutdown(false);
                return false;
            }
            try {
                this.reindex();
            }
            catch (XMLDBException e) {
                System.err.println("XMLDBException while reindexing collection: " + InteractiveClient.getExceptionMessage(e));
                e.printStackTrace();
                return false;
            }
        }
        if (this.options.rmCol.isPresent()) {
            try {
                this.rmcol(this.options.rmCol.get());
            }
            catch (XMLDBException e) {
                System.err.println("XMLDBException while removing collection: " + InteractiveClient.getExceptionMessage(e));
                e.printStackTrace();
                return false;
            }
        }
        if (this.options.mkCol.isPresent()) {
            try {
                this.mkcol(this.options.mkCol.get());
            }
            catch (XMLDBException e) {
                System.err.println("XMLDBException during mkcol: " + InteractiveClient.getExceptionMessage(e));
                e.printStackTrace();
                return false;
            }
        }
        boolean bl = foundCollection = !this.options.setCol.isPresent();
        if (this.options.getDoc.isPresent()) {
            try {
                Resource res = this.retrieve(this.options.getDoc.get());
                if (res == null) return true;
                if ("XMLResource".equals(res.getResourceType())) {
                    if (this.options.outputFile.isPresent()) {
                        this.writeOutputFile(this.options.outputFile.get(), res.getContent());
                        return true;
                    }
                    System.out.println(res.getContent().toString());
                    return true;
                }
                if (this.options.outputFile.isPresent()) {
                    ((ExtendedResource)res).getContentIntoAFile(this.options.outputFile.get());
                    ((EXistResource)res).freeResources();
                    return true;
                }
                ((ExtendedResource)res).getContentIntoAStream(System.out);
                System.out.println();
                return true;
            }
            catch (XMLDBException e) {
                System.err.println("XMLDBException while trying to retrieve document: " + InteractiveClient.getExceptionMessage(e));
                e.printStackTrace();
                return false;
            }
        }
        if (this.options.rmDoc.isPresent()) {
            if (!foundCollection) {
                System.err.println("Please specify target collection with --collection");
                return true;
            } else {
                try {
                    this.remove(this.options.rmDoc.get());
                    return true;
                }
                catch (XMLDBException e) {
                    System.err.println("XMLDBException during parse: " + InteractiveClient.getExceptionMessage(e));
                    e.printStackTrace();
                    return false;
                }
            }
        }
        if (!this.options.parseDocs.isEmpty()) {
            if (!foundCollection) {
                System.err.println("Please specify target collection with --collection");
                return true;
            } else {
                for (Path path : this.options.parseDocs) {
                    try {
                        this.parse(path);
                    }
                    catch (XMLDBException e) {
                        System.err.println("XMLDBException during parse: " + InteractiveClient.getExceptionMessage(e));
                        e.printStackTrace();
                        return false;
                    }
                }
            }
            return true;
        }
        if (this.options.xpath.isPresent() || !this.options.queryFiles.isEmpty()) {
            Serializable buf3;
            Serializable buf2;
            String xpath = null;
            if (!this.options.queryFiles.isEmpty()) {
                try (BufferedReader reader = Files.newBufferedReader(this.options.queryFiles.get(0));){
                    String line;
                    buf2 = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        ((StringBuilder)buf2).append(line);
                        ((StringBuilder)buf2).append(EOL);
                    }
                    xpath = ((StringBuilder)buf2).toString();
                }
            }
            if (this.options.xpath.isPresent()) {
                String xpathStr = this.options.xpath.get();
                if (!xpathStr.equals("<<STDIN")) {
                    xpath = xpathStr;
                } else {
                    try {
                        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                        buf2 = null;
                        try {
                            String line;
                            buf3 = new StringBuilder();
                            while ((line = stdin.readLine()) != null) {
                                ((StringBuilder)buf3).append(line);
                                ((StringBuilder)buf3).append(EOL);
                            }
                            xpath = ((StringBuilder)buf3).toString();
                        }
                        catch (Throwable buf3) {
                            buf2 = buf3;
                            throw buf3;
                        }
                        finally {
                            if (stdin != null) {
                                if (buf2 != null) {
                                    try {
                                        stdin.close();
                                    }
                                    catch (Throwable buf3) {
                                        ((Throwable)buf2).addSuppressed(buf3);
                                    }
                                } else {
                                    stdin.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        System.err.println("failed to read query from stdin");
                        return false;
                    }
                }
            }
            if (xpath == null) return true;
            try {
                ResourceSet result = this.find(xpath);
                int maxResults = this.options.howManyResults.filter(n -> n > 0).orElse((int)result.getSize());
                if (this.options.outputFile.isPresent()) {
                    OutputStream fos = Files.newOutputStream(this.options.outputFile.get(), new OpenOption[0]);
                    buf3 = null;
                    try (BufferedOutputStream bos = new BufferedOutputStream(fos);
                         PrintStream ps = new PrintStream(bos);){
                        for (int i = 0; i < maxResults && (long)i < result.getSize(); ++i) {
                            Resource res = result.getResource((long)i);
                            if (res instanceof ExtendedResource) {
                                ((ExtendedResource)res).getContentIntoAStream(ps);
                                continue;
                            }
                            ps.print(res.getContent().toString());
                        }
                        return true;
                    }
                    catch (Throwable throwable) {
                        buf3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fos != null) {
                            if (buf3 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)buf3).addSuppressed(throwable);
                                }
                            } else {
                                fos.close();
                            }
                        }
                    }
                }
                for (int i = 0; i < maxResults && (long)i < result.getSize(); ++i) {
                    Resource res = result.getResource((long)i);
                    if (res instanceof ExtendedResource) {
                        ((ExtendedResource)res).getContentIntoAStream(System.out);
                        continue;
                    }
                    System.out.println(res.getContent());
                }
                return true;
            }
            catch (XMLDBException e) {
                System.err.println("XMLDBException during query: " + InteractiveClient.getExceptionMessage(e));
                e.printStackTrace();
                return false;
            }
        }
        if (!this.options.xupdateFile.isPresent()) return true;
        try {
            this.xupdate(this.options.setDoc, this.options.xupdateFile.get());
            return true;
        }
        catch (XMLDBException e) {
            System.err.println("XMLDBException during xupdate: " + InteractiveClient.getExceptionMessage(e));
            return false;
        }
        catch (IOException e) {
            System.err.println("IOException during xupdate: " + InteractiveClient.getExceptionMessage(e));
            return false;
        }
    }

    private boolean getGuiLoginData(Properties props) {
        Properties loginData = ClientFrame.getLoginData(props);
        if (loginData == null || loginData.isEmpty()) {
            return false;
        }
        props.putAll((Map<?, ?>)loginData);
        return true;
    }

    private void connectToDatabase() {
        try {
            this.connect();
        }
        catch (Exception cnf) {
            if (this.options.startGUI && this.frame != null) {
                this.frame.setStatus("Connection to database failed; message: " + cnf.getMessage());
            } else {
                System.err.println("Connection to database failed; message: " + cnf.getMessage());
            }
            cnf.printStackTrace();
            System.exit(1);
        }
    }

    public boolean run(String[] args) throws Exception {
        this.options = CommandlineOptions.parse(args);
        this.path = this.options.setCol.orElse(XmldbURI.ROOT_COLLECTION_URI);
        Optional<Path> home = ConfigurationHelper.getExistHome();
        this.properties = new Properties(defaultProps);
        Class<?> cl = Class.forName(this.properties.getProperty(DRIVER));
        Field CONF_XML = cl.getDeclaredField("CONF_XML");
        if (CONF_XML != null && home.isPresent()) {
            Path configuration = ConfigurationHelper.lookup((String)CONF_XML.get(""));
            this.properties.setProperty(CONFIGURATION, configuration.toAbsolutePath().toString());
        }
        this.properties.putAll((Map<?, ?>)this.loadClientProperties());
        this.setPropertiesFromCommandLine(this.options, this.properties);
        if (!this.options.quiet) {
            this.printNotice();
        }
        this.properties.setProperty(URI, URLDecoder.decode(this.properties.getProperty(URI), "UTF-8"));
        boolean interactive = true;
        if (!this.options.parseDocs.isEmpty() || this.options.rmDoc.isPresent() || this.options.getDoc.isPresent() || this.options.rmCol.isPresent() || this.options.xpath.isPresent() || !this.options.queryFiles.isEmpty() || this.options.xupdateFile.isPresent() || this.options.reindex) {
            interactive = false;
        }
        if (interactive && this.options.startGUI) {
            boolean haveLoginData = this.getGuiLoginData(this.properties);
            if (!haveLoginData) {
                return false;
            }
        } else if (this.options.username.isPresent() && !this.options.password.isPresent()) {
            try {
                this.properties.setProperty(PASSWORD, this.console.readLine("password: ", Character.valueOf('*')));
            }
            catch (Exception haveLoginData) {
                // empty catch block
            }
        }
        this.historyFile = home.map(h -> h.resolve(".exist_history")).orElse(Paths.get(".exist_history", new String[0]));
        this.queryHistoryFile = home.map(h -> h.resolve(".exist_query_history")).orElse(Paths.get(".exist_query_history", new String[0]));
        if (Files.isReadable(this.queryHistoryFile)) {
            this.readQueryHistory();
        }
        if (interactive) {
            Terminal.setupTerminal();
            this.console = new ConsoleReader();
            this.console.addCompletor((Completor)new CollectionCompleter());
            try {
                History history = new History(this.historyFile.toFile());
                this.console.setHistory(history);
            }
            catch (Exception history) {
                // empty catch block
            }
        }
        this.connectToDatabase();
        if (this.current == null) {
            if (this.options.startGUI && this.frame != null) {
                this.frame.setStatus("Could not retrieve collection " + this.path);
            } else {
                System.err.println("Could not retrieve collection " + this.path);
            }
            this.shutdown(false);
            return false;
        }
        boolean processingOK = this.processCommandLineActions();
        if (!processingOK) {
            return false;
        }
        if (interactive) {
            if (this.options.startGUI) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (UnsupportedLookAndFeelException ulafe) {
                    System.err.println("Warning: Unable to set native look and feel: " + ulafe.getMessage());
                }
                this.frame = new ClientFrame(this, this.path, this.properties);
                this.frame.setLocation(100, 100);
                this.frame.setSize(500, 500);
                this.frame.setVisible(true);
            }
            if (!this.options.startGUI || this.frame == null) {
                try {
                    this.getResources();
                }
                catch (XMLDBException e) {
                    System.err.println("XMLDBException while retrieving collection contents: " + InteractiveClient.getExceptionMessage(e));
                    e.getCause().printStackTrace();
                    return false;
                }
            }
            boolean retry = true;
            while (retry) {
                String errorMessage = "";
                try {
                    this.getResources();
                }
                catch (XMLDBException e) {
                    errorMessage = InteractiveClient.getExceptionMessage(e);
                    ClientFrame.showErrorMessage("XMLDBException occurred while retrieving collection: " + errorMessage, e);
                }
                if (errorMessage.matches("^.*Invalid password for user.*$") || errorMessage.matches("^.*User .* unknown.*") || errorMessage.matches("^.*Connection refused: connect.*")) {
                    boolean haveLoginData = this.getGuiLoginData(this.properties);
                    if (!haveLoginData) {
                        return false;
                    }
                    this.shutdown(false);
                    this.connectToDatabase();
                    continue;
                }
                if (!errorMessage.isEmpty()) {
                    this.frame.dispose();
                    return false;
                }
                retry = false;
            }
            this.messageln(EOL + "type help or ? for help.");
            if (this.options.openQueryGUI) {
                QueryDialog qd = new QueryDialog(this, this.current, this.properties);
                qd.setLocation(100, 100);
                qd.setVisible(true);
            } else if (!this.options.startGUI) {
                this.readlineInputLoop();
            } else {
                this.frame.displayPrompt();
            }
        } else {
            this.shutdown(false);
        }
        return true;
    }

    public static String getExceptionMessage(Throwable e) {
        Throwable cause;
        while ((cause = e.getCause()) != null) {
            e = cause;
        }
        return e.getMessage();
    }

    protected void readQueryHistory() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(this.queryHistoryFile.toFile());
            NodeList nodes = doc.getElementsByTagName("query");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element query = (Element)nodes.item(i);
                StringBuilder value = new StringBuilder();
                for (Node next = query.getFirstChild(); next != null; next = next.getNextSibling()) {
                    value.append(next.getTextContent());
                }
                this.queryHistory.addLast(value.toString());
            }
        }
        catch (Exception e) {
            if (this.options.startGUI) {
                ClientFrame.showErrorMessage("Error while reading query history: " + e.getMessage(), e);
            }
            this.errorln("Error while reading query history: " + e.getMessage());
        }
    }

    protected void addToHistory(String query) {
        this.queryHistory.add(query);
    }

    protected void writeQueryHistory() {
        try {
            this.console.getHistory().flushBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.queryHistoryFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput(writer, null);
            int p = 0;
            if (this.queryHistory.size() > 20) {
                p = this.queryHistory.size() - 20;
            }
            AttributesImpl attrs = new AttributesImpl();
            serializer.startDocument();
            serializer.startElement("", "history", "history", attrs);
            ListIterator<String> i = this.queryHistory.listIterator(p);
            while (i.hasNext()) {
                serializer.startElement("", "query", "query", attrs);
                String next = i.next();
                serializer.characters(next.toCharArray(), 0, next.length());
                serializer.endElement("", "query", "query");
            }
            serializer.endElement("", "history", "history");
            serializer.endDocument();
            writer.close();
            SerializerPool.getInstance().returnObject(serializer);
        }
        catch (IOException e) {
            System.err.println("IO error while writing query history.");
        }
        catch (SAXException e) {
            System.err.println("SAX exception while writing query history.");
        }
    }

    public void readlineInputLoop() {
        boolean cont = true;
        while (cont) {
            try {
                String line = "true".equals(this.properties.getProperty(COLORS)) ? this.console.readLine("\u001b[0;36mexist:" + this.path + ">" + ANSI_WHITE) : this.console.readLine("exist:" + this.path + ">");
                if (line == null) continue;
                cont = this.process(line);
            }
            catch (EOFException e) {
                break;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            this.console.getHistory().flushBuffer();
        }
        catch (Exception e) {
            System.err.println("Could not write history File to " + this.historyFile.toAbsolutePath().toString());
        }
        this.shutdown(false);
        this.messageln("quit.");
    }

    protected final void shutdown(boolean force) {
        this.lazyTraceWriter.ifPresent(writer -> {
            try {
                writer.write("</query-log>");
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        try {
            DatabaseInstanceManager mgr = (DatabaseInstanceManager)this.current.getService("DatabaseInstanceManager", "1.0");
            if (mgr == null) {
                System.err.println("service is not available");
            } else if (mgr.isLocalInstance() || force) {
                System.out.println("shutting down database...");
                mgr.shutdown();
            }
        }
        catch (XMLDBException e) {
            System.err.println("database shutdown failed: ");
            e.printStackTrace();
        }
    }

    public void printNotice() {
        this.messageln(this.getNotice());
    }

    public String getNotice() {
        StringBuilder builder = new StringBuilder();
        builder.append(SystemProperties.getInstance().getSystemProperty("product-name", "eXist-db"));
        builder.append(" version ");
        builder.append(SystemProperties.getInstance().getSystemProperty("product-version", "unknown"));
        if (!"".equals(SystemProperties.getInstance().getSystemProperty("git-commit", ""))) {
            builder.append(" (");
            builder.append(SystemProperties.getInstance().getSystemProperty("git-commit", "(unknown Git commit ID)"));
            builder.append(")");
        }
        builder.append(", Copyright (C) 2001-");
        builder.append(Calendar.getInstance().get(1));
        builder.append(" The eXist-db Project");
        builder.append(EOL);
        builder.append("eXist-db comes with ABSOLUTELY NO WARRANTY.");
        builder.append(EOL);
        builder.append("This is free software, and you are welcome to redistribute it");
        builder.append(EOL);
        builder.append("under certain conditions; for details read the license file.");
        builder.append(EOL);
        return builder.toString();
    }

    private void message(String msg) {
        if (!this.options.quiet) {
            if (this.options.startGUI && this.frame != null) {
                this.frame.display(msg);
            } else {
                System.out.print(msg);
            }
        }
    }

    private void messageln(String msg) {
        if (!this.options.quiet) {
            if (this.options.startGUI && this.frame != null) {
                this.frame.display(msg + EOL);
            } else {
                System.out.println(msg);
            }
        }
    }

    private void errorln(String msg) {
        if (this.options.startGUI && this.frame != null) {
            this.frame.display(msg + EOL);
        } else {
            System.err.println(msg);
        }
    }

    private Collection resolveCollection(XmldbURI path) throws XMLDBException {
        return DatabaseManager.getCollection((String)(this.properties.getProperty(URI) + path), (String)this.properties.getProperty(USER), (String)this.properties.getProperty(PASSWORD));
    }

    private Resource resolveResource(XmldbURI path) throws XMLDBException {
        try {
            XmldbURI collectionPath = path.numSegments() == 1 ? XmldbURI.xmldbUriFor(this.current.getName()) : path.removeLastSegment();
            XmldbURI resourceName = path.lastSegment();
            Collection collection = this.resolveCollection(collectionPath);
            if (collection == null) {
                this.messageln("Collection " + collectionPath + " not found.");
                return null;
            }
            this.messageln("Locating resource " + resourceName + " in collection " + collection.getName());
            return collection.getResource(resourceName.toString());
        }
        catch (URISyntaxException e) {
            this.errorln("could not parse collection name into a valid URI: " + e.getMessage());
            return null;
        }
    }

    private void writeOutputFile(Path file, Object data) throws Exception {
        block25: {
            try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
                if (data instanceof byte[]) {
                    os.write((byte[])data);
                    break block25;
                }
                try (OutputStreamWriter writer = new OutputStreamWriter(os, Charset.forName(this.properties.getProperty(ENCODING)));){
                    writer.write(data.toString());
                }
            }
        }
    }

    private static String formatString(String s1, String s2, int width) {
        StringBuilder buf = new StringBuilder(width);
        if (s1.length() > width) {
            s1 = s1.substring(0, width - 1);
        }
        buf.append(s1);
        int fill = width - (s1.length() + s2.length());
        for (int i = 0; i < fill; ++i) {
            buf.append(' ');
        }
        buf.append(s2);
        return buf.toString();
    }

    private static String formatString(String[] args, int[] sizes) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            int j;
            if (sizes[i] < 0) {
                buf.append(args[i]);
            } else {
                for (j = 0; j < sizes[i] && j < args[i].length(); ++j) {
                    buf.append(args[i].charAt(j));
                }
            }
            for (j = 0; j < sizes[i] - args[i].length(); ++j) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static Properties getSystemProperties() {
        Properties sysProperties = new Properties();
        try {
            sysProperties.load(InteractiveClient.class.getClassLoader().getResourceAsStream("org/exist/system.properties"));
        }
        catch (IOException e) {
            System.err.println("Unable to load system.properties from class loader");
        }
        return sysProperties;
    }

    public static ImageIcon getExistIcon(Class clazz) {
        return new ImageIcon(clazz.getResource("/org/exist/client/icons/x.png"));
    }

    static {
        try {
            Class.forName("org.exist.plugin.command.Commands");
            havePluggableCommands = true;
        }
        catch (Exception e) {
            havePluggableCommands = false;
        }
    }

    public static class ProgressObserver
    implements Observer {
        final ProgressBar elementsProgress = new ProgressBar("storing elements");
        Observable lastObservable = null;
        final ProgressBar parseProgress = new ProgressBar("storing nodes   ");

        @Override
        public void update(Observable o, Object obj) {
            ProgressIndicator ind = (ProgressIndicator)obj;
            if (this.lastObservable == null || o != this.lastObservable) {
                System.out.println();
            }
            if (o instanceof ElementIndex) {
                this.elementsProgress.set(ind.getValue(), ind.getMax());
            } else {
                this.parseProgress.set(ind.getValue(), ind.getMax());
            }
            this.lastObservable = o;
        }
    }

    private class CollectionCompleter
    implements Completor {
        private CollectionCompleter() {
        }

        public int complete(String buffer, int cursor, List candidates) {
            String toComplete;
            int p = buffer.lastIndexOf(32);
            if (p > -1 && ++p < buffer.length()) {
                toComplete = buffer.substring(p);
            } else {
                toComplete = buffer;
                p = 0;
            }
            SortedSet<String> set = InteractiveClient.this.completitions.tailSet(toComplete);
            if (set != null && set.size() > 0) {
                for (String next : InteractiveClient.this.completitions.tailSet(toComplete)) {
                    if (!next.startsWith(toComplete)) continue;
                    candidates.add(next);
                }
            }
            return p;
        }
    }
}

