/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.exist.client.ClientFrame;
import org.exist.client.InteractiveClient;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.util.URIUtils;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class NewResourceDialog
extends JFrame {
    private static final String DEFAULT_FILENAME = "new-resource";
    private static final String DEFAULT_MODULE_NS = "http://module1";
    private static final String DEFAULT_MODULE_NS_PREFIX = "mod1";
    private final InteractiveClient client;

    public NewResourceDialog(InteractiveClient client) {
        super("New Resource...");
        this.setupComponents();
        this.client = client;
    }

    private void setupComponents() {
        JLabel lblLibModule = new JLabel("Library Module");
        JPanel panLibModule = new JPanel(new BorderLayout());
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        JLabel lblResourceType = new JLabel("Resource Type: ");
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(lblResourceType, c);
        this.getContentPane().add(lblResourceType);
        JComboBox<ResourceType> cmbResourceTypes = new JComboBox<ResourceType>(ResourceType.values());
        cmbResourceTypes.setSelectedIndex(0);
        cmbResourceTypes.addActionListener(e -> {
            Object src = e.getSource();
            if (src.equals(cmbResourceTypes)) {
                boolean visible1;
                switch ((ResourceType)((Object)((Object)cmbResourceTypes.getSelectedItem()))) {
                    case XQUERY_LIBRARY: {
                        visible1 = true;
                        break;
                    }
                    default: {
                        visible1 = false;
                    }
                }
                lblLibModule.setVisible(visible1);
                panLibModule.setVisible(visible1);
                this.pack();
            }
        });
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(cmbResourceTypes, c);
        this.getContentPane().add(cmbResourceTypes);
        JLabel lblFilename = new JLabel("Filename (excluding extension): ");
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(lblFilename, c);
        this.getContentPane().add(lblFilename);
        JTextField txtFilename = new JTextField(20);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(txtFilename, c);
        this.getContentPane().add(txtFilename);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(lblLibModule, c);
        this.getContentPane().add(lblLibModule);
        lblLibModule.setVisible(false);
        panLibModule.setBorder(BorderFactory.createEtchedBorder(1));
        GridBagLayout panGrid = new GridBagLayout();
        panLibModule.setLayout(panGrid);
        GridBagConstraints cPan = new GridBagConstraints();
        cPan.insets = new Insets(5, 5, 5, 5);
        JLabel lblLibModuleNamespace = new JLabel("Namespace: ");
        cPan.gridx = 0;
        cPan.gridy = 0;
        cPan.gridwidth = 1;
        cPan.anchor = 17;
        cPan.fill = 0;
        panGrid.setConstraints(lblLibModuleNamespace, cPan);
        panLibModule.add(lblLibModuleNamespace);
        JTextField txtLibModuleNamespace = new JTextField(DEFAULT_MODULE_NS, 50);
        cPan.gridx = 1;
        cPan.gridy = 0;
        cPan.gridwidth = 1;
        cPan.anchor = 17;
        cPan.fill = 0;
        panGrid.setConstraints(txtLibModuleNamespace, cPan);
        panLibModule.add(txtLibModuleNamespace);
        JLabel lblLibModulePrefix = new JLabel("Namespace prefix: ");
        cPan.gridx = 0;
        cPan.gridy = 1;
        cPan.gridwidth = 1;
        cPan.anchor = 17;
        cPan.fill = 0;
        panGrid.setConstraints(lblLibModulePrefix, cPan);
        panLibModule.add(lblLibModulePrefix);
        JTextField txtLibModulePrefix = new JTextField(DEFAULT_MODULE_NS_PREFIX, 10);
        cPan.gridx = 1;
        cPan.gridy = 1;
        cPan.gridwidth = 1;
        cPan.anchor = 17;
        cPan.fill = 0;
        panGrid.setConstraints(txtLibModulePrefix, cPan);
        panLibModule.add(txtLibModulePrefix);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(panLibModule, c);
        this.getContentPane().add(panLibModule);
        panLibModule.setVisible(false);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = -1;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(btnCancel, c);
        this.getContentPane().add(btnCancel);
        JButton btnCreate = new JButton("Create Resource");
        btnCreate.addActionListener(e -> {
            this.createResource((ResourceType)((Object)((Object)cmbResourceTypes.getSelectedItem())), txtFilename.getText(), txtLibModuleNamespace.getText(), txtLibModulePrefix.getText());
            this.setVisible(false);
            this.dispose();
        });
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 0;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(btnCreate, c);
        this.getContentPane().add(btnCreate);
        this.pack();
    }

    private void createResource(ResourceType resourceType, String filename, String moduleNamespace, String moduleNamespacePrefix) {
        StringBuilder resourceContentBuilder = new StringBuilder();
        try (InputStream is = this.getClass().getResourceAsStream(resourceType.getTemplatePath());
             InputStreamReader reader = new InputStreamReader(is);){
            char[] buf = new char[1024];
            int read = -1;
            while ((read = reader.read(buf)) > -1) {
                resourceContentBuilder.append(buf, 0, read);
            }
        }
        catch (IOException ioe) {
            ClientFrame.showErrorMessage(ioe.getMessage(), ioe);
        }
        String resourceContent = resourceType == ResourceType.XQUERY_LIBRARY ? resourceContentBuilder.toString().replaceAll("\\$NS", moduleNamespace).replaceAll("\\$PREFIX", moduleNamespacePrefix) : resourceContentBuilder.toString();
        try {
            String resName = URIUtils.urlEncodeUtf8((this.isNullOrEmpty(filename) ? DEFAULT_FILENAME : filename) + "." + resourceType.getFileExtension());
            String resType = resourceType == ResourceType.XML_DOCUMENT ? "XMLResource" : "BinaryResource";
            Collection collection = this.client.current;
            Resource resource = collection.createResource(resName, resType);
            resource.setContent((Object)resourceContent);
            ((EXistResource)resource).setMimeType(resourceType.getMimeType());
            collection.storeResource(resource);
            collection.close();
            this.client.reloadCollection();
        }
        catch (XMLDBException xmldbe) {
            ClientFrame.showErrorMessage(xmldbe.getMessage(), xmldbe);
        }
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static enum ResourceType {
        XML_DOCUMENT("XML Document", "xml", "application/xml", "xml-resource.tmpl"),
        XQUERY_MAIN("XQuery Main Module", "xqy", "application/xquery", "xquery-resource.tmpl"),
        XQUERY_LIBRARY("XQuery Library Module", "xqm", "application/xquery", "xquery-lib-resource.tmpl");

        private final String label;
        private final String fileExtension;
        private final String mimeType;
        private final String templatePath;

        private ResourceType(String label, String fileExtension, String mimeType, String templatePath) {
            this.label = label;
            this.fileExtension = fileExtension;
            this.mimeType = mimeType;
            this.templatePath = templatePath;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }

        public String toString() {
            return this.label;
        }
    }
}

