/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.exist.client.DialogCompleteWithResponse;
import org.exist.client.DialogWithResponse;
import org.exist.client.InteractiveClient;
import org.exist.client.security.AutoCompletion;
import org.exist.security.ACLPermission;
import org.exist.security.Account;
import org.exist.security.internal.aider.ACEAider;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class AccessControlEntryDialog
extends JFrame
implements DialogWithResponse<ACEAider> {
    private final UserManagementService userManagementService;
    private DefaultTableModel permissionTableModel = null;
    private DefaultComboBoxModel usernameModel;
    private final Set<String> allUsernames;
    private DefaultComboBoxModel groupNameModel = null;
    private final Set<String> allGroupNames;
    private final List<DialogCompleteWithResponse<ACEAider>> dialogCompleteWithResponseCallbacks = new ArrayList<DialogCompleteWithResponse<ACEAider>>();
    private JButton btnClose;
    private JButton btnCreate;
    private JComboBox cmbAccess;
    private JComboBox cmbGroupName;
    private JComboBox cmbTarget;
    private JComboBox cmbUsername;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAccess;
    private JLabel lblGroupName;
    private JLabel lblPermission;
    private JLabel lblTarget;
    private JLabel lblUsername;
    private JTable tblPermission;

    public AccessControlEntryDialog(UserManagementService userManagementService, String title) throws XMLDBException {
        this.userManagementService = userManagementService;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        this.allUsernames = new HashSet<String>();
        for (Account account : userManagementService.getAccounts()) {
            this.allUsernames.add(account.getName());
        }
        this.allGroupNames = new HashSet<String>();
        for (String groupName : userManagementService.getGroups()) {
            this.allGroupNames.add(groupName);
        }
        this.initComponents();
        this.setTitle(title);
    }

    private DefaultTableModel getPermissionTableModel() {
        if (this.permissionTableModel == null) {
            this.permissionTableModel = new DefaultTableModel(new Object[][]{{false, false, false}}, new String[]{"Read", "Write", "Execute"}){

                public Class getColumnClass(int columnIndex) {
                    return Boolean.class;
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return true;
                }
            };
        }
        return this.permissionTableModel;
    }

    private ComboBoxModel getUsernameModel() {
        if (this.usernameModel == null) {
            this.usernameModel = new DefaultComboBoxModel();
            this.usernameModel.addElement("");
            for (String username : this.allUsernames) {
                this.usernameModel.addElement(username);
            }
        }
        return this.usernameModel;
    }

    private ComboBoxModel getGroupNameModel() {
        if (this.groupNameModel == null) {
            this.groupNameModel = new DefaultComboBoxModel();
            this.groupNameModel.addElement("");
            for (String groupName : this.allGroupNames) {
                this.groupNameModel.addElement(groupName);
            }
        }
        return this.groupNameModel;
    }

    private boolean isValidUsername(String username) {
        return this.allUsernames.contains(username);
    }

    private boolean isValidGroupName(String groupName) {
        return this.allGroupNames.contains(groupName);
    }

    private void initComponents() {
        this.lblTarget = new JLabel();
        this.cmbTarget = new JComboBox();
        this.lblUsername = new JLabel();
        this.cmbUsername = new JComboBox();
        AutoCompletion.enable(this.cmbUsername);
        this.lblGroupName = new JLabel();
        this.cmbGroupName = new JComboBox();
        AutoCompletion.enable(this.cmbGroupName);
        this.lblAccess = new JLabel();
        this.cmbAccess = new JComboBox();
        this.lblPermission = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblPermission = new JTable();
        this.jSeparator1 = new JSeparator();
        this.btnCreate = new JButton();
        this.btnClose = new JButton();
        this.setDefaultCloseOperation(3);
        this.lblTarget.setText("Target:");
        this.cmbTarget.setModel(new DefaultComboBoxModel<String>(new String[]{"USER", "GROUP"}));
        this.cmbTarget.addActionListener(this::cmbTargetActionPerformed);
        this.lblUsername.setText("Username:");
        this.cmbUsername.setEditable(true);
        this.cmbUsername.setModel(this.getUsernameModel());
        this.cmbUsername.addActionListener(this::cmbUsernameActionPerformed);
        this.lblGroupName.setText("Group:");
        this.cmbGroupName.setEditable(true);
        this.cmbGroupName.setModel(this.getGroupNameModel());
        this.cmbGroupName.setEnabled(false);
        this.cmbGroupName.addActionListener(this::cmbGroupNameActionPerformed);
        this.lblAccess.setText("Access:");
        this.cmbAccess.setModel(new DefaultComboBoxModel<String>(new String[]{"ALLOWED", "DENIED"}));
        this.lblPermission.setText("Permission");
        this.tblPermission.setModel(this.getPermissionTableModel());
        this.tblPermission.setRowSelectionAllowed(false);
        this.jScrollPane1.setViewportView(this.tblPermission);
        this.btnCreate.setText("Create");
        this.btnCreate.addActionListener(this::btnCreateActionPerformed);
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this::btnCloseActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane1, -2, 345, -2)).addComponent(this.lblPermission).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblUsername).addComponent(this.lblTarget).addComponent(this.lblGroupName).addComponent(this.lblAccess)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbAccess, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmbTarget, -2, -1, -2).addComponent(this.cmbUsername, 0, 257, Short.MAX_VALUE).addComponent(this.cmbGroupName, 0, -1, Short.MAX_VALUE))))).addContainerGap(24, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreate))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTarget).addComponent(this.cmbTarget, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUsername).addComponent(this.cmbUsername, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGroupName).addComponent(this.cmbGroupName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbAccess, -2, -1, -2).addComponent(this.lblAccess)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPermission).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCreate).addComponent(this.btnClose)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        String who;
        ACLPermission.ACE_TARGET target = ACLPermission.ACE_TARGET.valueOf((String)this.cmbTarget.getSelectedItem());
        if (target == ACLPermission.ACE_TARGET.USER ? !this.isValidUsername(who = (String)this.cmbUsername.getSelectedItem()) : !this.isValidGroupName(who = (String)this.cmbGroupName.getSelectedItem())) {
            return;
        }
        ACLPermission.ACE_ACCESS_TYPE accessType = ACLPermission.ACE_ACCESS_TYPE.valueOf((String)this.cmbAccess.getSelectedItem());
        int mode = 0;
        if (((Boolean)this.tblPermission.getValueAt(0, 0)).booleanValue()) {
            mode |= 4;
        }
        if (((Boolean)this.tblPermission.getValueAt(0, 1)).booleanValue()) {
            mode |= 2;
        }
        if (((Boolean)this.tblPermission.getValueAt(0, 2)).booleanValue()) {
            mode |= 1;
        }
        ACEAider ace = new ACEAider(accessType, target, who, mode);
        for (DialogCompleteWithResponse<ACEAider> callback : this.getDialogCompleteWithResponseCallbacks()) {
            callback.complete(ace);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void cmbTargetActionPerformed(ActionEvent evt) {
        ACLPermission.ACE_TARGET aceTarget = ACLPermission.ACE_TARGET.valueOf((String)this.cmbTarget.getSelectedItem());
        switch (aceTarget) {
            case USER: {
                this.cmbGroupName.setEnabled(false);
                this.cmbUsername.setEnabled(true);
                break;
            }
            case GROUP: {
                this.cmbUsername.setEnabled(false);
                this.cmbGroupName.setEnabled(true);
            }
        }
    }

    private void cmbUsernameActionPerformed(ActionEvent evt) {
        String currentUsername = (String)this.cmbUsername.getSelectedItem();
        boolean isValid = this.isValidUsername(currentUsername);
        this.btnCreate.setEnabled(isValid);
    }

    private void cmbGroupNameActionPerformed(ActionEvent evt) {
        String currentGroupName = (String)this.cmbGroupName.getSelectedItem();
        boolean isValid = this.isValidGroupName(currentGroupName);
        this.btnCreate.setEnabled(isValid);
    }

    private List<DialogCompleteWithResponse<ACEAider>> getDialogCompleteWithResponseCallbacks() {
        return this.dialogCompleteWithResponseCallbacks;
    }

    @Override
    public void addDialogCompleteWithResponseCallback(DialogCompleteWithResponse<ACEAider> dialogCompleteWithResponseCallback) {
        this.getDialogCompleteWithResponseCallbacks().add(dialogCompleteWithResponseCallback);
    }
}

