/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.exist.client.DialogCompleteWithResponse;
import org.exist.client.InteractiveClient;
import org.exist.client.LabelledBoolean;
import org.exist.client.LabelledBooleanEditor;
import org.exist.client.LabelledBooleanRenderer;
import org.exist.client.ResourceDescriptor;
import org.exist.client.security.AccessControlEntryDialog;
import org.exist.client.security.AclTableModel;
import org.exist.client.security.BasicPermissionsTableModel;
import org.exist.client.security.FindGroupForm;
import org.exist.client.security.FindUserForm;
import org.exist.security.ACLPermission;
import org.exist.security.internal.aider.ACEAider;
import org.exist.security.internal.aider.PermissionAider;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.util.URIUtils;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class EditPropertiesDialog
extends JFrame {
    private final UserManagementService userManagementService;
    private final String currentUser;
    private final Collection parent;
    private final XmldbURI uri;
    private final String internetMediaType;
    private final Date created;
    private final Date lastModified;
    private final PermissionAider permission;
    private final List<ResourceDescriptor> applyTo;
    private BasicPermissionsTableModel basicPermissionsTableModel = null;
    private DefaultTableModel aclTableModel = null;
    private static final String ERROR_TITLE = "Edit Properties Error";
    private JButton btnAddAce;
    private JButton btnChangeGroup;
    private JButton btnChangeOwner;
    private JButton btnClose;
    private JButton btnSave;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JLabel lblAccessControlList;
    private JLabel lblBasePermissions;
    private JLabel lblCreated;
    private JLabel lblCreatedValue;
    private JLabel lblGroup;
    private JLabel lblGroupValue;
    private JLabel lblInternetMediaType;
    private JLabel lblInternetMediaTypeValue;
    private JLabel lblLastModified;
    private JLabel lblLastModifiedValue;
    private JLabel lblOwner;
    private JLabel lblOwnerValue;
    private JLabel lblResource;
    private JLabel lblResourceValue;
    private JMenuItem miInsertAceAfter;
    private JMenuItem miInsertAceBefore;
    private JMenuItem miMoveDown;
    private JMenuItem miMoveUp;
    private JMenuItem miRemoveAce;
    private JPopupMenu pmAcl;
    private JTable tblAcl;
    private JTable tblBasePermissions;

    public EditPropertiesDialog(UserManagementService userManagementService, String currentUser, Collection parent, XmldbURI uri, String internetMediaType, Date created, Date lastModified, PermissionAider permission, List<ResourceDescriptor> applyTo) {
        this.userManagementService = userManagementService;
        this.currentUser = currentUser;
        this.parent = parent;
        this.uri = uri;
        this.internetMediaType = internetMediaType;
        this.created = created;
        this.lastModified = lastModified;
        this.permission = permission;
        this.applyTo = applyTo;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        this.initComponents();
        this.setFormProperties();
    }

    private void setFormProperties() {
        this.lblResourceValue.setText(URIUtils.urlDecodeUtf8(this.uri));
        this.lblInternetMediaTypeValue.setText(this.internetMediaType != null ? this.internetMediaType : "N/A");
        this.lblCreatedValue.setText(DateFormat.getDateTimeInstance().format(this.created));
        this.lblLastModifiedValue.setText(this.lastModified != null ? DateFormat.getDateTimeInstance().format(this.lastModified) : "N/A");
        this.lblOwnerValue.setText(this.permission.getOwner().getName());
        this.lblGroupValue.setText(this.permission.getGroup().getName());
        try {
            boolean canModify = this.canModifyPermissions();
            this.btnChangeOwner.setEnabled(this.isDba());
            this.btnChangeGroup.setEnabled(this.isDba());
            this.tblBasePermissions.setEnabled(canModify);
            if (!(this.permission instanceof ACLPermission)) {
                this.tblAcl.setEnabled(false);
            } else {
                this.tblAcl.setEnabled(canModify);
            }
            this.miInsertAceBefore.setEnabled(canModify);
            this.miInsertAceAfter.setEnabled(canModify);
            this.btnAddAce.setEnabled(canModify);
            this.miMoveUp.setEnabled(false);
            this.miMoveDown.setEnabled(false);
            this.miRemoveAce.setEnabled(false);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not get dba group members: " + xmldbe.getMessage(), ERROR_TITLE, 0);
        }
    }

    private BasicPermissionsTableModel getBasicPermissionsTableModel() {
        if (this.basicPermissionsTableModel == null) {
            this.basicPermissionsTableModel = new BasicPermissionsTableModel(this.permission);
        }
        return this.basicPermissionsTableModel;
    }

    private DefaultTableModel getAclTableModel() {
        if (this.aclTableModel == null) {
            this.aclTableModel = new AclTableModel(this.permission);
        }
        return this.aclTableModel;
    }

    private UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    private void initComponents() {
        this.pmAcl = new JPopupMenu();
        this.miInsertAceBefore = new JMenuItem();
        this.miInsertAceAfter = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.miMoveUp = new JMenuItem();
        this.miMoveDown = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.miRemoveAce = new JMenuItem();
        this.lblResource = new JLabel();
        this.lblInternetMediaType = new JLabel();
        this.lblCreated = new JLabel();
        this.lblLastModified = new JLabel();
        this.lblOwner = new JLabel();
        this.lblGroup = new JLabel();
        this.lblResourceValue = new JLabel();
        this.lblInternetMediaTypeValue = new JLabel();
        this.lblCreatedValue = new JLabel();
        this.lblLastModifiedValue = new JLabel();
        this.lblOwnerValue = new JLabel();
        this.lblGroupValue = new JLabel();
        this.btnChangeOwner = new JButton();
        this.btnChangeGroup = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.tblBasePermissions = new JTable();
        this.tblBasePermissions.setDefaultRenderer(LabelledBoolean.class, new LabelledBooleanRenderer());
        this.tblBasePermissions.setDefaultEditor(LabelledBoolean.class, new LabelledBooleanEditor());
        this.lblAccessControlList = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lblBasePermissions = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.tblAcl = new JTable();
        this.jSeparator2 = new JSeparator();
        this.btnSave = new JButton();
        this.btnClose = new JButton();
        this.btnAddAce = new JButton();
        this.miInsertAceBefore.setText("Insert ACE before...");
        this.miInsertAceBefore.addActionListener(this::miInsertAceBeforeActionPerformed);
        this.pmAcl.add(this.miInsertAceBefore);
        this.miInsertAceAfter.setText("Insert ACE after...");
        this.miInsertAceAfter.addActionListener(this::miInsertAceAfterActionPerformed);
        this.pmAcl.add(this.miInsertAceAfter);
        this.pmAcl.add(this.jSeparator3);
        this.miMoveUp.setText("Move ACE up");
        this.miMoveUp.addActionListener(this::miMoveUpActionPerformed);
        this.pmAcl.add(this.miMoveUp);
        this.miMoveDown.setText("Move ACE down");
        this.miMoveDown.addActionListener(this::miMoveDownActionPerformed);
        this.pmAcl.add(this.miMoveDown);
        this.pmAcl.add(this.jSeparator4);
        this.miRemoveAce.setText("Remove ACE");
        this.miRemoveAce.addActionListener(this::miRemoveAceActionPerformed);
        this.pmAcl.add(this.miRemoveAce);
        this.setDefaultCloseOperation(2);
        this.setTitle("Properties");
        this.lblResource.setText("Resource:");
        this.lblInternetMediaType.setText("Internet Media Type:");
        this.lblCreated.setText("Created:");
        this.lblLastModified.setText("Last Modified:");
        this.lblOwner.setText("Owner:");
        this.lblGroup.setText("Group:");
        this.lblResourceValue.setText("<resource>");
        this.lblInternetMediaTypeValue.setText("<internet media type>");
        this.lblCreatedValue.setText("<created>");
        this.lblLastModifiedValue.setText("<last modified>");
        this.lblOwnerValue.setText("<owner>");
        this.lblGroupValue.setText("<group>");
        this.btnChangeOwner.setText("...");
        this.btnChangeOwner.addActionListener(this::btnChangeOwnerActionPerformed);
        this.btnChangeGroup.setText("...");
        this.btnChangeGroup.addActionListener(this::btnChangeGroupActionPerformed);
        this.tblBasePermissions.setModel(this.getBasicPermissionsTableModel());
        this.tblBasePermissions.setRowSelectionAllowed(false);
        this.jScrollPane2.setViewportView(this.tblBasePermissions);
        this.lblAccessControlList.setText("Access Control List");
        this.lblBasePermissions.setText("Base Permissions");
        this.tblAcl.setModel(this.getAclTableModel());
        this.tblAcl.setComponentPopupMenu(this.pmAcl);
        this.tblAcl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EditPropertiesDialog.this.tblAclMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.tblAcl);
        this.btnSave.setText("Save");
        this.btnSave.addActionListener(this::btnSaveActionPerformed);
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this::btnCloseActionPerformed);
        this.btnAddAce.setText("Add Access Control Entry...");
        this.btnAddAce.addActionListener(this::btnAddAceActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBasePermissions).addComponent(this.lblAccessControlList).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.lblOwner).addGap(112, 112, 112)).addComponent(this.lblLastModified, GroupLayout.Alignment.LEADING).addComponent(this.lblCreated, GroupLayout.Alignment.LEADING)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblResource).addComponent(this.lblInternetMediaType).addComponent(this.lblGroup)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblResourceValue, -1, 251, Short.MAX_VALUE).addComponent(this.lblInternetMediaTypeValue, -1, -1, Short.MAX_VALUE).addComponent(this.lblCreatedValue, -1, -1, Short.MAX_VALUE).addComponent(this.lblLastModifiedValue, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lblGroupValue, -2, 216, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChangeGroup, -2, 26, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblOwnerValue, -2, 216, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChangeOwner, -2, 26, -2)))).addComponent(this.btnAddAce).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -1, 404, Short.MAX_VALUE))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator2, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblResource).addComponent(this.lblResourceValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblInternetMediaType).addComponent(this.lblInternetMediaTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCreated).addComponent(this.lblCreatedValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLastModified).addComponent(this.lblLastModifiedValue)).addGap(14, 14, 14).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOwner).addComponent(this.lblOwnerValue).addComponent(this.btnChangeOwner, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGroup).addComponent(this.lblGroupValue).addComponent(this.btnChangeGroup, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblBasePermissions).addGap(5, 5, 5).addComponent(this.jScrollPane2, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblAccessControlList).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 132, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAddAce).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClose).addComponent(this.btnSave)).addGap(20, 20, 20)));
        this.pack();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        try {
            ArrayList<ACEAider> dlgAces = new ArrayList<ACEAider>();
            if (this.permission instanceof ACLPermission) {
                for (int i = 0; i < this.tblAcl.getRowCount(); ++i) {
                    ACLPermission.ACE_TARGET target = ACLPermission.ACE_TARGET.valueOf((String)this.getAclTableModel().getValueAt(i, 0));
                    String who = (String)this.getAclTableModel().getValueAt(i, 1);
                    ACLPermission.ACE_ACCESS_TYPE access = ACLPermission.ACE_ACCESS_TYPE.valueOf((String)this.getAclTableModel().getValueAt(i, 2));
                    int mode = 0;
                    if (((Boolean)this.tblAcl.getValueAt(i, 3)).booleanValue()) {
                        mode |= 4;
                    }
                    if (((Boolean)this.tblAcl.getValueAt(i, 4)).booleanValue()) {
                        mode |= 2;
                    }
                    if (((Boolean)this.tblAcl.getValueAt(i, 5)).booleanValue()) {
                        mode |= 1;
                    }
                    dlgAces.add(new ACEAider(access, target, who, mode));
                }
            }
            for (ResourceDescriptor desc : this.applyTo) {
                if (desc.isCollection()) {
                    Collection coll = this.parent.getChildCollection(desc.getName().toString());
                    this.getUserManagementService().setPermissions(coll, this.lblOwnerValue.getText(), this.lblGroupValue.getText(), this.getBasicPermissionsTableModel().getMode(), dlgAces);
                    continue;
                }
                Resource res = this.parent.getResource(desc.getName().toString());
                this.getUserManagementService().setPermissions(res, this.lblOwnerValue.getText(), this.lblGroupValue.getText(), this.getBasicPermissionsTableModel().getMode(), dlgAces);
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not update properties: " + xmldbe.getMessage(), ERROR_TITLE, 0);
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void btnChangeOwnerActionPerformed(ActionEvent evt) {
        DialogCompleteWithResponse<String> callback = username -> this.lblOwnerValue.setText((String)username);
        try {
            FindUserForm findUserForm = new FindUserForm(this.getUserManagementService());
            findUserForm.addDialogCompleteWithResponseCallback(callback);
            findUserForm.setTitle("Change Owner...");
            findUserForm.setVisible(true);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not retrieve list of users: " + xmldbe.getMessage(), ERROR_TITLE, 0);
        }
    }

    private void btnChangeGroupActionPerformed(ActionEvent evt) {
        DialogCompleteWithResponse<String> callback = groupName -> this.lblGroupValue.setText((String)groupName);
        try {
            FindGroupForm findGroupForm = new FindGroupForm(this.getUserManagementService());
            findGroupForm.addDialogCompleteWithResponseCallback(callback);
            findGroupForm.setTitle("Change Group...");
            findGroupForm.setVisible(true);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not retrieve list of groups: " + xmldbe.getMessage(), ERROR_TITLE, 0);
        }
    }

    private void miRemoveAceActionPerformed(ActionEvent evt) {
        this.getAclTableModel().removeRow(this.tblAcl.getSelectedRow());
    }

    private void miMoveUpActionPerformed(ActionEvent evt) {
        if (this.tblAcl.getSelectedRow() > 0) {
            this.getAclTableModel().moveRow(this.tblAcl.getSelectedRow(), this.tblAcl.getSelectedRow(), this.tblAcl.getSelectedRow() - 1);
        }
    }

    private void miMoveDownActionPerformed(ActionEvent evt) {
        if (this.tblAcl.getSelectedRow() < this.getAclTableModel().getRowCount() - 1) {
            this.getAclTableModel().moveRow(this.tblAcl.getSelectedRow(), this.tblAcl.getSelectedRow(), this.tblAcl.getSelectedRow() + 1);
        }
    }

    private void btnAddAceActionPerformed(ActionEvent evt) {
        DialogCompleteWithResponse<ACEAider> callback = ace -> this.getAclTableModel().addRow(new Object[]{ace.getTarget().toString(), ace.getWho(), ace.getAccessType().toString(), (ace.getMode() & 4) == 4, (ace.getMode() & 2) == 2, (ace.getMode() & 1) == 1});
        try {
            AccessControlEntryDialog aceDialog = new AccessControlEntryDialog(this.getUserManagementService(), "Create Access Control Entry");
            aceDialog.addDialogCompleteWithResponseCallback(callback);
            aceDialog.setVisible(true);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not get user/group members: " + xmldbe.getMessage(), ERROR_TITLE, 0);
        }
    }

    private void miInsertAceBeforeActionPerformed(ActionEvent evt) {
        DialogCompleteWithResponse<ACEAider> callback = ace -> {
            int insertAt = this.tblAcl.getSelectedRow();
            this.getAclTableModel().insertRow(insertAt, new Object[]{ace.getTarget().toString(), ace.getWho(), ace.getAccessType().toString(), (ace.getMode() & 4) == 4, (ace.getMode() & 2) == 2, (ace.getMode() & 1) == 1});
        };
        try {
            AccessControlEntryDialog aceDialog = new AccessControlEntryDialog(this.getUserManagementService(), "Insert Access Control Entry (before...)");
            aceDialog.addDialogCompleteWithResponseCallback(callback);
            aceDialog.setVisible(true);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not get user/group members: " + xmldbe.getMessage(), ERROR_TITLE, 0);
        }
    }

    private void miInsertAceAfterActionPerformed(ActionEvent evt) {
        DialogCompleteWithResponse<ACEAider> callback = ace -> {
            int insertAt = this.tblAcl.getSelectedRow() < this.getAclTableModel().getRowCount() - 1 ? this.tblAcl.getSelectedRow() + 1 : this.getAclTableModel().getRowCount();
            this.getAclTableModel().insertRow(insertAt, new Object[]{ace.getTarget().toString(), ace.getWho(), ace.getAccessType().toString(), (ace.getMode() & 4) == 4, (ace.getMode() & 2) == 2, (ace.getMode() & 1) == 1});
        };
        try {
            AccessControlEntryDialog aceDialog = new AccessControlEntryDialog(this.getUserManagementService(), "Insert Access Control Entry (after...)");
            aceDialog.addDialogCompleteWithResponseCallback(callback);
            aceDialog.setVisible(true);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not get user/group members: " + xmldbe.getMessage(), ERROR_TITLE, 0);
        }
    }

    private boolean isDba() throws XMLDBException {
        HashSet<String> dbaMembers = new HashSet<String>(Arrays.asList(this.getUserManagementService().getGroupMembers("dba")));
        return dbaMembers.contains(this.currentUser);
    }

    private boolean canModifyPermissions() throws XMLDBException {
        return this.isDba() || this.permission.getOwner().getName().equals(this.currentUser);
    }

    private void tblAclMouseClicked(MouseEvent evt) {
        boolean aclSelected = this.tblAcl.getSelectedRow() > -1;
        try {
            boolean canModify = this.canModifyPermissions();
            this.miInsertAceBefore.setEnabled(canModify);
            this.miInsertAceAfter.setEnabled(canModify);
            this.miMoveUp.setEnabled(canModify && aclSelected);
            this.miMoveDown.setEnabled(canModify && aclSelected);
            this.miRemoveAce.setEnabled(canModify && aclSelected);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not get dba group members: " + xmldbe.getMessage(), ERROR_TITLE, 0);
        }
    }
}

