/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.exist.client.DialogCompleteWithResponse;
import org.exist.client.DialogWithResponse;
import org.exist.client.security.AutoCompletion;
import org.exist.security.Account;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class FindUserForm
extends JFrame
implements DialogWithResponse<String> {
    private final UserManagementService userManagementService;
    private final List<DialogCompleteWithResponse<String>> dialogCompleteWithResponseCallbacks = new ArrayList<DialogCompleteWithResponse<String>>();
    private final Set<String> allUsernames;
    private DefaultComboBoxModel usernameModel;
    private JButton btnCancel;
    private JButton btnOk;
    private JComboBox cmbUsername;
    private JSeparator jSeparator1;
    private JLabel lblUsername;

    public FindUserForm(UserManagementService userManagementService) throws XMLDBException {
        this.userManagementService = userManagementService;
        this.allUsernames = new HashSet<String>();
        for (Account account : userManagementService.getAccounts()) {
            this.allUsernames.add(account.getName());
        }
        this.initComponents();
    }

    private void initComponents() {
        this.lblUsername = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.cmbUsername = new JComboBox();
        AutoCompletion.enable(this.cmbUsername);
        this.setDefaultCloseOperation(2);
        this.setTitle("Find User...");
        this.lblUsername.setText("User name:");
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(this::btnOkActionPerformed);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this::btnCancelActionPerformed);
        this.cmbUsername.setEditable(true);
        this.cmbUsername.setModel(this.getUsernameModel());
        this.cmbUsername.addActionListener(this::cmbUsernameActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.lblUsername).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbUsername, -2, 341, -2).addContainerGap(17, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUsername).addComponent(this.cmbUsername, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel)).addContainerGap(14, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void cmbUsernameActionPerformed(ActionEvent evt) {
        String currentUsername = (String)this.cmbUsername.getSelectedItem();
        boolean isValid = this.isValidUsername(currentUsername);
        this.btnOk.setEnabled(isValid);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        String currentUsername = (String)this.cmbUsername.getSelectedItem();
        if (!this.isValidUsername(currentUsername)) {
            return;
        }
        for (DialogCompleteWithResponse<String> callback : this.getDialogCompleteWithResponseCallbacks()) {
            callback.complete(currentUsername);
        }
        this.setVisible(false);
        this.dispose();
    }

    private boolean isValidUsername(String username) {
        return this.allUsernames.contains(username);
    }

    private ComboBoxModel getUsernameModel() {
        if (this.usernameModel == null) {
            this.usernameModel = new DefaultComboBoxModel();
            this.usernameModel.addElement("");
            for (String username : this.allUsernames) {
                this.usernameModel.addElement(username);
            }
        }
        return this.usernameModel;
    }

    private UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    @Override
    public void addDialogCompleteWithResponseCallback(DialogCompleteWithResponse<String> dialogCompleteWithResponseCallback) {
        this.getDialogCompleteWithResponseCallbacks().add(dialogCompleteWithResponseCallback);
    }

    private List<DialogCompleteWithResponse<String>> getDialogCompleteWithResponseCallbacks() {
        return this.dialogCompleteWithResponseCallbacks;
    }
}

