/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.exist.client.ClientFrame;
import org.exist.client.DialogCompleteWithResponse;
import org.exist.client.HighlightedTableCellRenderer;
import org.exist.client.InteractiveClient;
import org.exist.client.security.EditGroupDialog;
import org.exist.client.security.EditUserDialog;
import org.exist.client.security.GroupDialog;
import org.exist.client.security.ReadOnlyDefaultTableModel;
import org.exist.client.security.UserDialog;
import org.exist.security.AXSchemaType;
import org.exist.security.Account;
import org.exist.security.AccountComparator;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class UserManagerDialog
extends JFrame {
    private static final long serialVersionUID = 2091215304766070041L;
    private UserManagementService userManagementService;
    private final String currentUser;
    private final ClientFrame client;
    private DefaultTableModel usersTableModel = null;
    private DefaultTableModel groupsTableModel = null;
    private JButton btnClose;
    private JButton btnCreate;
    private JSeparator jSeparator1;
    private JMenuItem miEditGroup;
    private JMenuItem miEditUser;
    private JMenuItem miNewGroup;
    private JMenuItem miNewUser;
    private JMenuItem miRemoveGroup;
    private JMenuItem miRemoveUser;
    private JPopupMenu pmGroups;
    private JPopupMenu pmUsers;
    private JScrollPane spGroups;
    private JScrollPane spUsers;
    private JTable tblGroups;
    private JTable tblUsers;
    private JTabbedPane tpUserManager;

    public UserManagerDialog(UserManagementService userManagementService, String currentUser, ClientFrame client) {
        this.userManagementService = userManagementService;
        this.currentUser = currentUser;
        this.client = client;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        this.initComponents();
        this.tblUsers.setDefaultRenderer(Object.class, new HighlightedTableCellRenderer());
        this.tblGroups.setDefaultRenderer(Object.class, new HighlightedTableCellRenderer());
    }

    private TableModel getUsersTableModel() {
        if (this.usersTableModel == null) {
            try {
                Account[] accounts = this.userManagementService.getAccounts();
                Arrays.sort(accounts, new AccountComparator());
                String[][] tableData = new String[accounts.length][3];
                for (int i = 0; i < accounts.length; ++i) {
                    tableData[i][0] = accounts[i].getName();
                    tableData[i][1] = accounts[i].getMetadataValue(AXSchemaType.FULLNAME);
                    tableData[i][2] = accounts[i].getMetadataValue(EXistSchemaType.DESCRIPTION);
                }
                this.usersTableModel = new ReadOnlyDefaultTableModel(tableData, new String[]{"User", "Full Name", "Description"});
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(this, "Could not get users list: " + xmldbe.getMessage(), "User Manager Error", 0);
            }
        }
        return this.usersTableModel;
    }

    private TableModel getGroupsTableModel() {
        if (this.groupsTableModel == null) {
            try {
                Object[] groupNames = this.userManagementService.getGroups();
                Arrays.sort(groupNames);
                String[][] tableData = new String[groupNames.length][2];
                for (int i = 0; i < groupNames.length; ++i) {
                    tableData[i][0] = groupNames[i];
                    tableData[i][1] = this.userManagementService.getGroup((String)groupNames[i]).getMetadataValue(EXistSchemaType.DESCRIPTION);
                }
                this.groupsTableModel = new ReadOnlyDefaultTableModel(tableData, new String[]{"Group", "Description"});
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(this, "Could not get groups list: " + xmldbe.getMessage(), "User Manager Error", 0);
            }
        }
        return this.groupsTableModel;
    }

    public void refreshUsersTableModel() {
        int rowCount = this.usersTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.usersTableModel.removeRow(0);
        }
        try {
            Account[] accounts = this.userManagementService.getAccounts();
            Arrays.sort(accounts, new AccountComparator());
            for (int i = 0; i < accounts.length; ++i) {
                this.usersTableModel.addRow(new String[]{accounts[i].getName(), accounts[i].getMetadataValue(AXSchemaType.FULLNAME), accounts[i].getMetadataValue(EXistSchemaType.DESCRIPTION)});
            }
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not get users list: " + xmldbe.getMessage(), "User Manager Error", 0);
        }
    }

    public void refreshGroupsTableModel() {
        int rowCount = this.groupsTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.groupsTableModel.removeRow(0);
        }
        try {
            Object[] groupNames = this.userManagementService.getGroups();
            Arrays.sort(groupNames);
            for (int i = 0; i < groupNames.length; ++i) {
                this.groupsTableModel.addRow(new String[]{groupNames[i], this.userManagementService.getGroup((String)groupNames[i]).getMetadataValue(EXistSchemaType.DESCRIPTION)});
            }
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not get groups list: " + xmldbe.getMessage(), "User Manager Error", 0);
        }
    }

    private void showUserDialog() {
        UserDialog userDialog = new UserDialog(this.userManagementService);
        userDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UserManagerDialog.this.refreshUsersTableModel();
                UserManagerDialog.this.refreshGroupsTableModel();
            }
        });
        userDialog.setVisible(true);
    }

    private void showGroupDialog() {
        GroupDialog groupDialog = new GroupDialog(this.userManagementService, this.currentUser);
        groupDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UserManagerDialog.this.refreshGroupsTableModel();
            }
        });
        groupDialog.setVisible(true);
    }

    private void initComponents() {
        this.pmUsers = new JPopupMenu();
        this.miNewUser = new JMenuItem();
        this.miEditUser = new JMenuItem();
        this.miRemoveUser = new JMenuItem();
        this.pmGroups = new JPopupMenu();
        this.miNewGroup = new JMenuItem();
        this.miEditGroup = new JMenuItem();
        this.miRemoveGroup = new JMenuItem();
        this.tpUserManager = new JTabbedPane();
        this.spUsers = new JScrollPane();
        this.tblUsers = new JTable();
        this.spGroups = new JScrollPane();
        this.tblGroups = new JTable();
        this.jSeparator1 = new JSeparator();
        this.btnCreate = new JButton();
        this.btnClose = new JButton();
        this.miNewUser.setText("New User...");
        this.miNewUser.addActionListener(this::miNewUserActionPerformed);
        this.pmUsers.add(this.miNewUser);
        this.miNewUser.getAccessibleContext().setAccessibleName("New User");
        this.miEditUser.setText("Edit User...");
        this.miEditUser.addActionListener(this::miEditUserActionPerformed);
        this.pmUsers.add(this.miEditUser);
        this.miEditUser.getAccessibleContext().setAccessibleName("Edit User");
        this.miRemoveUser.setText("Remove User");
        this.miRemoveUser.addActionListener(this::miRemoveUserActionPerformed);
        this.pmUsers.add(this.miRemoveUser);
        this.miNewGroup.setText("New Group...");
        this.miNewGroup.addActionListener(this::miNewGroupActionPerformed);
        this.pmGroups.add(this.miNewGroup);
        this.miNewGroup.getAccessibleContext().setAccessibleName("New Group");
        this.miEditGroup.setText("Edit Group...");
        this.miEditGroup.addActionListener(this::miEditGroupActionPerformed);
        this.pmGroups.add(this.miEditGroup);
        this.miEditGroup.getAccessibleContext().setAccessibleName("Edit Group");
        this.miRemoveGroup.setText("Remove Group");
        this.miRemoveGroup.addActionListener(this::miRemoveGroupActionPerformed);
        this.pmGroups.add(this.miRemoveGroup);
        this.setDefaultCloseOperation(2);
        this.setTitle("User Manager");
        this.tblUsers.setModel(this.getUsersTableModel());
        this.tblUsers.setAutoCreateRowSorter(true);
        this.tblUsers.setComponentPopupMenu(this.pmUsers);
        this.tblUsers.setShowGrid(true);
        this.tblUsers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UserManagerDialog.this.tblUsersMouseClicked(evt);
            }
        });
        this.spUsers.setViewportView(this.tblUsers);
        this.tpUserManager.addTab("Users", this.spUsers);
        this.tblGroups.setModel(this.getGroupsTableModel());
        this.tblGroups.setAutoCreateRowSorter(true);
        this.tblGroups.setComponentPopupMenu(this.pmGroups);
        this.tblGroups.setShowGrid(true);
        this.tblGroups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UserManagerDialog.this.tblGroupsMouseClicked(evt);
            }
        });
        this.spGroups.setViewportView(this.tblGroups);
        this.tpUserManager.addTab("Groups", this.spGroups);
        this.spGroups.getAccessibleContext().setAccessibleName("Groups");
        this.btnCreate.setText("Create");
        this.btnCreate.addActionListener(this::btnCreateActionPerformed);
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this::btnCloseActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(250, Short.MAX_VALUE).addComponent(this.btnClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreate).addGap(20, 20, 20)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tpUserManager, -1, 439, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 291, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnCreate).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnClose).addContainerGap()))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tpUserManager, -2, 291, -2).addGap(0, 51, Short.MAX_VALUE))));
        this.tpUserManager.getAccessibleContext().setAccessibleName("Users");
        this.pack();
    }

    private void miNewUserActionPerformed(ActionEvent evt) {
        this.showUserDialog();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private String getSelectedUsername() {
        return (String)this.tblUsers.getValueAt(this.tblUsers.getSelectedRow(), 0);
    }

    private String getSelectedGroup() {
        return (String)this.tblGroups.getValueAt(this.tblGroups.getSelectedRow(), 0);
    }

    private void miRemoveUserActionPerformed(ActionEvent evt) {
        String selectedUsername = this.getSelectedUsername();
        try {
            Account account = this.userManagementService.getAccount(selectedUsername);
            this.userManagementService.removeAccount(account);
            this.usersTableModel.removeRow(this.tblUsers.getSelectedRow());
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not remove user '" + selectedUsername + "': " + xmldbe.getMessage(), "User Manager Error", 0);
        }
    }

    private void miEditUserActionPerformed(ActionEvent evt) {
        String selectedUsername = this.getSelectedUsername();
        try {
            Account account = this.userManagementService.getAccount(selectedUsername);
            this.showEditUserDialog(account);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not edit user '" + selectedUsername + "': " + xmldbe.getMessage(), "User Manager Error", 0);
        }
    }

    private UserManagementService reconnectClientAndUserManager(String password) throws XMLDBException {
        Properties loginData = new Properties();
        loginData.setProperty("password", password);
        this.client.reconnectClient(loginData);
        return this.client.getUserManagementService();
    }

    private void showEditUserDialog(Account account) {
        UserManagerDialog that = this;
        DialogCompleteWithResponse<String> callback = response -> {
            try {
                System.out.println("Detected logged-in user password change, reconnecting to server...");
                that.userManagementService = this.reconnectClientAndUserManager((String)response);
                System.out.println("Reconnected.");
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(that, "Could not edit user '" + this.getSelectedUsername() + "': " + xmldbe.getMessage(), "User Manager Error", 0);
            }
        };
        EditUserDialog userDialog = new EditUserDialog(this.userManagementService, account);
        if (this.getSelectedUsername().equals(this.currentUser)) {
            userDialog.addDialogCompleteWithResponseCallback(callback);
        }
        userDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UserManagerDialog.this.refreshUsersTableModel();
            }
        });
        userDialog.setVisible(true);
    }

    private void showEditGroupDialog(Group group) {
        EditGroupDialog groupDialog = new EditGroupDialog(this.userManagementService, this.currentUser, group);
        groupDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UserManagerDialog.this.refreshGroupsTableModel();
            }
        });
        groupDialog.setVisible(true);
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        switch (this.tpUserManager.getSelectedIndex()) {
            case 0: {
                this.showUserDialog();
                break;
            }
            case 1: {
                this.showGroupDialog();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void tblUsersMouseClicked(MouseEvent evt) {
        boolean userSelected = this.tblUsers.getSelectedRow() > -1;
        String selectedUsername = this.getSelectedUsername();
        boolean canModify = userSelected && !selectedUsername.equals("SYSTEM");
        boolean canDelete = userSelected && !selectedUsername.equals("SYSTEM") && !selectedUsername.equals("admin") && !selectedUsername.equals("guest");
        this.miEditUser.setEnabled(canModify);
        this.miRemoveUser.setEnabled(canDelete);
        if (evt.getClickCount() == 2 && canModify) {
            try {
                Account account = this.userManagementService.getAccount(selectedUsername);
                this.showEditUserDialog(account);
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(this, "Could not edit user '" + selectedUsername + "': " + xmldbe.getMessage(), "User Manager Error", 0);
            }
        }
    }

    private void miEditGroupActionPerformed(ActionEvent evt) {
        String selectedGroup = this.getSelectedGroup();
        try {
            Group group = this.userManagementService.getGroup(selectedGroup);
            this.showEditGroupDialog(group);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not edit group '" + selectedGroup + "': " + xmldbe.getMessage(), "User Manager Error", 0);
        }
    }

    private void miRemoveGroupActionPerformed(ActionEvent evt) {
        String selectedGroup = this.getSelectedGroup();
        try {
            Group group = this.userManagementService.getGroup(selectedGroup);
            this.userManagementService.removeGroup(group);
            this.groupsTableModel.removeRow(this.tblGroups.getSelectedRow());
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not remove group '" + selectedGroup + "': " + xmldbe.getMessage(), "User Manager Error", 0);
        }
    }

    private void tblGroupsMouseClicked(MouseEvent evt) {
        boolean groupSelected = this.tblGroups.getSelectedRow() > -1;
        String selectedGroup = this.getSelectedGroup();
        boolean canDelete = groupSelected && !selectedGroup.equals("dba") && !selectedGroup.equals("guest");
        this.miRemoveGroup.setEnabled(canDelete);
        if (evt.getClickCount() == 2) {
            try {
                Group group = this.userManagementService.getGroup(selectedGroup);
                this.showEditGroupDialog(group);
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(this, "Could not edit group '" + selectedGroup + "': " + xmldbe.getMessage(), "User Manager Error", 0);
            }
        }
    }

    private void miNewGroupActionPerformed(ActionEvent evt) {
        this.showGroupDialog();
    }
}

