/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.CollectionTrigger;
import org.exist.collections.triggers.CollectionTriggerProxy;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.DocumentTriggerProxy;
import org.exist.collections.triggers.Trigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.collections.triggers.TriggerProxy;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.security.Account;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.ParametersExtractor;
import org.exist.util.XMLReaderObjectFactory;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ConfigurationClass(value="collection")
public class CollectionConfiguration {
    public static final String COLLECTION_CONFIG_SUFFIX = ".xconf";
    public static final XmldbURI COLLECTION_CONFIG_SUFFIX_URI = XmldbURI.create(".xconf");
    public static final String DEFAULT_COLLECTION_CONFIG_FILE = "collection.xconf";
    public static final XmldbURI DEFAULT_COLLECTION_CONFIG_FILE_URI = XmldbURI.create("collection.xconf");
    public static final String NAMESPACE = "http://exist-db.org/collection-config/1.0";
    private static final String ROOT_ELEMENT = "collection";
    private static final String TRIGGERS_ELEMENT = "triggers";
    private static final String TRIGGER_ELEMENT = "trigger";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String INDEX_ELEMENT = "index";
    private static final String PERMISSIONS_ELEMENT = "default-permissions";
    private static final String GROUP_ELEMENT = "default-group";
    private static final String RESOURCE_ATTR = "resource";
    private static final String COLLECTION_ATTR = "collection";
    private static final String VALIDATION_ELEMENT = "validation";
    private static final String VALIDATION_MODE_ATTR = "mode";
    private static final Logger LOG = LogManager.getLogger(CollectionConfiguration.class);
    private final List<TriggerProxy<? extends CollectionTrigger>> colTriggers = new ArrayList<TriggerProxy<? extends CollectionTrigger>>();
    private final List<TriggerProxy<? extends DocumentTrigger>> docTriggers = new ArrayList<TriggerProxy<? extends DocumentTrigger>>();
    private IndexSpec indexSpec = null;
    private XmldbURI docName = null;
    private XmldbURI srcCollectionURI;
    private int defCollPermissions = 511;
    private int defResPermissions = 438;
    private String defCollGroup = null;
    private String defResGroup = null;
    private XMLReaderObjectFactory.VALIDATION_SETTING validationMode = XMLReaderObjectFactory.VALIDATION_SETTING.UNKNOWN;
    private final BrokerPool pool;

    public CollectionConfiguration(BrokerPool pool) {
        this.pool = pool;
    }

    protected void read(DBBroker broker, Document doc, boolean checkOnly, XmldbURI srcCollectionURI, XmldbURI docName) throws CollectionConfigurationException {
        Element root;
        if (!checkOnly) {
            this.docName = docName;
            this.srcCollectionURI = srcCollectionURI;
        }
        if ((root = doc.getDocumentElement()) == null) {
            this.throwOrLog("Configuration document can not be parsed", checkOnly);
            return;
        }
        if (!"collection".equals(root.getLocalName())) {
            this.throwOrLog("Expected element 'collection' in configuration document. Got element '" + root.getLocalName() + "'", checkOnly);
            return;
        }
        if (root.getNamespaceURI() == null || !NAMESPACE.equals(root.getNamespaceURI())) {
            this.throwOrLog("Expected namespace 'http://exist-db.org/collection-config/1.0' for element 'parameter' in configuration document. Got '" + root.getNamespaceURI() + "'", checkOnly);
            return;
        }
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (NAMESPACE.equals(node.getNamespaceURI())) {
                Element elem;
                if (TRIGGERS_ELEMENT.equals(node.getLocalName())) {
                    NodeList triggers = node.getChildNodes();
                    for (int j = 0; j < triggers.getLength(); ++j) {
                        node = triggers.item(j);
                        if (node.getNodeType() != 1 || !node.getLocalName().equals(TRIGGER_ELEMENT)) continue;
                        this.configureTrigger((Element)node, srcCollectionURI, checkOnly);
                    }
                    continue;
                }
                if (INDEX_ELEMENT.equals(node.getLocalName())) {
                    elem = (Element)node;
                    try {
                        if (this.indexSpec == null) {
                            this.indexSpec = new IndexSpec(broker, elem);
                            continue;
                        }
                        this.indexSpec.read(broker, elem);
                    }
                    catch (DatabaseConfigurationException e) {
                        if (checkOnly) {
                            throw new CollectionConfigurationException(e.getMessage(), e);
                        }
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (PERMISSIONS_ELEMENT.equals(node.getLocalName())) {
                    elem = (Element)node;
                    String permsOpt = elem.getAttribute(RESOURCE_ATTR);
                    if (permsOpt != null && permsOpt.length() > 0) {
                        LOG.debug("RESOURCE: " + permsOpt);
                        try {
                            this.defResPermissions = Integer.parseInt(permsOpt, 8);
                        }
                        catch (NumberFormatException e) {
                            if (checkOnly) {
                                throw new CollectionConfigurationException("Illegal value for permissions in configuration document : " + e.getMessage(), e);
                            }
                            LOG.warn("Ilegal value for permissions in configuration document : " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if ((permsOpt = elem.getAttribute("collection")) == null || permsOpt.length() <= 0) continue;
                    LOG.debug("COLLECTION: " + permsOpt);
                    try {
                        this.defCollPermissions = Integer.parseInt(permsOpt, 8);
                    }
                    catch (NumberFormatException e) {
                        if (checkOnly) {
                            throw new CollectionConfigurationException("Illegal value for permissions in configuration document : " + e.getMessage(), e);
                        }
                        LOG.warn("Ilegal value for permissions in configuration document : " + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (GROUP_ELEMENT.equals(node.getLocalName())) {
                    elem = (Element)node;
                    String groupOpt = elem.getAttribute(RESOURCE_ATTR);
                    if (groupOpt != null && groupOpt.length() > 0) {
                        LOG.debug("RESOURCE: " + groupOpt);
                        if (this.pool.getSecurityManager().getGroup(groupOpt) != null) {
                            this.defResGroup = groupOpt;
                        } else {
                            if (checkOnly) {
                                throw new CollectionConfigurationException("Ilegal value for group in configuration document : " + groupOpt);
                            }
                            LOG.warn("Ilegal value for group in configuration document : " + groupOpt);
                        }
                    }
                    if ((groupOpt = elem.getAttribute("collection")) == null || groupOpt.length() <= 0) continue;
                    LOG.debug("COLLECTION: " + groupOpt);
                    if (this.pool.getSecurityManager().getGroup(groupOpt) != null) {
                        this.defCollGroup = groupOpt;
                        continue;
                    }
                    if (checkOnly) {
                        throw new CollectionConfigurationException("Ilegal value for group in configuration document : " + groupOpt);
                    }
                    LOG.warn("Ilegal value for group in configuration document : " + groupOpt);
                    continue;
                }
                if (VALIDATION_ELEMENT.equals(node.getLocalName())) {
                    elem = (Element)node;
                    String mode = elem.getAttribute(VALIDATION_MODE_ATTR);
                    if (mode == null) {
                        LOG.debug("Unable to determine validation mode in " + srcCollectionURI);
                        this.validationMode = XMLReaderObjectFactory.VALIDATION_SETTING.UNKNOWN;
                        continue;
                    }
                    LOG.debug(srcCollectionURI + " : Validation mode=" + mode);
                    this.validationMode = XMLReaderObjectFactory.convertValidationMode(mode);
                    continue;
                }
                this.throwOrLog("Ignored node '" + node.getLocalName() + "' in configuration document", checkOnly);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            this.throwOrLog("Ignored node '" + node.getLocalName() + "' in namespace '" + node.getNamespaceURI() + "' in configuration document", checkOnly);
        }
    }

    private void throwOrLog(String message, boolean throwExceptions) throws CollectionConfigurationException {
        if (throwExceptions) {
            throw new CollectionConfigurationException(message);
        }
        LOG.warn(message);
    }

    public XmldbURI getDocName() {
        return this.docName;
    }

    protected void setIndexConfiguration(IndexSpec spec) {
        this.indexSpec = spec;
    }

    public XmldbURI getSourceCollectionURI() {
        return this.srcCollectionURI;
    }

    public int getDefCollPermissions() {
        return this.defCollPermissions;
    }

    public int getDefResPermissions() {
        return this.defResPermissions;
    }

    public String getDefCollGroup(Account user) {
        return this.defCollGroup != null ? this.defCollGroup : user.getPrimaryGroup();
    }

    public String getDefResGroup(Account user) {
        return this.defResGroup != null ? this.defResGroup : user.getPrimaryGroup();
    }

    public XMLReaderObjectFactory.VALIDATION_SETTING getValidationMode() {
        return this.validationMode;
    }

    public IndexSpec getIndexConfiguration() {
        return this.indexSpec;
    }

    private void configureTrigger(Element triggerElement, XmldbURI collectionConfigurationURI, boolean testOnly) throws CollectionConfigurationException {
        String classname = triggerElement.getAttributes().getNamedItem(CLASS_ATTRIBUTE).getNodeValue();
        try {
            Class<?> clazz = Class.forName(classname);
            if (!Trigger.class.isAssignableFrom(clazz)) {
                this.throwOrLog("Trigger's class '" + classname + "' is not assignable from '" + Trigger.class + "'", testOnly);
                return;
            }
            NodeList nlParameter = triggerElement.getElementsByTagNameNS(NAMESPACE, PARAMETER_ELEMENT);
            Map<String, List<? extends Object>> parameters = ParametersExtractor.extract(nlParameter);
            boolean added = false;
            if (DocumentTrigger.class.isAssignableFrom(clazz)) {
                this.docTriggers.add(new DocumentTriggerProxy((Class<? extends DocumentTrigger>)clazz, parameters));
                added = true;
            }
            if (CollectionTrigger.class.isAssignableFrom(clazz)) {
                this.colTriggers.add(new CollectionTriggerProxy((Class<? extends CollectionTrigger>)clazz, parameters));
                added = true;
            }
            if (!added) {
                throw new TriggerException("Unknown Trigger class type: " + clazz.getName());
            }
        }
        catch (ClassNotFoundException | TriggerException e) {
            if (testOnly) {
                throw new CollectionConfigurationException(e.getMessage(), e);
            }
            LOG.warn("Trigger class not found: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<TriggerProxy<? extends CollectionTrigger>> collectionTriggers() {
        return this.colTriggers;
    }

    public List<TriggerProxy<? extends DocumentTrigger>> documentTriggers() {
        return this.docTriggers;
    }

    public boolean triggerRegistered(Class<?> triggerClass) {
        if (DocumentTrigger.class.isAssignableFrom(triggerClass) && this.hasTriggerProxy(this.docTriggers, triggerClass)) {
            return true;
        }
        return CollectionTrigger.class.isAssignableFrom(triggerClass) && this.hasTriggerProxy(this.colTriggers, triggerClass);
    }

    private <T> boolean hasTriggerProxy(List<TriggerProxy<? extends T>> triggerProxies, Class<? extends T> triggerProxyClazz) {
        for (TriggerProxy<T> triggerProxy : triggerProxies) {
            if (triggerProxy.getClazz() != triggerProxyClazz) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.indexSpec != null) {
            result.append(this.indexSpec.toString()).append(System.getProperty("line.separator"));
        }
        return result.toString();
    }
}

