/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import com.evolvedbinary.j8fu.function.Consumer2E;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.Indexer;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.CollectionMetadata;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.DocumentTriggers;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.indexing.IndexController;
import org.exist.indexing.StreamListener;
import org.exist.security.Account;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionFactory;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.util.MimeType;
import org.exist.util.SyntaxException;
import org.exist.util.XMLReaderObjectFactory;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.util.serializer.DOMStreamer;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@NotThreadSafe
public class MutableCollection
implements Collection {
    private static final Logger LOG = LogManager.getLogger(Collection.class);
    private static final int SHALLOW_SIZE = 550;
    private static final int DOCUMENT_SIZE = 450;
    private static final int POOL_PARSER_THRESHOLD = 500;
    private int collectionId = -1;
    private XmldbURI path;
    private final Lock lock;
    @GuardedBy(value="lock")
    private final Map<String, DocumentImpl> documents = new TreeMap<String, DocumentImpl>();
    @GuardedBy(value="lock")
    private ObjectHashSet<XmldbURI> subCollections = new ObjectHashSet(19);
    private long address = -1L;
    private long created = 0L;
    private volatile boolean collectionConfigEnabled = true;
    private boolean triggersEnabled = true;
    private XMLReader userReader;
    private boolean isTempCollection;
    private Permission permissions;
    private final CollectionMetadata collectionMetadata;
    private final ObservaleMutableCollection observable = new ObservaleMutableCollection();
    private int refCount;
    private int timestamp;

    public MutableCollection(DBBroker broker, XmldbURI path) {
        this.permissions = PermissionFactory.getDefaultCollectionPermission(broker.getBrokerPool().getSecurityManager());
        this.setPath(path);
        this.lock = new ReentrantReadWriteLock(path);
        this.collectionMetadata = new CollectionMetadata(this);
    }

    public static MutableCollection load(DBBroker broker, XmldbURI path, VariableByteInput inputStream) throws PermissionDeniedException, IOException, LockException {
        MutableCollection collection = new MutableCollection(broker, path);
        collection.deserialize(broker, inputStream);
        return collection;
    }

    @Override
    public boolean isTriggersEnabled() {
        return this.triggersEnabled;
    }

    @Override
    public final void setPath(XmldbURI path) {
        path = path.toCollectionPathURI();
        this.isTempCollection = path.getRawCollectionPath().equals("/db/system/temp");
        this.path = path;
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCollection(DBBroker broker, Collection child, boolean isNew) throws PermissionDeniedException, LockException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Permission to write to Collection denied for " + this.getURI());
        }
        XmldbURI childName = child.getURI().lastSegment();
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            if (!this.subCollections.contains(childName)) {
                this.subCollections.add(childName);
            }
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
        if (isNew) {
            child.setCreationTime(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Collection.CollectionEntry> getEntries(DBBroker broker) throws PermissionDeniedException, LockException {
        Iterator<XmldbURI> subCollectionIterator;
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        ArrayList<Collection.CollectionEntry> list = new ArrayList<Collection.CollectionEntry>();
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            subCollectionIterator = this.subCollections.stableIterator();
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
        while (subCollectionIterator.hasNext()) {
            XmldbURI subCollectionURI = subCollectionIterator.next();
            Collection.SubCollectionEntry entry = new Collection.SubCollectionEntry(broker.getBrokerPool().getSecurityManager(), subCollectionURI);
            ((Collection.CollectionEntry)entry).readMetadata(broker);
            list.add(entry);
        }
        for (DocumentImpl document : this.copyOfDocs()) {
            Collection.DocumentEntry entry = new Collection.DocumentEntry(document);
            ((Collection.CollectionEntry)entry).readMetadata(broker);
            list.add(entry);
        }
        return list;
    }

    @Override
    public Collection.CollectionEntry getChildCollectionEntry(DBBroker broker, String name) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        XmldbURI subCollectionURI = this.getURI().append(name);
        Collection.SubCollectionEntry entry = new Collection.SubCollectionEntry(broker.getBrokerPool().getSecurityManager(), subCollectionURI);
        ((Collection.CollectionEntry)entry).readMetadata(broker);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection.CollectionEntry getResourceEntry(DBBroker broker, String name) throws PermissionDeniedException, LockException {
        Collection.DocumentEntry entry;
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            entry = new Collection.DocumentEntry(this.documents.get(name));
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
        ((Collection.CollectionEntry)entry).readMetadata(broker);
        return entry;
    }

    @Override
    public boolean isTempCollection() {
        return this.isTempCollection;
    }

    @Override
    public void release(Lock.LockMode mode) {
        this.getLock().release(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(DBBroker broker, Collection child) throws PermissionDeniedException, LockException {
        XmldbURI childName = child.getURI().lastSegment();
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            this.subCollections.remove(childName);
            this.subCollections.add(childName);
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void addDocument(Txn transaction, DBBroker broker, DocumentImpl doc) throws PermissionDeniedException, LockException {
        this.addDocument(transaction, broker, doc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocument(Txn transaction, DBBroker broker, DocumentImpl doc, DocumentImpl oldDoc) throws PermissionDeniedException, LockException {
        if (oldDoc == null) {
            if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
                throw new PermissionDeniedException("Permission to write to Collection denied for " + this.getURI());
            }
        } else if (!oldDoc.getPermissions().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Permission to write to overwrite document: " + oldDoc.getURI());
        }
        if (doc.getDocId() == -1) {
            try {
                doc.setDocId(broker.getNextResourceId(transaction, this));
            }
            catch (EXistException e) {
                LOG.error("Collection error " + e.getMessage(), (Throwable)e);
                return;
            }
        }
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            this.documents.put(doc.getFileURI().getRawCollectionPath(), doc);
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void unlinkDocument(DBBroker broker, DocumentImpl doc) throws PermissionDeniedException, LockException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Permission denied to remove document from collection: " + this.path);
        }
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            this.documents.remove(doc.getFileURI().getRawCollectionPath());
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public Iterator<XmldbURI> collectionIterator(DBBroker broker) throws PermissionDeniedException, LockException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission to list sub-collections denied on " + this.getURI());
        }
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            Iterator<XmldbURI> iterator = this.subCollections.stableIterator();
            return iterator;
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    @Override
    public Iterator<XmldbURI> collectionIteratorNoLock(DBBroker broker) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission to list sub-collections denied on " + this.getURI());
        }
        return this.subCollections.stableIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Collection> getDescendants(DBBroker broker, Subject user) throws PermissionDeniedException {
        Iterator<XmldbURI> i;
        ArrayList<Collection> collectionList;
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission to list sub-collections denied on " + this.getURI());
        }
        try {
            this.getLock().acquire(Lock.LockMode.READ_LOCK);
            try {
                collectionList = new ArrayList<Collection>(this.subCollections.size());
                i = this.subCollections.stableIterator();
            }
            finally {
                this.getLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        catch (LockException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        while (i.hasNext()) {
            XmldbURI childName = i.next();
            Collection child = broker.getCollection(this.path.append(childName));
            if (!this.getPermissionsNoLock().validate(user, 4)) continue;
            collectionList.add(child);
            if (child.getChildCollectionCount(broker) <= 0) continue;
            collectionList.addAll(child.getDescendants(broker, user));
        }
        return collectionList;
    }

    @Override
    public MutableDocumentSet allDocs(DBBroker broker, MutableDocumentSet docs, boolean recursive) throws PermissionDeniedException {
        return this.allDocs(broker, docs, recursive, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableDocumentSet allDocs(DBBroker broker, MutableDocumentSet docs, boolean recursive, LockedDocumentMap lockMap) throws PermissionDeniedException {
        List<XmldbURI> subColls = null;
        if (this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            try {
                this.getLock().acquire(Lock.LockMode.READ_LOCK);
                try {
                    this.getDocuments(broker, docs);
                    subColls = this.subCollections.keys();
                }
                finally {
                    this.getLock().release(Lock.LockMode.READ_LOCK);
                }
            }
            catch (LockException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (recursive && subColls != null) {
            for (XmldbURI childName : subColls) {
                try {
                    Collection child = broker.openCollection(this.path.appendInternal(childName), Lock.LockMode.NO_LOCK);
                    if (child == null) continue;
                    child.allDocs(broker, docs, recursive, lockMap);
                }
                catch (PermissionDeniedException permissionDeniedException) {}
            }
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentSet allDocs(DBBroker broker, MutableDocumentSet docs, boolean recursive, LockedDocumentMap lockMap, Lock.LockMode lockType) throws LockException, PermissionDeniedException {
        XmldbURI[] uris = null;
        if (this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            this.getLock().acquire(Lock.LockMode.READ_LOCK);
            try {
                this.getDocuments(broker, docs, lockMap, lockType);
                List<XmldbURI> subColls = this.subCollections.keys();
                if (subColls != null) {
                    uris = new XmldbURI[subColls.size()];
                    for (int i = 0; i < subColls.size(); ++i) {
                        uris[i] = this.path.appendInternal(subColls.get(i));
                    }
                }
            }
            finally {
                this.getLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        if (recursive && uris != null) {
            for (void var10_11 : uris) {
                try {
                    Collection child = broker.openCollection((XmldbURI)var10_11, Lock.LockMode.NO_LOCK);
                    if (child == null) continue;
                    child.allDocs(broker, docs, recursive, lockMap, lockType);
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    // empty catch block
                }
            }
        }
        return docs;
    }

    @Override
    public DocumentSet getDocuments(DBBroker broker, MutableDocumentSet docs) throws PermissionDeniedException, LockException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        try {
            this.getLock().acquire(Lock.LockMode.READ_LOCK);
            docs.addCollection(this);
            this.addDocumentsToSet(broker, docs);
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
        return docs;
    }

    @Override
    public DocumentSet getDocumentsNoLock(DBBroker broker, MutableDocumentSet docs) {
        docs.addCollection(this);
        this.addDocumentsToSet(broker, docs);
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentSet getDocuments(DBBroker broker, MutableDocumentSet docs, LockedDocumentMap lockMap, Lock.LockMode lockType) throws LockException, PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        try {
            this.getLock().acquire(Lock.LockMode.READ_LOCK);
            docs.addCollection(this);
            this.addDocumentsToSet(broker, docs, lockMap, lockType);
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
        return docs;
    }

    private List<DocumentImpl> copyOfDocs() throws LockException {
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            ArrayList<DocumentImpl> arrayList = new ArrayList<DocumentImpl>(this.documents.values());
            return arrayList;
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    private Set<String> copyOfDocNames() throws LockException {
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            TreeSet<String> treeSet = new TreeSet<String>(this.documents.keySet());
            return treeSet;
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    private void addDocumentsToSet(DBBroker broker, MutableDocumentSet docs, LockedDocumentMap lockMap, Lock.LockMode lockType) throws LockException {
        for (DocumentImpl doc : this.copyOfDocs()) {
            if (!doc.getPermissions().validate(broker.getCurrentSubject(), 2)) continue;
            doc.getUpdateLock().acquire(lockType);
            docs.add(doc);
            lockMap.add(doc);
        }
    }

    private void addDocumentsToSet(DBBroker broker, MutableDocumentSet docs) {
        try {
            for (DocumentImpl doc : this.copyOfDocs()) {
                if (!doc.getPermissions().validate(broker.getCurrentSubject(), 4)) continue;
                docs.add(doc);
            }
        }
        catch (LockException e) {
            LOG.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean allowUnload() {
        if (this.getURI().startsWith(CollectionConfigurationManager.ROOT_COLLECTION_CONFIG_URI)) {
            return false;
        }
        try {
            this.getLock().acquire(Lock.LockMode.READ_LOCK);
            try {
                for (DocumentImpl doc : this.documents.values()) {
                    if (!doc.isLockedForWrite()) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.getLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        catch (LockException e) {
            LOG.error((Object)e);
            return false;
        }
    }

    @Override
    public int compareTo(Collection other) {
        Objects.requireNonNull(other);
        if (this.collectionId == other.getId()) {
            return 0;
        }
        if (this.collectionId < other.getId()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Collection)) {
            return false;
        }
        return ((Collection)obj).getId() == this.collectionId;
    }

    @Override
    public int getMemorySize() {
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            int n = 550 + this.documents.size() * 450;
            this.getLock().release(Lock.LockMode.READ_LOCK);
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.getLock().release(Lock.LockMode.READ_LOCK);
                throw throwable;
            }
            catch (LockException e) {
                LOG.error((Object)e);
                return -1;
            }
        }
    }

    @Override
    public int getChildCollectionCount(DBBroker broker) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            int n = this.subCollections.size();
            this.getLock().release(Lock.LockMode.READ_LOCK);
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.getLock().release(Lock.LockMode.READ_LOCK);
                throw throwable;
            }
            catch (LockException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        }
    }

    @Override
    public boolean isEmpty(DBBroker broker) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            boolean bl = this.documents.isEmpty() && this.subCollections.isEmpty();
            this.getLock().release(Lock.LockMode.READ_LOCK);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.getLock().release(Lock.LockMode.READ_LOCK);
                throw throwable;
            }
            catch (LockException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentImpl getDocument(DBBroker broker, XmldbURI name) throws PermissionDeniedException {
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            DocumentImpl doc = this.documents.get(name.getRawCollectionPath());
            if (doc != null) {
                if (!doc.getPermissions().validate(broker.getCurrentSubject(), 4)) {
                    throw new PermissionDeniedException("Permission denied to read document: " + name.toString());
                }
            } else {
                LOG.debug("Document " + name + " not found!");
            }
            DocumentImpl documentImpl = doc;
            this.getLock().release(Lock.LockMode.READ_LOCK);
            return documentImpl;
        }
        catch (Throwable throwable) {
            try {
                this.getLock().release(Lock.LockMode.READ_LOCK);
                throw throwable;
            }
            catch (LockException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    @Override
    public DocumentImpl getDocumentWithLock(DBBroker broker, XmldbURI name) throws LockException, PermissionDeniedException {
        return this.getDocumentWithLock(broker, name, Lock.LockMode.READ_LOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentImpl getDocumentWithLock(DBBroker broker, XmldbURI name, Lock.LockMode lockMode) throws LockException, PermissionDeniedException {
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            DocumentImpl doc = this.documents.get(name.getRawCollectionPath());
            if (doc != null) {
                if (!doc.getPermissions().validate(broker.getCurrentSubject(), 4)) {
                    throw new PermissionDeniedException("Permission denied to read document: " + name.toString());
                }
                doc.getUpdateLock().acquire(lockMode);
            }
            DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    @Override
    public DocumentImpl getDocumentNoLock(DBBroker broker, String rawPath) throws PermissionDeniedException {
        DocumentImpl doc = this.documents.get(rawPath);
        if (doc != null && !doc.getPermissions().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read document: " + rawPath);
        }
        return doc;
    }

    @Override
    public void releaseDocument(DocumentImpl doc) {
        if (doc != null) {
            doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    @Override
    public void releaseDocument(DocumentImpl doc, Lock.LockMode mode) {
        if (doc != null) {
            doc.getUpdateLock().release(mode);
        }
    }

    @Override
    public int getDocumentCount(DBBroker broker) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            int n = this.documents.size();
            this.getLock().release(Lock.LockMode.READ_LOCK);
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.getLock().release(Lock.LockMode.READ_LOCK);
                throw throwable;
            }
            catch (LockException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                return -1;
            }
        }
    }

    @Override
    public int getDocumentCountNoLock(DBBroker broker) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        return this.documents.size();
    }

    @Override
    public int getId() {
        return this.collectionId;
    }

    @Override
    public XmldbURI getURI() {
        return this.path;
    }

    @Override
    public XmldbURI getParentURI() {
        if (this.path.equals(XmldbURI.ROOT_COLLECTION_URI)) {
            return null;
        }
        return this.path.removeLastSegment();
    }

    @Override
    public final Permission getPermissions() {
        try {
            this.getLock().acquire(Lock.LockMode.READ_LOCK);
            Permission permission = this.permissions;
            return permission;
        }
        catch (LockException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            Permission permission = this.permissions;
            return permission;
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    @Override
    public Permission getPermissionsNoLock() {
        return this.permissions;
    }

    @Override
    public CollectionMetadata getMetadata() {
        return this.collectionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDocument(DBBroker broker, XmldbURI name) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            boolean bl = this.documents.containsKey(name.getRawCollectionPath());
            this.getLock().release(Lock.LockMode.READ_LOCK);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.getLock().release(Lock.LockMode.READ_LOCK);
                throw throwable;
            }
            catch (LockException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                return this.documents.containsKey(name.getRawCollectionPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildCollection(DBBroker broker, XmldbURI name) throws PermissionDeniedException, LockException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            boolean bl = this.subCollections.contains(name);
            return bl;
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    @Override
    public boolean hasChildCollectionNoLock(DBBroker broker, XmldbURI name) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        return this.subCollections.contains(name);
    }

    @Override
    public Iterator<DocumentImpl> iterator(DBBroker broker) throws PermissionDeniedException, LockException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        return this.getDocuments(broker, new DefaultDocumentSet()).getDocumentIterator();
    }

    @Override
    public Iterator<DocumentImpl> iteratorNoLock(DBBroker broker) throws PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 4)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        return this.getDocumentsNoLock(broker, new DefaultDocumentSet()).getDocumentIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(VariableByteOutputStream outputStream) throws IOException, LockException {
        Iterator<XmldbURI> i;
        int size;
        outputStream.writeInt(this.collectionId);
        this.getLock().acquire(Lock.LockMode.READ_LOCK);
        try {
            size = this.subCollections.size();
            i = this.subCollections.stableIterator();
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
        outputStream.writeInt(size);
        while (i.hasNext()) {
            XmldbURI childCollectionURI = i.next();
            outputStream.writeUTF(childCollectionURI.toString());
        }
        this.permissions.write(outputStream);
        outputStream.writeLong(this.created);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserialize(DBBroker broker, VariableByteInput istream) throws IOException, PermissionDeniedException, LockException {
        this.collectionId = istream.readInt();
        if (this.collectionId < 0) {
            throw new IOException("Internal error reading collection: invalid collection id");
        }
        int collLen = istream.readInt();
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            this.subCollections = new ObjectHashSet(collLen == 0 ? 19 : collLen);
            for (int i = 0; i < collLen; ++i) {
                this.subCollections.add(XmldbURI.create(istream.readUTF()));
            }
            this.permissions.read(istream);
            this.created = istream.readLong();
            if (!this.permissions.validate(broker.getCurrentSubject(), 1)) {
                throw new PermissionDeniedException("Permission denied to open the Collection " + this.path);
            }
            final MutableCollection col = this;
            broker.getCollectionResources(new Collection.InternalAccess(){

                @Override
                public void addDocument(DocumentImpl doc) throws EXistException {
                    doc.setCollection(col);
                    if (doc.getDocId() == -1) {
                        LOG.error("Document must have ID. [" + doc + "]");
                        throw new EXistException("Document must have ID.");
                    }
                    MutableCollection.this.documents.put(doc.getFileURI().getRawCollectionPath(), doc);
                }

                @Override
                public int getId() {
                    return col.getId();
                }
            });
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void removeCollection(DBBroker broker, XmldbURI name) throws LockException, PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Permission denied to read collection: " + this.path);
        }
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            this.subCollections.remove(name);
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void removeResource(Txn transaction, DBBroker broker, DocumentImpl doc) throws PermissionDeniedException, LockException, IOException, TriggerException {
        if (doc.getCollection() != this) {
            throw new IOException("Document '" + doc.getURI() + "' does not belong to Collection '" + this.getURI() + "'.");
        }
        if (doc.getResourceType() == 1) {
            this.removeBinaryResource(transaction, broker, doc);
        } else {
            this.removeXMLResource(transaction, broker, doc.getFileURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXMLResource(Txn transaction, DBBroker broker, XmldbURI name) throws PermissionDeniedException, TriggerException, LockException, IOException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Permission denied to write collection: " + this.path);
        }
        DocumentImpl doc = null;
        BrokerPool db = broker.getBrokerPool();
        db.getProcessMonitor().startJob("remove XML resource", name);
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            doc = this.documents.get(name.getRawCollectionPath());
            if (doc == null) {
                return;
            }
            doc.getUpdateLock().acquire(Lock.LockMode.WRITE_LOCK);
            boolean useTriggers = this.isTriggersEnabled();
            if (CollectionConfiguration.DEFAULT_COLLECTION_CONFIG_FILE_URI.equals(name)) {
                useTriggers = false;
                CollectionConfigurationManager confMgr = broker.getBrokerPool().getConfigurationManager();
                if (confMgr != null) {
                    confMgr.invalidate(this.getURI(), broker.getBrokerPool());
                }
            }
            DocumentTriggers trigger = new DocumentTriggers(broker, null, this, useTriggers ? this.getConfiguration(broker) : null);
            trigger.beforeDeleteDocument(broker, transaction, doc);
            broker.removeXMLResource(transaction, doc);
            this.documents.remove(name.getRawCollectionPath());
            trigger.afterDeleteDocument(broker, transaction, this.getURI().append(name));
            broker.getBrokerPool().getNotificationService().notifyUpdate(doc, 2);
        }
        finally {
            broker.getBrokerPool().getProcessMonitor().endJob();
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
            }
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBinaryResource(Txn transaction, DBBroker broker, XmldbURI name) throws PermissionDeniedException, LockException, TriggerException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Permission denied to write collection: " + this.path);
        }
        try {
            this.getLock().acquire(Lock.LockMode.READ_LOCK);
            DocumentImpl doc = this.getDocument(broker, name);
            if (doc.isLockedForWrite()) {
                throw new PermissionDeniedException("Document " + doc.getFileURI() + " is locked for write");
            }
            this.removeBinaryResource(transaction, broker, doc);
        }
        finally {
            this.getLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBinaryResource(Txn transaction, DBBroker broker, DocumentImpl doc) throws PermissionDeniedException, LockException, TriggerException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Permission denied to write collection: " + this.path);
        }
        if (doc == null) {
            return;
        }
        broker.getBrokerPool().getProcessMonitor().startJob("remove binary resource", doc.getFileURI());
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            if (doc.getResourceType() != 1) {
                throw new PermissionDeniedException("document " + doc.getFileURI() + " is not a binary object");
            }
            if (doc.isLockedForWrite()) {
                throw new PermissionDeniedException("Document " + doc.getFileURI() + " is locked for write");
            }
            doc.getUpdateLock().acquire(Lock.LockMode.WRITE_LOCK);
            DocumentTriggers trigger = new DocumentTriggers(broker, null, this, this.isTriggersEnabled() ? this.getConfiguration(broker) : null);
            trigger.beforeDeleteDocument(broker, transaction, doc);
            IndexController indexController = broker.getIndexController();
            StreamListener listener = indexController.getStreamListener(doc, StreamListener.ReindexMode.REMOVE_BINARY);
            try {
                indexController.startIndexDocument(transaction, listener);
                try {
                    broker.removeBinaryResource(transaction, (BinaryDocument)doc);
                }
                catch (IOException ex) {
                    throw new PermissionDeniedException("Cannot delete file: " + doc.getURI().toString() + ": " + ex.getMessage(), ex);
                }
                this.documents.remove(doc.getFileURI().getRawCollectionPath());
            }
            finally {
                indexController.endIndexDocument(transaction, listener);
            }
            trigger.afterDeleteDocument(broker, transaction, doc.getURI());
        }
        finally {
            broker.getBrokerPool().getProcessMonitor().endJob();
            doc.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void store(Txn transaction, DBBroker broker, IndexInfo info, InputSource source) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        this.storeXMLInternal(transaction, broker, info, (Consumer2E<IndexInfo, EXistException, SAXException>)((Consumer2E)storeInfo -> {
            try {
                InputStream is = source.getByteStream();
                if (is != null && is.markSupported()) {
                    is.reset();
                } else {
                    Reader cs = source.getCharacterStream();
                    if (cs != null && cs.markSupported()) {
                        cs.reset();
                    }
                }
            }
            catch (IOException e) {
                LOG.debug("InputStream or CharacterStream underlying the InputSource does not support marking and therefore cannot be re-read.");
            }
            XMLReader reader = this.getReader(broker, false, storeInfo.getCollectionConfig());
            storeInfo.setReader(reader, null);
            try {
                reader.parse(source);
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            finally {
                this.releaseReader(broker, (IndexInfo)storeInfo, reader);
            }
        }));
    }

    @Override
    public void store(Txn transaction, DBBroker broker, IndexInfo info, String data) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        this.storeXMLInternal(transaction, broker, info, (Consumer2E<IndexInfo, EXistException, SAXException>)((Consumer2E)storeInfo -> {
            CollectionConfiguration colconf = storeInfo.getDocument().getCollection().getConfiguration(broker);
            XMLReader reader = this.getReader(broker, false, colconf);
            storeInfo.setReader(reader, null);
            try {
                reader.parse(new InputSource(new StringReader(data)));
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            finally {
                this.releaseReader(broker, (IndexInfo)storeInfo, reader);
            }
        }));
    }

    @Override
    public void store(Txn transaction, DBBroker broker, IndexInfo info, Node node) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Permission denied to write collection: " + this.path);
        }
        this.storeXMLInternal(transaction, broker, info, (Consumer2E<IndexInfo, EXistException, SAXException>)((Consumer2E)storeInfo -> storeInfo.getDOMStreamer().serialize(node, true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeXMLInternal(Txn transaction, DBBroker broker, IndexInfo info, Consumer2E<IndexInfo, EXistException, SAXException> parserFn) throws EXistException, SAXException, PermissionDeniedException {
        DocumentImpl document = info.getIndexer().getDocument();
        BrokerPool db = broker.getBrokerPool();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("storing document " + document.getDocId() + " ...");
            }
            if (!document.getUpdateLock().isLockedForWrite()) {
                LOG.warn("document is not locked for write !");
            }
            db.getProcessMonitor().startJob("storing document", document.getFileURI());
            parserFn.accept((Object)info);
            broker.storeXMLResource(transaction, document);
            broker.flush();
            broker.closeDocument();
            LOG.debug("document stored.");
        }
        finally {
            document.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
            broker.getBrokerPool().getProcessMonitor().endJob();
        }
        this.setCollectionConfigEnabled(true);
        broker.deleteObservers();
        if (info.isCreating()) {
            info.getTriggers().afterCreateDocument(broker, transaction, document);
        } else {
            StreamListener listener = broker.getIndexController().getStreamListener();
            listener.endReplaceDocument(transaction);
            info.getTriggers().afterUpdateDocument(broker, transaction, document);
        }
        db.getNotificationService().notifyUpdate(document, info.isCreating() ? 0 : 1);
        XmldbURI docName = document.getFileURI();
        if (this.getURI().startsWith(XmldbURI.CONFIG_COLLECTION_URI) && docName.endsWith(CollectionConfiguration.COLLECTION_CONFIG_SUFFIX_URI)) {
            broker.sync(Sync.MAJOR);
            CollectionConfigurationManager manager = broker.getBrokerPool().getConfigurationManager();
            if (manager != null) {
                try {
                    manager.invalidate(this.getURI(), broker.getBrokerPool());
                    manager.loadConfiguration(broker, this);
                }
                catch (PermissionDeniedException | LockException pde) {
                    throw new EXistException(pde.getMessage(), pde);
                }
                catch (CollectionConfigurationException e) {
                    throw new EXistException("Error while reading new collection configuration: " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public IndexInfo validateXMLResource(Txn transaction, DBBroker broker, XmldbURI name, String data) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        return this.validateXMLResource(transaction, broker, name, new InputSource(new StringReader(data)));
    }

    @Override
    public IndexInfo validateXMLResource(Txn transaction, DBBroker broker, XmldbURI name, InputSource source) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        CollectionConfiguration colconf = this.getConfiguration(broker);
        return this.validateXMLResourceInternal(transaction, broker, name, colconf, (Consumer2E<IndexInfo, SAXException, EXistException>)((Consumer2E)info -> {
            XMLReader reader = this.getReader(broker, true, colconf);
            info.setReader(reader, null);
            try {
                InputSource closeShieldedInputSource = this.closeShieldInputSource(source);
                reader.parse(closeShieldedInputSource);
            }
            catch (SAXException e) {
                throw new SAXException("The XML parser reported a problem: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            finally {
                this.releaseReader(broker, (IndexInfo)info, reader);
            }
        }));
    }

    private InputSource closeShieldInputSource(InputSource source) {
        InputSource protectedInputSource = new InputSource();
        protectedInputSource.setEncoding(source.getEncoding());
        protectedInputSource.setSystemId(source.getSystemId());
        protectedInputSource.setPublicId(source.getPublicId());
        if (source.getByteStream() != null) {
            CloseShieldInputStream closeShieldByteStream = new CloseShieldInputStream(source.getByteStream());
            protectedInputSource.setByteStream((InputStream)closeShieldByteStream);
        }
        if (source.getCharacterStream() != null) {
            CloseShieldReader closeShieldReader = new CloseShieldReader(source.getCharacterStream());
            protectedInputSource.setCharacterStream(closeShieldReader);
        }
        return protectedInputSource;
    }

    @Override
    public IndexInfo validateXMLResource(Txn transaction, DBBroker broker, XmldbURI name, Node node) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        return this.validateXMLResourceInternal(transaction, broker, name, this.getConfiguration(broker), (Consumer2E<IndexInfo, SAXException, EXistException>)((Consumer2E)info -> {
            info.setDOMStreamer(new DOMStreamer());
            info.getDOMStreamer().serialize(node, true);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexInfo validateXMLResourceInternal(Txn transaction, DBBroker broker, XmldbURI name, CollectionConfiguration config, Consumer2E<IndexInfo, SAXException, EXistException> validator) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException {
        this.checkConfigurationDocument(transaction, broker, name);
        BrokerPool db = broker.getBrokerPool();
        if (db.isReadOnly()) {
            throw new IOException("Database is read-only");
        }
        DocumentImpl oldDoc = null;
        boolean oldDocLocked = false;
        db.getProcessMonitor().startJob("validating document", name);
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            DocumentImpl document = new DocumentImpl(db, this, name);
            oldDoc = this.documents.get(name.getRawCollectionPath());
            this.checkPermissionsForAddDocument(broker, oldDoc);
            this.checkCollectionConflict(name);
            this.manageDocumentInformation(oldDoc, document);
            Indexer indexer = new Indexer(broker, transaction);
            IndexInfo info = new IndexInfo(indexer, config);
            info.setCreating(oldDoc == null);
            info.setOldDocPermissions(oldDoc != null ? oldDoc.getPermissions() : null);
            indexer.setDocument(document, config);
            this.addObserversToIndexer(broker, indexer);
            indexer.setValidating(true);
            if (CollectionConfiguration.DEFAULT_COLLECTION_CONFIG_FILE_URI.equals(name)) {
                this.setCollectionConfigEnabled(false);
            }
            DocumentTriggers trigger = new DocumentTriggers(broker, indexer, this, this.isTriggersEnabled() ? config : null);
            trigger.setValidating(true);
            info.setTriggers(trigger);
            if (oldDoc == null) {
                trigger.beforeCreateDocument(broker, transaction, this.getURI().append(name));
            } else {
                trigger.beforeUpdateDocument(broker, transaction, oldDoc);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanning document " + this.getURI().append(name));
            }
            validator.accept((Object)info);
            if (oldDoc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removing old document " + oldDoc.getFileURI());
                }
                this.updateModificationTime(document);
                oldDoc.getUpdateLock().acquire(Lock.LockMode.WRITE_LOCK);
                oldDocLocked = true;
                StreamListener listener = broker.getIndexController().getStreamListener(document, StreamListener.ReindexMode.REPLACE_DOCUMENT);
                listener.startReplaceDocument(transaction);
                if (oldDoc.getResourceType() == 1) {
                    broker.removeBinaryResource(transaction, (BinaryDocument)oldDoc);
                    this.documents.remove(oldDoc.getFileURI().getRawCollectionPath());
                    document.getUpdateLock().acquire(Lock.LockMode.WRITE_LOCK);
                    document.setDocId(broker.getNextResourceId(transaction, this));
                    this.addDocument(transaction, broker, document);
                } else {
                    broker.removeXMLResource(transaction, oldDoc, false);
                    oldDoc.copyOf(document, true);
                    indexer.setDocumentObject(oldDoc);
                    document = oldDoc;
                    oldDocLocked = false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removed old document " + oldDoc.getFileURI());
                }
            } else {
                document.getUpdateLock().acquire(Lock.LockMode.WRITE_LOCK);
                document.setDocId(broker.getNextResourceId(transaction, this));
                this.addDocument(transaction, broker, document);
            }
            trigger.setValidating(false);
            IndexInfo indexInfo = info;
            return indexInfo;
        }
        finally {
            if (oldDoc != null && oldDocLocked) {
                oldDoc.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
            }
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
            db.getProcessMonitor().endJob();
        }
    }

    private void checkConfigurationDocument(Txn transaction, DBBroker broker, XmldbURI docUri) throws EXistException, PermissionDeniedException, LockException {
        if (!this.getURI().startsWith(XmldbURI.CONFIG_COLLECTION_URI)) {
            return;
        }
        if (!docUri.endsWith(CollectionConfiguration.COLLECTION_CONFIG_SUFFIX_URI)) {
            return;
        }
        Iterator<DocumentImpl> i = this.iterator(broker);
        while (i.hasNext()) {
            DocumentImpl confDoc = i.next();
            XmldbURI currentConfDocName = confDoc.getFileURI();
            if (currentConfDocName == null || currentConfDocName.equals(docUri)) continue;
            throw new EXistException("Could not store configuration '" + docUri + "': A configuration document with a different name (" + currentConfDocName + ") already exists in this collection (" + this.getURI() + ")");
        }
    }

    private void addObserversToIndexer(DBBroker broker, Indexer indexer) {
        broker.deleteObservers();
        this.observable.forEachObserver(observer -> {
            indexer.addObserver((Observer)observer);
            broker.addObserver((Observer)observer);
        });
    }

    private void manageDocumentInformation(DocumentImpl oldDoc, DocumentImpl document) {
        DocumentMetadata metadata;
        if (oldDoc != null) {
            metadata = oldDoc.getMetadata();
            metadata.setCreated(oldDoc.getMetadata().getCreated());
            document.setPermissions(oldDoc.getPermissions());
        } else {
            metadata = new DocumentMetadata();
            metadata.setCreated(System.currentTimeMillis());
        }
        document.setMetadata(metadata);
    }

    private void updateModificationTime(DocumentImpl document) {
        DocumentMetadata metadata = document.getMetadata();
        metadata.setLastModified(System.currentTimeMillis());
        document.setMetadata(metadata);
    }

    private void checkPermissionsForAddDocument(DBBroker broker, DocumentImpl oldDoc) throws LockException, PermissionDeniedException {
        if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 1)) {
            throw new PermissionDeniedException("Execute permission is not granted on the Collection.");
        }
        if (oldDoc != null) {
            LOG.debug("Found old doc " + oldDoc.getDocId());
            Account lockUser = oldDoc.getUserLock();
            if (lockUser != null && !lockUser.equals(broker.getCurrentSubject())) {
                throw new PermissionDeniedException("The document is locked by user '" + lockUser.getName() + "'.");
            }
            if (oldDoc.getPermissions().getOwner().getId() != broker.getCurrentSubject().getId() && !oldDoc.getPermissions().validate(broker.getCurrentSubject(), 2)) {
                throw new PermissionDeniedException("A resource with the same name already exists in the target collection '" + this.path + "', and you do not have write access on that resource.");
            }
        } else if (!this.getPermissionsNoLock().validate(broker.getCurrentSubject(), 2)) {
            throw new PermissionDeniedException("Write permission is not granted on the Collection.");
        }
    }

    private void checkCollectionConflict(XmldbURI docUri) throws EXistException, PermissionDeniedException {
        if (this.subCollections.contains(docUri.lastSegment())) {
            throw new EXistException("The collection '" + this.getURI() + "' already has a sub-collection named '" + docUri.lastSegment() + "', you cannot create a Document with the same name as an existing collection.");
        }
    }

    @Override
    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI name, byte[] data, String mimeType) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException {
        return this.addBinaryResource(transaction, broker, name, data, mimeType, null, null);
    }

    @Override
    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI name, byte[] data, String mimeType, Date created, Date modified) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException {
        return this.addBinaryResource(transaction, broker, name, (InputStream)new ByteArrayInputStream(data), mimeType, (long)data.length, created, modified);
    }

    @Override
    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI name, InputStream is, String mimeType, long size) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException {
        return this.addBinaryResource(transaction, broker, name, is, mimeType, size, null, null);
    }

    @Override
    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, XmldbURI name, InputStream is, String mimeType, long size, Date created, Date modified) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException {
        BinaryDocument blob = new BinaryDocument(broker.getBrokerPool(), this, name);
        return this.addBinaryResource(transaction, broker, blob, is, mimeType, size, created, modified);
    }

    @Override
    public BinaryDocument validateBinaryResource(Txn transaction, DBBroker broker, XmldbURI name) throws PermissionDeniedException, LockException, TriggerException, IOException {
        return new BinaryDocument(broker.getBrokerPool(), this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryDocument addBinaryResource(Txn transaction, DBBroker broker, BinaryDocument blob, InputStream is, String mimeType, long size, Date created, Date modified) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException {
        BrokerPool db = broker.getBrokerPool();
        if (db.isReadOnly()) {
            throw new IOException("Database is read-only");
        }
        XmldbURI docUri = blob.getFileURI();
        DocumentImpl oldDoc = this.getDocument(broker, docUri);
        DocumentTriggers trigger = new DocumentTriggers(broker, null, this, this.isTriggersEnabled() ? this.getConfiguration(broker) : null);
        this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
        try {
            db.getProcessMonitor().startJob("storing binary resource", docUri);
            this.checkPermissionsForAddDocument(broker, oldDoc);
            this.checkCollectionConflict(docUri);
            this.manageDocumentInformation(oldDoc, blob);
            DocumentMetadata metadata = blob.getMetadata();
            metadata.setMimeType(mimeType == null ? MimeType.BINARY_TYPE.getName() : mimeType);
            if (created != null) {
                metadata.setCreated(created.getTime());
            }
            if (modified != null) {
                metadata.setLastModified(modified.getTime());
            }
            blob.setContentLength(size);
            if (oldDoc == null) {
                trigger.beforeCreateDocument(broker, transaction, blob.getURI());
            } else {
                trigger.beforeUpdateDocument(broker, transaction, oldDoc);
            }
            if (oldDoc != null) {
                LOG.debug("removing old document " + oldDoc.getFileURI());
                this.updateModificationTime(blob);
                broker.removeResource(transaction, oldDoc);
            }
            broker.storeBinaryResource(transaction, blob, is);
            this.addDocument(transaction, broker, blob, oldDoc);
            IndexController indexController = broker.getIndexController();
            StreamListener listener = indexController.getStreamListener(blob, StreamListener.ReindexMode.STORE);
            indexController.startIndexDocument(transaction, listener);
            try {
                broker.storeXMLResource(transaction, blob);
            }
            finally {
                indexController.endIndexDocument(transaction, listener);
            }
            blob.getUpdateLock().acquire(Lock.LockMode.READ_LOCK);
        }
        finally {
            broker.getBrokerPool().getProcessMonitor().endJob();
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
        try {
            if (oldDoc == null) {
                trigger.afterCreateDocument(broker, transaction, blob);
            } else {
                trigger.afterUpdateDocument(broker, transaction, blob);
            }
        }
        finally {
            blob.getUpdateLock().release(Lock.LockMode.READ_LOCK);
        }
        return blob;
    }

    @Override
    public void setId(int id) {
        this.collectionId = id;
    }

    @Override
    public void setPermissions(int mode) throws LockException, PermissionDeniedException {
        try {
            this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
            this.permissions.setMode(mode);
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void setPermissions(String mode) throws SyntaxException, LockException, PermissionDeniedException {
        try {
            this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
            this.permissions.setMode(mode);
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void setPermissions(Permission permissions) throws LockException {
        try {
            this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
            this.permissions = permissions;
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public CollectionConfiguration getConfiguration(DBBroker broker) {
        if (!this.isCollectionConfigEnabled()) {
            return null;
        }
        CollectionConfigurationManager manager = broker.getBrokerPool().getConfigurationManager();
        if (manager == null) {
            return null;
        }
        CollectionConfiguration configuration = null;
        try {
            configuration = manager.getConfiguration(broker, this);
            this.setCollectionConfigEnabled(true);
        }
        catch (CollectionConfigurationException e) {
            this.setCollectionConfigEnabled(false);
            LOG.warn("Failed to load collection configuration for '" + this.getURI() + "'", (Throwable)e);
        }
        return configuration;
    }

    @Override
    public void setCollectionConfigEnabled(boolean collectionConfigEnabled) {
        this.collectionConfigEnabled = collectionConfigEnabled;
    }

    @Override
    public boolean isCollectionConfigEnabled() {
        return this.collectionConfigEnabled;
    }

    @Override
    public void setAddress(long addr) {
        this.address = addr;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public void setCreationTime(long ms) {
        this.created = ms;
    }

    @Override
    public long getCreationTime() {
        return this.created;
    }

    @Override
    public void setTriggersEnabled(boolean enabled) {
        try {
            this.getLock().acquire(Lock.LockMode.WRITE_LOCK);
            this.triggersEnabled = enabled;
        }
        catch (LockException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            this.triggersEnabled = enabled;
        }
        finally {
            this.getLock().release(Lock.LockMode.WRITE_LOCK);
        }
    }

    @Override
    public void setReader(XMLReader reader) {
        this.userReader = reader;
    }

    private XMLReader getReader(DBBroker broker, boolean validation, CollectionConfiguration collectionConf) {
        if (this.userReader != null) {
            return this.userReader;
        }
        XMLReader reader = broker.getBrokerPool().getParserPool().borrowXMLReader();
        if (!validation) {
            XMLReaderObjectFactory.setReaderValidationMode(XMLReaderObjectFactory.VALIDATION_SETTING.DISABLED, reader);
        } else if (collectionConf != null) {
            XMLReaderObjectFactory.VALIDATION_SETTING mode = collectionConf.getValidationMode();
            XMLReaderObjectFactory.setReaderValidationMode(mode, reader);
        }
        return reader;
    }

    private void releaseReader(DBBroker broker, IndexInfo info, XMLReader reader) {
        if (this.userReader != null) {
            return;
        }
        if (info.getIndexer().getDocSize() > 500) {
            return;
        }
        Configuration config = broker.getConfiguration();
        String optionValue = (String)config.getProperty("validation.mode");
        XMLReaderObjectFactory.VALIDATION_SETTING validationMode = XMLReaderObjectFactory.convertValidationMode(optionValue);
        XMLReaderObjectFactory.setReaderValidationMode(validationMode, reader);
        broker.getBrokerPool().getParserPool().returnXMLReader(reader);
    }

    @Override
    public IndexSpec getIndexConfiguration(DBBroker broker) {
        CollectionConfiguration conf = this.getConfiguration(broker);
        if (conf == null) {
            return broker.getIndexConfiguration();
        }
        return conf.getIndexConfiguration();
    }

    @Override
    public GeneralRangeIndexSpec getIndexByPathConfiguration(DBBroker broker, NodePath nodePath) {
        IndexSpec idxSpec = this.getIndexConfiguration(broker);
        return idxSpec == null ? null : idxSpec.getIndexByPath(nodePath);
    }

    @Override
    public QNameRangeIndexSpec getIndexByQNameConfiguration(DBBroker broker, QName nodeName) {
        IndexSpec idxSpec = this.getIndexConfiguration(broker);
        return idxSpec == null ? null : idxSpec.getIndexByQName(nodeName);
    }

    @Override
    public Observable getObservable() {
        return this.observable;
    }

    @Override
    public long getKey() {
        return this.collectionId;
    }

    @Override
    public int getReferenceCount() {
        return this.refCount;
    }

    @Override
    public int incReferenceCount() {
        return ++this.refCount;
    }

    @Override
    public int decReferenceCount() {
        return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
    }

    @Override
    public void setReferenceCount(int count) {
        this.refCount = count;
    }

    @Override
    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean sync(boolean syncJournal) {
        return false;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getURI());
        buf.append("[");
        try {
            Iterator<String> i = this.copyOfDocNames().iterator();
            while (i.hasNext()) {
                buf.append(i.next());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
        }
        catch (LockException e) {
            LOG.error((Object)e);
            throw new IllegalStateException(e);
        }
        buf.append("]");
        return buf.toString();
    }

    private static class ObservaleMutableCollection
    extends Observable {
        private Observer[] observers = null;

        private ObservaleMutableCollection() {
        }

        @Override
        public synchronized void addObserver(Observer o) {
            if (this.hasObserver(o)) {
                return;
            }
            if (this.observers == null) {
                this.observers = new Observer[1];
                this.observers[0] = o;
            } else {
                Observer[] n = new Observer[this.observers.length + 1];
                System.arraycopy(this.observers, 0, n, 0, this.observers.length);
                n[this.observers.length] = o;
                this.observers = n;
            }
        }

        private boolean hasObserver(Observer o) {
            if (this.observers == null) {
                return false;
            }
            for (Observer observer : this.observers) {
                if (observer != o) continue;
                return true;
            }
            return false;
        }

        void forEachObserver(Consumer<Observer> consumer) {
            if (this.observers != null) {
                for (Observer observer : this.observers) {
                    consumer.accept(observer);
                }
            }
        }

        @Override
        public synchronized void deleteObservers() {
            if (this.observers != null) {
                this.observers = null;
            }
        }
    }

    private static class CloseShieldReader
    extends Reader {
        private final Reader reader;

        public CloseShieldReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.reader.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

