/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.triggers.CollectionTrigger;
import org.exist.collections.triggers.Trigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.collections.triggers.TriggerProxy;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;

public class CollectionTriggers
implements CollectionTrigger {
    private final List<CollectionTrigger> triggers;

    public CollectionTriggers(DBBroker broker) throws TriggerException {
        this(broker, null, null);
    }

    public CollectionTriggers(DBBroker broker, Collection collection) throws TriggerException {
        this(broker, collection, collection.getConfiguration(broker));
    }

    public CollectionTriggers(DBBroker broker, Collection collection, CollectionConfiguration config) throws TriggerException {
        CollectionTrigger instance;
        List<TriggerProxy<? extends CollectionTrigger>> colTriggers = null;
        if (config != null) {
            colTriggers = config.collectionTriggers();
        }
        java.util.Collection<TriggerProxy<? extends CollectionTrigger>> masterTriggers = broker.getDatabase().getCollectionTriggers();
        this.triggers = new ArrayList<CollectionTrigger>(masterTriggers.size() + (colTriggers == null ? 0 : colTriggers.size()));
        for (TriggerProxy<? extends CollectionTrigger> colTrigger : masterTriggers) {
            instance = colTrigger.newInstance(broker, collection);
            this.register(instance);
        }
        if (colTriggers != null) {
            for (TriggerProxy<? extends CollectionTrigger> colTrigger : colTriggers) {
                instance = colTrigger.newInstance(broker, collection);
                this.register(instance);
            }
        }
    }

    private void register(CollectionTrigger trigger) {
        this.triggers.add(trigger);
    }

    @Override
    public void configure(DBBroker broker, Collection col, Map<String, List<? extends Object>> parameters) throws TriggerException {
    }

    @Override
    public void beforeCreateCollection(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
        for (CollectionTrigger trigger : this.triggers) {
            trigger.beforeCreateCollection(broker, txn, uri);
        }
    }

    @Override
    public void afterCreateCollection(DBBroker broker, Txn txn, Collection collection) {
        for (CollectionTrigger trigger : this.triggers) {
            try {
                trigger.afterCreateCollection(broker, txn, collection);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeCopyCollection(DBBroker broker, Txn txn, Collection collection, XmldbURI newUri) throws TriggerException {
        for (CollectionTrigger trigger : this.triggers) {
            trigger.beforeCopyCollection(broker, txn, collection, newUri);
        }
    }

    @Override
    public void afterCopyCollection(DBBroker broker, Txn txn, Collection collection, XmldbURI oldUri) {
        for (CollectionTrigger trigger : this.triggers) {
            try {
                trigger.afterCopyCollection(broker, txn, collection, oldUri);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeMoveCollection(DBBroker broker, Txn txn, Collection collection, XmldbURI newUri) throws TriggerException {
        for (CollectionTrigger trigger : this.triggers) {
            trigger.beforeMoveCollection(broker, txn, collection, newUri);
        }
    }

    @Override
    public void afterMoveCollection(DBBroker broker, Txn txn, Collection collection, XmldbURI oldUri) {
        for (CollectionTrigger trigger : this.triggers) {
            try {
                trigger.afterMoveCollection(broker, txn, collection, oldUri);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeDeleteCollection(DBBroker broker, Txn txn, Collection collection) throws TriggerException {
        for (CollectionTrigger trigger : this.triggers) {
            trigger.beforeDeleteCollection(broker, txn, collection);
        }
    }

    @Override
    public void afterDeleteCollection(DBBroker broker, Txn txn, XmldbURI uri) {
        for (CollectionTrigger trigger : this.triggers) {
            try {
                trigger.afterDeleteCollection(broker, txn, uri);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

