/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.ArrayDeque;
import java.util.Deque;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.util.sax.event.SAXEvent;
import org.exist.util.sax.event.contenthandler.Characters;
import org.exist.util.sax.event.contenthandler.EndDocument;
import org.exist.util.sax.event.contenthandler.EndElement;
import org.exist.util.sax.event.contenthandler.EndPrefixMapping;
import org.exist.util.sax.event.contenthandler.IgnorableWhitespace;
import org.exist.util.sax.event.contenthandler.ProcessingInstruction;
import org.exist.util.sax.event.contenthandler.SetDocumentLocator;
import org.exist.util.sax.event.contenthandler.SkippedEntity;
import org.exist.util.sax.event.contenthandler.StartDocument;
import org.exist.util.sax.event.contenthandler.StartElement;
import org.exist.util.sax.event.contenthandler.StartPrefixMapping;
import org.exist.util.sax.event.lexicalhandler.Comment;
import org.exist.util.sax.event.lexicalhandler.EndCDATA;
import org.exist.util.sax.event.lexicalhandler.EndDTD;
import org.exist.util.sax.event.lexicalhandler.EndEntity;
import org.exist.util.sax.event.lexicalhandler.StartCDATA;
import org.exist.util.sax.event.lexicalhandler.StartDTD;
import org.exist.util.sax.event.lexicalhandler.StartEntity;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class DeferrableFilteringTrigger
extends FilteringTrigger {
    private boolean defer = false;
    protected Deque<SAXEvent> deferred = new ArrayDeque<SAXEvent>();

    public boolean isDeferring() {
        return this.defer;
    }

    public void defer(boolean defer) throws SAXException {
        if (this.defer && !defer) {
            this.applyDeferredEvents();
        }
        this.defer = defer;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.defer) {
            this.deferred.add(new SetDocumentLocator(locator));
        } else {
            super.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.defer) {
            this.deferred.add(StartDocument.INSTANCE);
        } else {
            super.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.defer) {
            this.deferred.add(EndDocument.INSTANCE);
        } else {
            super.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.defer) {
            this.deferred.add(new StartPrefixMapping(prefix, uri));
        } else {
            super.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.defer) {
            this.deferred.add(new EndPrefixMapping(prefix));
        } else {
            super.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname, Attributes attributes) throws SAXException {
        if (this.defer) {
            this.deferred.add(new StartElement(namespaceURI, localName, qname, attributes));
        } else {
            super.startElement(namespaceURI, localName, qname, attributes);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws SAXException {
        if (this.defer) {
            this.deferred.add(new EndElement(namespaceURI, localName, qname));
        } else {
            super.endElement(namespaceURI, localName, qname);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.defer) {
            this.deferred.add(new Characters(ch, start, length));
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.defer) {
            this.deferred.add(new IgnorableWhitespace(ch, start, length));
        } else {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.defer) {
            this.deferred.add(new ProcessingInstruction(target, data));
        } else {
            super.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.defer) {
            this.deferred.add(new SkippedEntity(name));
        } else {
            super.skippedEntity(name);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.defer) {
            this.deferred.add(new StartDTD(name, publicId, systemId));
        } else {
            super.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.defer) {
            this.deferred.add(EndDTD.INSTANCE);
        } else {
            super.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.defer) {
            this.deferred.add(new StartEntity(name));
        } else {
            super.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.defer) {
            this.deferred.add(new EndEntity(name));
        } else {
            super.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.defer) {
            this.deferred.add(StartCDATA.INSTANCE);
        } else {
            super.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.defer) {
            this.deferred.add(EndCDATA.INSTANCE);
        } else {
            super.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.defer) {
            this.deferred.add(new Comment(ch, start, length));
        } else {
            super.comment(ch, start, length);
        }
    }

    protected void applyDeferredEvents() throws SAXException {
        SAXEvent event = null;
        while ((event = this.deferred.poll()) != null) {
            if (event instanceof SetDocumentLocator) {
                SetDocumentLocator setDocumentLocator = (SetDocumentLocator)event;
                this.setDocumentLocator_deferred(setDocumentLocator.locator);
                continue;
            }
            if (event instanceof StartDocument) {
                this.startDocument_deferred();
                continue;
            }
            if (event instanceof EndDocument) {
                this.endDocument_deferred();
                continue;
            }
            if (event instanceof StartPrefixMapping) {
                StartPrefixMapping startPrefixMapping = (StartPrefixMapping)event;
                this.startPrefixMapping_deferred(startPrefixMapping.prefix, startPrefixMapping.uri);
                continue;
            }
            if (event instanceof EndPrefixMapping) {
                EndPrefixMapping endPrefixMapping = (EndPrefixMapping)event;
                this.endPrefixMapping_deferred(endPrefixMapping.prefix);
                continue;
            }
            if (event instanceof StartElement) {
                StartElement startElement = (StartElement)event;
                this.startElement_deferred(startElement.namespaceURI, startElement.localName, startElement.qname, startElement.attributes);
                continue;
            }
            if (event instanceof EndElement) {
                EndElement endElement = (EndElement)event;
                this.endElement_deferred(endElement.namespaceURI, endElement.localName, endElement.qname);
                continue;
            }
            if (event instanceof Characters) {
                Characters characters = (Characters)event;
                this.characters_deferred(characters.ch, 0, characters.ch.length);
                continue;
            }
            if (event instanceof IgnorableWhitespace) {
                IgnorableWhitespace ignorableWhitespace = (IgnorableWhitespace)event;
                this.ignorableWhitespace_deferred(ignorableWhitespace.ch, 0, ignorableWhitespace.ch.length);
                continue;
            }
            if (event instanceof ProcessingInstruction) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)event;
                this.processingInstruction_deferred(processingInstruction.target, processingInstruction.data);
                continue;
            }
            if (event instanceof SkippedEntity) {
                SkippedEntity skippedEntity = (SkippedEntity)event;
                this.skippedEntity_deferred(skippedEntity.name);
                continue;
            }
            if (event instanceof StartDTD) {
                StartDTD startDTD = (StartDTD)event;
                this.startDTD_deferred(startDTD.name, startDTD.publicId, startDTD.systemId);
                continue;
            }
            if (event instanceof EndDTD) {
                this.endDTD_deferred();
                continue;
            }
            if (event instanceof StartEntity) {
                StartEntity startEntity = (StartEntity)event;
                this.startEntity_deferred(startEntity.name);
                continue;
            }
            if (event instanceof EndEntity) {
                EndEntity endEntity = (EndEntity)event;
                this.endEntity_deferred(endEntity.name);
                continue;
            }
            if (event instanceof StartCDATA) {
                this.startCDATA_deferred();
                continue;
            }
            if (event instanceof EndCDATA) {
                this.endCDATA_deferred();
                continue;
            }
            if (!(event instanceof Comment)) continue;
            Comment comment = (Comment)event;
            this.comment_deferred(comment.ch, 0, comment.ch.length);
        }
    }

    protected void setDocumentLocator_deferred(Locator locator) {
        super.setDocumentLocator(locator);
    }

    protected void startDocument_deferred() throws SAXException {
        super.startDocument();
    }

    protected void endDocument_deferred() throws SAXException {
        super.endDocument();
    }

    protected void startPrefixMapping_deferred(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
    }

    protected void endPrefixMapping_deferred(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    protected void startElement_deferred(String namespaceUri, String localName, String qName, Attributes attrs) throws SAXException {
        super.startElement(namespaceUri, localName, qName, attrs);
    }

    protected void endElement_deferred(String namespaceUri, String localName, String qName) throws SAXException {
        super.endElement(namespaceUri, localName, qName);
    }

    protected void characters_deferred(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
    }

    protected void ignorableWhitespace_deferred(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    protected void processingInstruction_deferred(String target, String data) throws SAXException {
        super.processingInstruction(target, data);
    }

    protected void skippedEntity_deferred(String name) throws SAXException {
        super.skippedEntity(name);
    }

    protected void startDTD_deferred(String name, String publicId, String systemId) throws SAXException {
        super.startDTD(name, publicId, systemId);
    }

    protected void endDTD_deferred() throws SAXException {
        super.endDTD();
    }

    protected void startEntity_deferred(String name) throws SAXException {
        super.startEntity(name);
    }

    protected void endEntity_deferred(String name) throws SAXException {
        super.endEntity(name);
    }

    protected void startCDATA_deferred() throws SAXException {
        super.startCDATA();
    }

    protected void endCDATA_deferred() throws SAXException {
        super.endCDATA();
    }

    protected void comment_deferred(char[] ch, int start, int length) throws SAXException {
        super.comment(ch, start, length);
    }
}

