/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exist.Indexer;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.SAXTrigger;
import org.exist.collections.triggers.Trigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.collections.triggers.TriggerProxy;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class DocumentTriggers
implements DocumentTrigger,
ContentHandler,
LexicalHandler,
ErrorHandler {
    private Indexer indexer;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private ErrorHandler errorHandler;
    private SAXTrigger last = null;
    private final List<DocumentTrigger> triggers;

    public DocumentTriggers(DBBroker broker) throws TriggerException {
        this(broker, null, null, null);
    }

    public DocumentTriggers(DBBroker broker, Collection collection) throws TriggerException {
        this(broker, null, collection, collection.isTriggersEnabled() ? collection.getConfiguration(broker) : null);
    }

    public DocumentTriggers(DBBroker broker, Indexer indexer, Collection collection, CollectionConfiguration config) throws TriggerException {
        DocumentTrigger instance;
        List<TriggerProxy<? extends DocumentTrigger>> docTriggers = null;
        if (config != null) {
            docTriggers = config.documentTriggers();
        }
        java.util.Collection<TriggerProxy<? extends DocumentTrigger>> masterTriggers = broker.getDatabase().getDocumentTriggers();
        this.triggers = new ArrayList<DocumentTrigger>(masterTriggers.size() + (docTriggers == null ? 0 : docTriggers.size()));
        for (TriggerProxy<? extends DocumentTrigger> docTrigger : masterTriggers) {
            instance = docTrigger.newInstance(broker, collection);
            this.register(instance);
        }
        if (docTriggers != null) {
            for (TriggerProxy<? extends DocumentTrigger> docTrigger : docTriggers) {
                instance = docTrigger.newInstance(broker, collection);
                this.register(instance);
            }
        }
        if (indexer != null) {
            this.finishPreparation(indexer);
        }
        this.last = null;
    }

    private void finishPreparation(Indexer indexer) {
        if (this.last == null) {
            this.contentHandler = indexer;
            this.lexicalHandler = indexer;
            this.errorHandler = indexer;
        } else {
            this.last.next(indexer);
        }
        this.indexer = indexer;
    }

    private void register(DocumentTrigger trigger) {
        if (trigger instanceof SAXTrigger) {
            SAXTrigger filteringTrigger = (SAXTrigger)trigger;
            if (this.last == null) {
                this.contentHandler = filteringTrigger;
                this.lexicalHandler = filteringTrigger;
                this.errorHandler = filteringTrigger;
            } else {
                this.last.next(filteringTrigger);
            }
            this.last = filteringTrigger;
        }
        this.triggers.add(trigger);
    }

    @Override
    public void configure(DBBroker broker, Collection parent, Map<String, List<? extends Object>> parameters) throws TriggerException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.lexicalHandler.startEntity(name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.lexicalHandler.endEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.lexicalHandler.startCDATA();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.lexicalHandler.comment(ch, start, length);
    }

    @Override
    public void beforeCreateDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
        for (DocumentTrigger trigger : this.triggers) {
            trigger.beforeCreateDocument(broker, txn, uri);
        }
    }

    @Override
    public void afterCreateDocument(DBBroker broker, Txn txn, DocumentImpl document) {
        for (DocumentTrigger trigger : this.triggers) {
            try {
                trigger.afterCreateDocument(broker, txn, document);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        for (DocumentTrigger trigger : this.triggers) {
            trigger.beforeUpdateDocument(broker, txn, document);
        }
    }

    @Override
    public void afterUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) {
        for (DocumentTrigger trigger : this.triggers) {
            try {
                trigger.afterUpdateDocument(broker, txn, document);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        for (DocumentTrigger trigger : this.triggers) {
            trigger.beforeUpdateDocumentMetadata(broker, txn, document);
        }
    }

    @Override
    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) {
        for (DocumentTrigger trigger : this.triggers) {
            try {
                trigger.afterUpdateDocumentMetadata(broker, txn, document);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        for (DocumentTrigger trigger : this.triggers) {
            trigger.beforeCopyDocument(broker, txn, document, newUri);
        }
    }

    @Override
    public void afterCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI oldUri) {
        for (DocumentTrigger trigger : this.triggers) {
            try {
                trigger.afterCopyDocument(broker, txn, document, oldUri);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        for (DocumentTrigger trigger : this.triggers) {
            trigger.beforeMoveDocument(broker, txn, document, newUri);
        }
    }

    @Override
    public void afterMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI oldUri) {
        for (DocumentTrigger trigger : this.triggers) {
            try {
                trigger.afterMoveDocument(broker, txn, document, oldUri);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeDeleteDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        for (DocumentTrigger trigger : this.triggers) {
            trigger.beforeDeleteDocument(broker, txn, document);
        }
    }

    @Override
    public void afterDeleteDocument(DBBroker broker, Txn txn, XmldbURI uri) {
        for (DocumentTrigger trigger : this.triggers) {
            try {
                trigger.afterDeleteDocument(broker, txn, uri);
            }
            catch (Exception e) {
                Trigger.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isValidating() {
        return false;
    }

    @Override
    public void setValidating(boolean validating) {
        for (DocumentTrigger trigger : this.triggers) {
            trigger.setValidating(validating);
        }
        this.indexer.setValidating(validating);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }
}

