/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exist.collections.Collection;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;

public class Dumper
extends FilteringTrigger
implements DocumentTrigger {
    @Override
    public void configure(DBBroker broker, Collection parent, Map<String, List<?>> parameters) throws TriggerException {
        super.configure(broker, parent, parameters);
        System.out.println("parameters:");
        for (Map.Entry<String, List<?>> entry : parameters.entrySet()) {
            System.out.print(entry.getKey() + " = " + entry.getValue());
        }
    }

    public void prepare(int event, DBBroker broker, Txn txn, XmldbURI documentName, DocumentImpl existingDocument) throws TriggerException {
        System.out.println("\nstoring document " + documentName + " into collection " + this.getCollection().getURI());
        if (existingDocument != null) {
            System.out.println("replacing document " + existingDocument.getFileURI());
        }
        System.out.println("collection contents:");
        DefaultDocumentSet docs = new DefaultDocumentSet();
        try {
            this.getCollection().getDocuments(broker, docs);
        }
        catch (PermissionDeniedException | LockException e) {
            throw new TriggerException(e.getMessage(), e);
        }
        Iterator<DocumentImpl> i = docs.getDocumentIterator();
        while (i.hasNext()) {
            System.out.println("\t" + i.next().getFileURI());
        }
    }

    @Override
    public void beforeCreateDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
        this.prepare(-1, broker, txn, uri, null);
    }

    @Override
    public void afterCreateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        this.prepare(-1, broker, txn, document.getURI(), document);
    }

    @Override
    public void afterUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        this.prepare(-1, broker, txn, newUri, document);
    }

    @Override
    public void afterCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        this.prepare(-1, broker, txn, newUri, document);
    }

    @Override
    public void afterMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeDeleteDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        this.prepare(-1, broker, txn, document.getURI(), document);
    }

    @Override
    public void afterDeleteDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }
}

