/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.DateTimeValue;

public class HistoryTrigger
extends FilteringTrigger
implements DocumentTrigger {
    public static final String PARAM_ROOT_NAME = "root";
    public static final XmldbURI DEFAULT_ROOT_PATH = XmldbURI.ROOT_COLLECTION_URI.append("history");
    private XmldbURI rootPath = DEFAULT_ROOT_PATH;

    @Override
    public void configure(DBBroker broker, Collection parent, Map<String, List<?>> parameters) throws TriggerException {
        super.configure(broker, parent, parameters);
        if (parameters.containsKey(PARAM_ROOT_NAME)) {
            try {
                this.rootPath = XmldbURI.xmldbUriFor(parameters.get(PARAM_ROOT_NAME).get(0).toString());
            }
            catch (URISyntaxException e) {
                throw new TriggerException(e);
            }
        }
    }

    private void makeCopy(DBBroker broker, Txn txn, DocumentImpl doc) throws TriggerException {
        if (doc == null) {
            return;
        }
        XmldbURI path = this.rootPath.append(doc.getURI());
        try {
            String dtValue = new DateTimeValue(new Date(doc.getMetadata().getLastModified())).getStringValue();
            dtValue = dtValue.replaceAll(":", "-");
            dtValue = dtValue.replaceAll("\\.", "-");
            XmldbURI name = XmldbURI.create(dtValue);
            Collection destination = broker.getOrCreateCollection(txn, path);
            broker.saveCollection(txn, destination);
            broker.copyResource(txn, doc, destination, name);
        }
        catch (IOException | EXistException | PermissionDeniedException | LockException | XPathException xpe) {
            throw new TriggerException(xpe);
        }
    }

    @Override
    public void beforeCreateDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
    }

    @Override
    public void afterCreateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        this.makeCopy(broker, txn, document);
    }

    @Override
    public void afterUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void afterCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeDeleteDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        this.makeCopy(broker, txn, document);
    }

    @Override
    public void beforeMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        this.makeCopy(broker, txn, document);
    }

    @Override
    public void afterMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void afterDeleteDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }
}

