/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.exist.collections.triggers.TriggerException;

public class TriggerEvents {
    public static short CREATE = 1;
    public static short UPDATE = (short)2;
    public static short COPY = (short)3;
    public static short MOVE = (short)4;
    public static short DELETE = (short)5;
    public static short BEFORE = (short)-1;
    public static short AFTER = 1;
    public static short COLLECTION = 0;
    public static short DOCUMENT = (short)10;
    public static short BEFORE_CREATE_COLLECTION = (short)-1;
    public static short AFTER_CREATE_COLLECTION = 1;
    public static short BEFORE_UPDATE_COLLECTION = (short)-2;
    public static short AFTER_UPDATE_COLLECTION = (short)2;
    public static short BEFORE_COPY_COLLECTION = (short)-3;
    public static short AFTER_COPY_COLLECTION = (short)3;
    public static short BEFORE_MOVE_COLLECTION = (short)-4;
    public static short AFTER_MOVE_COLLECTION = (short)4;
    public static short BEFORE_DELETE_COLLECTION = (short)-5;
    public static short AFTER_DELETE_COLLECTION = (short)5;
    public static short BEFORE_CREATE_DOCUMENT = (short)-11;
    public static short AFTER_CREATE_DOCUMENT = (short)11;
    public static short BEFORE_UPDATE_DOCUMENT = (short)-12;
    public static short AFTER_UPDATE_DOCUMENT = (short)12;
    public static short BEFORE_COPY_DOCUMENT = (short)-13;
    public static short AFTER_COPY_DOCUMENT = (short)13;
    public static short BEFORE_MOVE_DOCUMENT = (short)-14;
    public static short AFTER_MOVE_DOCUMENT = (short)14;
    public static short BEFORE_DELETE_DOCUMENT = (short)-15;
    public static short AFTER_DELETE_DOCUMENT = (short)15;
    private static final String[] EVENTS_STRING = new String[]{"CREATE-COLLECTION", "UPDATE-COLLECTION", "COPY-COLLECTION", "MOVE-COLLECTION", "DELETE-COLLECTION", "CREATE-DOCUMENT", "UPDATE-DOCUMENT", "COPY-DOCUMENT", "MOVE-DOCUMENT", "DELETE-DOCUMENT"};
    private static final EVENTS[] _EVENTS_ = new EVENTS[]{EVENTS.CREATE_COLLECTION, EVENTS.UPDATE_COLLECTION, EVENTS.COPY_COLLECTION, EVENTS.MOVE_COLLECTION, EVENTS.DELETE_COLLECTION, EVENTS.CREATE_DOCUMENT, EVENTS.UPDATE_DOCUMENT, EVENTS.COPY_DOCUMENT, EVENTS.MOVE_DOCUMENT, EVENTS.DELETE_DOCUMENT};
    public static final String[] OLD_EVENTS_STRING = new String[]{"STORE", "UPDATE", "REMOVE"};

    public static Set<EVENTS> convertFromString(String events) throws TriggerException {
        HashSet<EVENTS> result = new HashSet<EVENTS>();
        StringTokenizer tok = new StringTokenizer(events, ", ");
        while (tok.hasMoreTokens()) {
            int i;
            String event = tok.nextToken();
            for (i = 0; i < EVENTS_STRING.length; ++i) {
                if (!event.equalsIgnoreCase(EVENTS_STRING[i])) continue;
                result.add(_EVENTS_[i]);
                break;
            }
            if (i <= EVENTS_STRING.length) continue;
            throw new TriggerException("Unknown event type '" + event);
        }
        return result;
    }

    public static Set<EVENTS> convertFromOldDesign(String events) throws TriggerException {
        HashSet<EVENTS> result = new HashSet<EVENTS>();
        StringTokenizer tok = new StringTokenizer(events, ", ");
        while (tok.hasMoreTokens()) {
            int i;
            String event = tok.nextToken();
            for (i = 0; i < OLD_EVENTS_STRING.length && !event.equalsIgnoreCase(OLD_EVENTS_STRING[i]); ++i) {
            }
            switch (i) {
                case 0: {
                    result.add(EVENTS.CREATE_DOCUMENT);
                    break;
                }
                case 1: {
                    result.add(EVENTS.UPDATE_DOCUMENT);
                    break;
                }
                case 2: {
                    result.add(EVENTS.DELETE_DOCUMENT);
                    break;
                }
            }
        }
        return result;
    }

    public static enum EVENTS {
        CREATE_COLLECTION,
        UPDATE_COLLECTION,
        COPY_COLLECTION,
        MOVE_COLLECTION,
        DELETE_COLLECTION,
        CREATE_DOCUMENT,
        UPDATE_DOCUMENT,
        COPY_DOCUMENT,
        MOVE_DOCUMENT,
        DELETE_DOCUMENT;

    }
}

