/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.collections.triggers.CollectionTrigger;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.SAXTrigger;
import org.exist.collections.triggers.TriggerEvents;
import org.exist.collections.triggers.TriggerException;
import org.exist.collections.triggers.TriggerStatePerThread;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeSet;
import org.exist.security.PermissionDeniedException;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.ProcessMonitor;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.ContextItemDeclaration;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;

public class XQueryTrigger
extends SAXTrigger
implements DocumentTrigger,
CollectionTrigger {
    protected Logger LOG = LogManager.getLogger(this.getClass());
    private static final String NAMESPACE = "http://exist-db.org/xquery/trigger";
    private static final String EVENT_TYPE_PREPARE = "prepare";
    private static final String EVENT_TYPE_FINISH = "finish";
    private static final String DEFAULT_BINDING_PREFIX = "local:";
    public static final String[] EVENTS = new String[]{"CREATE-DOCUMENT", "CREATE-COLLECTION", "UPDATE-DOCUMENT", "UPDATE-COLLECTION", "COPY-DOCUMENT", "COPY-COLLECTION", "MOVE-DOCUMENT", "MOVE-COLLECTION", "DELETE-DOCUMENT", "DELETE-COLLECTION"};
    public static final QName beforeCreateCollection = new QName("before-create-collection", "http://exist-db.org/xquery/trigger");
    public static final QName afterCreateCollection = new QName("after-create-collection", "http://exist-db.org/xquery/trigger");
    public static final QName beforeUpdateCollection = new QName("before-update-collection", "http://exist-db.org/xquery/trigger");
    public static final QName afterUpdateCollection = new QName("after-update-collection", "http://exist-db.org/xquery/trigger");
    public static final QName beforeCopyCollection = new QName("before-copy-collection", "http://exist-db.org/xquery/trigger");
    public static final QName afterCopyCollection = new QName("after-copy-collection", "http://exist-db.org/xquery/trigger");
    public static final QName beforeMoveCollection = new QName("before-move-collection", "http://exist-db.org/xquery/trigger");
    public static final QName afterMoveCollection = new QName("after-move-collection", "http://exist-db.org/xquery/trigger");
    public static final QName beforeDeleteCollection = new QName("before-delete-collection", "http://exist-db.org/xquery/trigger");
    public static final QName afterDeleteCollection = new QName("after-delete-collection", "http://exist-db.org/xquery/trigger");
    public static final QName beforeCreateDocument = new QName("before-create-document", "http://exist-db.org/xquery/trigger");
    public static final QName afterCreateDocument = new QName("after-create-document", "http://exist-db.org/xquery/trigger");
    public static final QName beforeUpdateDocument = new QName("before-update-document", "http://exist-db.org/xquery/trigger");
    public static final QName afterUpdateDocument = new QName("after-update-document", "http://exist-db.org/xquery/trigger");
    public static final QName beforeCopyDocument = new QName("before-copy-document", "http://exist-db.org/xquery/trigger");
    public static final QName afterCopyDocument = new QName("after-copy-document", "http://exist-db.org/xquery/trigger");
    public static final QName beforeMoveDocument = new QName("before-move-document", "http://exist-db.org/xquery/trigger");
    public static final QName afterMoveDocument = new QName("after-move-document", "http://exist-db.org/xquery/trigger");
    public static final QName beforeDeleteDocument = new QName("before-delete-document", "http://exist-db.org/xquery/trigger");
    public static final QName afterDeleteDocument = new QName("after-delete-document", "http://exist-db.org/xquery/trigger");
    private Set<TriggerEvents.EVENTS> events;
    private Collection collection = null;
    private String strQuery = null;
    private String urlQuery = null;
    private Properties userDefinedVariables = new Properties();
    private String bindingPrefix = null;
    private XQuery service;
    public static final String PREPARE_EXCEPTION_MESSAGE = "Error during trigger prepare";

    @Override
    public void configure(DBBroker broker, Collection parent, Map<String, List<?>> parameters) throws TriggerException {
        this.collection = parent;
        if (parameters != null) {
            List<?> urlQueries;
            this.events = new HashSet<TriggerEvents.EVENTS>();
            List<?> paramEvents = parameters.get("event");
            if (paramEvents != null) {
                for (String event : paramEvents) {
                    this.events.addAll(TriggerEvents.convertFromOldDesign(event));
                    this.events.addAll(TriggerEvents.convertFromString(event));
                }
            }
            this.urlQuery = (urlQueries = parameters.get("url")) != null ? (String)urlQueries.get(0) : null;
            List<?> strQueries = parameters.get("query");
            this.strQuery = strQueries != null ? (String)strQueries.get(0) : null;
            for (String paramName : parameters.keySet()) {
                if ("bindingPrefix".equals(paramName)) {
                    String bindingPrefix = (String)parameters.get("bindingPrefix").get(0);
                    if (bindingPrefix == null || "".equals(bindingPrefix.trim())) continue;
                    this.bindingPrefix = bindingPrefix.trim() + ":";
                    continue;
                }
                if ("url".equals(paramName)) {
                    this.urlQuery = (String)parameters.get("url").get(0);
                    continue;
                }
                if ("query".equals(paramName)) {
                    this.strQuery = (String)parameters.get("query").get(0);
                    continue;
                }
                this.userDefinedVariables.put(paramName, parameters.get(paramName).get(0));
            }
            if (this.bindingPrefix == null) {
                this.bindingPrefix = DEFAULT_BINDING_PREFIX;
            }
            if (this.urlQuery != null || this.strQuery != null) {
                this.service = broker.getBrokerPool().getXQueryService();
                return;
            }
        }
        this.LOG.error("XQuery Trigger for: '" + parent.getURI() + "' is missing its XQuery parameter");
    }

    private Source getQuerySource(DBBroker broker) {
        Source querySource = null;
        if (this.urlQuery != null) {
            try {
                querySource = SourceFactory.getSource(broker, null, this.urlQuery, false);
            }
            catch (Exception e) {
                this.LOG.error((Object)e);
            }
        } else if (this.strQuery != null) {
            querySource = new StringSource(this.strQuery);
        }
        return querySource;
    }

    private void prepare(int event, DBBroker broker, Txn transaction, XmldbURI src, XmldbURI dst, boolean isCollection) throws TriggerException {
        CompiledXQuery compiledQuery;
        Source query = this.getQuerySource(broker);
        if (query == null) {
            return;
        }
        if (!TriggerStatePerThread.verifyUniqueTriggerPerThreadBeforePrepare(this, src)) {
            return;
        }
        TriggerStatePerThread.setTransaction(transaction);
        XQueryContext context = new XQueryContext(broker.getBrokerPool());
        try {
            compiledQuery = this.service.compile(broker, context, query);
            context.declareVariable(this.bindingPrefix + "type", (Object)EVENT_TYPE_PREPARE);
            context.declareVariable(this.bindingPrefix + "event", (Object)new StringValue(XQueryTrigger.eventToString(event)));
            if (isCollection) {
                context.declareVariable(this.bindingPrefix + "collection", (Object)new AnyURIValue(src));
            } else {
                context.declareVariable(this.bindingPrefix + "collection", (Object)new AnyURIValue(src.removeLastSegment()));
            }
            context.declareVariable(this.bindingPrefix + "uri", (Object)new AnyURIValue(src));
            if (dst == null) {
                context.declareVariable(this.bindingPrefix + "new-uri", (Object)Sequence.EMPTY_SEQUENCE);
            } else {
                context.declareVariable(this.bindingPrefix + "new-uri", (Object)new AnyURIValue(dst));
            }
            context.declareVariable(this.bindingPrefix + "eventType", (Object)EVENT_TYPE_PREPARE);
            context.declareVariable(this.bindingPrefix + "triggerEvent", (Object)new StringValue(XQueryTrigger.eventToString(event)));
            if (isCollection) {
                context.declareVariable(this.bindingPrefix + "collectionName", (Object)new AnyURIValue(src));
            } else {
                context.declareVariable(this.bindingPrefix + "collectionName", (Object)new AnyURIValue(src.removeLastSegment()));
                context.declareVariable(this.bindingPrefix + "documentName", (Object)new AnyURIValue(src));
            }
            for (String string : this.userDefinedVariables.keySet()) {
                String varValue = this.userDefinedVariables.getProperty(string);
                context.declareVariable(this.bindingPrefix + string, (Object)new StringValue(varValue));
            }
        }
        catch (IOException | PermissionDeniedException | XPathException e) {
            TriggerStatePerThread.setTriggerRunningState(0, this, null);
            TriggerStatePerThread.setTransaction(null);
            throw new TriggerException(PREPARE_EXCEPTION_MESSAGE, e);
        }
        try {
            NodeSet contextSet = NodeSet.EMPTY_SET;
            this.service.execute(broker, compiledQuery, (Sequence)contextSet);
            this.LOG.debug("Trigger fired for prepare");
        }
        catch (PermissionDeniedException | XPathException e) {
            TriggerStatePerThread.setTriggerRunningState(0, this, null);
            TriggerStatePerThread.setTransaction(null);
            throw new TriggerException(PREPARE_EXCEPTION_MESSAGE, e);
        }
    }

    private void finish(int event, DBBroker broker, Txn transaction, XmldbURI src, XmldbURI dst, boolean isCollection) {
        Source query = this.getQuerySource(broker);
        if (query == null) {
            return;
        }
        if (!TriggerStatePerThread.verifyUniqueTriggerPerThreadBeforeFinish(this, src)) {
            return;
        }
        XQueryContext context = new XQueryContext(broker.getBrokerPool());
        CompiledXQuery compiledQuery = null;
        try {
            compiledQuery = this.service.compile(broker, context, query);
            context.declareVariable(this.bindingPrefix + "type", (Object)EVENT_TYPE_FINISH);
            context.declareVariable(this.bindingPrefix + "event", (Object)new StringValue(XQueryTrigger.eventToString(event)));
            if (isCollection) {
                context.declareVariable(this.bindingPrefix + "collection", (Object)new AnyURIValue(src));
            } else {
                context.declareVariable(this.bindingPrefix + "collection", (Object)new AnyURIValue(src.removeLastSegment()));
            }
            context.declareVariable(this.bindingPrefix + "uri", (Object)new AnyURIValue(src));
            if (dst == null) {
                context.declareVariable(this.bindingPrefix + "new-uri", (Object)Sequence.EMPTY_SEQUENCE);
            } else {
                context.declareVariable(this.bindingPrefix + "new-uri", (Object)new AnyURIValue(dst));
            }
            context.declareVariable(this.bindingPrefix + "eventType", (Object)EVENT_TYPE_FINISH);
            context.declareVariable(this.bindingPrefix + "triggerEvent", (Object)new StringValue(XQueryTrigger.eventToString(event)));
            if (isCollection) {
                context.declareVariable(this.bindingPrefix + "collectionName", (Object)new AnyURIValue(src));
            } else {
                context.declareVariable(this.bindingPrefix + "collectionName", (Object)new AnyURIValue(src.removeLastSegment()));
                context.declareVariable(this.bindingPrefix + "documentName", (Object)new AnyURIValue(src));
            }
            for (String string : this.userDefinedVariables.keySet()) {
                String varValue = this.userDefinedVariables.getProperty(string);
                context.declareVariable(this.bindingPrefix + string, (Object)new StringValue(varValue));
            }
        }
        catch (IOException | PermissionDeniedException | XPathException e) {
            this.LOG.error((Object)e);
        }
        try {
            NodeSet contextSet = NodeSet.EMPTY_SET;
            this.service.execute(broker, compiledQuery, (Sequence)contextSet);
        }
        catch (XPathException e) {
            this.LOG.error("Error during trigger finish", (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            this.LOG.error((Object)e);
        }
        TriggerStatePerThread.setTriggerRunningState(0, this, null);
        TriggerStatePerThread.setTransaction(null);
        this.LOG.debug("Trigger fired for finish");
    }

    private CompiledXQuery getScript(boolean isBefore, DBBroker broker, Txn transaction, XmldbURI src) throws TriggerException {
        Source query = this.getQuerySource(broker);
        if (query == null) {
            return null;
        }
        if (isBefore && !TriggerStatePerThread.verifyUniqueTriggerPerThreadBeforePrepare(this, src)) {
            return null;
        }
        if (!isBefore && !TriggerStatePerThread.verifyUniqueTriggerPerThreadBeforeFinish(this, src)) {
            return null;
        }
        TriggerStatePerThread.setTransaction(transaction);
        XQueryContext context = new XQueryContext(broker.getBrokerPool());
        if (query instanceof DBSource) {
            context.setModuleLoadPath("xmldb:exist://" + ((DBSource)query).getDocumentPath().removeLastSegment().toString());
        }
        try {
            CompiledXQuery compiledQuery = this.service.compile(broker, context, query);
            for (String string : this.userDefinedVariables.keySet()) {
                String varValue = this.userDefinedVariables.getProperty(string);
                context.declareVariable(this.bindingPrefix + string, (Object)new StringValue(varValue));
            }
            compiledQuery.reset();
            context.getWatchDog().reset();
            context.prepareForExecution();
            return compiledQuery;
        }
        catch (IOException | PermissionDeniedException | XPathException e) {
            this.LOG.warn(e.getMessage(), (Throwable)e);
            TriggerStatePerThread.setTriggerRunningState(0, this, null);
            TriggerStatePerThread.setTransaction(null);
            throw new TriggerException(PREPARE_EXCEPTION_MESSAGE, e);
        }
    }

    private void execute(boolean isBefore, DBBroker broker, Txn transaction, QName functionName, XmldbURI src, XmldbURI dst) throws TriggerException {
        CompiledXQuery compiledQuery = this.getScript(isBefore, broker, transaction, src);
        if (compiledQuery == null) {
            return;
        }
        ProcessMonitor pm = null;
        XQueryContext context = compiledQuery.getContext();
        try {
            UserDefinedFunction function;
            int nParams = 1;
            if (dst != null) {
                nParams = 2;
            }
            if ((function = context.resolveFunction(functionName, nParams)) != null) {
                ArrayList<Expression> args = new ArrayList<Expression>(nParams);
                if (isBefore) {
                    args.add(new LiteralValue(context, new AnyURIValue(src)));
                    if (dst != null) {
                        args.add(new LiteralValue(context, new AnyURIValue(dst)));
                    }
                } else {
                    if (dst != null) {
                        args.add(new LiteralValue(context, new AnyURIValue(dst)));
                    }
                    args.add(new LiteralValue(context, new AnyURIValue(src)));
                }
                pm = broker.getBrokerPool().getProcessMonitor();
                context.getProfiler().traceQueryStart();
                pm.queryStarted(context.getWatchDog());
                FunctionCall call = new FunctionCall(context, function);
                call.setArguments(args);
                call.analyze(new AnalyzeContextInfo());
                ContextItemDeclaration cid = call.getContext().getContextItemDeclartion();
                Sequence contextSequence = cid != null ? cid.eval(null) : NodeSet.EMPTY_SET;
                call.eval(contextSequence);
            }
        }
        catch (XPathException e) {
            TriggerStatePerThread.setTriggerRunningState(0, this, null);
            TriggerStatePerThread.setTransaction(null);
            throw new TriggerException(PREPARE_EXCEPTION_MESSAGE, e);
        }
        finally {
            if (pm != null) {
                context.getProfiler().traceQueryEnd(context);
                pm.queryCompleted(context.getWatchDog());
            }
            compiledQuery.reset();
            context.reset();
        }
        if (!isBefore) {
            TriggerStatePerThread.setTriggerRunningState(0, this, null);
            TriggerStatePerThread.setTransaction(null);
            this.LOG.debug("Trigger fired 'after'");
        } else {
            this.LOG.debug("Trigger fired 'before'");
        }
    }

    public static String eventToString(int event) {
        return EVENTS[event];
    }

    @Override
    public void beforeCreateCollection(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.CREATE_COLLECTION)) {
            this.prepare(1, broker, txn, uri, null, true);
        } else {
            this.execute(true, broker, txn, beforeCreateCollection, uri, null);
        }
    }

    @Override
    public void afterCreateCollection(DBBroker broker, Txn txn, Collection collection) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.CREATE_COLLECTION)) {
            this.finish(1, broker, txn, collection.getURI(), null, true);
        } else {
            this.execute(false, broker, txn, afterCreateCollection, collection.getURI(), null);
        }
    }

    @Override
    public void beforeCopyCollection(DBBroker broker, Txn txn, Collection collection, XmldbURI newUri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.COPY_COLLECTION)) {
            this.prepare(5, broker, txn, collection.getURI(), newUri, true);
        } else {
            this.execute(true, broker, txn, beforeCopyCollection, collection.getURI(), newUri);
        }
    }

    @Override
    public void afterCopyCollection(DBBroker broker, Txn txn, Collection collection, XmldbURI oldUri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.COPY_COLLECTION)) {
            this.finish(5, broker, txn, collection.getURI(), oldUri, true);
        } else {
            this.execute(false, broker, txn, afterCopyCollection, oldUri, collection.getURI());
        }
    }

    @Override
    public void beforeMoveCollection(DBBroker broker, Txn txn, Collection collection, XmldbURI newUri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.MOVE_COLLECTION)) {
            this.prepare(7, broker, txn, collection.getURI(), newUri, true);
        } else {
            this.execute(true, broker, txn, beforeMoveCollection, collection.getURI(), newUri);
        }
    }

    @Override
    public void afterMoveCollection(DBBroker broker, Txn txn, Collection collection, XmldbURI oldUri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.MOVE_COLLECTION)) {
            this.finish(7, broker, txn, oldUri, collection.getURI(), true);
        } else {
            this.execute(false, broker, txn, afterMoveCollection, oldUri, collection.getURI());
        }
    }

    @Override
    public void beforeDeleteCollection(DBBroker broker, Txn txn, Collection collection) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.DELETE_COLLECTION)) {
            this.prepare(9, broker, txn, collection.getURI(), null, true);
        } else {
            this.execute(true, broker, txn, beforeDeleteCollection, collection.getURI(), null);
        }
    }

    @Override
    public void afterDeleteCollection(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.DELETE_COLLECTION)) {
            this.finish(9, broker, txn, this.collection.getURI(), null, true);
        } else {
            this.execute(false, broker, txn, afterDeleteCollection, uri, null);
        }
    }

    @Override
    public void beforeCreateDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.CREATE_DOCUMENT)) {
            this.prepare(0, broker, txn, uri, null, false);
        } else {
            this.execute(true, broker, txn, beforeCreateDocument, uri, null);
        }
    }

    @Override
    public void afterCreateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.CREATE_DOCUMENT)) {
            this.finish(0, broker, txn, document.getURI(), null, false);
        } else {
            this.execute(false, broker, txn, afterCreateDocument, document.getURI(), null);
        }
    }

    @Override
    public void beforeUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.UPDATE_DOCUMENT)) {
            this.prepare(2, broker, txn, document.getURI(), null, false);
        } else {
            this.execute(true, broker, txn, beforeUpdateDocument, document.getURI(), null);
        }
    }

    @Override
    public void afterUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.UPDATE_DOCUMENT)) {
            this.finish(2, broker, txn, document.getURI(), null, false);
        } else {
            this.execute(false, broker, txn, afterUpdateDocument, document.getURI(), null);
        }
    }

    @Override
    public void beforeCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.COPY_DOCUMENT)) {
            this.prepare(4, broker, txn, document.getURI(), newUri, false);
        } else {
            this.execute(true, broker, txn, beforeCopyDocument, document.getURI(), newUri);
        }
    }

    @Override
    public void afterCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI oldUri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.COPY_DOCUMENT)) {
            this.finish(4, broker, txn, document.getURI(), oldUri, false);
        } else {
            this.execute(false, broker, txn, afterCopyDocument, oldUri, document.getURI());
        }
    }

    @Override
    public void beforeMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.MOVE_DOCUMENT)) {
            this.prepare(6, broker, txn, document.getURI(), newUri, false);
        } else {
            this.execute(true, broker, txn, beforeMoveDocument, document.getURI(), newUri);
        }
    }

    @Override
    public void afterMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI oldUri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.MOVE_DOCUMENT)) {
            this.finish(6, broker, txn, oldUri, document.getURI(), false);
        } else {
            this.execute(false, broker, txn, afterMoveDocument, oldUri, document.getURI());
        }
    }

    @Override
    public void beforeDeleteDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.DELETE_DOCUMENT)) {
            this.prepare(8, broker, txn, document.getURI(), null, false);
        } else {
            this.execute(true, broker, txn, beforeDeleteDocument, document.getURI(), null);
        }
    }

    @Override
    public void afterDeleteDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
        if (this.events.contains((Object)TriggerEvents.EVENTS.DELETE_DOCUMENT)) {
            this.finish(8, broker, txn, uri, null, false);
        } else {
            this.execute(false, broker, txn, afterDeleteDocument, uri, null);
        }
    }

    @Override
    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }
}

