/*
 * Decompiled with CFR 0.152.
 */
package org.exist.config;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.dom.memtree.ElementImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationImpl
implements Configuration {
    private Map<String, Object> runtimeProperties = new HashMap<String, Object>();
    protected WeakReference<Configurable> configuredObjectReference = null;
    private Element element;
    private Map<String, String> props = null;
    Map<String, Object> objects = null;
    private boolean saving = false;

    private ConfigurationImpl() {
    }

    protected ConfigurationImpl(Element element) {
        this.element = element;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public String getName() {
        return this.element.getLocalName();
    }

    @Override
    public String getValue() {
        return this.element.getTextContent();
    }

    @Override
    public Configuration getConfiguration(String name) {
        if (this.element.getLocalName().equals(name)) {
            return this;
        }
        List<Configuration> list = this.getConfigurations(name);
        if (list == null) {
            return null;
        }
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<Configuration> getConfigurations(String name) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        for (Node child = this.element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Element el = (Element)child;
            String ns = el.getNamespaceURI();
            if (!name.equals(el.getLocalName()) || ns == null || !"http://exist-db.org/Configuration".equals(ns)) continue;
            ConfigurationImpl config = new ConfigurationImpl(el);
            list.add(config);
        }
        return list;
    }

    private void cache() {
        if (this.props != null) {
            return;
        }
        this.props = new HashMap<String, String>();
        HashSet<String> names = new HashSet<String>();
        for (Node child = this.element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String ns;
            if (child.getNodeType() != 1 || (ns = child.getNamespaceURI()) == null || !"http://exist-db.org/Configuration".equals(ns)) continue;
            String name = child.getLocalName();
            if (names.contains(name)) {
                if (!this.props.containsKey(name)) continue;
                this.props.remove(name);
                continue;
            }
            this.props.put(name, child.getTextContent());
            names.add(name);
        }
        NamedNodeMap attrs = this.element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if ("xmlns".equals(attr.getPrefix())) continue;
            this.props.put(attr.getLocalName(), attr.getNodeValue());
        }
    }

    @Override
    public void clearCache() {
        this.props = null;
    }

    @Override
    public String getProperty(String name) {
        this.cache();
        return this.props.get(name);
    }

    public String getProperty(String name, String default_property) {
        String property = this.getProperty(name);
        if (property == null) {
            return default_property;
        }
        return property;
    }

    @Override
    public Map<String, String> getPropertyMap(String name) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.hasProperty(name)) {
            map.put(name, this.getProperty(name));
            return map;
        }
        Node child = this.element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                Element el = (Element)child;
                String ns = el.getNamespaceURI();
                if (name.equals(el.getLocalName()) && ns != null && "http://exist-db.org/Configuration".equals(ns)) {
                    Node attr;
                    NamedNodeMap attrs;
                    if (!el.hasAttributes() || (attrs = el.getAttributes()).getLength() != 1 || (attr = attrs.getNamedItem("key")) == null) continue;
                    String key = attr.getNodeValue();
                    String value = el.getTextContent();
                    if (key != null && !key.isEmpty() && value != null && !value.isEmpty()) {
                        map.put(key, value);
                    }
                }
            }
            child = child.getNextSibling();
        }
        return map;
    }

    @Override
    public boolean hasProperty(String name) {
        this.cache();
        return this.props.containsKey(name);
    }

    public Object getRuntimeProperty(String name) {
        return this.runtimeProperties.get(name);
    }

    public boolean hasRuntimeProperty(String name) {
        return this.runtimeProperties.containsKey(name);
    }

    public void setRuntimeProperty(String name, Object obj) {
        this.runtimeProperties.put(name, obj);
    }

    @Override
    public Boolean getPropertyBoolean(String name) {
        String value = this.getProperty(name);
        if (value == null) {
            return null;
        }
        switch (value.toLowerCase()) {
            case "yes": 
            case "true": {
                return true;
            }
            case "no": 
            case "false": {
                return false;
            }
        }
        return null;
    }

    public Boolean getPropertyBoolean(String name, boolean defaultValue) {
        Boolean value = this.getPropertyBoolean(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Integer getPropertyInteger(String name) {
        String value = this.getProperty(name);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Integer getPropertyInteger(String name, Integer defaultValue, boolean positive) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        int result = Integer.parseInt(value);
        if (positive && result < 0) {
            return defaultValue;
        }
        return result;
    }

    @Override
    public Long getPropertyLong(String name) {
        String value = this.getProperty(name);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    public Long getPropertyLong(String name, Long defaultValue, boolean positive) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        long result = Long.parseLong(value);
        if (positive && result < 0L) {
            return (long)defaultValue;
        }
        return result;
    }

    public Integer getPropertyMegabytes(String name, Integer defaultValue) {
        String cacheMem = this.element.getAttribute(name);
        if (cacheMem != null) {
            Integer result;
            if (cacheMem.endsWith("M") || cacheMem.endsWith("m")) {
                cacheMem = cacheMem.substring(0, cacheMem.length() - 1);
            }
            if ((result = Integer.valueOf(cacheMem)) < 0) {
                return defaultValue;
            }
            return result;
        }
        return defaultValue;
    }

    public String getConfigFilePath() {
        return "";
    }

    @Override
    public Set<String> getProperties() {
        HashSet<String> properties = new HashSet<String>();
        NamedNodeMap attrs = this.element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            if ("xmlns".equals(attrs.item(i).getPrefix())) continue;
            properties.add(attrs.item(i).getNodeName());
        }
        NodeList children = this.element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            properties.add(child.getNodeName());
        }
        return properties;
    }

    @Override
    public synchronized Object putObject(String name, Object object) {
        if (this.objects == null) {
            this.objects = new HashMap<String, Object>();
        }
        return this.objects.put(name, object);
    }

    @Override
    public synchronized Object getObject(String name) {
        if (this.objects == null) {
            return null;
        }
        return this.objects.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkForUpdates(Element element) {
        ConfigurationImpl configurationImpl = this;
        synchronized (configurationImpl) {
            if (!this.saving && this.configuredObjectReference != null && this.configuredObjectReference.get() != null) {
                this.clearCache();
                this.element = element;
                Configurator.configure((Configurable)this.configuredObjectReference.get(), this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws PermissionDeniedException, ConfigurationException {
        if (this.element instanceof ElementImpl) {
            return;
        }
        ConfigurationImpl configurationImpl = this;
        synchronized (configurationImpl) {
            try {
                this.saving = true;
                if (this.configuredObjectReference != null && this.configuredObjectReference.get() != null) {
                    Configurator.save((Configurable)this.configuredObjectReference.get(), ((DocumentImpl)this.element.getOwnerDocument()).getURI());
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            finally {
                this.saving = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(DBBroker broker) throws PermissionDeniedException, ConfigurationException {
        if (this.element instanceof ElementImpl) {
            return;
        }
        ConfigurationImpl configurationImpl = this;
        synchronized (configurationImpl) {
            try {
                this.saving = true;
                if (this.configuredObjectReference != null && this.configuredObjectReference.get() != null) {
                    Configurator.save(broker, (Configurable)this.configuredObjectReference.get(), ((DocumentImpl)this.element.getOwnerDocument()).getURI());
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            finally {
                this.saving = false;
            }
        }
    }

    public boolean equals(Object obj) {
        return this.equals(obj, Optional.empty());
    }

    @Override
    public boolean equals(Object obj, Optional<String> property) {
        if (obj instanceof ConfigurationImpl) {
            ConfigurationImpl conf = (ConfigurationImpl)obj;
            if (!this.getName().equals(conf.getName())) {
                return false;
            }
            String name = property.orElse("id");
            Optional<String> value = Optional.ofNullable(this.getProperty(name));
            return value.map(v -> v.equals(conf.getProperty(name))).orElse(false);
        }
        return false;
    }
}

