/*
 * Decompiled with CFR 0.152.
 */
package org.exist.config;

import java.lang.reflect.Method;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.Reference;

public class ReferenceImpl<R, O extends Configurable>
implements Reference<R, O>,
Configurable {
    private R resolver;
    private String methodName;
    private String name;
    private O cached = null;

    public ReferenceImpl(R resolver, String methodName, String name) {
        this.resolver = resolver;
        this.methodName = methodName;
        this.name = name;
    }

    @Deprecated
    public ReferenceImpl(R resolver, O cached) {
        this.resolver = resolver;
        this.methodName = null;
        this.name = null;
        this.cached = cached;
    }

    public ReferenceImpl(R resolver, O cached, String name) {
        this.resolver = resolver;
        this.methodName = null;
        this.name = name;
        this.cached = cached;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public O resolve() {
        if (this.cached == null) {
            Class<?> clazz = this.resolver.getClass();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(this.methodName) || method.getParameterTypes().length != 1 || !"java.lang.String".equals(method.getParameterTypes()[0].getName())) continue;
                try {
                    this.cached = (Configurable)method.invoke(this.resolver, this.name);
                    break;
                }
                catch (Exception e) {
                    this.cached = null;
                }
            }
        }
        return this.cached;
    }

    @Override
    public R resolver() {
        return this.resolver;
    }

    @Override
    public boolean isConfigured() {
        Object obj = this.resolve();
        return obj != null && obj.isConfigured();
    }

    @Override
    public Configuration getConfiguration() {
        Object obj = this.resolve();
        if (obj == null) {
            return null;
        }
        return obj.getConfiguration();
    }
}

