/*
 * Decompiled with CFR 0.152.
 */
package org.exist.config.mapper;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.Configurator;
import org.exist.config.annotation.NewClass;
import org.exist.config.mapper.CallMethod;

public class Constructor {
    private static Map<Object, Configuration> configurations = new HashMap<Object, Configuration>();

    public static Configuration getConfiguration(Object obj) {
        return configurations.get(obj);
    }

    public static Object load(NewClass newClazz, Configurable instance, Configuration conf) {
        String url = newClazz.mapper();
        if (url == null) {
            Configurator.LOG.error("Field must have 'ConfigurationFieldClassMask' annotation or registered mapping instruction for class '" + newClazz.name() + "' [" + conf.getName() + "], skip instance creation.");
            return null;
        }
        InputStream is = instance.getClass().getClassLoader().getResourceAsStream(url);
        if (is == null) {
            Configurator.LOG.error("Registered mapping instruction for class '" + newClazz.name() + "' missing resource '" + url + "', skip instance creation.");
            return null;
        }
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader(is);
            Object obj = null;
            Stack objs = new Stack();
            Stack<CallMethod> instructions = new Stack<CallMethod>();
            block6: while (reader.hasNext()) {
                int eventType = reader.next();
                switch (eventType) {
                    case 1: {
                        String localName = reader.getLocalName();
                        if ("class".equals(localName)) {
                            if (!"name".equals(reader.getAttributeLocalName(0))) {
                                Configurator.LOG.error("class element first attribute must be 'name', skip instance creation.");
                                return null;
                            }
                            String clazzName = reader.getAttributeValue(0);
                            Class<?> clazz = Class.forName(clazzName);
                            java.lang.reflect.Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                            Object newInstance = constructor.newInstance(new Object[0]);
                            if (obj == null) {
                                obj = newInstance;
                            }
                            objs.add(newInstance);
                            if (instructions.empty()) continue block6;
                            ((CallMethod)instructions.peek()).setValue(newInstance);
                            break;
                        }
                        if (!"callMethod".equals(localName)) break;
                        Configuration _conf_ = conf;
                        if (!instructions.empty()) {
                            _conf_ = ((CallMethod)instructions.peek()).getConfiguration();
                        }
                        CallMethod call = new CallMethod(objs.peek(), _conf_);
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            call.set(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                        }
                        instructions.add(call);
                        break;
                    }
                    case 2: {
                        String localName = reader.getLocalName();
                        if ("class".equals(localName)) {
                            objs.pop();
                            break;
                        }
                        if (!"callMethod".equals(localName)) break;
                        CallMethod call = (CallMethod)instructions.pop();
                        call.eval();
                    }
                }
            }
            configurations.put(obj, conf);
            return obj;
        }
        catch (Exception e) {
            Configurator.LOG.error((Object)e);
            return null;
        }
    }
}

