/*
 * Decompiled with CFR 0.152.
 */
package org.exist.debuggee;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.debuggee.Debuggee;
import org.exist.debuggee.DummyDebuggee;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;

public class DebuggeeFactory {
    private static final Logger LOG = LogManager.getLogger(DebuggeeFactory.class);
    private static Debuggee instance = null;

    public static Debuggee getInstance() {
        if (instance == null) {
            String className = System.getProperty("exist.debuggee", "org.exist.debuggee.DebuggeeImpl");
            try {
                Class<?> clazz = Class.forName(className);
                if (!Debuggee.class.isAssignableFrom(clazz)) {
                    LOG.warn("Class " + className + " does not implement interface Debuggee. Using fallback.");
                } else {
                    instance = (Debuggee)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Class not found for debuggee: " + className);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Failed to instantiate class for debuggee: " + className);
            }
            catch (InstantiationException e) {
                LOG.warn("Failed to instantiate class for debuggee: " + className);
            }
            if (instance == null) {
                instance = new DummyDebuggee();
            }
        }
        return instance;
    }

    public static void checkForDebugRequest(HttpServletRequest request, XQueryContext context) throws XPathException {
        String idekey;
        String xdebug = request.getParameter("XDEBUG_SESSION_START");
        if (xdebug != null) {
            context.declareVariable(Debuggee.SESSION, (Object)xdebug);
        } else {
            xdebug = request.getParameter("XDEBUG_SESSION");
            if (xdebug != null) {
                context.declareVariable(Debuggee.SESSION, (Object)xdebug);
            } else {
                Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (int i = 0; i < cookies.length; ++i) {
                        if (!"XDEBUG_SESSION".equals(cookies[i].getName())) continue;
                        context.declareVariable(Debuggee.SESSION, (Object)cookies[i].getValue());
                        break;
                    }
                }
            }
        }
        if (context.requireDebugMode() && (idekey = request.getParameter("KEY")) != null) {
            context.declareVariable(Debuggee.IDEKEY, (Object)idekey);
        }
    }
}

