/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.INode;
import org.exist.dom.QName;
import org.exist.util.hashtable.Object2ObjectHashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    private static final int DEFAULT_SIZE = 10;
    private final IndexedHashMap<QName, Node> namedNodes = new IndexedHashMap(10);
    private final Document ownerDocument;
    private final boolean attributesOnly;

    public NamedNodeMapImpl(Document ownerDocument, boolean attributesOnly) {
        this.ownerDocument = ownerDocument;
        this.attributesOnly = attributesOnly;
    }

    @Override
    public Node getNamedItem(String name) {
        try {
            return this.getNamedItem(new QName(name));
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, "Invalid name");
        }
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return this.getNamedItem(new QName(localName, namespaceURI));
    }

    private Node getNamedItem(QName qname) {
        return this.namedNodes.get(qname);
    }

    @Override
    public Node setNamedItem(Node arg) throws DOMException {
        try {
            return this.setNamedItem(new QName(arg.getNodeName()), arg);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, "Invalid name");
        }
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        return this.setNamedItem(new QName(arg.getLocalName(), arg.getNamespaceURI()), arg);
    }

    public Node setNamedItem(INode arg) throws DOMException {
        return this.setNamedItem(arg.getQName(), arg);
    }

    private Node setNamedItem(QName qname, Node arg) {
        if (arg.getNodeType() == 9 && arg != this.ownerDocument || arg.getOwnerDocument() != this.ownerDocument) {
            throw new DOMException(4, "Owning document IDs do not match");
        }
        if (this.attributesOnly && arg.getNodeType() != 2 && arg.getNodeType() != 101) {
            throw new DOMException(3, "This map is for attributes, but setNamedItem was called on a: " + arg.getClass().getName());
        }
        return this.namedNodes.put(qname, arg);
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        try {
            return this.removeNamedItem(new QName(name));
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, "Invalid name");
        }
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return this.removeNamedItem(new QName(localName, namespaceURI));
    }

    private Node removeNamedItem(QName qname) throws DOMException {
        Node previous = this.namedNodes.remove(qname);
        if (previous != null) {
            return previous;
        }
        throw new DOMException(8, "No such named value is present in the map");
    }

    @Override
    public Node item(int index) {
        if (index >= this.namedNodes.size()) {
            return null;
        }
        return this.namedNodes.get(index);
    }

    @Override
    public int getLength() {
        return this.namedNodes.size();
    }

    private static final class IndexedHashMap<K, V> {
        private final Object2ObjectHashMap<K, V> map;
        private final List<K> keys;

        public IndexedHashMap(int initialSize) {
            this.map = new Object2ObjectHashMap(initialSize);
            this.keys = new ArrayList<K>(initialSize);
        }

        public final V put(K key, V value) {
            V current = this.map.get(key);
            this.map.put(key, value);
            if (current == null) {
                this.keys.add(key);
            }
            return current;
        }

        public final V get(K key) {
            return this.map.get(key);
        }

        public final V get(int index) {
            return this.map.get(this.keys.get(index));
        }

        public final V remove(K key) {
            if (this.keys.remove(key)) {
                return this.map.remove(key);
            }
            return null;
        }

        public final int size() {
            return this.keys.size();
        }
    }
}

