/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.interpreter.Context;
import org.exist.util.XMLChar;

public class QName
implements Comparable<QName> {
    public static final String WILDCARD = "*";
    private static final char COLON = ':';
    public static final QName EMPTY_QNAME;
    public static final QName DOCUMENT_QNAME;
    public static final QName TEXT_QNAME;
    public static final QName COMMENT_QNAME;
    public static final QName DOCTYPE_QNAME;
    private final String localPart;
    private final String namespaceURI;
    private final String prefix;
    private final byte nameType;
    private static final Pattern ptnClarkNotation;

    public QName(String localPart, String namespaceURI, String prefix, byte nameType) {
        this.localPart = localPart;
        this.namespaceURI = namespaceURI == null ? "" : namespaceURI;
        this.prefix = prefix;
        this.nameType = nameType;
    }

    public QName(String localPart, String namespaceURI, String prefix) {
        this(localPart, namespaceURI, prefix, 0);
    }

    public QName(String localPart, String namespaceURI, byte nameType) {
        this(localPart, namespaceURI, null, nameType);
    }

    public QName(String localPart, String namespaceURI) {
        this(localPart, namespaceURI, null);
    }

    public QName(QName other, byte nameType) {
        this(other.localPart, other.namespaceURI, other.prefix, nameType);
    }

    public QName(QName other) {
        this(other.localPart, other.namespaceURI, other.prefix, other.nameType);
    }

    public QName(String name) throws IllegalQNameException {
        this(QName.extractLocalName(name), "", QName.extractPrefix(name));
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public boolean hasNamespace() {
        return !this.namespaceURI.equals("");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public byte getNameType() {
        return this.nameType;
    }

    public String getStringValue() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return this.prefix + ':' + this.localPart;
        }
        return this.localPart;
    }

    @Deprecated
    public String toString() {
        return this.getStringValue();
    }

    @Override
    public int compareTo(QName other) {
        int c = this.namespaceURI.compareTo(other.namespaceURI);
        return c == 0 ? this.localPart.compareTo(other.localPart) : c;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof QName)) {
            return false;
        }
        QName qnOther = (QName)other;
        return this.namespaceURI.equals(qnOther.namespaceURI) && this.localPart.equals(qnOther.localPart);
    }

    public boolean matches(QName qnOther) {
        if (this.equals(qnOther)) {
            return true;
        }
        if (this == WildcardQName.instance || qnOther == WildcardQName.instance) {
            return true;
        }
        if ((this.localPart.equals(WILDCARD) || qnOther.localPart.equals(WILDCARD)) && this.namespaceURI.equals(qnOther.namespaceURI)) {
            return true;
        }
        if ((this.namespaceURI.equals(WILDCARD) || qnOther.namespaceURI.equals(WILDCARD)) && this.localPart.equals(qnOther.localPart)) {
            return true;
        }
        return this.namespaceURI.equals(WILDCARD) && this.localPart.equals(WILDCARD) || qnOther.namespaceURI.equals(WILDCARD) || qnOther.localPart.equals(WILDCARD);
    }

    public int hashCode() {
        return this.namespaceURI.hashCode() ^ this.localPart.hashCode();
    }

    public javax.xml.namespace.QName toJavaQName() {
        return new javax.xml.namespace.QName(this.namespaceURI, this.localPart, this.prefix == null ? "" : this.prefix);
    }

    public static String extractPrefix(String qname) throws IllegalQNameException {
        int p = qname.indexOf(58);
        if (p == -1) {
            return null;
        }
        if (p == 0) {
            throw new IllegalQNameException(Validity.INVALID_PREFIX.val, "Illegal QName: starts with a :");
        }
        if (Character.isDigit(qname.substring(0, 1).charAt(0))) {
            throw new IllegalQNameException(Validity.INVALID_PREFIX.val, "Illegal QName: starts with a digit");
        }
        return qname.substring(0, p);
    }

    public static String extractLocalName(String qname) throws IllegalQNameException {
        int p = qname.indexOf(58);
        if (p == -1) {
            return qname;
        }
        if (p == 0 || p == qname.length() - 1) {
            throw new IllegalQNameException(Validity.ILLEGAL_FORMAT.val, "Illegal QName: starts or ends with a ':'");
        }
        byte validity = QName.isQName(qname);
        if (validity != Validity.VALID.val) {
            throw new IllegalQNameException(validity, "Illegal QName: '" + qname + "'.");
        }
        return qname.substring(p + 1);
    }

    public static QName parse(String namespaceURI, String qname) throws IllegalQNameException {
        int p = qname.indexOf(58);
        if (p == -1) {
            return new QName(qname, namespaceURI);
        }
        byte validity = QName.isQName(qname);
        if (validity != Validity.VALID.val) {
            throw new IllegalQNameException(validity, "Illegal QName: '" + qname + "'");
        }
        return new QName(qname.substring(p + 1), namespaceURI, qname.substring(0, p));
    }

    public static QName parse(Context context, String qname, String defaultNS) throws IllegalQNameException {
        String namespaceURI;
        Matcher clarkNotation;
        if (qname.length() > 0 && qname.charAt(0) == '{' && (clarkNotation = ptnClarkNotation.matcher(qname)).matches()) {
            String ns = clarkNotation.group(1);
            String localPart = clarkNotation.group(2);
            return new QName(localPart, ns);
        }
        String prefix = QName.extractPrefix(qname);
        if (prefix != null) {
            namespaceURI = context.getURIForPrefix(prefix);
            if (namespaceURI == null) {
                throw new IllegalQNameException(Validity.INVALID_PREFIX.val, "No namespace defined for prefix " + prefix);
            }
        } else {
            namespaceURI = defaultNS;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        return new QName(QName.extractLocalName(qname), namespaceURI, prefix);
    }

    public static QName parse(Context context, String qname) throws IllegalQNameException {
        return QName.parse(context, qname, context.getURIForPrefix(""));
    }

    public final byte isValid(boolean allowWildcards) {
        byte result = Validity.VALID.val;
        if (!allowWildcards || this != WildcardQName.getInstance()) {
            if (!(this instanceof WildcardLocalPartQName && allowWildcards || XMLChar.isValidNCName(this.localPart))) {
                result = (byte)(result ^ Validity.INVALID_LOCAL_PART.val);
            }
            if (this.prefix != null && !XMLChar.isValidNCName(this.prefix)) {
                result = (byte)(result ^ Validity.INVALID_PREFIX.val);
            }
        }
        return result;
    }

    public static final byte isQName(String name) {
        int colon = name.indexOf(58);
        if (colon == -1) {
            return XMLChar.isValidNCName(name) ? Validity.VALID.val : Validity.INVALID_LOCAL_PART.val;
        }
        if (colon == 0 || colon == name.length() - 1) {
            return Validity.ILLEGAL_FORMAT.val;
        }
        if (!XMLChar.isValidNCName(name.substring(0, colon))) {
            return Validity.INVALID_PREFIX.val;
        }
        if (!XMLChar.isValidNCName(name.substring(colon + 1))) {
            return Validity.INVALID_LOCAL_PART.val;
        }
        return Validity.VALID.val;
    }

    public static QName fromJavaQName(javax.xml.namespace.QName jQn) {
        return new QName(jQn.getLocalPart(), jQn.getNamespaceURI(), jQn.getPrefix());
    }

    static {
        DOCUMENT_QNAME = EMPTY_QNAME = new QName("", "");
        TEXT_QNAME = EMPTY_QNAME;
        COMMENT_QNAME = EMPTY_QNAME;
        DOCTYPE_QNAME = EMPTY_QNAME;
        ptnClarkNotation = Pattern.compile("\\{([^&{}]*)\\}([^&{}:]+)");
    }

    public static class IllegalQNameException
    extends Exception {
        private final byte validity;

        public IllegalQNameException(byte validity) {
            super(IllegalQNameException.asMessage(validity));
            this.validity = validity;
            if (validity == Validity.VALID.val) {
                throw new IllegalArgumentException("Cannot construct an IllegalQNameException with validity == VALID");
            }
        }

        public IllegalQNameException(byte validity, String message) {
            super(message + ". " + IllegalQNameException.asMessage(validity));
            this.validity = validity;
            if (validity == Validity.VALID.val) {
                throw new IllegalArgumentException("Cannot construct an IllegalQNameException with validity == VALID");
            }
        }

        public byte getValidity() {
            return this.validity;
        }

        private static String asMessage(byte validity) {
            StringBuilder builder = new StringBuilder("QName is invalid:");
            for (Validity v : Validity.values()) {
                if ((validity & v.val) != validity) continue;
                builder.append(" ").append(v.name());
            }
            return builder.toString();
        }
    }

    public static enum Validity {
        VALID(0),
        INVALID_LOCAL_PART(1),
        INVALID_NAMESPACE(2),
        INVALID_PREFIX(4),
        ILLEGAL_FORMAT(8);

        public final byte val;

        private Validity(byte val) {
            this.val = val;
        }
    }

    public static class WildcardLocalPartQName
    extends QName
    implements PartialQName {
        public WildcardLocalPartQName(String namespaceURI) {
            super(QName.WILDCARD, namespaceURI);
        }

        public WildcardLocalPartQName(String namespaceURI, byte nameType) {
            super(QName.WILDCARD, namespaceURI, nameType);
        }

        public WildcardLocalPartQName(String namespaceURI, String prefix) {
            super(QName.WILDCARD, namespaceURI, prefix);
        }

        public static WildcardLocalPartQName parseFromPrefix(Context context, String prefix, String defaultNS) throws IllegalQNameException {
            String namespaceURI;
            if (prefix != null) {
                namespaceURI = context.getURIForPrefix(prefix);
                if (namespaceURI == null) {
                    throw new IllegalQNameException(Validity.INVALID_PREFIX.val, "No namespace defined for prefix " + prefix);
                }
            } else {
                namespaceURI = defaultNS;
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            return new WildcardLocalPartQName(namespaceURI, prefix);
        }

        public static WildcardLocalPartQName parseFromPrefix(Context context, String prefix) throws IllegalQNameException {
            return WildcardLocalPartQName.parseFromPrefix(context, prefix, context.getURIForPrefix(""));
        }
    }

    public static class WildcardNamespaceURIQName
    extends QName
    implements PartialQName {
        public WildcardNamespaceURIQName(String localPart) {
            super(localPart, QName.WILDCARD);
        }

        public WildcardNamespaceURIQName(String localPart, byte nameType) {
            super(localPart, QName.WILDCARD, nameType);
        }
    }

    public static class WildcardQName
    extends QName
    implements PartialQName {
        private static final WildcardQName instance = new WildcardQName();

        public static WildcardQName getInstance() {
            return instance;
        }

        private WildcardQName() {
            super(QName.WILDCARD, QName.WILDCARD, QName.WILDCARD);
        }
    }

    public static interface PartialQName {
    }
}

