/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.CollectionConfiguration;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.CDATASectionImpl;
import org.exist.dom.persistent.CommentImpl;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.TextImpl;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.txn.Txn;
import org.exist.util.pool.NodePool;
import org.w3c.dom.DOMException;

public class DOMIndexer {
    private static final Logger LOG = LogManager.getLogger(DOMIndexer.class);
    private static final QName ROOT_QNAME = new QName("temp", "http://exist.sourceforge.net/NS/exist", "exist");
    private final DBBroker broker;
    private final Txn transaction;
    private final DocumentImpl doc;
    private final org.exist.dom.persistent.DocumentImpl targetDoc;
    private final IndexSpec indexSpec;
    private final Stack<ElementImpl> stack = new Stack();
    private StoredNode prevNode = null;
    private final TextImpl text = new TextImpl();
    private final CommentImpl comment = new CommentImpl();
    private final ProcessingInstructionImpl pi = new ProcessingInstructionImpl();

    public DOMIndexer(DBBroker broker, Txn transaction, DocumentImpl doc, org.exist.dom.persistent.DocumentImpl targetDoc) {
        this.broker = broker;
        this.transaction = transaction;
        this.doc = doc;
        this.targetDoc = targetDoc;
        CollectionConfiguration config = targetDoc.getCollection().getConfiguration(broker);
        this.indexSpec = config != null ? config.getIndexConfiguration() : null;
    }

    public void scan() throws EXistException {
        DocumentTypeImpl dt = new DocumentTypeImpl("temp", null, "");
        this.targetDoc.setDocumentType(dt);
    }

    public void store() {
        int top;
        ElementImpl elem = new ElementImpl(ROOT_QNAME, this.broker.getBrokerPool().getSymbols());
        elem.setNodeId(this.broker.getBrokerPool().getNodeFactory().createInstance());
        elem.setOwnerDocument(this.targetDoc);
        elem.setChildCount(this.doc.getChildCount());
        elem.addNamespaceMapping("exist", "http://exist.sourceforge.net/NS/exist");
        NodePath path = new NodePath();
        path.addComponent(ROOT_QNAME);
        this.stack.push(elem);
        this.broker.storeNode(this.transaction, elem, path, this.indexSpec);
        this.targetDoc.appendChild(elem);
        elem.setChildCount(0);
        int n = top = this.doc.size > 1 ? 1 : -1;
        while (top > 0) {
            this.store(top, path);
            top = this.doc.getNextSiblingFor(top);
        }
        this.stack.pop();
        this.broker.endElement(elem, path, null);
        path.removeLastComponent();
    }

    private void store(int top, NodePath currentPath) {
        int nodeNr = top;
        while (nodeNr > 0) {
            this.startNode(nodeNr, currentPath);
            int nextNode = this.doc.getFirstChildFor(nodeNr);
            while (nextNode == -1) {
                this.endNode(nodeNr, currentPath);
                if (top == nodeNr) break;
                nextNode = this.doc.getNextSiblingFor(nodeNr);
                if (nextNode != -1 || (nodeNr = this.doc.getParentNodeFor(nodeNr)) != -1 && top != nodeNr) continue;
                this.endNode(nodeNr, currentPath);
                nextNode = -1;
                break;
            }
            nodeNr = nextNode;
        }
    }

    private void startNode(int nodeNr, NodePath currentPath) {
        switch (this.doc.nodeKind[nodeNr]) {
            case 1: {
                ElementImpl elem = (ElementImpl)NodePool.getInstance().borrowNode((short)1);
                if (this.stack.empty()) {
                    elem.setNodeId(this.broker.getBrokerPool().getNodeFactory().createInstance());
                    this.initElement(nodeNr, elem);
                    this.stack.push(elem);
                    this.broker.storeNode(this.transaction, elem, currentPath, this.indexSpec);
                    this.targetDoc.appendChild(elem);
                    elem.setChildCount(0);
                } else {
                    ElementImpl last = this.stack.peek();
                    this.initElement(nodeNr, elem);
                    last.appendChildInternal(this.prevNode, elem);
                    this.stack.push(elem);
                    this.broker.storeNode(this.transaction, elem, currentPath, this.indexSpec);
                    elem.setChildCount(0);
                }
                this.setPrevious(null);
                currentPath.addComponent(elem.getQName());
                this.storeAttributes(nodeNr, elem, currentPath);
                break;
            }
            case 3: {
                if (this.prevNode != null && (this.prevNode.getNodeType() == 3 || this.prevNode.getNodeType() == 4)) break;
                ElementImpl last = this.stack.peek();
                this.text.setData(new String(this.doc.characters, this.doc.alpha[nodeNr], this.doc.alphaLen[nodeNr]));
                this.text.setOwnerDocument(this.targetDoc);
                last.appendChildInternal(this.prevNode, this.text);
                this.setPrevious(this.text);
                this.broker.storeNode(this.transaction, this.text, null, this.indexSpec);
                break;
            }
            case 4: {
                ElementImpl last = this.stack.peek();
                CDATASectionImpl cdata = (CDATASectionImpl)NodePool.getInstance().borrowNode((short)4);
                cdata.setData(this.doc.characters, this.doc.alpha[nodeNr], this.doc.alphaLen[nodeNr]);
                cdata.setOwnerDocument(this.targetDoc);
                last.appendChildInternal(this.prevNode, cdata);
                this.setPrevious(cdata);
                this.broker.storeNode(this.transaction, cdata, null, this.indexSpec);
                break;
            }
            case 8: {
                this.comment.setData(this.doc.characters, this.doc.alpha[nodeNr], this.doc.alphaLen[nodeNr]);
                this.comment.setOwnerDocument(this.targetDoc);
                if (this.stack.empty()) {
                    this.comment.setNodeId(NodeId.DOCUMENT_NODE);
                    this.targetDoc.appendChild(this.comment);
                    this.broker.storeNode(this.transaction, this.comment, null, this.indexSpec);
                    break;
                }
                ElementImpl last = this.stack.peek();
                last.appendChildInternal(this.prevNode, this.comment);
                this.broker.storeNode(this.transaction, this.comment, null, this.indexSpec);
                this.setPrevious(this.comment);
                break;
            }
            case 7: {
                QName qn = this.doc.nodeName[nodeNr];
                this.pi.setTarget(qn.getLocalPart());
                this.pi.setData(new String(this.doc.characters, this.doc.alpha[nodeNr], this.doc.alphaLen[nodeNr]));
                this.pi.setOwnerDocument(this.targetDoc);
                if (this.stack.empty()) {
                    this.pi.setNodeId(NodeId.DOCUMENT_NODE);
                    this.targetDoc.appendChild(this.pi);
                } else {
                    ElementImpl last = this.stack.peek();
                    last.appendChildInternal(this.prevNode, this.pi);
                    this.setPrevious(this.pi);
                }
                this.broker.storeNode(this.transaction, this.pi, null, this.indexSpec);
                break;
            }
            default: {
                LOG.debug("Skipped indexing of in-memory node of type " + this.doc.nodeKind[nodeNr]);
            }
        }
    }

    private void initElement(int nodeNr, ElementImpl elem) {
        short attribs = (short)this.doc.getAttributesCountFor(nodeNr);
        elem.setOwnerDocument(this.targetDoc);
        elem.setAttributes(attribs);
        elem.setChildCount(this.doc.getChildCountFor(nodeNr) + attribs);
        elem.setNodeName(this.doc.nodeName[nodeNr], this.broker.getBrokerPool().getSymbols());
        Map<String, String> ns = this.getNamespaces(nodeNr);
        if (ns != null) {
            elem.setNamespaceMappings(ns);
        }
    }

    private Map<String, String> getNamespaces(int nodeNr) {
        int ns = this.doc.alphaLen[nodeNr];
        if (ns < 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (ns < this.doc.nextNamespace && this.doc.namespaceParent[ns] == nodeNr) {
            QName qn = this.doc.namespaceCode[ns];
            if ("xmlns".equals(qn.getLocalPart())) {
                map.put("", qn.getNamespaceURI());
            } else {
                map.put(qn.getLocalPart(), qn.getNamespaceURI());
            }
            ++ns;
        }
        return map;
    }

    private void storeAttributes(int nodeNr, ElementImpl elem, NodePath path) throws DOMException {
        int attr = this.doc.alpha[nodeNr];
        if (attr > -1) {
            while (attr < this.doc.nextAttr && this.doc.attrParent[attr] == nodeNr) {
                QName qn = this.doc.attrName[attr];
                AttrImpl attrib = (AttrImpl)NodePool.getInstance().borrowNode((short)2);
                attrib.setNodeName(qn, this.broker.getBrokerPool().getSymbols());
                attrib.setValue(this.doc.attrValue[attr]);
                attrib.setOwnerDocument(this.targetDoc);
                elem.appendChildInternal(this.prevNode, attrib);
                this.setPrevious(attrib);
                this.broker.storeNode(this.transaction, attrib, path, this.indexSpec);
                ++attr;
            }
        }
    }

    private void endNode(int nodeNr, NodePath currentPath) {
        if (this.doc.nodeKind[nodeNr] == 1) {
            ElementImpl last = this.stack.pop();
            this.broker.endElement(last, currentPath, null);
            currentPath.removeLastComponent();
            this.setPrevious(last);
        }
    }

    private void setPrevious(StoredNode previous) {
        if (!(this.prevNode == null || this.prevNode.getNodeType() != 3 && this.prevNode.getNodeType() != 8 && this.prevNode.getNodeType() != 7 || previous != null && this.prevNode.getNodeType() == previous.getNodeType())) {
            this.prevNode.clear();
        }
        this.prevNode = previous;
    }
}

