/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import java.util.HashMap;
import java.util.Map;
import org.exist.dom.INodeHandle;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.persistent.NodeProxy;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DocumentBuilderReceiver
implements ContentHandler,
LexicalHandler,
Receiver {
    private MemTreeBuilder builder = null;
    private final boolean explicitNSDecl;
    private Map<String, String> namespaces = null;
    private boolean checkNS = false;
    private boolean suppressWhitespace = true;

    public DocumentBuilderReceiver() {
        this(null);
    }

    public DocumentBuilderReceiver(MemTreeBuilder builder) {
        this(builder, false);
    }

    public DocumentBuilderReceiver(MemTreeBuilder builder, boolean declareNamespaces) {
        this.builder = builder;
        this.explicitNSDecl = declareNamespaces;
    }

    public void setCheckNS(boolean checkNS) {
        this.checkNS = checkNS;
    }

    public void setSuppressWhitespace(boolean flag) {
        this.suppressWhitespace = flag;
    }

    @Override
    public Document getDocument() {
        return this.builder.getDocument();
    }

    public XQueryContext getContext() {
        return this.builder.getContext();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.builder == null) {
            this.builder = new MemTreeBuilder();
            this.builder.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.builder.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        if (prefix == null || prefix.length() == 0) {
            this.builder.setDefaultNamespace(namespaceURI);
        }
        if (!this.explicitNSDecl) {
            return;
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        this.namespaces.put(prefix, namespaceURI);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (prefix == null || prefix.length() == 0) {
            this.builder.setDefaultNamespace("");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.builder.startElement(namespaceURI, localName, qName, attrs);
        this.declareNamespaces();
    }

    private void declareNamespaces() {
        if (this.explicitNSDecl && this.namespaces != null) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                this.builder.namespaceNode(entry.getKey(), entry.getValue());
            }
            this.namespaces.clear();
        }
    }

    @Override
    public void startElement(QName qname, AttrList attribs) {
        this.builder.startElement(this.checkNS(true, qname), null);
        this.declareNamespaces();
        if (attribs != null) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                this.builder.addAttribute(attribs.getQName(i), attribs.getValue(i));
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.builder.endElement();
    }

    @Override
    public void endElement(QName qname) throws SAXException {
        this.builder.endElement();
    }

    public void addReferenceNode(NodeProxy proxy) throws SAXException {
        this.builder.addReferenceNode(proxy);
    }

    public void addNamespaceNode(QName qname) throws SAXException {
        this.builder.namespaceNode(qname, this.checkNS);
    }

    @Override
    public void characters(CharSequence seq) throws SAXException {
        this.builder.characters(seq);
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        this.builder.characters(ch, start, len);
    }

    @Override
    public void attribute(QName qname, String value) throws SAXException {
        try {
            this.builder.addAttribute(this.checkNS(false, qname), value);
        }
        catch (DOMException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        if (!this.suppressWhitespace) {
            this.builder.characters(ch, start, len);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.builder.processingInstruction(target, data);
    }

    @Override
    public void cdataSection(char[] ch, int start, int len) throws SAXException {
        this.builder.cdataSection(new String(ch, start, len));
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void documentType(String name, String publicId, String systemId) throws SAXException {
        this.builder.documentType(name, publicId, systemId);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.builder.comment(ch, start, length);
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void highlightText(CharSequence seq) {
    }

    public void setCurrentNode(INodeHandle node) {
    }

    private QName checkNS(boolean isElement, QName qname) {
        if (this.checkNS) {
            XQueryContext context = this.builder.getContext();
            if (qname.getPrefix() == null) {
                if (!qname.hasNamespace()) {
                    return qname;
                }
                if (isElement) {
                    return qname;
                }
                String prefix = this.generatePrefix(context, context.getInScopePrefix(qname.getNamespaceURI()));
                context.declareInScopeNamespace(prefix, qname.getNamespaceURI());
                return new QName(qname.getLocalPart(), qname.getNamespaceURI(), prefix);
            }
            if (qname.getPrefix().isEmpty() && qname.getNamespaceURI() == null) {
                return qname;
            }
            String inScopeNamespace = context.getInScopeNamespace(qname.getPrefix());
            if (inScopeNamespace == null) {
                context.declareInScopeNamespace(qname.getPrefix(), qname.getNamespaceURI());
            } else if (!inScopeNamespace.equals(qname.getNamespaceURI())) {
                String prefix = this.generatePrefix(context, context.getInScopePrefix(qname.getNamespaceURI()));
                context.declareInScopeNamespace(prefix, qname.getNamespaceURI());
                return new QName(qname.getLocalPart(), qname.getNamespaceURI(), prefix);
            }
        }
        return qname;
    }

    private String generatePrefix(XQueryContext context, String prefix) {
        int i = 0;
        while (prefix == null) {
            prefix = "XXX";
            if (i > 0) {
                prefix = prefix + String.valueOf(i);
            }
            if (context.getInScopeNamespace(prefix) == null) continue;
            prefix = null;
            ++i;
        }
        return prefix;
    }
}

