/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import java.util.HashSet;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;

public class InMemoryNodeSet
extends ValueSequence {
    public static final InMemoryNodeSet EMPTY = new InMemoryNodeSet(0);

    public InMemoryNodeSet() {
    }

    public InMemoryNodeSet(int initialSize) {
        super(initialSize);
    }

    public InMemoryNodeSet(Sequence otherSequence) throws XPathException {
        super(otherSequence);
        HashSet<DocumentImpl> docs = new HashSet<DocumentImpl>();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if (node.getNodeType() == 9) {
                docs.add((DocumentImpl)node);
                continue;
            }
            docs.add(node.getOwnerDocument());
        }
        for (DocumentImpl doc : docs) {
            doc.expand();
        }
    }

    @Override
    public Sequence getAttributes(NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectAttributes(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getDescendantAttributes(NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectDescendantAttributes(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getChildren(NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectChildren(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getChildrenForParent(NodeImpl parent) {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if (!node.getNodeId().isChildOf(parent.getNodeId())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public Sequence getDescendants(boolean includeSelf, NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectDescendants(includeSelf, test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getAncestors(boolean includeSelf, NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectAncestors(includeSelf, test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getParents(NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            NodeImpl parent = (NodeImpl)node.selectParentNode();
            if (parent == null || !test.matches(parent)) continue;
            nodes.add(parent);
        }
        return nodes;
    }

    @Override
    public Sequence getSelf(NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if ((test.getType() != -1 || node.getNodeType() != 2) && !test.matches(node)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public Sequence getPrecedingSiblings(NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectPrecedingSiblings(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getFollowingSiblings(NodeTest test) throws XPathException {
        InMemoryNodeSet nodes = new InMemoryNodeSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectFollowingSiblings(test, nodes);
        }
        return nodes;
    }
}

