/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.numbering.NodeId;
import org.exist.stax.ExtendedXMLStreamReader;

public class InMemoryXMLStreamReader
implements ExtendedXMLStreamReader {
    private static final String NOT_START_ELEMENT = "Cursor is not at the start of an element";
    private final DocumentImpl doc;
    private final NodeImpl rootNode;
    private int currentNode;
    private int state = 7;

    public InMemoryXMLStreamReader(DocumentImpl doc, NodeImpl node) {
        this.doc = doc;
        this.rootNode = node;
        this.currentNode = -1;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (name.equals("node-id")) {
            if (this.currentNode < 0 || this.currentNode >= this.doc.size) {
                return null;
            }
            this.doc.expand();
            return this.doc.nodeId[this.currentNode];
        }
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.currentNode > -1) {
            int next = -1;
            if ((this.state == 1 || this.state == 7) && (next = this.doc.getFirstChildFor(this.currentNode)) < 0) {
                this.state = 2;
                return this.state;
            }
            if (next < 0 && (next = this.doc.next[this.currentNode]) < this.currentNode) {
                this.state = next == 0 ? 8 : 2;
                this.currentNode = next;
                return this.state;
            }
            this.currentNode = next;
        } else {
            this.currentNode = this.rootNode.getNodeNumber();
        }
        switch (this.doc.nodeKind[this.currentNode]) {
            case 3: {
                this.state = 4;
                break;
            }
            case 4: {
                this.state = 12;
                break;
            }
            case 8: {
                this.state = 5;
                break;
            }
            case 7: {
                this.state = 3;
                break;
            }
            case 1: {
                this.state = 1;
            }
        }
        return this.state;
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text");
        }
        int eventType = this.next();
        StringBuilder content = new StringBuilder();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                content.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT");
                }
                throw new XMLStreamException("Unexpected event type " + eventType);
            }
            eventType = this.next();
        }
        return content.toString();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.currentNode != this.rootNode.getNodeNumber() || this.state == 7 || this.state == 1;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public boolean isStartElement() {
        return this.state == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.state == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.state == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        int attrCount = this.doc.getAttributesCountFor(this.currentNode);
        if (attrCount == 0) {
            return null;
        }
        int attrStart = this.doc.alpha[this.currentNode];
        for (int i = 0; i < attrCount; ++i) {
            QName qname = this.doc.attrName[attrStart + i];
            if (namespaceURI != null && !namespaceURI.equals(qname.getNamespaceURI()) || !localName.equals(qname.getLocalPart())) continue;
            return this.doc.attrValue[attrStart + i];
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        return this.doc.getAttributesCountFor(this.currentNode);
    }

    @Override
    public QName getAttributeQName(int index) {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        if (index > this.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int attr = this.doc.alpha[this.currentNode];
        return this.doc.attrName[attr + index];
    }

    @Override
    public javax.xml.namespace.QName getAttributeName(int index) {
        return this.getAttributeQName(index).toJavaQName();
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        return this.getAttributeQName(index).getNamespaceURI();
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        return this.getAttributeQName(index).getLocalPart();
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        return this.getAttributeQName(index).getPrefix();
    }

    @Override
    public NodeId getAttributeId(int index) {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        if (index > this.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.doc.expand();
        int attr = this.doc.alpha[this.currentNode];
        return this.doc.attrNodeId[attr + index];
    }

    @Override
    public String getAttributeType(int index) {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        if (index > this.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int attr = this.doc.alpha[this.currentNode];
        int type = this.doc.attrType[attr + index];
        switch (type) {
            case 1: {
                return "ID";
            }
            case 2: {
                return "IDREF";
            }
            case 3: {
                return "IDREFS";
            }
        }
        return "CDATA";
    }

    @Override
    public String getAttributeValue(int index) {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        if (index > this.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int attr = this.doc.alpha[this.currentNode];
        return this.doc.attrValue[attr + index];
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        if (this.state != 1) {
            throw new IllegalStateException(NOT_START_ELEMENT);
        }
        return true;
    }

    @Override
    public int getNamespaceCount() {
        if (this.state != 1 && this.state != 2 && this.state != 13) {
            throw new IllegalStateException("Cursor is not at an element or namespace");
        }
        return this.doc.getNamespacesCountFor(this.currentNode);
    }

    @Override
    public String getNamespacePrefix(int index) {
        if (index > this.getNamespaceCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ns = this.doc.alphaLen[this.currentNode];
        QName nsQName = this.doc.namespaceCode[ns + index];
        return nsQName.getLocalPart();
    }

    @Override
    public String getNamespaceURI(int index) {
        if (index > this.getNamespaceCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ns = this.doc.alphaLen[this.currentNode];
        QName nsQName = this.doc.namespaceCode[ns + index];
        return nsQName.getNamespaceURI();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEventType() {
        return this.state;
    }

    @Override
    public String getText() {
        if (this.state == 4 || this.state == 5 || this.state == 12) {
            return new String(this.doc.characters, this.doc.alpha[this.currentNode], this.doc.alphaLen[this.currentNode]);
        }
        return "";
    }

    @Override
    public char[] getTextCharacters() {
        char[] ch = new char[this.doc.alphaLen[this.currentNode]];
        System.arraycopy(this.doc.characters, this.doc.alpha[this.currentNode], ch, 0, ch.length);
        return ch;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTextStart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTextLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getEncoding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasText() {
        return this.state == 4 || this.state == 5 || this.state == 12;
    }

    @Override
    public Location getLocation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QName getQName() {
        if (this.state == 1 || this.state == 2) {
            return this.doc.nodeName[this.currentNode];
        }
        throw new IllegalStateException("Cursor is not at the start of end of an element");
    }

    @Override
    public javax.xml.namespace.QName getName() {
        return this.getQName().toJavaQName();
    }

    @Override
    public String getLocalName() {
        return this.getQName().getLocalPart();
    }

    @Override
    public boolean hasName() {
        return this.state == 1 || this.state == 2;
    }

    @Override
    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.getQName().getPrefix();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        QName qn = this.doc.nodeName[this.currentNode];
        return qn != null ? qn.getLocalPart() : null;
    }

    @Override
    public String getPIData() {
        return new String(this.doc.characters, this.doc.alpha[this.currentNode], this.doc.alphaLen[this.currentNode]);
    }
}

