/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import java.util.Arrays;
import org.exist.Namespaces;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.xquery.XQueryContext;
import org.w3c.dom.DOMException;
import org.xml.sax.Attributes;

public class MemTreeBuilder {
    private final XQueryContext context;
    private DocumentImpl doc;
    private short level = 1;
    private int[] prevNodeInLevel;
    private String defaultNamespaceURI = "";

    public MemTreeBuilder() {
        this(null);
    }

    public MemTreeBuilder(XQueryContext context) {
        this.context = context;
        this.prevNodeInLevel = new int[15];
        Arrays.fill(this.prevNodeInLevel, -1);
        this.prevNodeInLevel[0] = 0;
    }

    public DocumentImpl getDocument() {
        return this.doc;
    }

    public XQueryContext getContext() {
        return this.context;
    }

    public int getSize() {
        return this.doc.getSize();
    }

    public void startDocument() {
        this.doc = new DocumentImpl(this.context, false);
    }

    public void startDocument(boolean explicitCreation) {
        this.doc = new DocumentImpl(this.context, explicitCreation);
    }

    public void endDocument() {
    }

    public int startElement(String namespaceURI, String localName, String qname, Attributes attributes) {
        int prefixIdx = qname.indexOf(58);
        String prefix = null;
        if (this.context != null && !this.getDefaultNamespace().equals(namespaceURI == null ? "" : namespaceURI)) {
            prefix = this.context.getPrefixForURI(namespaceURI);
        }
        if (prefix == null) {
            String string = prefix = prefixIdx != -1 ? qname.substring(0, prefixIdx) : null;
        }
        if (localName.isEmpty() && prefixIdx > -1) {
            localName = qname.substring(prefixIdx + 1);
        }
        QName qn = new QName(localName, namespaceURI, prefix);
        return this.startElement(qn, attributes);
    }

    public int startElement(QName qname, Attributes attributes) {
        int prevNr;
        int nodeNr = this.doc.addNode((short)1, this.level, qname);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrQName = attributes.getQName(i);
                if (attrQName.startsWith("xmlns")) continue;
                int p = attrQName.indexOf(58);
                String attrNS = attributes.getURI(i);
                String attrPrefix = p != -1 ? attrQName.substring(0, p) : null;
                String attrLocalName = attributes.getLocalName(i);
                QName attrQn = new QName(attrLocalName, attrNS, attrPrefix);
                int type = this.getAttribType(attrQn, attributes.getType(i));
                this.doc.addAttribute(nodeNr, attrQn, attributes.getValue(i), type);
            }
        }
        if (this.level + 1 >= this.prevNodeInLevel.length) {
            int[] t = new int[this.level + 2];
            System.arraycopy(this.prevNodeInLevel, 0, t, 0, this.prevNodeInLevel.length);
            this.prevNodeInLevel = t;
        }
        if ((prevNr = this.prevNodeInLevel[this.level]) > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
        this.level = (short)(this.level + 1);
        return nodeNr;
    }

    private int getAttribType(QName qname, String type) {
        if (qname.equals(Namespaces.XML_ID_QNAME)) {
            return 0;
        }
        if (type.equals("ID")) {
            return 1;
        }
        if (type.equals("IDREF")) {
            return 2;
        }
        if (type.equals("IDREFS")) {
            return 3;
        }
        return 0;
    }

    public void endElement() {
        this.prevNodeInLevel[this.level] = -1;
        this.level = (short)(this.level - 1);
    }

    public int addReferenceNode(NodeProxy proxy) {
        int lastNode = this.doc.getLastNode();
        if (lastNode > 0 && this.level == this.doc.getTreeLevel(lastNode)) {
            int p;
            if (this.doc.getNodeType(lastNode) == 3 && proxy.getNodeType() == 3) {
                this.doc.appendChars(lastNode, proxy.getNodeValue());
                return lastNode;
            }
            if (this.doc.getNodeType(lastNode) == 100 && this.doc.references[p = this.doc.alpha[lastNode]].getNodeType() == 3 && proxy.getNodeType() == 3) {
                String s = this.doc.references[p].getStringValue() + proxy.getStringValue();
                this.doc.replaceReferenceNode(lastNode, s);
                return lastNode;
            }
        }
        int nodeNr = this.doc.addNode((short)100, this.level, null);
        this.doc.addReferenceNode(nodeNr, proxy);
        this.linkNode(nodeNr);
        return nodeNr;
    }

    public int addAttribute(QName qname, String value) {
        int lastNode = this.doc.getLastNode();
        int nodeNr = this.doc.addAttribute(lastNode, qname, value, 0);
        return nodeNr;
    }

    public int characters(char[] ch, int start, int len) {
        int lastNode = this.doc.getLastNode();
        if (lastNode > 0 && this.level == this.doc.getTreeLevel(lastNode)) {
            int p;
            if (this.doc.getNodeType(lastNode) == 3) {
                this.doc.appendChars(lastNode, ch, start, len);
                return lastNode;
            }
            if (this.doc.getNodeType(lastNode) == 100 && this.doc.references[p = this.doc.alpha[lastNode]].getNodeType() == 3) {
                StringBuilder s = new StringBuilder(this.doc.references[p].getStringValue());
                s.append(ch, start, len);
                this.doc.replaceReferenceNode(lastNode, s);
                return lastNode;
            }
        }
        int nodeNr = this.doc.addNode((short)3, this.level, null);
        this.doc.addChars(nodeNr, ch, start, len);
        this.linkNode(nodeNr);
        return nodeNr;
    }

    public int characters(CharSequence s) {
        if (s == null) {
            return -1;
        }
        int lastNode = this.doc.getLastNode();
        if (lastNode > 0 && this.level == this.doc.getTreeLevel(lastNode)) {
            int p;
            if (this.doc.getNodeType(lastNode) == 3 || this.doc.getNodeType(lastNode) == 4) {
                this.doc.appendChars(lastNode, s);
                return lastNode;
            }
            if (this.doc.getNodeType(lastNode) == 100 && (this.doc.references[p = this.doc.alpha[lastNode]].getNodeType() == 3 || this.doc.references[p].getNodeType() == 4)) {
                this.doc.replaceReferenceNode(lastNode, this.doc.references[p].getStringValue() + s);
                return lastNode;
            }
        }
        int nodeNr = this.doc.addNode((short)3, this.level, null);
        this.doc.addChars(nodeNr, s);
        this.linkNode(nodeNr);
        return nodeNr;
    }

    public int comment(CharSequence data) {
        int nodeNr = this.doc.addNode((short)8, this.level, null);
        this.doc.addChars(nodeNr, data);
        this.linkNode(nodeNr);
        return nodeNr;
    }

    public int comment(char[] ch, int start, int len) {
        int nodeNr = this.doc.addNode((short)8, this.level, null);
        this.doc.addChars(nodeNr, ch, start, len);
        this.linkNode(nodeNr);
        return nodeNr;
    }

    public int cdataSection(CharSequence data) {
        int lastNode = this.doc.getLastNode();
        if (lastNode > 0 && this.level == this.doc.getTreeLevel(lastNode)) {
            int p;
            if (this.doc.getNodeType(lastNode) == 3 || this.doc.getNodeType(lastNode) == 4) {
                this.doc.appendChars(lastNode, data);
                return lastNode;
            }
            if (this.doc.getNodeType(lastNode) == 100 && (this.doc.references[p = this.doc.alpha[lastNode]].getNodeType() == 3 || this.doc.references[p].getNodeType() == 4)) {
                this.doc.replaceReferenceNode(lastNode, this.doc.references[p].getStringValue() + data);
                return lastNode;
            }
        }
        int nodeNr = this.doc.addNode((short)4, this.level, null);
        this.doc.addChars(nodeNr, data);
        this.linkNode(nodeNr);
        return nodeNr;
    }

    public int processingInstruction(String target, String data) {
        QName qname = new QName(target, null, null);
        int nodeNr = this.doc.addNode((short)7, this.level, qname);
        this.doc.addChars(nodeNr, data == null ? "" : data);
        this.linkNode(nodeNr);
        return nodeNr;
    }

    public int namespaceNode(String prefix, String uri) {
        QName qname = prefix == null || prefix.isEmpty() ? new QName("xmlns", uri) : new QName(prefix, uri, "xmlns");
        return this.namespaceNode(qname);
    }

    public int namespaceNode(QName qname) {
        return this.namespaceNode(qname, false);
    }

    public int namespaceNode(QName qname, boolean checkNS) {
        QName elemQN;
        int lastNode = this.doc.getLastNode();
        boolean addNode = true;
        if (this.doc.nodeName != null && (elemQN = this.doc.nodeName[lastNode]) != null) {
            String qnPrefix;
            String elemPrefix = elemQN.getPrefix() == null ? "" : elemQN.getPrefix();
            String elemNs = elemQN.getNamespaceURI() == null ? "" : elemQN.getNamespaceURI();
            String string = qnPrefix = qname.getPrefix() == null ? "" : qname.getPrefix();
            if (checkNS && "".equals(elemPrefix) && "".equals(elemNs) && "".equals(qnPrefix) && "xmlns".equals(qname.getLocalPart())) {
                throw new DOMException(14, "Cannot output a namespace node for the default namespace when the element is in no namespace.");
            }
            if (elemPrefix.equals(qname.getLocalPart()) && elemQN.getNamespaceURI() != null) {
                addNode = false;
            }
        }
        return addNode ? this.doc.addNamespace(lastNode, qname) : -1;
    }

    public int documentType(String publicId, String systemId) {
        return -1;
    }

    public void documentType(String name, String publicId, String systemId) {
    }

    private void linkNode(int nodeNr) {
        int prevNr = this.prevNodeInLevel[this.level];
        if (prevNr > -1) {
            this.doc.next[prevNr] = nodeNr;
        }
        this.doc.next[nodeNr] = this.prevNodeInLevel[this.level - 1];
        this.prevNodeInLevel[this.level] = nodeNr;
    }

    public void setReplaceAttributeFlag(boolean replaceAttribute) {
        this.doc.replaceAttribute = replaceAttribute;
    }

    public void setDefaultNamespace(String defaultNamespaceURI) {
        this.defaultNamespaceURI = defaultNamespaceURI;
    }

    private String getDefaultNamespace() {
        return this.defaultNamespaceURI == null ? "" : this.defaultNamespaceURI;
    }
}

