/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import java.util.Iterator;
import java.util.Properties;
import org.apache.xml.utils.XML11Char;
import org.apache.xml.utils.XMLChar;
import org.exist.collections.Collection;
import org.exist.dom.INode;
import org.exist.dom.NodeListImpl;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.ProcessingInstructionImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.EmptyNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.Receiver;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.UntypedAtomicValue;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class NodeImpl<T extends NodeImpl>
implements INode<DocumentImpl, T>,
NodeValue {
    public static final short REFERENCE_NODE = 100;
    public static final short NAMESPACE_NODE = 101;
    protected int nodeNumber;
    protected DocumentImpl document;

    public NodeImpl(DocumentImpl doc, int nodeNumber) {
        this.document = doc;
        this.nodeNumber = nodeNumber;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    @Override
    public int getImplementationType() {
        return 0;
    }

    @Override
    public DocumentSet getDocumentSet() {
        return DocumentSet.EMPTY_DOCUMENT_SET;
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return EmptyNodeSet.EMPTY_COLLECTION_ITERATOR;
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public final QName getQName() {
        switch (this.getNodeType()) {
            case 2: {
                return this.document.attrName[this.nodeNumber];
            }
            case 1: 
            case 7: {
                return this.document.nodeName[this.nodeNumber];
            }
            case 101: {
                return this.document.namespaceCode[this.nodeNumber];
            }
            case 9: {
                return QName.EMPTY_QNAME;
            }
            case 8: {
                return QName.EMPTY_QNAME;
            }
            case 3: {
                return QName.EMPTY_QNAME;
            }
            case 4: {
                return QName.EMPTY_QNAME;
            }
        }
        return null;
    }

    @Override
    public final void setQName(QName qname) {
        switch (this.getNodeType()) {
            case 2: {
                this.document.attrName[this.nodeNumber] = qname;
                break;
            }
            case 1: 
            case 7: {
                this.document.nodeName[this.nodeNumber] = qname;
                break;
            }
            case 101: {
                this.document.namespaceCode[this.nodeNumber] = qname;
            }
        }
    }

    @Override
    public final String getNodeName() {
        switch (this.getNodeType()) {
            case 9: {
                return "#document";
            }
            case 11: {
                return "#document-fragment";
            }
            case 1: 
            case 2: 
            case 101: {
                return this.getQName().getStringValue();
            }
            case 7: {
                return ((ProcessingInstructionImpl)this).getTarget();
            }
            case 3: {
                return "#text";
            }
            case 8: {
                return "#comment";
            }
            case 4: {
                return "#cdata-section";
            }
        }
        return "#unknown";
    }

    @Override
    public String getLocalName() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 101: {
                return this.getQName().getLocalPart();
            }
        }
        return null;
    }

    @Override
    public String getNamespaceURI() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: {
                String nsUri = this.getQName().getNamespaceURI();
                if (nsUri.equals("")) {
                    return null;
                }
                return nsUri;
            }
            case 101: {
                return "http://www.w3.org/2000/xmlns/";
            }
        }
        return null;
    }

    @Override
    public final String getPrefix() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 101: {
                return this.getQName().getPrefix();
            }
        }
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if (prefix == null || this.getNodeType() == 9) {
            return;
        }
        if (this.getOwnerDocument().getXmlVersion().equals("1.0") && !XMLChar.isValidNCName((String)prefix)) {
            throw new DOMException(5, "Prefix '" + prefix + "' in XML 1.0 contains invalid characters");
        }
        if (this.getOwnerDocument().getXmlVersion().equals("1.1") && !XML11Char.isXML11ValidNCName((String)prefix)) {
            throw new DOMException(5, "Prefix '" + prefix + "' in XML 1.1 contains invalid characters");
        }
        if (this.getNamespaceURI() == null) {
            throw new DOMException(14, "Cannot set prefix when namespace is null");
        }
        if (prefix.equals("xml") && !this.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace")) {
            throw new DOMException(14, "Prefix 'xml' is invalid for namespace '" + this.getNamespaceURI() + "'");
        }
        if (this.getNodeType() == 2 && prefix.equals("xmlns") && !this.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
            throw new DOMException(14, "Prefix 'xmlns' is invalid for namespace '" + this.getNamespaceURI() + "'");
        }
        if (this.getNodeType() == 1 || this.getNodeType() == 2) {
            QName qname = this.getQName();
            this.setQName(new QName(qname.getLocalPart(), qname.getNamespaceURI(), prefix, qname.getNameType()));
        }
    }

    @Override
    public NodeId getNodeId() {
        this.expand();
        return this.document.nodeId[this.nodeNumber];
    }

    public void expand() throws DOMException {
        this.document.expand();
    }

    public void deepCopy() throws DOMException {
        DocumentImpl newDoc = this.document.expandRefs(this);
        if (newDoc != this.document) {
            this.nodeNumber = 1;
            this.document = newDoc;
        }
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public short getNodeType() {
        if (this.document == null) {
            return 9;
        }
        return this.document.nodeKind[this.nodeNumber];
    }

    @Override
    public Node getParentNode() {
        int next = this.document.next[this.nodeNumber];
        while (next > this.nodeNumber) {
            next = this.document.next[next];
        }
        if (next < 0) {
            return null;
        }
        return this.document.getNode(next);
    }

    public Node selectParentNode() {
        if (this.nodeNumber == 0) {
            return null;
        }
        int next = this.document.next[this.nodeNumber];
        while (next > this.nodeNumber) {
            next = this.document.next[next];
        }
        if (next < 0) {
            return null;
        }
        if (next == 0) {
            return this.document.explicitlyCreated ? this.document : null;
        }
        return this.document.getNode(next);
    }

    @Override
    public void addContextNode(int contextId, NodeValue node) {
        throw this.unsupported();
    }

    public boolean equals(Object other) {
        if (!(other instanceof NodeImpl)) {
            return false;
        }
        NodeImpl o = (NodeImpl)other;
        return this.document == o.document && this.nodeNumber == o.nodeNumber && this.getNodeType() == o.getNodeType();
    }

    @Override
    public boolean equals(NodeValue other) throws XPathException {
        if (other.getImplementationType() != 0) {
            return false;
        }
        NodeImpl o = (NodeImpl)other;
        return this.document == o.document && this.nodeNumber == o.nodeNumber && this.getNodeType() == o.getNodeType();
    }

    @Override
    public boolean after(NodeValue other, boolean isFollowing) throws XPathException {
        if (other.getImplementationType() != 0) {
            throw new XPathException("cannot compare persistent node with in-memory node");
        }
        return this.nodeNumber > ((NodeImpl)other).nodeNumber;
    }

    @Override
    public boolean before(NodeValue other, boolean isPreceding) throws XPathException {
        if (other.getImplementationType() != 0) {
            throw new XPathException("cannot compare persistent node with in-memory node");
        }
        return this.nodeNumber < ((NodeImpl)other).nodeNumber;
    }

    @Override
    public int compareTo(NodeImpl other) {
        if (other.document == this.document) {
            if (this.nodeNumber == other.nodeNumber && this.getNodeType() == other.getNodeType()) {
                return 0;
            }
            if (this.nodeNumber < other.nodeNumber) {
                return -1;
            }
            return 1;
        }
        if (this.document.docId < other.document.docId) {
            return -1;
        }
        return 1;
    }

    @Override
    public Sequence tail() throws XPathException {
        return Sequence.EMPTY_SEQUENCE;
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeListImpl();
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        if (this.nodeNumber == 0) {
            return null;
        }
        int parent = this.document.getParentNodeFor(this.nodeNumber);
        int nextNode = this.document.getFirstChildFor(parent);
        while (nextNode >= parent && nextNode < this.nodeNumber) {
            int following = this.document.next[nextNode];
            if (following == this.nodeNumber) {
                return this.document.getNode(nextNode);
            }
            nextNode = following;
        }
        return null;
    }

    @Override
    public Node getNextSibling() {
        int nextNr = this.document.next[this.nodeNumber];
        return nextNr < this.nodeNumber ? null : this.document.getNode(nextNr);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public DocumentImpl getOwnerDocument() {
        return this.document;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() == 9 && newChild != this.document || newChild.getOwnerDocument() != this.document) {
            throw new DOMException(4, "Owning document IDs do not match");
        }
        throw this.unsupported();
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node cloneNode(boolean deep) {
        throw this.unsupported();
    }

    @Override
    public void normalize() {
        throw this.unsupported();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        throw this.unsupported();
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public int getType() {
        if (this.document == null) {
            return 6;
        }
        switch (this.getNodeType()) {
            case 9: {
                return 6;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 501;
            }
        }
        return -1;
    }

    @Override
    public String getStringValue() {
        short level = this.document.treeLevel[this.nodeNumber];
        int startOffset = 0;
        int len = -1;
        for (int next = this.nodeNumber + 1; next < this.document.size && this.document.treeLevel[next] > level; ++next) {
            if (this.document.nodeKind[next] == 3 || this.document.nodeKind[next] == 4 || this.document.nodeKind[next] == 7) {
                if (len < 0) {
                    startOffset = this.document.alpha[next];
                    len = this.document.alphaLen[next];
                    continue;
                }
                len += this.document.alphaLen[next];
                continue;
            }
            return this.getStringValueSlow();
        }
        return len < 0 ? "" : new String(this.document.characters, startOffset, len);
    }

    private String getStringValueSlow() {
        short level = this.document.treeLevel[this.nodeNumber];
        StringBuilder buf = null;
        block4: for (int next = this.nodeNumber + 1; next < this.document.size && this.document.treeLevel[next] > level; ++next) {
            switch (this.document.nodeKind[next]) {
                case 3: 
                case 4: 
                case 7: {
                    if (buf == null) {
                        buf = new StringBuilder();
                    }
                    buf.append(this.document.characters, this.document.alpha[next], this.document.alphaLen[next]);
                    continue block4;
                }
                case 100: {
                    if (buf == null) {
                        buf = new StringBuilder();
                    }
                    buf.append(this.document.references[this.document.alpha[next]].getStringValue());
                }
            }
        }
        return buf == null ? "" : buf.toString();
    }

    @Override
    public Sequence toSequence() {
        return this;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        return UntypedAtomicValue.convertTo(null, this.getStringValue(), requiredType);
    }

    @Override
    public AtomicValue atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValue());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean hasOne() {
        return true;
    }

    @Override
    public boolean hasMany() {
        return false;
    }

    @Override
    public void add(Item item) throws XPathException {
        throw this.unsupported();
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
        throw this.unsupported();
    }

    @Override
    public int getItemType() {
        return -1;
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return new SingleNodeIterator(this);
    }

    @Override
    public SequenceIterator unorderedIterator() {
        return new SingleNodeIterator(this);
    }

    @Override
    public int getItemCount() {
        return 1;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return true;
    }

    @Override
    public NodeSet toNodeSet() throws XPathException {
        ValueSequence seq = new ValueSequence();
        seq.add(this);
        return seq.toNodeSet();
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        return new ValueSequence(this).toMemNodeSet();
    }

    @Override
    public void toSAX(DBBroker broker, ContentHandler handler, Properties properties) throws SAXException {
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperty("sax-document-events", "false");
        if (properties != null) {
            serializer.setProperties(properties);
        }
        if (handler instanceof LexicalHandler) {
            serializer.setSAXHandlers(handler, (LexicalHandler)((Object)handler));
        } else {
            serializer.setSAXHandlers(handler, null);
        }
        serializer.toSAX(this);
    }

    @Override
    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        if (this.document != null) {
            this.document.copyTo(this, receiver);
        }
    }

    public void streamTo(Serializer serializer, Receiver receiver) throws SAXException {
        if (this.document != null) {
            this.document.streamTo(serializer, this, receiver);
        }
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        int preference = javaClass.isAssignableFrom(NodeImpl.class) ? 0 : (javaClass.isAssignableFrom(Node.class) ? 1 : (javaClass == String.class || javaClass == CharSequence.class ? 2 : (javaClass == Character.class || javaClass == Character.TYPE ? 2 : (javaClass == Double.class || javaClass == Double.TYPE ? 10 : (javaClass == Float.class || javaClass == Float.TYPE ? 11 : (javaClass == Long.class || javaClass == Long.TYPE ? 12 : (javaClass == Integer.class || javaClass == Integer.TYPE ? 13 : (javaClass == Short.class || javaClass == Short.TYPE ? 14 : (javaClass == Byte.class || javaClass == Byte.TYPE ? 15 : (javaClass == Boolean.class || javaClass == Boolean.TYPE ? 16 : (javaClass == Object.class ? 20 : Integer.MAX_VALUE)))))))))));
        return preference;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(NodeImpl.class) || target.isAssignableFrom(Node.class) || target == Object.class) {
            return (T)this;
        }
        StringValue v = new StringValue(this.getStringValue());
        return v.toJavaObject(target);
    }

    @Override
    public void setSelfAsContext(int contextId) {
        throw this.unsupported();
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public void setIsCached(boolean cached) {
        throw this.unsupported();
    }

    @Override
    public void removeDuplicates() {
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public void destroy(XQueryContext context, Sequence contextSequence) {
    }

    public abstract void selectAttributes(NodeTest var1, Sequence var2) throws XPathException;

    public abstract void selectDescendantAttributes(NodeTest var1, Sequence var2) throws XPathException;

    public abstract void selectChildren(NodeTest var1, Sequence var2) throws XPathException;

    public void selectDescendants(boolean includeSelf, NodeTest test, Sequence result) throws XPathException {
        if (includeSelf && test.matches(this)) {
            result.add(this);
        }
    }

    public void selectAncestors(boolean includeSelf, NodeTest test, Sequence result) throws XPathException {
        NodeImpl n;
        if (this.nodeNumber < 1) {
            return;
        }
        if (includeSelf && test.matches(n = this.document.getNode(this.nodeNumber))) {
            result.add(n);
        }
        int nextNode = this.document.getParentNodeFor(this.nodeNumber);
        while (nextNode > 0) {
            NodeImpl n2 = this.document.getNode(nextNode);
            if (test.matches(n2)) {
                result.add(n2);
            }
            nextNode = this.document.getParentNodeFor(nextNode);
        }
    }

    public void selectPrecedingSiblings(NodeTest test, Sequence result) throws XPathException {
        int parent = this.document.getParentNodeFor(this.nodeNumber);
        int nextNode = this.document.getFirstChildFor(parent);
        while (nextNode >= parent && nextNode < this.nodeNumber) {
            NodeImpl n = this.document.getNode(nextNode);
            if (test.matches(n)) {
                result.add(n);
            }
            nextNode = this.document.next[nextNode];
        }
    }

    public void selectPreceding(NodeTest test, Sequence result, int position) throws XPathException {
        NodeId myNodeId = this.getNodeId();
        int count = 0;
        for (int i = this.nodeNumber - 1; i > 0; --i) {
            NodeImpl n = this.document.getNode(i);
            if (myNodeId.isDescendantOf(n.getNodeId()) || !test.matches(n)) continue;
            if (position < 0 || ++count == position) {
                result.add(n);
            }
            if (count == position) break;
        }
    }

    public void selectFollowingSiblings(NodeTest test, Sequence result) throws XPathException {
        int parent = this.document.getParentNodeFor(this.nodeNumber);
        if (parent == 0) {
            if (this.getNodeType() == 1) {
                return;
            }
            for (NodeImpl next = (NodeImpl)this.getNextSibling(); next != null; next = (NodeImpl)next.getNextSibling()) {
                if (test.matches(next)) {
                    result.add(next);
                }
                if (next.getNodeType() != 1) {
                    continue;
                }
                break;
            }
        } else {
            int nextNode = this.document.getFirstChildFor(parent);
            while (nextNode > parent) {
                NodeImpl n = this.document.getNode(nextNode);
                if (nextNode > this.nodeNumber && test.matches(n)) {
                    result.add(n);
                }
                nextNode = this.document.next[nextNode];
            }
        }
    }

    public void selectFollowing(NodeTest test, Sequence result, int position) throws XPathException {
        int parent = this.document.getParentNodeFor(this.nodeNumber);
        if (parent == 0) {
            if (this.getNodeType() == 1) {
                return;
            }
            for (NodeImpl next = (NodeImpl)this.getNextSibling(); next != null; next = (NodeImpl)next.getNextSibling()) {
                if (test.matches(next)) {
                    next.selectDescendants(true, test, result);
                }
                if (next.getNodeType() != 1) {
                    continue;
                }
                break;
            }
        } else {
            NodeId myNodeId = this.getNodeId();
            int count = 0;
            for (int nextNode = this.nodeNumber + 1; nextNode < this.document.size; ++nextNode) {
                NodeImpl n = this.document.getNode(nextNode);
                if (n.getNodeId().isDescendantOf(myNodeId) || !test.matches(n)) continue;
                if (position < 0 || ++count == position) {
                    result.add(n);
                }
                if (count != position) {
                    continue;
                }
                break;
            }
        }
    }

    public boolean matchAttributes(NodeTest test) {
        return false;
    }

    public boolean matchDescendantAttributes(NodeTest test) throws XPathException {
        return false;
    }

    public boolean matchChildren(NodeTest test) throws XPathException {
        return false;
    }

    public boolean matchDescendants(boolean includeSelf, NodeTest test) throws XPathException {
        return includeSelf && test.matches(this);
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public String getTextContent() throws DOMException {
        throw this.unsupported();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public boolean isSameNode(Node other) {
        throw this.unsupported();
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw this.unsupported();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw this.unsupported();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw this.unsupported();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw this.unsupported();
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw this.unsupported();
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw this.unsupported();
    }

    @Override
    public Object getUserData(String key) {
        throw this.unsupported();
    }

    @Override
    public boolean isPersistentSet() {
        return false;
    }

    @Override
    public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
    }

    @Override
    public void clearContext(int contextId) {
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public boolean hasChanged(int previousState) {
        return false;
    }

    protected DOMException unsupported() {
        return new DOMException(9, "not implemented on class: " + this.getClass().getName());
    }

    private static final class SingleNodeIterator
    implements SequenceIterator {
        NodeImpl node;

        public SingleNodeIterator(NodeImpl node) {
            this.node = node;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public Item nextItem() {
            NodeImpl next = this.node;
            this.node = null;
            return next;
        }
    }
}

