/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class ProcessingInstructionImpl
extends NodeImpl
implements ProcessingInstruction {
    public ProcessingInstructionImpl(DocumentImpl doc, int nodeNumber) {
        super(doc, nodeNumber);
    }

    @Override
    public String getTarget() {
        QName qname = this.getQName();
        return qname != null ? qname.getLocalPart() : null;
    }

    @Override
    public String getStringValue() {
        return this.getData().replaceFirst("^\\s+", "");
    }

    @Override
    public String getData() {
        return new String(this.document.characters, this.document.alpha[this.nodeNumber], this.document.alphaLen[this.nodeNumber]);
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    @Override
    public AtomicValue atomize() throws XPathException {
        return new StringValue(this.getData());
    }

    @Override
    public void setData(String data) throws DOMException {
        this.document.characters = data.toCharArray();
        this.document.alpha[this.nodeNumber] = 0;
        this.document.alphaLen[this.nodeNumber] = data.length();
    }

    @Override
    public String getBaseURI() {
        String baseURI = "";
        int parent = -1;
        int test = this.document.getParentNodeFor(this.nodeNumber);
        if (this.document.nodeKind[test] != 9) {
            parent = test;
        }
        while (parent != -1 && this.document.getNode(parent).getBaseURI() != null) {
            baseURI = baseURI.isEmpty() ? this.document.getNode(parent).getBaseURI() : this.document.getNode(parent).getBaseURI() + "/" + baseURI;
            test = this.document.getParentNodeFor(parent);
            if (this.document.nodeKind[test] == 9) {
                return baseURI;
            }
            parent = test;
        }
        if (baseURI.isEmpty()) {
            baseURI = this.getOwnerDocument().getBaseURI();
        }
        return baseURI;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public int getItemType() {
        return 4;
    }

    public String toString() {
        return "in-memory#processing-instruction {" + this.getTarget() + "} {" + this.getData() + "} ";
    }

    @Override
    public void selectAttributes(NodeTest test, Sequence result) throws XPathException {
    }

    @Override
    public void selectChildren(NodeTest test, Sequence result) throws XPathException {
    }

    @Override
    public void selectDescendantAttributes(NodeTest test, Sequence result) throws XPathException {
    }
}

