/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.nio.charset.StandardCharsets;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NamedNode;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.SymbolTable;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.Signatures;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.util.XMLString;
import org.exist.util.pool.NodePool;
import org.exist.util.serializer.AttrList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class AttrImpl
extends NamedNode
implements Attr {
    public static final int LENGTH_NS_ID = 2;
    public static final int LENGTH_PREFIX_LENGTH = 2;
    public static final int CDATA = 0;
    public static final int ID = 1;
    public static final int IDREF = 2;
    public static final int IDREFS = 3;
    private static final int DEFAULT_ATTRIBUTE_TYPE = 0;
    private int attributeType = 0;
    private int indexType = 0;
    private XMLString value = null;

    public AttrImpl() {
        super((short)2);
    }

    public AttrImpl(QName name, SymbolTable symbols) throws DOMException {
        super((short)2, name);
        if (symbols != null && symbols.getSymbol(this.nodeName.getLocalPart()) < 0) {
            throw new DOMException(15, "Too many element/attribute names registered in the database. No of distinct names is limited to 16bit. Aborting store.");
        }
    }

    public AttrImpl(QName name, String str, SymbolTable symbols) throws DOMException {
        this(name, symbols);
        this.value = new XMLString(str.toCharArray());
    }

    public AttrImpl(AttrImpl other) {
        super(other);
        this.attributeType = other.attributeType;
        this.value = other.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.attributeType = 0;
        this.value = null;
    }

    @Override
    public byte[] serialize() {
        if (this.nodeName.getLocalPart() == null) {
            throw new RuntimeException("Local name is null");
        }
        short id = this.ownerDocument.getBrokerPool().getSymbols().getSymbol(this);
        byte idSizeType = Signatures.getSizeType(id);
        int prefixLen = 0;
        if (this.nodeName.hasNamespace() && this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
            prefixLen = UTF8.encoded(this.nodeName.getPrefix());
        }
        int nodeIdLen = this.nodeId.size();
        byte[] data = ByteArrayPool.getByteArray(3 + nodeIdLen + Signatures.getLength(idSizeType) + (this.nodeName.hasNamespace() ? 4 + prefixLen : 0) + this.value.UTF8Size());
        int pos = 0;
        data[pos] = -128;
        int n = pos;
        data[n] = (byte)(data[n] | idSizeType);
        int n2 = pos;
        data[n2] = (byte)(data[n2] | (byte)(this.attributeType << 2));
        if (this.nodeName.hasNamespace()) {
            int n3 = pos;
            data[n3] = (byte)(data[n3] | 0x10);
        }
        ByteConversion.shortToByte((short)this.nodeId.units(), data, ++pos);
        this.nodeId.serialize(data, pos += 2);
        Signatures.write(idSizeType, id, data, pos += nodeIdLen);
        pos += Signatures.getLength(idSizeType);
        if (this.nodeName.hasNamespace()) {
            short nsId = this.ownerDocument.getBrokerPool().getSymbols().getNSSymbol(this.nodeName.getNamespaceURI());
            ByteConversion.shortToByte(nsId, data, pos);
            ByteConversion.shortToByte((short)prefixLen, data, pos += 2);
            pos += 2;
            if (this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
                UTF8.encode(this.nodeName.getPrefix(), data, pos);
            }
            pos += prefixLen;
        }
        this.value.UTF8Encode(data, pos);
        return data;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        int pos = start;
        byte idSizeType = (byte)(data[pos] & 3);
        boolean hasNamespace = (data[pos] & 0x10) == 16;
        int attrType = (data[pos] & 4) >> 2;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        short id = (short)Signatures.read(idSizeType, data, pos += dln.size());
        pos += Signatures.getLength(idSizeType);
        String name = doc.getBrokerPool().getSymbols().getName(id);
        if (name == null) {
            throw new RuntimeException("no symbol for id " + id);
        }
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, pos);
            short prefixLen = ByteConversion.byteToShort(data, pos += 2);
            pos += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, pos, prefixLen).toString();
            }
            pos += prefixLen;
        }
        String namespace = nsId == 0 ? "" : doc.getBrokerPool().getSymbols().getNamespace(nsId);
        XMLString value = UTF8.decode(data, pos, len - (pos - start));
        AttrImpl attr = pooled ? (AttrImpl)NodePool.getInstance().borrowNode((short)2) : new AttrImpl();
        attr.setNodeName(doc.getBrokerPool().getSymbols().getQName((short)2, namespace, name, prefix));
        attr.value = value;
        attr.setNodeId(dln);
        attr.setType(attrType);
        return attr;
    }

    public static void addToList(DBBroker broker, byte[] data, int start, int len, AttrList list) {
        int pos = start;
        byte idSizeType = (byte)(data[pos] & 3);
        boolean hasNamespace = (data[pos] & 0x10) == 16;
        int attrType = (data[pos] & 4) >> 2;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = broker.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        short id = (short)Signatures.read(idSizeType, data, pos += dln.size());
        pos += Signatures.getLength(idSizeType);
        String name = broker.getBrokerPool().getSymbols().getName(id);
        if (name == null) {
            throw new RuntimeException("no symbol for id " + id);
        }
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, pos);
            short prefixLen = ByteConversion.byteToShort(data, pos += 2);
            pos += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, pos, prefixLen).toString();
            }
            pos += prefixLen;
        }
        String namespace = nsId == 0 ? "" : broker.getBrokerPool().getSymbols().getNamespace(nsId);
        String value = new String(data, pos, len - (pos - start), StandardCharsets.UTF_8);
        list.addAttribute(broker.getBrokerPool().getSymbols().getQName((short)2, namespace, name, prefix), value, attrType, dln);
    }

    @Override
    public String getName() {
        return this.getNodeName();
    }

    public int getType() {
        return this.attributeType;
    }

    public void setType(int type) {
        this.attributeType = type;
    }

    public static String getAttributeType(int type) {
        switch (type) {
            case 1: {
                return "ID";
            }
            case 2: {
                return "IDREF";
            }
            case 3: {
                return "IDREFS";
            }
            case 0: {
                return "CDATA";
            }
        }
        return null;
    }

    public void setIndexType(int idxType) {
        this.indexType = idxType;
    }

    public int getIndexType() {
        return this.indexType;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    @Override
    public void setValue(String value) throws DOMException {
        this.value = new XMLString(value.toCharArray());
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.setValue(nodeValue);
    }

    @Override
    public Element getOwnerElement() {
        return (Element)this.getOwnerDocument().getNode(this.nodeId.getParentId());
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public StoredNode getParentStoredNode() {
        return (StoredNode)this.getOwnerDocument().getNode(this.nodeId.getParentId());
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.nodeName) + "=\"" + this.value + "\"";
    }

    @Override
    public String toString(boolean top) {
        if (top) {
            return "<exist:attribute xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" exist:id=\"" + this.getNodeId() + "\" exist:source=\"" + this.getOwnerDocument().getFileURI() + "\" " + this.getNodeName() + "=\"" + this.getValue() + "\"/>";
        }
        return this.toString();
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean isId() {
        return this.getType() == 1;
    }

    @Override
    public String getBaseURI() {
        Element e = this.getOwnerElement();
        if (e != null) {
            return e.getBaseURI();
        }
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return false;
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    @Override
    public Object getUserData(String key) {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof AttrImpl) {
            AttrImpl other = (AttrImpl)obj;
            return other.getQName().equals(this.getQName()) && other.value.equals(this.value);
        }
        return false;
    }
}

