/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.util.XMLString;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class CDATASectionImpl
extends AbstractCharacterData
implements CDATASection {
    public CDATASectionImpl() {
        super((short)4);
    }

    public CDATASectionImpl(NodeId nodeId, String data) {
        super((short)4, nodeId, data);
    }

    public CDATASectionImpl(NodeId nodeId) {
        super((short)4, nodeId);
    }

    public CDATASectionImpl(XMLString data) {
        super((short)4);
        this.cdata = data;
    }

    public CDATASectionImpl(String data) {
        super((short)4, data);
    }

    @Override
    public byte[] serialize() {
        int nodeIdLen = this.nodeId.size();
        byte[] data = ByteArrayPool.getByteArray(3 + nodeIdLen + this.cdata.UTF8Size());
        int pos = 0;
        data[pos] = -96;
        ByteConversion.shortToByte((short)this.nodeId.units(), data, ++pos);
        this.nodeId.serialize(data, pos += 2);
        this.cdata.UTF8Encode(data, pos += nodeIdLen);
        return data;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        int pos = start;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        int nodeIdLen = dln.size();
        CDATASectionImpl cdata = new CDATASectionImpl(dln);
        cdata.cdata = UTF8.decode(data, pos += nodeIdLen, len - (pos - start));
        return cdata;
    }

    @Override
    public String getWholeText() {
        return null;
    }

    @Override
    public boolean isElementContentWhitespace() {
        return false;
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        return null;
    }

    @Override
    public Text splitText(int offset) throws DOMException {
        return null;
    }
}

