/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.NotThreadSafe;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.util.LockException;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Node;

@NotThreadSafe
public class DefaultDocumentSet
extends Int2ObjectHashMap
implements MutableDocumentSet {
    private static final int DEFAULT_SIZE = 29;
    private static final double DEFAULT_GROWTH = 1.75;
    private final BitSet docIds = new BitSet();
    private final BitSet collectionIds = new BitSet();
    private final Set<Collection> collections = new TreeSet<Collection>();
    private final Deque<Runnable> lockReleasers = new ArrayDeque<Runnable>();

    public DefaultDocumentSet() {
        super(29, 1.75);
    }

    public DefaultDocumentSet(int initialSize) {
        super(initialSize, 1.75);
    }

    @Override
    public void clear() {
        super.clear();
        this.docIds.clear();
        this.collectionIds.clear();
        this.collections.clear();
    }

    @Override
    public void add(DocumentImpl doc) {
        this.add(doc, true);
    }

    @Override
    public void add(DocumentImpl doc, boolean checkDuplicates) {
        int docId = doc.getDocId();
        if (checkDuplicates && this.contains(docId)) {
            return;
        }
        this.docIds.set(docId);
        this.put(docId, doc);
        Collection collection = doc.getCollection();
        if (collection != null && !this.collectionIds.get(collection.getId())) {
            this.collectionIds.set(collection.getId());
            this.collections.add(collection);
        }
    }

    public void add(Node node) {
        if (!(node instanceof DocumentImpl)) {
            throw new IllegalArgumentException("wrong implementation");
        }
        this.add((DocumentImpl)node);
    }

    @Override
    public void addAll(DocumentSet other) {
        Iterator<DocumentImpl> i = other.getDocumentIterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    @Override
    public void addCollection(Collection collection) {
        if (!this.collectionIds.get(collection.getId())) {
            this.collectionIds.set(collection.getId());
            this.collections.add(collection);
        }
    }

    @Override
    public Iterator<DocumentImpl> getDocumentIterator() {
        return this.valueIterator();
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return this.collections.iterator();
    }

    @Override
    public int getDocumentCount() {
        return this.size();
    }

    public int getCollectionCount() {
        return this.collections.size();
    }

    @Override
    public DocumentImpl getDoc(int docId) {
        return (DocumentImpl)this.get(docId);
    }

    @Override
    public XmldbURI[] getNames() {
        Object[] result = new XmldbURI[this.size()];
        int j = 0;
        Iterator<DocumentImpl> i = this.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl d = i.next();
            result[j] = d.getFileURI();
            ++j;
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    public DocumentSet intersection(DocumentSet other) {
        DocumentImpl d;
        DefaultDocumentSet r = new DefaultDocumentSet();
        Iterator<DocumentImpl> i = this.getDocumentIterator();
        while (i.hasNext()) {
            d = i.next();
            if (!other.contains(d.getDocId())) continue;
            r.add(d);
        }
        i = other.getDocumentIterator();
        while (i.hasNext()) {
            d = i.next();
            if (!this.contains(d.getDocId()) || r.contains(d.getDocId())) continue;
            r.add(d);
        }
        return r;
    }

    public DocumentSet union(DocumentSet other) {
        DefaultDocumentSet result = new DefaultDocumentSet();
        result.addAll(other);
        Iterator<DocumentImpl> i = this.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl d = i.next();
            if (result.contains(d.getDocId())) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public boolean contains(DocumentSet other) {
        if (other.getDocumentCount() > this.size()) {
            return false;
        }
        if (other instanceof DefaultDocumentSet) {
            DefaultDocumentSet otherDDS = (DefaultDocumentSet)other;
            BitSet compare = new BitSet();
            compare.or(this.docIds);
            compare.and(otherDDS.docIds);
            return compare.equals(otherDDS.docIds);
        }
        Iterator<DocumentImpl> otherDocumentIterator = other.getDocumentIterator();
        while (otherDocumentIterator.hasNext()) {
            DocumentImpl otherDocument = otherDocumentIterator.next();
            if (this.contains(otherDocument.getDocId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(int id) {
        return this.docIds.get(id);
    }

    @Override
    public NodeSet docsToNodeSet() {
        NewArrayNodeSet result = new NewArrayNodeSet();
        Iterator<DocumentImpl> i = this.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl doc = i.next();
            if (doc.getResourceType() != 0) continue;
            result.add(new NodeProxy(doc, NodeId.DOCUMENT_NODE));
        }
        return result;
    }

    public int getMinDocId() {
        int min = -1;
        Iterator<DocumentImpl> i = this.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl d = i.next();
            if (min == -1) {
                min = d.getDocId();
                continue;
            }
            if (d.getDocId() >= min) continue;
            min = d.getDocId();
        }
        return min;
    }

    public int getMaxDocId() {
        int max = -1;
        Iterator<DocumentImpl> i = this.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl d = i.next();
            if (d.getDocId() <= max) continue;
            max = d.getDocId();
        }
        return max;
    }

    @Override
    public boolean equalDocs(DocumentSet other) {
        if (this == other) {
            return true;
        }
        if (this.getDocumentCount() != other.getDocumentCount()) {
            return false;
        }
        if (other instanceof DefaultDocumentSet) {
            DefaultDocumentSet otherDDS = (DefaultDocumentSet)other;
            return this.docIds.equals(otherDDS.docIds);
        }
        Iterator<DocumentImpl> otherDocumentIterator = other.getDocumentIterator();
        while (otherDocumentIterator.hasNext()) {
            DocumentImpl otherDocument = otherDocumentIterator.next();
            if (this.contains(otherDocument.getDocId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void lock(DBBroker broker, boolean exclusive) throws LockException {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            DocumentImpl d = (DocumentImpl)this.values[idx];
            Lock dlock = d.getUpdateLock();
            dlock.acquire(exclusive ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK);
            this.lockReleasers.push(() -> dlock.release(exclusive ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK));
        }
    }

    @Override
    public void unlock() {
        while (!this.lockReleasers.isEmpty()) {
            this.lockReleasers.pop().run();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Iterator<DocumentImpl> i = this.getDocumentIterator();
        while (i.hasNext()) {
            result.append(i.next());
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

