/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.exist.EXistException;
import org.exist.Resource;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfiguration;
import org.exist.dom.NodeListImpl;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentFragmentImpl;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.CDATASectionImpl;
import org.exist.dom.persistent.CommentImpl;
import org.exist.dom.persistent.DOMImplementationImpl;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.TextImpl;
import org.exist.numbering.NodeId;
import org.exist.security.Account;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionFactory;
import org.exist.security.SecurityManager;
import org.exist.security.UnixStylePermission;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.StorageAddress;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.MultiReadReentrantLock;
import org.exist.storage.txn.Txn;
import org.exist.util.XMLString;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.NameTest;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends NodeImpl<DocumentImpl>
implements Resource,
Document {
    public static final int UNKNOWN_DOCUMENT_ID = -1;
    public static final byte XML_FILE = 0;
    public static final byte BINARY_FILE = 1;
    public static final int LENGTH_DOCUMENT_ID = 4;
    public static final int LENGTH_DOCUMENT_TYPE = 1;
    private final BrokerPool pool;
    private int children = 0;
    private long[] childAddress = null;
    private transient Collection collection = null;
    private int docId = -1;
    private XmldbURI fileURI = null;
    private Permission permissions = null;
    private transient Lock updateLock = null;
    private DocumentMetadata metadata = null;

    public DocumentImpl(BrokerPool pool) {
        this(pool, null, null);
    }

    public DocumentImpl(BrokerPool pool, Collection collection, XmldbURI fileURI) {
        this.pool = pool;
        this.collection = collection;
        this.fileURI = fileURI;
        this.permissions = PermissionFactory.getDefaultResourcePermission(pool.getSecurityManager());
        if (collection != null && collection.getPermissions().isSetGid()) {
            try {
                this.permissions.setGroupFrom(collection.getPermissions());
            }
            catch (PermissionDeniedException pde) {
                throw new IllegalArgumentException(pde);
            }
        }
    }

    public BrokerPool getBrokerPool() {
        return this.pool;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection parent) {
        this.collection = parent;
    }

    public int getDocId() {
        return this.docId;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public byte getResourceType() {
        return 0;
    }

    public XmldbURI getFileURI() {
        return this.fileURI;
    }

    public void setFileURI(XmldbURI fileURI) {
        this.fileURI = fileURI;
    }

    @Override
    public XmldbURI getURI() {
        if (this.collection == null) {
            return this.fileURI;
        }
        return this.collection.getURI().append(this.fileURI);
    }

    public boolean isCollectionConfig() {
        return this.fileURI.endsWith(CollectionConfiguration.COLLECTION_CONFIG_SUFFIX_URI);
    }

    @Override
    public Permission getPermissions() {
        return this.permissions;
    }

    @Deprecated
    public void setPermissions(Permission perm) {
        this.permissions = perm;
    }

    @Deprecated
    public void setMetadata(DocumentMetadata meta) {
        this.metadata = meta;
    }

    @Override
    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    public void copyOf(DocumentImpl other, boolean preserve) {
        this.childAddress = null;
        this.children = 0;
        this.metadata = this.getMetadata();
        if (this.metadata == null) {
            this.metadata = new DocumentMetadata();
        }
        this.metadata.copyOf(other.getMetadata());
        if (preserve) {
            this.permissions = ((UnixStylePermission)other.permissions).copy();
        } else {
            long timestamp = System.currentTimeMillis();
            this.metadata.setCreated(timestamp);
            this.metadata.setLastModified(timestamp);
        }
        this.metadata.setPageCount(0);
    }

    public void copyChildren(DocumentImpl other) {
        this.childAddress = other.childAddress;
        this.children = other.children;
    }

    public synchronized boolean isLockedForWrite() {
        return this.getUpdateLock().isLockedForWrite();
    }

    public synchronized Lock getUpdateLock() {
        if (this.updateLock == null) {
            this.updateLock = new MultiReadReentrantLock(this.fileURI);
        }
        return this.updateLock;
    }

    public void setUserLock(Account user) {
        this.getMetadata().setUserLock(user == null ? 0 : user.getId());
    }

    public Account getUserLock() {
        int lockOwnerId = this.getMetadata().getUserLock();
        if (lockOwnerId == 0) {
            return null;
        }
        SecurityManager secman = this.pool.getSecurityManager();
        return secman.getAccount(lockOwnerId);
    }

    public long getContentLength() {
        long length = this.getMetadata().getPageCount() * this.pool.getPageSize();
        return length < 0L ? 0L : length;
    }

    public void triggerDefrag() {
        int fragmentationLimit = -1;
        Object property = this.pool.getConfiguration().getProperty("xupdate.fragmentation");
        if (property != null) {
            fragmentationLimit = (Integer)property;
        }
        if (fragmentationLimit != -1) {
            this.getMetadata().setSplitCount(fragmentationLimit);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node getNode(NodeId nodeId) {
        if (nodeId.getTreeLevel() == 1) {
            return this.getDocumentElement();
        }
        try (DBBroker broker = this.pool.getBroker();){
            IStoredNode iStoredNode = broker.objectWith(this, nodeId);
            return iStoredNode;
        }
        catch (EXistException e) {
            LOG.warn("Error occurred while retrieving node: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node getNode(NodeProxy p) {
        if (p.getNodeId().getTreeLevel() == 1) {
            return this.getDocumentElement();
        }
        try (DBBroker broker = this.pool.getBroker();){
            IStoredNode iStoredNode = broker.objectWith(p);
            return iStoredNode;
        }
        catch (Exception e) {
            LOG.warn("Error occurred while retrieving node: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void resizeChildList() {
        long[] newChildList = new long[this.children];
        if (this.childAddress != null) {
            System.arraycopy(this.childAddress, 0, newChildList, 0, this.childAddress.length);
        }
        this.childAddress = newChildList;
    }

    public void appendChild(NodeHandle child) throws DOMException {
        ++this.children;
        this.resizeChildList();
        this.childAddress[this.children - 1] = child.getInternalAddress();
    }

    public void write(VariableByteOutputStream ostream) throws IOException {
        try {
            if (!this.getCollection().isTempCollection() && !this.getUpdateLock().isLockedForWrite()) {
                LOG.warn("document not locked for write !");
            }
            ostream.writeInt(this.docId);
            ostream.writeUTF(this.fileURI.toString());
            this.getPermissions().write(ostream);
            ostream.writeInt(this.children);
            if (this.children > 0) {
                for (int i = 0; i < this.children; ++i) {
                    ostream.writeInt(StorageAddress.pageFromPointer(this.childAddress[i]));
                    ostream.writeShort(StorageAddress.tidFromPointer(this.childAddress[i]));
                }
            }
            this.getMetadata().write(this.pool.getSymbols(), ostream);
        }
        catch (IOException e) {
            LOG.warn("io error while writing document data", (Throwable)e);
        }
    }

    public void read(VariableByteInput istream) throws IOException, EOFException {
        try {
            this.docId = istream.readInt();
            this.fileURI = XmldbURI.createInternal(istream.readUTF());
            this.getPermissions().read(istream);
            this.children = istream.readInt();
            this.childAddress = new long[this.children];
            for (int i = 0; i < this.children; ++i) {
                this.childAddress[i] = StorageAddress.createPointer(istream.readInt(), istream.readShort());
            }
            this.metadata = new DocumentMetadata();
            this.metadata.read(this.pool.getSymbols(), istream);
        }
        catch (IOException e) {
            LOG.error("IO error while reading document data for document " + this.fileURI, (Throwable)e);
        }
    }

    @Override
    public int compareTo(DocumentImpl other) {
        long otherId = other.docId;
        if (otherId == (long)this.docId) {
            return 0;
        }
        if ((long)this.docId < otherId) {
            return -1;
        }
        return 1;
    }

    @Override
    public IStoredNode updateChild(Txn transaction, Node oldChild, Node newChild) throws DOMException {
        if (!(oldChild instanceof StoredNode)) {
            throw new DOMException(4, "Node does not belong to this document");
        }
        IStoredNode oldNode = (IStoredNode)oldChild;
        IStoredNode newNode = (IStoredNode)newChild;
        IStoredNode previousNode = (IStoredNode)oldNode.getPreviousSibling();
        if (previousNode == null) {
            throw new DOMException(8, "No previous sibling for the old child");
        }
        try (DBBroker broker = this.pool.getBroker();){
            if (oldChild.getNodeType() == 1) {
                if (newChild.getNodeType() != 1) {
                    throw new DOMException(13, "A node replacing the document root needs to be an element");
                }
                broker.removeNode(transaction, oldNode, oldNode.getPath(), null);
                broker.endRemove(transaction);
                newNode.setNodeId(oldNode.getNodeId());
                broker.insertNodeAfter(null, previousNode, newNode);
                NodePath path = newNode.getPath();
                broker.indexNode(transaction, newNode, path);
                broker.endElement(newNode, path, null);
                broker.flush();
            } else {
                broker.removeNode(transaction, oldNode, oldNode.getPath(), null);
                broker.endRemove(transaction);
                newNode.setNodeId(oldNode.getNodeId());
                broker.insertNodeAfter(transaction, previousNode, newNode);
            }
        }
        catch (EXistException e) {
            LOG.warn("Exception while updating child node: " + e.getMessage(), (Throwable)e);
        }
        return newNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node getFirstChild() {
        if (this.children == 0) {
            return null;
        }
        try (DBBroker broker = this.pool.getBroker();){
            IStoredNode iStoredNode = broker.objectWith(new NodeProxy(this, NodeId.DOCUMENT_NODE, this.childAddress[0]));
            return iStoredNode;
        }
        catch (EXistException e) {
            LOG.warn("Exception while inserting node: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected NodeProxy getFirstChildProxy() {
        return new NodeProxy(this, NodeId.ROOT_NODE, 1, this.childAddress[0]);
    }

    public long getFirstChildAddress() {
        if (this.children == 0) {
            return -1L;
        }
        return this.childAddress[0];
    }

    @Override
    public boolean hasChildNodes() {
        return this.children > 0;
    }

    @Override
    public NodeList getChildNodes() {
        NodeListImpl list = new NodeListImpl();
        try (DBBroker broker = this.pool.getBroker();){
            for (int i = 0; i < this.children; ++i) {
                IStoredNode child = broker.objectWith(new NodeProxy(this, NodeId.DOCUMENT_NODE, this.childAddress[i]));
                list.add(child);
            }
        }
        catch (EXistException e) {
            LOG.warn("Exception while retrieving child nodes: " + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    protected Node getPreviousSibling(NodeHandle node) {
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            NodeHandle next = (NodeHandle)((Object)cl.item(i));
            if (!StorageAddress.equals(node.getInternalAddress(), next.getInternalAddress())) continue;
            return i == 0 ? null : cl.item(i - 1);
        }
        return null;
    }

    protected Node getFollowingSibling(NodeHandle node) {
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            NodeHandle next = (NodeHandle)((Object)cl.item(i));
            if (!StorageAddress.equals(node, next)) continue;
            return i == this.children - 1 ? null : cl.item(i + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NodeList findElementsByTagName(NodeHandle root, QName qname) {
        try (DBBroker broker = this.pool.getBroker();){
            DefaultDocumentSet docs = new DefaultDocumentSet();
            docs.add(this);
            NewArrayNodeSet contextSet = new NewArrayNodeSet();
            contextSet.add(new NodeProxy(this, root.getNodeId(), root.getInternalAddress()));
            NodeSet nodeSet = broker.getStructuralIndex().scanByType((byte)0, 7, new NameTest(1, qname), false, docs, contextSet, -1);
            return nodeSet;
        }
        catch (Exception e) {
            LOG.warn("Exception while finding elements: " + e.getMessage(), (Throwable)e);
            return NodeSet.EMPTY_SET;
        }
    }

    @Override
    public DocumentType getDoctype() {
        return this.getMetadata().getDocType();
    }

    public void setDocumentType(DocumentType docType) {
        this.getMetadata().setDocType(docType);
    }

    @Override
    public DocumentImpl getOwnerDocument() {
        return null;
    }

    public void setOwnerDocument(Document doc) {
        if (doc != this) {
            throw new IllegalArgumentException("Can't set owner document");
        }
    }

    @Override
    public QName getQName() {
        return QName.DOCUMENT_QNAME;
    }

    @Override
    public void setQName(QName qname) {
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        QName qname;
        try {
            qname = new QName(name);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, "name is invalid");
        }
        if (qname.isValid(false) != QName.Validity.VALID.val) {
            throw new DOMException(5, "name is invalid");
        }
        AttrImpl attr = new AttrImpl(qname, this.getBrokerPool().getSymbols());
        attr.setOwnerDocument(this);
        return attr;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        QName qname;
        try {
            qname = QName.parse(namespaceURI, qualifiedName);
        }
        catch (QName.IllegalQNameException e) {
            int errCode = e.getValidity() == QName.Validity.ILLEGAL_FORMAT.val || (e.getValidity() & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val ? 14 : 5;
            throw new DOMException((short)errCode, "qualified name is invalid");
        }
        byte validity = qname.isValid(false);
        if ((validity & QName.Validity.INVALID_LOCAL_PART.val) == QName.Validity.INVALID_LOCAL_PART.val) {
            throw new DOMException(5, "qualified name is invalid");
        }
        if ((validity & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val) {
            throw new DOMException(14, "qualified name is invalid");
        }
        AttrImpl attr = new AttrImpl(qname, this.getBrokerPool().getSymbols());
        attr.setOwnerDocument(this);
        return attr;
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        QName qname;
        try {
            qname = new QName(tagName);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, "name is invalid");
        }
        if (qname.isValid(false) != QName.Validity.VALID.val) {
            throw new DOMException(5, "name is invalid");
        }
        ElementImpl element = new ElementImpl(qname, this.getBrokerPool().getSymbols());
        element.setOwnerDocument(this);
        return element;
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        QName qname;
        try {
            qname = QName.parse(namespaceURI, qualifiedName);
        }
        catch (QName.IllegalQNameException e) {
            int errCode = e.getValidity() == QName.Validity.ILLEGAL_FORMAT.val || (e.getValidity() & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val ? 14 : 5;
            throw new DOMException((short)errCode, "qualified name is invalid");
        }
        byte validity = qname.isValid(false);
        if ((validity & QName.Validity.INVALID_LOCAL_PART.val) == QName.Validity.INVALID_LOCAL_PART.val) {
            throw new DOMException(5, "qualified name is invalid");
        }
        if ((validity & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val) {
            throw new DOMException(14, "qualified name is invalid");
        }
        ElementImpl element = new ElementImpl(qname, this.getBrokerPool().getSymbols());
        element.setOwnerDocument(this);
        return element;
    }

    @Override
    public Text createTextNode(String data) {
        TextImpl text = new TextImpl(data);
        text.setOwnerDocument(this);
        return text;
    }

    @Override
    public Element getDocumentElement() {
        NodeList cl = this.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            if (cl.item(i).getNodeType() != 1) continue;
            return (Element)cl.item(i);
        }
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        if (tagname != null && tagname.equals("*")) {
            return this.getElementsByTagName(new QName.WildcardLocalPartQName(""));
        }
        try {
            return this.getElementsByTagName(new QName(tagname));
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, "name is invalid");
        }
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        boolean wildcardLocalPart;
        boolean wildcardNS = namespaceURI != null && namespaceURI.equals("*");
        boolean bl = wildcardLocalPart = localName != null && localName.equals("*");
        if (wildcardNS && wildcardLocalPart) {
            return this.getElementsByTagName(QName.WildcardQName.getInstance());
        }
        if (wildcardNS) {
            return this.getElementsByTagName(new QName.WildcardNamespaceURIQName(localName));
        }
        if (wildcardLocalPart) {
            return this.getElementsByTagName(new QName.WildcardLocalPartQName(namespaceURI));
        }
        return this.getElementsByTagName(new QName(localName, namespaceURI));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NodeList getElementsByTagName(QName qname) {
        try (DBBroker broker = this.pool.getBroker();){
            DefaultDocumentSet docs = new DefaultDocumentSet();
            docs.add(this);
            NewArrayNodeSet contextSet = new NewArrayNodeSet();
            ElementImpl root = (ElementImpl)this.getDocumentElement();
            contextSet.add(new NodeProxy(this, root.getNodeId(), root.getInternalAddress()));
            NodeSet nodeSet = broker.getStructuralIndex().scanByType((byte)0, 8, new NameTest(1, qname), false, docs, contextSet, -1);
            return nodeSet;
        }
        catch (Exception e) {
            LOG.error("Exception while finding elements: " + e.getMessage(), (Throwable)e);
            return NodeSet.EMPTY_SET;
        }
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public int getChildCount() {
        return this.children;
    }

    public void setChildCount(int count) {
        this.children = count;
        if (this.children == 0) {
            this.childAddress = null;
        }
    }

    @Override
    public boolean isSameNode(Node other) {
        if (other instanceof DocumentImpl) {
            return this.docId == ((DocumentImpl)other).getDocId();
        }
        return false;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        CDATASectionImpl cdataSection = new CDATASectionImpl(new XMLString(data.toCharArray()));
        cdataSection.setOwnerDocument(this);
        return cdataSection;
    }

    @Override
    public Comment createComment(String data) {
        CommentImpl comment = new CommentImpl(data);
        comment.setOwnerDocument(this);
        return comment;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        ProcessingInstructionImpl processingInstruction = new ProcessingInstructionImpl(target, data);
        processingInstruction.setOwnerDocument(this);
        return processingInstruction;
    }

    @Override
    public DocumentFragment createDocumentFragment() throws DOMException {
        return new DocumentFragmentImpl();
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public Element getElementById(String elementId) {
        throw this.unsupported();
    }

    @Override
    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw this.unsupported();
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public void setStrictErrorChecking(boolean strict) {
        throw this.unsupported();
    }

    @Override
    public String getInputEncoding() {
        throw this.unsupported();
    }

    @Override
    public String getXmlEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public String getDocumentURI() {
        return this.getBaseURI();
    }

    @Override
    public void setDocumentURI(String documentURI) {
        throw this.unsupported();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw this.unsupported();
    }

    @Override
    public void normalizeDocument() {
        throw this.unsupported();
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public String getBaseURI() {
        return this.getURI().toString();
    }

    public String toString() {
        return this.getURI() + " - <" + (this.getDocumentElement() != null ? this.getDocumentElement().getNodeName() : null) + ">";
    }

    @Override
    public NodeId getNodeId() {
        return null;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() != 9 && newChild.getOwnerDocument() != this) {
            throw new DOMException(4, "Owning document IDs do not match");
        }
        if (newChild == this) {
            throw new DOMException(3, "Cannot append a document to itself");
        }
        if (newChild.getNodeType() == 9) {
            throw new DOMException(3, "A Document Node may not be appended to a Document Node");
        }
        if (newChild.getNodeType() == 1 && this.getDocumentElement() != null) {
            throw new DOMException(3, "A Document Node may only have a single document element");
        }
        if (newChild.getNodeType() == 10 && this.getDoctype() != null) {
            throw new DOMException(3, "A Document Node may only have a single document type");
        }
        throw this.unsupported();
    }
}

