/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import org.exist.EXistException;
import org.exist.Namespaces;
import org.exist.dom.NamedNodeMapImpl;
import org.exist.dom.NodeListImpl;
import org.exist.dom.QName;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.CDATASectionImpl;
import org.exist.dom.persistent.CommentImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NamedNode;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeImplRef;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeVisitor;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.SymbolTable;
import org.exist.dom.persistent.TextImpl;
import org.exist.indexing.IndexController;
import org.exist.indexing.StreamListener;
import org.exist.numbering.NodeId;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeValueIndex;
import org.exist.storage.NodePath;
import org.exist.storage.Signatures;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.INodeIterator;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.util.pool.NodePool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NamedNode
implements Element {
    public static final int LENGTH_ELEMENT_CHILD_COUNT = 4;
    public static final int LENGTH_ATTRIBUTES_COUNT = 2;
    public static final int LENGTH_NS_ID = 2;
    public static final int LENGTH_PREFIX_LENGTH = 2;
    private short attributes = 0;
    private int children = 0;
    private int position = 0;
    private Map<String, String> namespaceMappings = null;
    private int indexType = 0;
    private boolean preserveWS = false;
    private boolean isDirty = false;

    public ElementImpl() {
        super((short)1);
    }

    public ElementImpl(QName nodeName, SymbolTable symbols) throws DOMException {
        super((short)1, nodeName);
        this.nodeName = nodeName;
        if (symbols.getSymbol(nodeName.getLocalPart()) < 0) {
            throw new DOMException(15, "Too many element/attribute names registered in the database. No of distinct names is limited to 16bit. Aborting store.");
        }
    }

    public ElementImpl(ElementImpl other) {
        super(other);
        this.children = other.children;
        this.attributes = other.attributes;
        this.namespaceMappings = other.namespaceMappings;
        this.indexType = other.indexType;
        this.position = other.position;
    }

    @Override
    public void clear() {
        super.clear();
        this.attributes = 0;
        this.children = 0;
        this.position = 0;
        this.namespaceMappings = null;
    }

    public void setIndexType(int idxType) {
        this.indexType = idxType;
    }

    public int getIndexType() {
        return this.indexType;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean declaresNamespacePrefixes() {
        if (this.namespaceMappings == null) {
            return false;
        }
        return this.namespaceMappings.size() > 0;
    }

    @Override
    public byte[] serialize() {
        if (this.nodeId == null) {
            throw new RuntimeException("nodeId = null for element: " + this.getQName().getStringValue());
        }
        try {
            byte[] prefixData;
            SymbolTable symbols;
            block36: {
                symbols = this.ownerDocument.getBrokerPool().getSymbols();
                if (this.declaresNamespacePrefixes()) {
                    try (ByteArrayOutputStream bout = new ByteArrayOutputStream();
                         DataOutputStream out = new DataOutputStream(bout);){
                        out.writeShort(this.namespaceMappings.size());
                        for (Map.Entry<String, String> namespaceMapping : this.namespaceMappings.entrySet()) {
                            out.writeUTF(namespaceMapping.getKey());
                            short nsId = symbols.getNSSymbol(namespaceMapping.getValue());
                            out.writeShort(nsId);
                        }
                        prefixData = bout.toByteArray();
                        break block36;
                    }
                }
                prefixData = null;
            }
            short id = symbols.getSymbol(this);
            boolean hasNamespace = this.nodeName.hasNamespace();
            short nsId = 0;
            if (hasNamespace) {
                nsId = symbols.getNSSymbol(this.nodeName.getNamespaceURI());
            }
            byte idSizeType = Signatures.getSizeType(id);
            byte signature = (byte)(0x20 | idSizeType);
            int prefixLen = 0;
            if (hasNamespace) {
                if (this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
                    prefixLen = UTF8.encoded(this.nodeName.getPrefix());
                }
                signature = (byte)(signature | 0x10);
            }
            if (this.isDirty) {
                signature = (byte)(signature | 8);
            }
            int nodeIdLen = this.nodeId.size();
            byte[] data = ByteArrayPool.getByteArray(7 + nodeIdLen + 2 + Signatures.getLength(idSizeType) + (hasNamespace ? prefixLen + 4 : 0) + (prefixData != null ? prefixData.length : 0));
            int next = 0;
            data[next] = signature;
            ByteConversion.intToByte(this.children, data, ++next);
            ByteConversion.shortToByte((short)this.nodeId.units(), data, next += 4);
            this.nodeId.serialize(data, next += 2);
            ByteConversion.shortToByte(this.attributes, data, next += nodeIdLen);
            Signatures.write(idSizeType, id, data, next += 2);
            next += Signatures.getLength(idSizeType);
            if (hasNamespace) {
                ByteConversion.shortToByte(nsId, data, next);
                ByteConversion.shortToByte((short)prefixLen, data, next += 2);
                next += 2;
                if (this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
                    UTF8.encode(this.nodeName.getPrefix(), data, next);
                }
                next += prefixLen;
            }
            if (prefixData != null) {
                System.arraycopy(prefixData, 0, data, next, prefixData.length);
            }
            return data;
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        int end = start + len;
        int pos = start;
        byte idSizeType = (byte)(data[pos] & 3);
        boolean isDirty = (data[pos] & 8) == 8;
        boolean hasNamespace = (data[pos] & 0x10) == 16;
        int children = ByteConversion.byteToInt(data, ++pos);
        short dlnLen = ByteConversion.byteToShort(data, pos += 4);
        NodeId dln = doc.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        short attributes = ByteConversion.byteToShort(data, pos += dln.size());
        short id = (short)Signatures.read(idSizeType, data, pos += 2);
        pos += Signatures.getLength(idSizeType);
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, pos);
            short prefixLen = ByteConversion.byteToShort(data, pos += 2);
            pos += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, pos, prefixLen).toString();
            }
            pos += prefixLen;
        }
        String name = doc.getBrokerPool().getSymbols().getName(id);
        String namespace = "";
        if (nsId != 0) {
            namespace = doc.getBrokerPool().getSymbols().getNamespace(nsId);
        }
        ElementImpl node = pooled ? (ElementImpl)NodePool.getInstance().borrowNode((short)1) : new ElementImpl();
        node.setNodeId(dln);
        node.nodeName = doc.getBrokerPool().getSymbols().getQName((short)1, namespace, name, prefix);
        node.children = children;
        node.attributes = attributes;
        node.isDirty = isDirty;
        node.setOwnerDocument(doc);
        if (end > pos) {
            byte[] pfxData = new byte[end - pos];
            System.arraycopy(data, pos, pfxData, 0, end - pos);
            ByteArrayInputStream bin = new ByteArrayInputStream(pfxData);
            DataInputStream in = new DataInputStream(bin);
            try {
                int prefixCount = in.readShort();
                for (int i = 0; i < prefixCount; ++i) {
                    prefix = in.readUTF();
                    nsId = in.readShort();
                    node.addNamespaceMapping(prefix, doc.getBrokerPool().getSymbols().getNamespace(nsId));
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        return node;
    }

    public static QName readQName(Value value, DocumentImpl document, NodeId nodeId) {
        byte[] data = value.data();
        int offset = value.start();
        byte idSizeType = (byte)(data[offset] & 3);
        boolean hasNamespace = (data[offset] & 0x10) == 16;
        ++offset;
        offset += 4;
        offset += 2;
        offset += nodeId.size();
        short id = (short)Signatures.read(idSizeType, data, offset += 2);
        offset += Signatures.getLength(idSizeType);
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, offset);
            short prefixLen = ByteConversion.byteToShort(data, offset += 2);
            offset += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, offset, prefixLen).toString();
            }
            offset += prefixLen;
        }
        String name = document.getBrokerPool().getSymbols().getName(id);
        String namespace = nsId != 0 ? document.getBrokerPool().getSymbols().getNamespace(nsId) : "";
        return new QName(name, namespace, prefix == null ? "" : prefix);
    }

    public static void readNamespaceDecls(List<String[]> namespaces, Value value, DocumentImpl document, NodeId nodeId) {
        byte[] data = value.data();
        int offset = value.start();
        int end = offset + value.getLength();
        byte idSizeType = (byte)(data[offset] & 3);
        boolean hasNamespace = (data[offset] & 0x10) == 16;
        ++offset;
        offset += 4;
        offset += 2;
        offset += nodeId.size();
        offset += 2;
        offset += Signatures.getLength(idSizeType);
        if (hasNamespace) {
            short prefixLen = ByteConversion.byteToShort(data, offset += 2);
            offset += 2;
            offset += prefixLen;
        }
        if (end > offset) {
            byte[] pfxData = new byte[end - offset];
            System.arraycopy(data, offset, pfxData, 0, end - offset);
            ByteArrayInputStream bin = new ByteArrayInputStream(pfxData);
            DataInputStream in = new DataInputStream(bin);
            try {
                int prefixCount = in.readShort();
                for (int i = 0; i < prefixCount; ++i) {
                    String prefix = in.readUTF();
                    short nsId = in.readShort();
                    namespaces.add(new String[]{prefix, document.getBrokerPool().getSymbols().getNamespace(nsId)});
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }

    public void addNamespaceMapping(String prefix, String ns) {
        if (prefix == null) {
            return;
        }
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new HashMap<String, String>(1);
        } else if (this.namespaceMappings.containsKey(prefix)) {
            return;
        }
        this.namespaceMappings.put(prefix, ns);
    }

    public void appendChildInternal(IStoredNode prevNode, NodeHandle child) throws DOMException {
        NodeId childId;
        if (prevNode == null) {
            childId = this.getNodeId().newChild();
        } else {
            if (prevNode.getNodeId() == null) {
                LOG.warn(this.getQName() + " : " + prevNode.getNodeName());
            }
            childId = prevNode.getNodeId().nextSibling();
        }
        child.setNodeId(childId);
        ++this.children;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Node appendChild(Node newChild) throws DOMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void appendAttributes(Txn transaction, NodeList attribs) throws DOMException {
        NodeList duplicateAttrs = this.findDupAttributes(attribs);
        this.removeAppendAttributes(transaction, duplicateAttrs, attribs);
    }

    private NodeList checkForAttributes(Txn transaction, NodeList nodes) throws DOMException {
        NodeListImpl attribs = null;
        NodeListImpl rest = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node next = nodes.item(i);
            if (next.getNodeType() == 2) {
                if (next.getNodeName().startsWith("xmlns")) continue;
                if (attribs == null) {
                    attribs = new NodeListImpl();
                }
                attribs.add(next);
                continue;
            }
            if (attribs == null) continue;
            if (rest == null) {
                rest = new NodeListImpl();
            }
            rest.add(next);
        }
        if (attribs == null) {
            return nodes;
        }
        this.appendAttributes(transaction, attribs);
        return rest;
    }

    @Override
    public void appendChildren(Txn transaction, NodeList nodes, int child) throws DOMException {
        if ((nodes = this.checkForAttributes(transaction, nodes)) == null || nodes.getLength() == 0) {
            return;
        }
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            NodePath path = this.getPath();
            StreamListener listener = null;
            IndexController indexes = broker.getIndexController();
            indexes.setDocument(this.ownerDocument);
            IStoredNode reindexRoot = indexes.getReindexRoot(this, path, true, true);
            indexes.setMode(StreamListener.ReindexMode.STORE);
            if (reindexRoot == null) {
                listener = indexes.getStreamListener();
            }
            if (this.children == 0) {
                this.appendChildren(transaction, this.nodeId.newChild(), null, new NodeImplRef(this), path, nodes, listener);
            } else if (child == 1) {
                Node firstChild = this.getFirstChild();
                this.insertBefore(transaction, nodes, firstChild);
            } else if (child > 1 && child <= this.children) {
                NodeList cl = this.getAttrsAndChildNodes();
                IStoredNode last = (IStoredNode)cl.item(child - 2);
                this.insertAfter(transaction, nodes, last);
            } else {
                IStoredNode last = (IStoredNode)this.getLastChild(true);
                this.appendChildren(transaction, last.getNodeId().nextSibling(), null, new NodeImplRef(this.getLastNode(last)), path, nodes, listener);
            }
            broker.updateNode(transaction, this, false);
            indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.STORE);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn("Exception while appending child node: " + e.getMessage(), (Throwable)e);
        }
    }

    private void appendChildren(Txn transaction, NodeId newNodeId, NodeId followingId, NodeImplRef last, NodePath lastPath, NodeList nodes, StreamListener listener) throws DOMException {
        if (last == null || last.getNode() == null || last.getNode().getOwnerDocument() == null) {
            throw new DOMException(13, "invalid node");
        }
        this.children += nodes.getLength();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            this.appendChild(transaction, newNodeId, last, lastPath, child, listener);
            NodeId next = newNodeId.nextSibling();
            if (followingId != null && next.equals(followingId)) {
                next = newNodeId.insertNode(followingId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Node ID collision on " + followingId + ". Using " + next + " instead.");
                }
            }
            newNodeId = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node appendChild(Txn transaction, NodeId newNodeId, NodeImplRef last, NodePath lastPath, Node child, StreamListener listener) throws DOMException {
        if (last == null) throw new DOMException(13, "invalid node");
        if (last.getNode() == null) {
            throw new DOMException(13, "invalid node");
        }
        DocumentImpl owner = this.getOwnerDocument();
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            switch (child.getNodeType()) {
                case 11: {
                    this.appendChildren(transaction, newNodeId, null, last, lastPath, child.getChildNodes(), listener);
                    Node node = null;
                    return node;
                }
                case 1: {
                    Node n;
                    ElementImpl elem = new ElementImpl(new QName(child.getLocalName() == null ? child.getNodeName() : child.getLocalName(), child.getNamespaceURI(), child.getPrefix()), broker.getBrokerPool().getSymbols());
                    elem.setNodeId(newNodeId);
                    elem.setOwnerDocument(owner);
                    NodeListImpl ch = new NodeListImpl();
                    NamedNodeMap attribs = child.getAttributes();
                    short numActualAttribs = 0;
                    for (int i = 0; i < attribs.getLength(); ++i) {
                        Attr attr = (Attr)attribs.item(i);
                        if (!attr.getNodeName().startsWith("xmlns")) {
                            ch.add(attr);
                            ++numActualAttribs;
                            continue;
                        }
                        String xmlnsDecl = attr.getNodeName();
                        String prefix = xmlnsDecl.length() == 5 ? "" : xmlnsDecl.substring(6);
                        elem.addNamespaceMapping(prefix, attr.getNodeValue());
                    }
                    NodeList cl = child.getChildNodes();
                    for (int i = 0; i < cl.getLength(); ++i) {
                        n = cl.item(i);
                        ch.add(n);
                    }
                    elem.setChildCount(ch.getLength());
                    if (numActualAttribs != (short)numActualAttribs) {
                        throw new DOMException(13, "Too many attributes");
                    }
                    elem.setAttributes(numActualAttribs);
                    lastPath.addComponent(elem.getQName());
                    broker.insertNodeAfter(transaction, last.getNode(), elem);
                    broker.indexNode(transaction, elem, lastPath);
                    IndexController indexes = broker.getIndexController();
                    indexes.startIndexDocument(transaction, listener);
                    try {
                        indexes.indexNode(transaction, elem, lastPath, listener);
                        elem.setChildCount(0);
                        last.setNode(elem);
                        elem.appendChildren(transaction, newNodeId.newChild(), null, last, lastPath, ch, listener);
                        broker.endElement(elem, lastPath, null);
                        indexes.endElement(transaction, elem, lastPath, listener);
                    }
                    finally {
                        indexes.endIndexDocument(transaction, listener);
                    }
                    lastPath.removeLastComponent();
                    n = elem;
                    return n;
                }
                case 3: {
                    TextImpl text = new TextImpl(newNodeId, ((Text)child).getData());
                    text.setOwnerDocument(owner);
                    broker.insertNodeAfter(transaction, last.getNode(), text);
                    broker.indexNode(transaction, text, lastPath);
                    broker.getIndexController().indexNode(transaction, text, lastPath, listener);
                    last.setNode(text);
                    TextImpl prefix = text;
                    return prefix;
                }
                case 4: {
                    CDATASectionImpl cdata = new CDATASectionImpl(newNodeId, ((CDATASection)child).getData());
                    cdata.setOwnerDocument(owner);
                    broker.insertNodeAfter(transaction, last.getNode(), cdata);
                    broker.indexNode(transaction, cdata, lastPath);
                    last.setNode(cdata);
                    CDATASectionImpl cDATASectionImpl = cdata;
                    return cDATASectionImpl;
                }
                case 2: {
                    Attr attr = (Attr)child;
                    String ns = attr.getNamespaceURI();
                    String prefix = "http://www.w3.org/XML/1998/namespace".equals(ns) ? "xml" : attr.getPrefix();
                    String name = attr.getLocalName();
                    if (name == null) {
                        name = attr.getName();
                    }
                    QName attrName = new QName(name, ns, prefix);
                    AttrImpl attrib = new AttrImpl(attrName, attr.getValue(), broker.getBrokerPool().getSymbols());
                    attrib.setNodeId(newNodeId);
                    attrib.setOwnerDocument(owner);
                    if (ns != null && attrName.compareTo(Namespaces.XML_ID_QNAME) == 0) {
                        attrib.setValue(StringValue.trimWhitespace(StringValue.collapseWhitespace(attrib.getValue())));
                        attrib.setType(1);
                    } else {
                        attrib.setQName(new QName(attrib.getQName(), 1));
                    }
                    broker.insertNodeAfter(transaction, last.getNode(), attrib);
                    broker.indexNode(transaction, attrib, lastPath);
                    broker.getIndexController().indexNode(transaction, attrib, lastPath, listener);
                    last.setNode(attrib);
                    AttrImpl attrImpl = attrib;
                    return attrImpl;
                }
                case 8: {
                    CommentImpl comment = new CommentImpl(((Comment)child).getData());
                    comment.setNodeId(newNodeId);
                    comment.setOwnerDocument(owner);
                    broker.insertNodeAfter(transaction, last.getNode(), comment);
                    broker.indexNode(transaction, comment, lastPath);
                    last.setNode(comment);
                    CommentImpl commentImpl = comment;
                    return commentImpl;
                }
                case 7: {
                    ProcessingInstructionImpl pi = new ProcessingInstructionImpl(newNodeId, ((ProcessingInstruction)child).getTarget(), ((ProcessingInstruction)child).getData());
                    pi.setOwnerDocument(owner);
                    broker.insertNodeAfter(transaction, last.getNode(), pi);
                    broker.indexNode(transaction, pi, lastPath);
                    last.setNode(pi);
                    ProcessingInstructionImpl processingInstructionImpl = pi;
                    return processingInstructionImpl;
                }
            }
            throw new DOMException(13, "Unknown node type: " + child.getNodeType() + " " + child.getNodeName());
        }
        catch (EXistException e) {
            LOG.warn("Exception while appending node: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes > 0;
    }

    public void setAttributes(short attribNum) {
        this.attributes = attribNum;
    }

    @Override
    public String getAttribute(String name) {
        AttrImpl attr = this.findAttribute(name);
        return attr != null ? attr.getValue() : "";
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        AttrImpl attr = this.findAttribute(new QName(localName, namespaceURI));
        return attr != null ? attr.getValue() : "";
    }

    @Deprecated
    public String _getAttributeNS(String namespaceURI, String localName) {
        AttrImpl attr = this.findAttribute(new QName(localName, namespaceURI));
        return attr != null ? attr.getValue() : null;
    }

    @Override
    public Attr getAttributeNode(String name) {
        return this.findAttribute(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.findAttribute(new QName(localName, namespaceURI));
    }

    @Override
    public NamedNodeMap getAttributes() {
        NamedNodeMapImpl map = new NamedNodeMapImpl(this.ownerDocument, true);
        if (this.hasAttributes()) {
            try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();
                 INodeIterator iterator = broker.getNodeIterator(this);){
                iterator.next();
                int childCount = this.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    IStoredNode next = (IStoredNode)iterator.next();
                    if (next.getNodeType() != 2) {
                        break;
                    }
                    map.setNamedItem(next);
                }
            }
            catch (IOException | EXistException e) {
                LOG.warn("Exception while retrieving attributes: " + e.getMessage());
            }
        }
        if (this.declaresNamespacePrefixes()) {
            for (Map.Entry<String, String> entry : this.namespaceMappings.entrySet()) {
                String prefix = entry.getKey();
                String ns = entry.getValue();
                QName attrName = new QName(prefix, "http://www.w3.org/2000/xmlns/", "xmlns");
                AttrImpl attr = new AttrImpl(attrName, ns, null);
                attr.setOwnerDocument(this.ownerDocument);
                map.setNamedItem(attr);
            }
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    private AttrImpl findAttribute(String qname) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AttrImpl findAttribute(String qname, INodeIterator iterator, IStoredNode current) {
        IStoredNode next;
        int childCount = current.getChildCount();
        for (int i = 0; i < childCount && (next = (IStoredNode)iterator.next()).getNodeType() == 2; ++i) {
            if (!next.getNodeName().equals(qname)) continue;
            return (AttrImpl)next;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private AttrImpl findAttribute(QName qname) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AttrImpl findAttribute(QName qname, INodeIterator iterator, IStoredNode current) {
        IStoredNode next;
        int childCount = current.getChildCount();
        for (int i = 0; i < childCount && (next = (IStoredNode)iterator.next()).getNodeType() == 2; ++i) {
            if (!next.getQName().equals(qname)) continue;
            return (AttrImpl)next;
        }
        return null;
    }

    private NodeList findDupAttributes(NodeList attrs) throws DOMException {
        NodeListImpl dupList = null;
        NamedNodeMap map = this.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node duplicate;
            Node attr = attrs.item(i);
            String localName = attr.getLocalName();
            if (localName == null) {
                localName = attr.getNodeName();
            }
            if ((duplicate = map.getNamedItemNS(attr.getNamespaceURI(), localName)) == null) continue;
            if (dupList == null) {
                dupList = new NodeListImpl();
            }
            dupList.add(duplicate);
        }
        return dupList;
    }

    @Override
    public int getChildCount() {
        return this.children;
    }

    @Override
    public boolean hasChildNodes() {
        return this.children - this.attributes > 0;
    }

    @Override
    public NodeList getChildNodes() {
        NodeListImpl childList = new NodeListImpl(this.children);
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            IEmbeddedXMLStreamReader reader = broker.getXMLStreamReader(this, false);
            while (reader.hasNext()) {
                int status = reader.next();
                if (status == 2 || !((NodeId)reader.getProperty("node-id")).isChildOf(this.nodeId)) continue;
                childList.add(reader.getNode());
            }
        }
        catch (IOException | XMLStreamException | EXistException e) {
            LOG.warn("Internal error while reading child nodes: " + e.getMessage(), (Throwable)e);
        }
        return childList;
    }

    private NodeList getAttrsAndChildNodes() {
        NodeListImpl childList = new NodeListImpl(this.children);
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            IEmbeddedXMLStreamReader reader = broker.getXMLStreamReader(this, true);
            while (reader.hasNext()) {
                int status = reader.next();
                if (status == 2 || !((NodeId)reader.getProperty("node-id")).isChildOf(this.nodeId)) continue;
                childList.add(reader.getNode());
            }
        }
        catch (IOException | XMLStreamException | EXistException e) {
            LOG.warn("Internal error while reading child nodes: " + e.getMessage(), (Throwable)e);
        }
        return childList;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        if (name != null && name.equals("*")) {
            return this.getElementsByTagName(new QName.WildcardLocalPartQName(""));
        }
        try {
            return this.getElementsByTagName(new QName(name));
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, "name is invalid");
        }
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        boolean wildcardLocalPart;
        boolean wildcardNS = namespaceURI != null && namespaceURI.equals("*");
        boolean bl = wildcardLocalPart = localName != null && localName.equals("*");
        if (wildcardNS && wildcardLocalPart) {
            return this.getElementsByTagName(QName.WildcardQName.getInstance());
        }
        if (wildcardNS) {
            return this.getElementsByTagName(new QName.WildcardNamespaceURIQName(localName));
        }
        if (wildcardLocalPart) {
            return this.getElementsByTagName(new QName.WildcardLocalPartQName(namespaceURI));
        }
        return this.getElementsByTagName(new QName(localName, namespaceURI));
    }

    private NodeList getElementsByTagName(QName qname) {
        return this.getOwnerDocument().findElementsByTagName(this, qname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node getFirstChild() {
        if (!this.hasChildNodes()) {
            return null;
        }
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();
             INodeIterator iterator = broker.getNodeIterator(this);){
            iterator.next();
            int i = 0;
            while (i < this.getChildCount()) {
                IStoredNode next = (IStoredNode)iterator.next();
                if (next.getNodeType() != 2) {
                    IStoredNode iStoredNode = next;
                    return iStoredNode;
                }
                ++i;
            }
            return null;
        }
        catch (IOException | EXistException e) {
            LOG.warn("Exception while retrieving child node: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Node getLastChild() {
        return this.getLastChild(false);
    }

    private Node getLastChild(boolean attributesAreChildren) {
        if (!attributesAreChildren && !this.hasChildNodes()) {
            return null;
        }
        if (!this.hasChildNodes() && !this.hasAttributes()) {
            return null;
        }
        Node node = null;
        if (!this.isDirty) {
            NodeId child = this.nodeId.getChild(this.children);
            node = this.ownerDocument.getNode(new NodeProxy(this.ownerDocument, child));
        }
        if (node == null) {
            NodeList cl = !attributesAreChildren ? this.getChildNodes() : this.getAttrsAndChildNodes();
            return cl.item(cl.getLength() - 1);
        }
        return node;
    }

    @Override
    public String getTagName() {
        return this.nodeName.getStringValue();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.findAttribute(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.findAttribute(new QName(localName, namespaceURI)) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getTextContent() throws DOMException {
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            String string = broker.getNodeValue(this, false);
            return string;
        }
        catch (EXistException e) {
            LOG.warn("Exception while reading node value: " + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        Attr attr = this.getAttributeNode(name);
        if (attr == null) {
            return;
        }
        this.removeAttributeNode(attr);
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String name) throws DOMException {
        Attr attr = this.getAttributeNodeNS(namespaceURI, name);
        if (attr == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();
             Txn transaction = broker.getBrokerPool().getTransactionManager().beginTransaction();){
            try {
                if (!(oldAttr instanceof IStoredNode)) {
                    throw new DOMException(4, "Wrong node type");
                }
                IStoredNode old = (IStoredNode)((Object)oldAttr);
                if (!old.getNodeId().isChildOf(this.nodeId)) {
                    throw new DOMException(8, "node " + old.getNodeId().getParentId() + " is not a child of element " + this.nodeId);
                }
                NodePath oldPath = old.getPath();
                IndexController indexes = broker.getIndexController();
                indexes.reindex(transaction, old, StreamListener.ReindexMode.REMOVE_SOME_NODES);
                broker.removeNode(transaction, old, oldPath, null);
                --this.children;
                this.attributes = (short)(this.attributes - 1);
            }
            finally {
                broker.endRemove(transaction);
            }
        }
        catch (EXistException e) {
            LOG.error((Object)e);
            throw new DOMException(15, e.getMessage());
        }
        return oldAttr;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        QName qname;
        try {
            qname = new QName(name);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, "name is invalid");
        }
        if (qname.isValid(false) != QName.Validity.VALID.val) {
            throw new DOMException(5, "name is invalid");
        }
        this.setAttribute(qname, value, qn -> this.getAttributeNode(qn.getLocalPart()));
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        QName qname;
        try {
            qname = QName.parse(namespaceURI, qualifiedName);
        }
        catch (QName.IllegalQNameException e) {
            int errCode = e.getValidity() == QName.Validity.ILLEGAL_FORMAT.val || (e.getValidity() & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val ? 14 : 5;
            throw new DOMException((short)errCode, "qualified name is invalid");
        }
        byte validity = qname.isValid(false);
        if ((validity & QName.Validity.INVALID_LOCAL_PART.val) == QName.Validity.INVALID_LOCAL_PART.val) {
            throw new DOMException(5, "qualified name is invalid");
        }
        if ((validity & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val) {
            throw new DOMException(14, "qualified name is invalid");
        }
        this.setAttribute(qname, value, qn -> this.getAttributeNodeNS(qn.getNamespaceURI(), qn.getLocalPart()));
    }

    private void setAttribute(QName attrName, String value, Function<QName, Attr> getFn) {
        block43: {
            Attr existingAttr = getFn.apply(attrName);
            if (existingAttr != null) {
                existingAttr.setValue(value);
                try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();
                     Txn transaction = broker.getBrokerPool().getTransactionManager().beginTransaction();){
                    if (!(existingAttr instanceof IStoredNode)) {
                        throw new DOMException(4, "Wrong node type");
                    }
                    IStoredNode existing = (IStoredNode)((Object)existingAttr);
                    if (!existing.getNodeId().isChildOf(this.nodeId)) {
                        throw new DOMException(8, "node " + existing.getNodeId().getParentId() + " is not a child of element " + this.nodeId);
                    }
                    IndexController indexes = broker.getIndexController();
                    indexes.reindex(transaction, existing, StreamListener.ReindexMode.STORE);
                    broker.updateNode(transaction, existing, true);
                    transaction.commit();
                    break block43;
                }
                catch (EXistException e) {
                    LOG.error((Object)e);
                    throw new DOMException(15, e.getMessage());
                }
            }
            try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
                AttrImpl attrib = new AttrImpl(attrName, value, broker.getBrokerPool().getSymbols());
                this.appendChild(attrib);
            }
            catch (EXistException e) {
                LOG.error((Object)e);
                throw new DOMException(15, e.getMessage());
            }
        }
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr, qname -> this.getAttributeNode(qname.getLocalPart()));
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.setAttributeNode(newAttr, qname -> this.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attr setAttributeNode(Attr newAttr, Function<QName, Attr> getFn) {
        QName attrName = new QName(newAttr.getLocalName(), newAttr.getNamespaceURI(), newAttr.getPrefix(), 1);
        Attr existingAttr = getFn.apply(attrName);
        if (existingAttr != null) {
            if (existingAttr.equals(newAttr)) {
                return newAttr;
            }
            existingAttr.setValue(newAttr.getValue());
            try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();
                 Txn transaction = broker.getBrokerPool().getTransactionManager().beginTransaction();){
                if (!(existingAttr instanceof IStoredNode)) {
                    throw new DOMException(4, "Wrong node type");
                }
                IStoredNode existing = (IStoredNode)((Object)existingAttr);
                if (!existing.getNodeId().isChildOf(this.nodeId)) {
                    throw new DOMException(8, "node " + existing.getNodeId().getParentId() + " is not a child of element " + this.nodeId);
                }
                IndexController indexes = broker.getIndexController();
                indexes.reindex(transaction, existing, StreamListener.ReindexMode.STORE);
                broker.updateNode(transaction, existing, true);
                transaction.commit();
                return existingAttr;
            }
            catch (EXistException e) {
                LOG.error((Object)e);
                throw new DOMException(15, e.getMessage());
            }
        }
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            AttrImpl attrib = new AttrImpl(attrName, newAttr.getValue(), broker.getBrokerPool().getSymbols());
            Attr attr = (Attr)this.appendChild(attrib);
            return attr;
        }
        catch (EXistException e) {
            LOG.error((Object)e);
            throw new DOMException(15, e.getMessage());
        }
    }

    public void setChildCount(int count) {
        this.children = count;
    }

    public void setNamespaceMappings(Map<String, String> map) {
        this.namespaceMappings = new HashMap<String, String>(map);
        for (String ns : this.namespaceMappings.values()) {
            this.ownerDocument.getBrokerPool().getSymbols().getNSSymbol(ns);
        }
    }

    public Iterator<String> getPrefixes() {
        return this.namespaceMappings.keySet().iterator();
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.namespaceMappings.get(prefix);
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean top) {
        return this.toString(top, new TreeSet<String>());
    }

    private String toString(boolean top, Set<String> namespaces) {
        StringBuilder buf = new StringBuilder();
        buf.append('<');
        buf.append(this.nodeName);
        if (this.declaresNamespacePrefixes()) {
            for (Map.Entry<String, String> namespaceMapping : this.namespaceMappings.entrySet()) {
                String prefix = namespaceMapping.getKey();
                String namespace = namespaceMapping.getValue();
                buf.append(' ').append("xmlns");
                if (!prefix.isEmpty()) {
                    buf.append(':').append(prefix);
                }
                buf.append("=\"").append(namespace).append('\"');
                namespaces.add(namespace);
            }
        }
        if (this.nodeName.getNamespaceURI().length() > 0 && !namespaces.contains(this.nodeName.getNamespaceURI())) {
            buf.append(' ').append("xmlns").append(':').append(this.nodeName.getPrefix()).append("=\"").append(this.nodeName.getNamespaceURI()).append('\"');
        }
        if (this.getInternalAddress() == -1L) {
            buf.append(" ...");
        } else {
            NamedNodeMap attrs = this.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                buf.append(' ').append(attr.getName()).append("=\"").append(this.escapeXml(attr)).append("\"");
            }
            StringBuilder children = new StringBuilder();
            NodeList childNodes = this.getChildNodes();
            block5: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                switch (child.getNodeType()) {
                    case 1: {
                        children.append(((ElementImpl)child).toString(false, namespaces));
                        continue block5;
                    }
                    default: {
                        children.append(child.toString());
                    }
                }
            }
            if (childNodes.getLength() > 0) {
                buf.append(">");
                buf.append(children.toString());
                buf.append("</").append(this.nodeName).append(">");
            } else {
                buf.append("/>");
            }
        }
        return buf.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void insertBefore(Txn transaction, NodeList nodes, Node refChild) throws DOMException {
        if (refChild == null) {
            this.appendChildren(transaction, nodes, -1);
            return;
        }
        if (!(refChild instanceof IStoredNode)) {
            throw new DOMException(4, "wrong node type");
        }
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            NodePath path = this.getPath();
            IndexController indexes = broker.getIndexController();
            indexes.setDocument(this.ownerDocument);
            IStoredNode reindexRoot = indexes.getReindexRoot(this, path, true, true);
            indexes.setMode(StreamListener.ReindexMode.STORE);
            StreamListener listener = reindexRoot == null ? indexes.getStreamListener() : null;
            IStoredNode following = (IStoredNode)refChild;
            IStoredNode previous = (IStoredNode)following.getPreviousSibling();
            if (previous == null) {
                NodeId newId = following.getNodeId().insertBefore();
                this.appendChildren(transaction, newId, following.getNodeId(), new NodeImplRef(this), path, nodes, listener);
            } else {
                NodeId newId = previous.getNodeId().insertNode(following.getNodeId());
                this.appendChildren(transaction, newId, following.getNodeId(), new NodeImplRef(this.getLastNode(previous)), path, nodes, listener);
            }
            this.setDirty(true);
            broker.updateNode(transaction, this, true);
            indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.STORE);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn("Exception while inserting node: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void insertAfter(Txn transaction, NodeList nodes, Node refChild) throws DOMException {
        if (refChild == null) {
            this.appendChildren(null, nodes, -1);
            return;
        }
        if (!(refChild instanceof IStoredNode)) {
            throw new DOMException(4, "wrong node type: ");
        }
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            NodePath path = this.getPath();
            IndexController indexes = broker.getIndexController();
            indexes.setDocument(this.ownerDocument);
            IStoredNode reindexRoot = indexes.getReindexRoot(this, path, true, true);
            indexes.setMode(StreamListener.ReindexMode.STORE);
            StreamListener listener = reindexRoot == null ? indexes.getStreamListener() : null;
            IStoredNode previous = (IStoredNode)refChild;
            IStoredNode following = (IStoredNode)previous.getNextSibling();
            NodeId followingId = following == null ? null : following.getNodeId();
            NodeId newNodeId = previous.getNodeId().insertNode(followingId);
            this.appendChildren(transaction, newNodeId, followingId, new NodeImplRef(this.getLastNode(previous)), path, nodes, listener);
            this.setDirty(true);
            broker.updateNode(transaction, this, true);
            indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.STORE);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn("Exception while inserting node: " + e.getMessage(), (Throwable)e);
        }
    }

    public void update(Txn transaction, NodeList newContent) throws DOMException {
        NodePath path = this.getPath();
        NodeList nodes = this.getAttrsAndChildNodes();
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            int i;
            StreamListener listener;
            IndexController indexes = broker.getIndexController();
            indexes.setDocument(this.ownerDocument);
            IStoredNode reindexRoot = indexes.getReindexRoot(this, path, true, true);
            indexes.setMode(StreamListener.ReindexMode.REMOVE_SOME_NODES);
            if (reindexRoot == null) {
                listener = indexes.getStreamListener();
            } else {
                listener = null;
                indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.REMOVE_SOME_NODES);
            }
            IStoredNode valueReindexRoot = broker.getValueIndex().getReindexRoot(this, path);
            broker.getValueIndex().reindex(valueReindexRoot);
            IStoredNode last = this;
            for (i = nodes.getLength(); i > 0; --i) {
                IStoredNode child = (IStoredNode)nodes.item(i - 1);
                if (child.getNodeType() == 2) {
                    last = child;
                    break;
                }
                if (child.getNodeType() == 1) {
                    path.addComponent(child.getQName());
                }
                broker.removeAllNodes(transaction, child, path, listener);
                if (child.getNodeType() != 1) continue;
                path.removeLastComponent();
            }
            indexes.flush();
            indexes.setMode(StreamListener.ReindexMode.STORE);
            indexes.getStreamListener();
            broker.endRemove(transaction);
            this.children = i;
            NodeId newNodeId = last == this ? this.nodeId.newChild() : last.getNodeId().nextSibling();
            this.appendChildren(transaction, newNodeId, null, new NodeImplRef(last), path, newContent, listener);
            broker.updateNode(transaction, this, false);
            indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.STORE);
            broker.getValueIndex().reindex(valueReindexRoot);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn("Exception while inserting node: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public IStoredNode updateChild(Txn transaction, Node oldChild, Node newChild) throws DOMException {
        IStoredNode previousNode;
        if (!(oldChild instanceof IStoredNode) || !(newChild instanceof IStoredNode)) {
            throw new DOMException(4, "Wrong node type");
        }
        IStoredNode oldNode = (IStoredNode)oldChild;
        IStoredNode newNode = (IStoredNode)newChild;
        if (!oldNode.getNodeId().getParentId().equals(this.nodeId)) {
            throw new DOMException(8, "Node is not a child of this element");
        }
        if (newNode.getNodeType() == 2 && newNode.getQName().equals(Namespaces.XML_ID_QNAME)) {
            AttrImpl attr = (AttrImpl)newNode;
            attr.setValue(StringValue.trimWhitespace(StringValue.collapseWhitespace(attr.getValue())));
            attr.setType(1);
        }
        previousNode = (previousNode = (IStoredNode)oldNode.getPreviousSibling()) == null ? this : this.getLastNode(previousNode);
        NodePath currentPath = this.getPath();
        NodePath oldPath = oldNode.getPath(currentPath);
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            IndexController indexes = broker.getIndexController();
            indexes.setDocument(this.ownerDocument);
            IStoredNode reindexRoot = indexes.getReindexRoot(oldNode, oldPath, false);
            indexes.setMode(StreamListener.ReindexMode.REMOVE_SOME_NODES);
            if (reindexRoot == null) {
                reindexRoot = oldNode;
            }
            indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.REMOVE_SOME_NODES);
            NativeValueIndex valueIndex = broker.getValueIndex();
            IStoredNode valueReindexRoot = valueIndex.getReindexRoot(this, oldPath);
            valueIndex.reindex(valueReindexRoot);
            broker.removeNode(transaction, oldNode, oldPath, null);
            broker.endRemove(transaction);
            newNode.setNodeId(oldNode.getNodeId());
            broker.insertNodeAfter(transaction, previousNode, newNode);
            NodePath path = newNode.getPath(currentPath);
            broker.indexNode(transaction, newNode, path);
            if (newNode.getNodeType() == 1) {
                broker.endElement(newNode, path, null);
            }
            broker.updateNode(transaction, this, true);
            indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.STORE);
            valueIndex.reindex(valueReindexRoot);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn("Exception while inserting node: " + e.getMessage(), (Throwable)e);
        }
        return newNode;
    }

    @Override
    public Node removeChild(Txn transaction, Node oldChild) throws DOMException {
        if (!(oldChild instanceof IStoredNode)) {
            throw new DOMException(4, "wrong node type");
        }
        IStoredNode oldNode = (IStoredNode)oldChild;
        if (!oldNode.getNodeId().getParentId().equals(this.nodeId)) {
            throw new DOMException(8, "node is not a child of this element");
        }
        NodePath oldPath = oldNode.getPath();
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            StreamListener listener;
            IndexController indexes = broker.getIndexController();
            indexes.setDocument(this.ownerDocument);
            IStoredNode reindexRoot = indexes.getReindexRoot(oldNode, oldPath, false);
            indexes.setMode(StreamListener.ReindexMode.REMOVE_SOME_NODES);
            if (reindexRoot == null) {
                listener = indexes.getStreamListener();
            } else {
                listener = null;
                indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.REMOVE_SOME_NODES);
            }
            broker.removeAllNodes(transaction, oldNode, oldPath, listener);
            --this.children;
            if (oldChild.getNodeType() == 2) {
                this.attributes = (short)(this.attributes - 1);
            }
            broker.endRemove(transaction);
            this.setDirty(true);
            broker.updateNode(transaction, this, false);
            broker.flush();
            if (reindexRoot != null && !reindexRoot.getNodeId().equals(oldNode.getNodeId())) {
                indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.STORE);
            }
        }
        catch (EXistException e) {
            LOG.warn("Exception while inserting node: " + e.getMessage(), (Throwable)e);
        }
        return oldNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppendAttributes(Txn transaction, NodeList removeList, NodeList appendList) {
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            StreamListener listener;
            IndexController indexes = broker.getIndexController();
            if (removeList != null) {
                try {
                    for (int i = 0; i < removeList.getLength(); ++i) {
                        Node oldChild = removeList.item(i);
                        if (!(oldChild instanceof IStoredNode)) {
                            throw new DOMException(4, "Wrong node type");
                        }
                        IStoredNode old = (IStoredNode)oldChild;
                        if (!old.getNodeId().isChildOf(this.nodeId)) {
                            throw new DOMException(8, "node " + old.getNodeId().getParentId() + " is not a child of element " + this.nodeId);
                        }
                        NodePath oldPath = old.getPath();
                        indexes.reindex(transaction, old, StreamListener.ReindexMode.REMOVE_SOME_NODES);
                        broker.removeNode(transaction, old, oldPath, null);
                        --this.children;
                        this.attributes = (short)(this.attributes - 1);
                    }
                }
                finally {
                    broker.endRemove(transaction);
                }
            }
            NodePath path = this.getPath();
            indexes.setDocument(this.ownerDocument, StreamListener.ReindexMode.STORE);
            IStoredNode reindexRoot = indexes.getReindexRoot(this, path, true, true);
            StreamListener streamListener = listener = reindexRoot == null ? indexes.getStreamListener() : null;
            if (this.children == 0) {
                this.appendChildren(transaction, this.nodeId.newChild(), null, new NodeImplRef(this), path, appendList, listener);
            } else {
                if (this.attributes == 0) {
                    IStoredNode firstChild = (IStoredNode)this.getFirstChild();
                    NodeId newNodeId = firstChild.getNodeId().insertBefore();
                    this.appendChildren(transaction, newNodeId, firstChild.getNodeId(), new NodeImplRef(this), path, appendList, listener);
                } else {
                    AttribVisitor visitor = new AttribVisitor();
                    this.accept(visitor);
                    NodeId firstChildId = visitor.firstChild == null ? null : visitor.firstChild.getNodeId();
                    NodeId newNodeId = visitor.lastAttrib.getNodeId().insertNode(firstChildId);
                    this.appendChildren(transaction, newNodeId, firstChildId, new NodeImplRef(visitor.lastAttrib), path, appendList, listener);
                }
                this.setDirty(true);
            }
            this.attributes = (short)(this.attributes + appendList.getLength());
            broker.updateNode(transaction, this, true);
            broker.flush();
            indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.STORE);
        }
        catch (EXistException e) {
            LOG.warn("Exception while inserting node: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Node replaceChild(Txn transaction, Node newChild, Node oldChild) throws DOMException {
        if (!(oldChild instanceof IStoredNode)) {
            throw new DOMException(4, "Wrong node type");
        }
        IStoredNode oldNode = (IStoredNode)oldChild;
        if (!oldNode.getNodeId().getParentId().equals(this.nodeId)) {
            throw new DOMException(8, "Node is not a child of this element");
        }
        IStoredNode previous = (IStoredNode)oldNode.getPreviousSibling();
        previous = previous == null ? this : this.getLastNode(previous);
        NodePath oldPath = oldNode.getPath();
        StreamListener listener = null;
        Node newNode = null;
        try (DBBroker broker = this.ownerDocument.getBrokerPool().getBroker();){
            IndexController indexes = broker.getIndexController();
            indexes.setDocument(this.ownerDocument);
            IStoredNode reindexRoot = broker.getIndexController().getReindexRoot(oldNode, oldPath, false);
            indexes.setMode(StreamListener.ReindexMode.REMOVE_SOME_NODES);
            if (reindexRoot == null) {
                listener = indexes.getStreamListener();
            } else {
                indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.REMOVE_SOME_NODES);
            }
            broker.removeAllNodes(transaction, oldNode, oldPath, listener);
            broker.endRemove(transaction);
            broker.flush();
            indexes.setMode(StreamListener.ReindexMode.STORE);
            listener = indexes.getStreamListener();
            newNode = this.appendChild(transaction, oldNode.getNodeId(), new NodeImplRef(previous), this.getPath(), newChild, listener);
            broker.storeXMLResource(transaction, this.getOwnerDocument());
            broker.updateNode(transaction, this, false);
            indexes.reindex(transaction, reindexRoot, StreamListener.ReindexMode.STORE);
            broker.flush();
        }
        catch (EXistException e) {
            LOG.warn("Exception while inserting node: " + e.getMessage(), (Throwable)e);
        }
        return newNode;
    }

    private String escapeXml(Node child) {
        String str = ((Attr)child).getValue();
        StringBuilder buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public void setPreserveSpace(boolean preserveWS) {
        this.preserveWS = preserveWS;
    }

    public boolean preserveSpace() {
        return this.preserveWS;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw this.unsupported();
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw this.unsupported();
    }

    @Override
    public String getBaseURI() {
        XmldbURI baseURI = this.calculateBaseURI();
        if (baseURI != null) {
            return baseURI.toString();
        }
        return "";
    }

    private XmldbURI calculateBaseURI() {
        XmldbURI baseURI = null;
        String nodeBaseURI = this._getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (nodeBaseURI != null && (baseURI = XmldbURI.create(nodeBaseURI, false)).isAbsolute()) {
            return baseURI;
        }
        StoredNode parent = this.getParentStoredNode();
        if (parent != null) {
            if (nodeBaseURI == null) {
                baseURI = ((ElementImpl)parent).calculateBaseURI();
            } else {
                XmldbURI parentsBaseURI = ((ElementImpl)parent).calculateBaseURI();
                baseURI = nodeBaseURI.isEmpty() ? parentsBaseURI : parentsBaseURI.append(baseURI);
            }
        } else {
            if (nodeBaseURI == null) {
                return XmldbURI.create(this.getOwnerDocument().getBaseURI(), false);
            }
            String docBaseURI = this.getOwnerDocument().getBaseURI();
            if (docBaseURI.endsWith("/")) {
                baseURI = XmldbURI.create(this.getOwnerDocument().getBaseURI(), false);
                baseURI.append(baseURI);
            } else {
                baseURI = XmldbURI.create(this.getOwnerDocument().getBaseURI(), false);
                baseURI = baseURI.removeLastSegment();
                baseURI.append(baseURI);
            }
        }
        return baseURI;
    }

    @Override
    public boolean accept(INodeIterator iterator, NodeVisitor visitor) {
        if (!visitor.visit(this)) {
            return false;
        }
        if (this.hasChildNodes() || this.hasAttributes()) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                IStoredNode next = (IStoredNode)iterator.next();
                if (next.accept(iterator, visitor)) continue;
                return false;
            }
        }
        return true;
    }

    private class AttribVisitor
    implements NodeVisitor {
        private IStoredNode lastAttrib = null;
        private IStoredNode firstChild = null;

        private AttribVisitor() {
        }

        @Override
        public boolean visit(IStoredNode node) {
            if (node.getNodeType() == 2) {
                this.lastAttrib = node;
            } else if (node.getNodeId().isChildOf(ElementImpl.this.nodeId)) {
                this.firstChild = node;
                return false;
            }
            return true;
        }
    }
}

