/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.exist.collections.Collection;
import org.exist.dom.persistent.AbstractArrayNodeSet;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.util.ArrayUtils;
import org.exist.util.FastQSort;
import org.exist.util.LockException;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;

public class ExtArrayNodeSet
extends AbstractArrayNodeSet
implements DocumentSet {
    private static final int DEFAULT_INITIAL_SIZE = 128;
    private final int initialSize;
    private final Deque<Runnable> lockReleasers = new ArrayDeque<Runnable>();
    private int[] documentIds;
    protected int lastDoc = -1;
    private Part[] parts;
    private int partCount = 0;
    protected Part lastPart = null;
    private boolean keepUnOrdered = false;

    public ExtArrayNodeSet() {
        this.initialSize = 128;
        this.documentIds = new int[64];
        this.parts = new Part[64];
        Arrays.fill(this.documentIds, 0);
    }

    public ExtArrayNodeSet(int initialDocsCount, int initialArraySize) {
        this.initialSize = initialArraySize;
        this.documentIds = new int[initialDocsCount > 0 ? initialDocsCount : 1];
        this.parts = new Part[initialDocsCount > 0 ? initialDocsCount : 1];
        Arrays.fill(this.documentIds, 0);
    }

    public ExtArrayNodeSet(int initialArraySize) {
        this.initialSize = initialArraySize;
        this.documentIds = new int[64];
        this.parts = new Part[64];
        Arrays.fill(this.documentIds, 0);
    }

    public void keepUnOrdered(boolean flag) {
        this.keepUnOrdered = flag;
    }

    private Part getPart(DocumentImpl doc, boolean create, int sizeHint) {
        if (this.lastPart != null && doc.getDocId() == this.lastDoc) {
            return this.lastPart;
        }
        int idx = ArrayUtils.binarySearch(this.documentIds, doc.getDocId(), this.partCount);
        Part part = null;
        if (idx >= 0) {
            part = this.parts[idx];
        } else if (create) {
            idx = -(idx + 1);
            part = new Part(sizeHint);
            this.insertPart(doc.getDocId(), part, idx);
        }
        return part;
    }

    private void insertPart(int docId, Part part, int idx) {
        if (this.partCount == this.parts.length) {
            int nsize = this.parts.length == 0 ? 1 : this.parts.length * 2;
            int[] ndocs = new int[nsize];
            System.arraycopy(this.documentIds, 0, ndocs, 0, this.documentIds.length);
            Arrays.fill(this.documentIds, -1);
            Part[] nparts = new Part[nsize];
            System.arraycopy(this.parts, 0, nparts, 0, this.parts.length);
            this.documentIds = ndocs;
            this.parts = nparts;
        }
        if (idx == this.partCount) {
            this.documentIds[idx] = docId;
            this.parts[idx] = part;
        } else {
            System.arraycopy(this.documentIds, idx, this.documentIds, idx + 1, this.partCount - idx);
            System.arraycopy(this.parts, idx, this.parts, idx + 1, this.partCount - idx);
            this.documentIds[idx] = docId;
            this.parts[idx] = part;
        }
        ++this.partCount;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.partCount; ++i) {
            this.parts[i] = null;
            this.documentIds[i] = 0;
        }
        this.size = 0;
        this.partCount = 0;
        this.isSorted = false;
        this.lastPart = null;
        this.lastDoc = -1;
        this.state = 0;
    }

    @Override
    protected final void addInternal(NodeProxy proxy, int sizeHint) {
        this.getPart(proxy.getOwnerDocument(), true, sizeHint != -1 ? sizeHint : this.initialSize).add(proxy);
        ++this.size;
    }

    @Override
    public int getSizeHint(DocumentImpl doc) {
        Part part = this.getPart(doc, false, 0);
        return part == null ? -1 : part.length;
    }

    @Override
    public NodeSetIterator iterator() {
        if (!this.isSorted()) {
            this.sort();
        }
        return new ExtArrayIterator();
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        this.sortInDocumentOrder();
        return new ExtArrayIterator();
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        if (!this.isSorted()) {
            this.sort();
        }
        return new ExtArrayIterator();
    }

    @Override
    public boolean contains(NodeProxy proxy) {
        Part part = this.getPart(proxy.getOwnerDocument(), false, 0);
        return part == null ? false : part.contains(proxy.getNodeId());
    }

    @Override
    public NodeProxy get(int pos) {
        int count = 0;
        for (int i = 0; i < this.partCount; ++i) {
            Part part = this.parts[i];
            if (count + part.length > pos) {
                return part.get(pos - count);
            }
            count += part.length;
        }
        return null;
    }

    @Override
    public NodeProxy get(NodeProxy p) {
        Part part = this.getPart(p.getOwnerDocument(), false, 0);
        return part == null ? null : part.get(p.getNodeId());
    }

    @Override
    public NodeProxy get(DocumentImpl doc, NodeId nodeId) {
        this.sort();
        Part part = this.getPart(doc, false, 0);
        return part == null ? null : part.get(nodeId);
    }

    @Override
    protected final NodeSet getDescendantsInSet(NodeSet al, boolean childOnly, boolean includeSelf, int mode, int contextId, boolean copyMatches) {
        this.sort();
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        for (NodeProxy node : al) {
            Part part = this.getPart(node.getOwnerDocument(), false, 0);
            if (part == null) continue;
            part.getDescendantsInSet(result, node, childOnly, includeSelf, mode, contextId, copyMatches);
        }
        return result;
    }

    public NodeProxy hasDescendantsInSet(DocumentImpl doc, NodeId ancestorId, boolean includeSelf, int contextId) {
        this.sort();
        Part part = this.getPart(doc, false, 0);
        return part == null ? null : part.hasDescendantsInSet(ancestorId, contextId, includeSelf);
    }

    @Override
    public void sort(boolean mergeContexts) {
        if (this.isSorted || this.keepUnOrdered) {
            return;
        }
        if (this.hasOne) {
            this.isSorted = true;
            this.size = this.parts[0].removeDuplicates(mergeContexts);
            return;
        }
        this.size = 0;
        for (int i = 0; i < this.partCount; ++i) {
            Part part = this.parts[i];
            part.sort();
            this.size += part.removeDuplicates(mergeContexts);
        }
        this.isSorted = true;
    }

    @Override
    public void setSelfAsContext(int contextId) throws XPathException {
        for (int i = 0; i < this.partCount; ++i) {
            this.parts[i].setSelfAsContext(contextId);
        }
    }

    @Override
    public NodeSet selectPrecedingSiblings(NodeSet siblings, int contextId) {
        this.sort();
        return super.selectPrecedingSiblings(siblings, contextId);
    }

    @Override
    public NodeSet selectFollowingSiblings(NodeSet siblings, int contextId) {
        this.sort();
        return super.selectFollowingSiblings(siblings, contextId);
    }

    @Override
    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
        this.sort();
        this.lastPart = this.getPart(doc, false, this.initialSize);
        return this.lastPart == null ? null : this.lastPart.parentWithChild(doc, nodeId, directParent, includeSelf);
    }

    public String debugParts() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.partCount; ++i) {
            buf.append(this.documentIds[i]);
            buf.append(' ');
        }
        return buf.toString();
    }

    @Override
    public int getIndexType() {
        if (this.indexType == 12) {
            for (int i = 0; i < this.partCount; ++i) {
                this.parts[i].determineIndexType();
            }
        }
        return this.indexType;
    }

    @Override
    public boolean equalDocs(DocumentSet other) {
        if (this == other) {
            return true;
        }
        if (this.partCount != other.getDocumentCount()) {
            return false;
        }
        for (int i = 0; i < this.partCount; ++i) {
            if (other.contains(this.parts[i].getOwnerDocument().getDocId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return new CollectionIterator();
    }

    @Override
    public Iterator<DocumentImpl> getDocumentIterator() {
        return new DocumentIterator();
    }

    @Override
    public int getDocumentCount() {
        return this.partCount;
    }

    @Override
    public DocumentImpl getDoc(int docId) {
        int idx = ArrayUtils.binarySearch(this.documentIds, docId, this.partCount);
        if (idx > -1) {
            return this.parts[idx].getOwnerDocument();
        }
        return null;
    }

    @Override
    public XmldbURI[] getNames() {
        XmldbURI[] uris = new XmldbURI[this.partCount];
        for (int i = 0; i < this.partCount; ++i) {
            uris[i] = this.parts[i].getOwnerDocument().getURI();
        }
        return uris;
    }

    @Override
    public DocumentSet intersection(DocumentSet other) {
        DocumentImpl doc;
        DefaultDocumentSet set = new DefaultDocumentSet();
        for (int i = 0; i < this.partCount; ++i) {
            doc = this.parts[i].getOwnerDocument();
            if (!other.contains(doc.getDocId())) continue;
            set.add(doc);
        }
        Iterator<DocumentImpl> i = other.getDocumentIterator();
        while (i.hasNext()) {
            doc = i.next();
            if (!this.contains(doc.getDocId()) || set.contains(doc.getDocId())) continue;
            set.add(doc);
        }
        return set;
    }

    @Override
    public boolean contains(DocumentSet other) {
        if (other.getDocumentCount() > this.partCount) {
            return false;
        }
        Iterator<DocumentImpl> i = other.getDocumentIterator();
        while (i.hasNext()) {
            DocumentImpl doc = i.next();
            if (this.contains(doc.getDocId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(int docId) {
        return ArrayUtils.binarySearch(this.documentIds, docId, this.partCount) > -1;
    }

    @Override
    public NodeSet docsToNodeSet() {
        ExtArrayNodeSet result = new ExtArrayNodeSet(this.partCount);
        for (int i = 0; i < this.partCount; ++i) {
            DocumentImpl doc = this.parts[i].getOwnerDocument();
            if (doc.getResourceType() != 0) continue;
            result.add(new NodeProxy(doc, NodeId.DOCUMENT_NODE));
        }
        return result;
    }

    @Override
    public void lock(DBBroker broker, boolean exclusive) throws LockException {
        for (int i = 0; i < this.partCount; ++i) {
            DocumentImpl doc = this.parts[i].getOwnerDocument();
            Lock docLock = doc.getUpdateLock();
            docLock.acquire(exclusive ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK);
            this.lockReleasers.push(() -> docLock.release(exclusive ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK));
        }
    }

    @Override
    public void unlock() {
        while (!this.lockReleasers.isEmpty()) {
            this.lockReleasers.pop().run();
        }
    }

    private class ExtArrayIterator
    implements NodeSetIterator,
    SequenceIterator {
        Part currentPart = null;
        int partPos = 0;
        int pos = 0;
        NodeProxy next = null;

        ExtArrayIterator() {
            if (this.partPos < ExtArrayNodeSet.this.partCount) {
                this.currentPart = ExtArrayNodeSet.this.parts[this.partPos];
            }
            if (this.currentPart != null && this.currentPart.length > 0) {
                this.next = this.currentPart.get(0);
            }
        }

        @Override
        public final void setPosition(NodeProxy proxy) {
            this.partPos = ArrayUtils.binarySearch(ExtArrayNodeSet.this.documentIds, proxy.getOwnerDocument().getDocId(), ExtArrayNodeSet.this.partCount);
            if (this.partPos >= 0) {
                this.currentPart = ExtArrayNodeSet.this.parts[this.partPos];
                int low = 0;
                int high = this.currentPart.length - 1;
                while (low <= high) {
                    int mid = (low + high) / 2;
                    NodeProxy p = this.currentPart.array[mid];
                    int cmp = p.getNodeId().compareTo(proxy.getNodeId());
                    if (cmp == 0) {
                        this.pos = mid;
                        this.next = p;
                        return;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    low = mid + 1;
                }
            }
            this.next = null;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final NodeProxy next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            NodeProxy n = this.next;
            this.next = null;
            if (++this.pos == this.currentPart.length) {
                if (++this.partPos < ExtArrayNodeSet.this.partCount) {
                    this.currentPart = ExtArrayNodeSet.this.parts[this.partPos];
                    if (this.currentPart != null && this.currentPart.length > 0) {
                        this.next = this.currentPart.get(0);
                        this.pos = 0;
                    }
                }
            } else {
                this.next = this.currentPart.get(this.pos);
            }
            return n;
        }

        @Override
        public final NodeProxy peekNode() {
            return this.next;
        }

        @Override
        public final Item nextItem() {
            if (this.next == null) {
                return null;
            }
            return this.next();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Part {
        private boolean isSorted = false;
        private NodeProxy[] array;
        private int length = 0;

        Part(int initialSize) {
            this.array = new NodeProxy[initialSize];
        }

        public void selectParentChild(NodeSet result, NodeProxy na, NodeSetIterator ia, int mode, int contextId) {
            if (this.length == 0) {
                return;
            }
            int pos = 0;
            int startPos = 0;
            NodeProxy nb = this.array[pos];
            NodeId lastMarked = na.getNodeId();
            while (na.getOwnerDocument().getDocId() == nb.getOwnerDocument().getDocId()) {
                NodeProxy next;
                NodeId pa = na.getNodeId();
                NodeId pb = nb.getNodeId();
                int relation = pb.computeRelation(pa);
                if (relation != -1) {
                    NodeProxy next2;
                    if (relation == 1) {
                        if (mode == 1) {
                            if (-1 != contextId) {
                                nb.addContextNode(contextId, na);
                            } else {
                                nb.copyContext(na);
                            }
                            result.add(nb);
                        } else {
                            if (-1 != contextId) {
                                na.addContextNode(contextId, nb);
                            } else {
                                na.copyContext(nb);
                            }
                            result.add(na);
                        }
                    }
                    if (++pos < this.length) {
                        nb = this.array[pos];
                        continue;
                    }
                    if (!ia.hasNext() || !(next2 = ia.peekNode()).getNodeId().isDescendantOf(pa)) break;
                    pos = startPos;
                    nb = this.array[pos];
                    na = (NodeProxy)ia.next();
                    startPos = pos;
                    continue;
                }
                int cmp = pa.compareTo(pb);
                if (cmp < 0) {
                    if (!ia.hasNext()) break;
                    next = (NodeProxy)ia.next();
                    if (next.getNodeId().isDescendantOf(pa)) {
                        pos = startPos;
                        nb = this.array[pos];
                    } else if (!next.getNodeId().isDescendantOf(lastMarked)) {
                        lastMarked = next.getNodeId();
                        startPos = pos;
                    }
                    na = next;
                    continue;
                }
                if (++pos < this.length) {
                    nb = this.array[pos];
                    continue;
                }
                if (!ia.hasNext()) continue;
                next = (NodeProxy)ia.next();
                if (next.getNodeId().isDescendantOf(pa)) {
                    pos = startPos;
                    nb = this.array[pos];
                }
                na = next;
            }
        }

        void add(NodeProxy p) {
            if (this.length > 0 && this.array[this.length - 1].getNodeId().equals(p.getNodeId())) {
                this.array[this.length - 1].addMatches(p);
                return;
            }
            if (this.length == this.array.length) {
                int newLength = this.length << 1;
                NodeProxy[] temp = new NodeProxy[newLength];
                System.arraycopy(this.array, 0, temp, 0, this.length);
                this.array = temp;
            }
            this.array[this.length++] = p;
        }

        boolean contains(NodeId nodeId) {
            return this.get(nodeId) != null;
        }

        NodeProxy get(int pos) {
            return this.array[pos];
        }

        NodeProxy get(NodeId nodeId) {
            int low = 0;
            int high = this.length - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                NodeProxy p = this.array[mid];
                int cmp = p.getNodeId().compareTo(nodeId);
                if (cmp == 0) {
                    return p;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            return null;
        }

        DocumentImpl getOwnerDocument() {
            if (this.length == 0) {
                return null;
            }
            return this.array[0].getOwnerDocument();
        }

        void sort() {
            if (this.isSorted) {
                return;
            }
            FastQSort.sortByNodeId(this.array, 0, this.length - 1);
        }

        NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
            NodeProxy temp;
            if (includeSelf && (temp = this.get(nodeId)) != null) {
                return temp;
            }
            for (NodeId parentNodeId = nodeId.getParentId(); parentNodeId != null; parentNodeId = parentNodeId.getParentId()) {
                temp = this.get(parentNodeId);
                if (temp != null) {
                    return temp;
                }
                if (!directParent) continue;
                return null;
            }
            return null;
        }

        NodeProxy hasDescendantsInSet(NodeId ancestorId, int contextId, boolean includeSelf) {
            int cmp;
            NodeId id;
            int low = 0;
            int high = this.length - 1;
            int mid = 0;
            while (low <= high && !(id = this.array[mid = (low + high) / 2].getNodeId()).isDescendantOrSelfOf(ancestorId)) {
                cmp = id.compareTo(ancestorId);
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) {
                return null;
            }
            while (mid > 0 && this.array[mid - 1].getNodeId().compareTo(ancestorId) >= 0) {
                --mid;
            }
            NodeProxy ancestor = new NodeProxy(this.getOwnerDocument(), ancestorId, 1);
            boolean foundOne = false;
            for (int i = mid; i < this.length && (cmp = this.array[i].getNodeId().computeRelation(ancestorId)) > -1; ++i) {
                boolean add = true;
                if (cmp == 3) {
                    add = includeSelf;
                }
                if (!add) continue;
                if (-1 != contextId) {
                    ancestor.deepCopyContext(this.array[i], contextId);
                } else {
                    ancestor.copyContext(this.array[i]);
                }
                ancestor.addMatches(this.array[i]);
                foundOne = true;
            }
            return foundOne ? ancestor : null;
        }

        NodeSet getDescendantsInSet(NodeSet result, NodeProxy parent, boolean childOnly, boolean includeSelf, int mode, int contextId, boolean copyMatches) {
            NodeId parentId = parent.getNodeId();
            if (parentId == NodeId.DOCUMENT_NODE) {
                block8: for (int i = 0; i < this.length; ++i) {
                    boolean add;
                    if (childOnly) {
                        add = this.array[i].getNodeId().getTreeLevel() == 1;
                    } else if (includeSelf) {
                        add = true;
                    } else {
                        boolean bl = add = this.array[i].getNodeId() != NodeId.DOCUMENT_NODE;
                    }
                    if (!add) continue;
                    switch (mode) {
                        case 1: {
                            if (-1 != contextId) {
                                this.array[i].deepCopyContext(parent, contextId);
                            } else {
                                this.array[i].copyContext(parent);
                            }
                            if (copyMatches) {
                                this.array[i].addMatches(parent);
                            }
                            result.add(this.array[i]);
                            continue block8;
                        }
                        case 0: {
                            if (-1 != contextId) {
                                parent.deepCopyContext(this.array[i], contextId);
                            } else {
                                parent.copyContext(this.array[i]);
                            }
                            if (copyMatches) {
                                parent.addMatches(this.array[i]);
                            }
                            result.add(parent, 1);
                        }
                    }
                }
            } else {
                int cmp;
                NodeProxy p;
                int low = 0;
                int high = this.length - 1;
                int mid = 0;
                while (low <= high && !(p = this.array[mid = (low + high) / 2]).getNodeId().isDescendantOrSelfOf(parentId)) {
                    cmp = p.getNodeId().compareTo(parentId);
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    low = mid + 1;
                }
                if (low > high) {
                    return result;
                }
                while (mid > 0 && this.array[mid - 1].getNodeId().compareTo(parentId) > -1) {
                    --mid;
                }
                block11: for (int i = mid; i < this.length && (cmp = this.array[i].getNodeId().computeRelation(parentId)) > -1; ++i) {
                    boolean add = true;
                    if (childOnly) {
                        add = cmp == 1;
                    } else if (cmp == 3) {
                        add = includeSelf;
                    }
                    if (!add) continue;
                    switch (mode) {
                        case 1: {
                            if (-1 != contextId) {
                                this.array[i].deepCopyContext(parent, contextId);
                            } else {
                                this.array[i].copyContext(parent);
                            }
                            this.array[i].addMatches(parent);
                            result.add(this.array[i]);
                            continue block11;
                        }
                        case 0: {
                            if (-1 != contextId) {
                                parent.deepCopyContext(this.array[i], contextId);
                            } else {
                                parent.copyContext(this.array[i]);
                            }
                            parent.addMatches(this.array[i]);
                            result.add(parent, 1);
                        }
                    }
                }
            }
            return result;
        }

        int removeDuplicates(boolean mergeContext) {
            int j = 0;
            for (int i = 1; i < this.length; ++i) {
                if (!this.array[i].getNodeId().equals(this.array[j].getNodeId())) {
                    if (i == ++j) continue;
                    this.array[j] = this.array[i];
                    continue;
                }
                if (mergeContext) {
                    this.array[j].addContext(this.array[i]);
                }
                this.array[j].addMatches(this.array[i]);
            }
            this.length = ++j;
            return this.length;
        }

        void determineIndexType() {
            if (ExtArrayNodeSet.this.indexType == 12) {
                for (int i = 0; i < this.length; ++i) {
                    NodeProxy node = this.array[i];
                    if (node.getOwnerDocument().getCollection().isTempCollection()) {
                        ExtArrayNodeSet.this.indexType = 11;
                        break;
                    }
                    int nodeIndexType = node.getIndexType();
                    if (ExtArrayNodeSet.this.indexType == 12) {
                        ExtArrayNodeSet.this.indexType = nodeIndexType;
                        continue;
                    }
                    if (ExtArrayNodeSet.this.indexType == nodeIndexType) continue;
                    ExtArrayNodeSet.this.indexType = 11;
                }
            }
        }

        void setSelfAsContext(int contextId) {
            for (int i = 0; i < this.length; ++i) {
                this.array[i].addContextNode(contextId, this.array[i]);
            }
        }
    }

    private class CollectionIterator
    implements Iterator<Collection> {
        private final Iterator<Collection> iterator;

        CollectionIterator() {
            if (ExtArrayNodeSet.this.partCount > 0) {
                ObjectHashSet<Collection> collections = new ObjectHashSet<Collection>(ExtArrayNodeSet.this.partCount);
                for (int i = 0; i < ExtArrayNodeSet.this.partCount; ++i) {
                    collections.add(ExtArrayNodeSet.this.parts[i].getOwnerDocument().getCollection());
                }
                this.iterator = collections.iterator();
            } else {
                this.iterator = null;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public final Collection next() {
            return this.iterator.next();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class DocumentIterator
    implements Iterator<DocumentImpl> {
        private int currentDoc = 0;

        private DocumentIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.currentDoc < ExtArrayNodeSet.this.partCount;
        }

        @Override
        public final DocumentImpl next() {
            if (this.currentDoc == ExtArrayNodeSet.this.partCount) {
                throw new NoSuchElementException();
            }
            return ExtArrayNodeSet.this.parts[this.currentDoc++].getOwnerDocument();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

