/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.exist.numbering.NodeId;

public abstract class Match
implements Comparable<Match> {
    private final int context;
    protected final NodeId nodeId;
    private final String matchTerm;
    private int[] offsets;
    private int[] lengths;
    private int currentOffset = 0;
    protected Match nextMatch = null;

    protected Match(int contextId, NodeId nodeId, String matchTerm) {
        this(contextId, nodeId, matchTerm, 1);
    }

    protected Match(int contextId, NodeId nodeId, String matchTerm, int frequency) {
        this.context = contextId;
        this.nodeId = nodeId;
        this.matchTerm = matchTerm;
        this.offsets = new int[frequency];
        this.lengths = new int[frequency];
    }

    protected Match(Match match) {
        this.context = match.context;
        this.nodeId = match.nodeId;
        this.matchTerm = match.matchTerm;
        this.offsets = match.offsets;
        this.lengths = match.lengths;
        this.currentOffset = match.currentOffset;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public int getFrequency() {
        return this.currentOffset;
    }

    public int getContextId() {
        return this.context;
    }

    public abstract Match createInstance(int var1, NodeId var2, String var3);

    public abstract Match newCopy();

    public abstract String getIndexId();

    public void addOffset(int offset, int length) {
        if (this.currentOffset == this.offsets.length) {
            int[] noffsets = new int[this.currentOffset + 1];
            System.arraycopy(this.offsets, 0, noffsets, 0, this.currentOffset);
            this.offsets = noffsets;
            int[] nlengths = new int[this.currentOffset + 1];
            System.arraycopy(this.lengths, 0, nlengths, 0, this.currentOffset);
            this.lengths = nlengths;
        }
        this.offsets[this.currentOffset] = offset;
        this.lengths[this.currentOffset++] = length;
    }

    private void addOffset(Offset offset) {
        this.addOffset(offset.offset, offset.length);
    }

    private void addOffsets(Collection<Offset> offsets) {
        offsets.forEach(this::addOffset);
    }

    public Offset getOffset(int pos) {
        return new Offset(this.offsets[pos], this.lengths[pos]);
    }

    public List<Offset> getOffsets() {
        ArrayList<Offset> result = new ArrayList<Offset>(this.currentOffset);
        for (int i = 0; i < this.currentOffset; ++i) {
            result.add(this.getOffset(i));
        }
        return result;
    }

    public Match continuedBy(Match other) {
        return this.followedBy(other, 0, 0);
    }

    public Match followedBy(Match other, int minDistance, int maxDistance) {
        LinkedList<Offset> newMatchOffsets = new LinkedList<Offset>();
        for (int i = 0; i < this.currentOffset; ++i) {
            for (int j = 0; j < other.currentOffset; ++j) {
                int distance = other.offsets[j] - (this.offsets[i] + this.lengths[i]);
                if (distance < minDistance || distance > maxDistance) continue;
                newMatchOffsets.add(new Offset(this.offsets[i], this.lengths[i] + distance + other.lengths[j]));
            }
        }
        if (newMatchOffsets.isEmpty()) {
            return null;
        }
        int wildCardSize = ((Offset)newMatchOffsets.get(0)).length - this.matchTerm.length() - other.matchTerm.length();
        StringBuilder matched = new StringBuilder(this.matchTerm);
        for (int ii = 0; ii < wildCardSize; ++ii) {
            matched.append('?');
        }
        matched.append(other.matchTerm);
        Match result = this.createInstance(this.context, this.nodeId, matched.toString());
        result.addOffsets(newMatchOffsets);
        return result;
    }

    public Match expandBackward(int minExpand, int maxExpand) {
        Match result = null;
        for (int i = 0; i < this.currentOffset; ++i) {
            if (this.offsets[i] - minExpand < 0) continue;
            if (result == null) {
                StringBuilder matched = new StringBuilder();
                for (int ii = 0; ii < minExpand; ++ii) {
                    matched.append('?');
                }
                matched.append(this.matchTerm);
                result = this.createInstance(this.context, this.nodeId, matched.toString());
            }
            int expand = Math.min(this.offsets[i], maxExpand);
            result.addOffset(this.offsets[i] - expand, this.lengths[i] + expand);
        }
        return result;
    }

    public Match expandForward(int minExpand, int maxExpand, int dataLength) {
        Match result = null;
        for (int i = 0; i < this.currentOffset; ++i) {
            if (this.offsets[i] + this.lengths[i] + minExpand > dataLength) continue;
            int expand = Math.min(dataLength - this.offsets[i] - this.lengths[i], maxExpand);
            if (result == null) {
                StringBuilder matched = new StringBuilder(this.matchTerm);
                for (int ii = 0; ii < expand; ++ii) {
                    matched.append('?');
                }
                result = this.createInstance(this.context, this.nodeId, matched.toString());
            }
            result.addOffset(this.offsets[i], this.lengths[i] + expand);
        }
        return result;
    }

    private Match filterOffsets(Predicate<Offset> predicate) {
        Match result = this.createInstance(this.context, this.nodeId, this.matchTerm);
        this.getOffsets().stream().filter(predicate).forEach(result::addOffset);
        if (result.currentOffset == 0) {
            return null;
        }
        return result;
    }

    public Match filterOffsetsStartingAt(int pos) {
        return this.filterOffsets(offset -> ((Offset)offset).offset == pos);
    }

    public Match filterOffsetsEndingAt(int pos) {
        return this.filterOffsets(offset -> ((Offset)offset).offset + ((Offset)offset).length == pos);
    }

    public Match filterOutOverlappingOffsets() {
        if (this.currentOffset == 0) {
            return this.newCopy();
        }
        List<Offset> newMatchOffsets = this.getOffsets();
        Collections.sort(newMatchOffsets, (o1, o2) -> {
            int lengthDiff = ((Offset)o2).length - ((Offset)o1).length;
            if (lengthDiff != 0) {
                return lengthDiff;
            }
            return ((Offset)o1).offset - ((Offset)o2).offset;
        });
        LinkedList<Offset> nonOverlappingMatchOffsets = new LinkedList<Offset>();
        nonOverlappingMatchOffsets.add(newMatchOffsets.remove(0));
        for (Offset o : newMatchOffsets) {
            boolean overlapsExistingOffset = false;
            for (Offset eo : nonOverlappingMatchOffsets) {
                if (!eo.overlaps(o)) continue;
                overlapsExistingOffset = true;
                break;
            }
            if (overlapsExistingOffset) continue;
            nonOverlappingMatchOffsets.add(o);
        }
        Match result = this.createInstance(this.context, this.nodeId, this.matchTerm);
        result.addOffsets(nonOverlappingMatchOffsets);
        return result;
    }

    public boolean hasMatchAt(int pos) {
        for (int i = 0; i < this.currentOffset; ++i) {
            if (this.offsets[i] != pos) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchAround(int pos) {
        for (int i = 0; i < this.currentOffset; ++i) {
            if (this.offsets[i] + this.lengths[i] < pos) continue;
            return true;
        }
        return false;
    }

    public void mergeOffsets(Match other) {
        for (int i = 0; i < other.currentOffset; ++i) {
            if (this.hasMatchAt(other.offsets[i])) continue;
            this.addOffset(other.offsets[i], other.lengths[i]);
        }
    }

    public Match getNextMatch() {
        return this.nextMatch;
    }

    public static boolean matchListEquals(Match m1, Match m2) {
        Match n1 = m1;
        Match n2 = m2;
        while (n1 != null) {
            if (n2 == null || n1 != n2) {
                return false;
            }
            n1 = n1.nextMatch;
            n2 = n2.nextMatch;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Match)) {
            return false;
        }
        Match om = (Match)other;
        return om.matchTerm != null && om.matchTerm.equals(this.matchTerm) && om.nodeId.equals(this.nodeId);
    }

    public boolean matchEquals(Match other) {
        if (this == other) {
            return true;
        }
        return (this.nodeId == other.nodeId || this.nodeId.equals(other.nodeId)) && this.matchTerm.equals(other.matchTerm);
    }

    @Override
    public int compareTo(Match other) {
        return this.matchTerm.compareTo(other.matchTerm);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.matchTerm != null) {
            buf.append(this.matchTerm);
        }
        for (int i = 0; i < this.currentOffset; ++i) {
            buf.append(" [");
            buf.append(this.offsets[i]).append(':').append(this.lengths[i]);
            buf.append("]");
        }
        if (this.nextMatch != null) {
            buf.append(' ').append(this.nextMatch.toString());
        }
        return buf.toString();
    }

    public static final class Offset
    implements Comparable<Offset> {
        private final int offset;
        private final int length;

        public Offset(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public int compareTo(Offset other) {
            return this.offset - other.offset;
        }

        public boolean overlaps(Offset other) {
            return other.offset >= this.offset && other.offset < this.offset + this.length || this.offset >= other.offset && this.offset < other.offset + other.length;
        }
    }
}

