/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import org.exist.dom.QName;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.SymbolTable;
import org.exist.numbering.NodeId;
import org.w3c.dom.DOMException;

public abstract class NamedNode<T extends NamedNode>
extends StoredNode<T> {
    protected QName nodeName = null;

    public NamedNode(short nodeType) {
        super(nodeType);
    }

    public NamedNode(short nodeType, QName qname) {
        super(nodeType);
        this.nodeName = qname;
    }

    protected NamedNode(short nodeType, NodeId nodeId, QName qname) {
        super(nodeType, nodeId);
        this.nodeName = qname;
    }

    protected NamedNode(NamedNode other) {
        super(other);
        this.nodeName = other.nodeName;
    }

    @Override
    public NamedNode extract() {
        return new NamedNode(this){};
    }

    @Override
    public QName getQName() {
        return this.nodeName;
    }

    @Override
    public void setQName(QName qname) {
        this.nodeName = qname;
    }

    @Override
    public String getLocalName() {
        return this.getQName().getLocalPart();
    }

    @Deprecated
    public void setNodeName(QName name) {
        this.nodeName = name;
    }

    public void setNodeName(QName name, SymbolTable symbols) throws DOMException {
        this.nodeName = name;
        if (symbols.getSymbol(this.nodeName.getLocalPart()) < 0) {
            throw new DOMException(15, "Too many element/attribute names registered in the database. No of distinct names is limited to 16bit. Aborting store.");
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.nodeName = null;
    }
}

