/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.nio.charset.StandardCharsets;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.util.ByteConversion;
import org.exist.util.pool.NodePool;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class ProcessingInstructionImpl
extends StoredNode
implements ProcessingInstruction {
    public static final int LENGTH_TARGET_DATA = 4;
    protected String target = null;
    protected String data = null;

    public ProcessingInstructionImpl() {
        super((short)7);
    }

    public ProcessingInstructionImpl(NodeId nodeId, String target, String data) {
        super((short)7, nodeId);
        this.target = target;
        this.data = data;
    }

    public ProcessingInstructionImpl(String target, String data) {
        this(null, target, data);
    }

    @Override
    public void clear() {
        super.clear();
        this.target = null;
        this.data = null;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    @Override
    public String getData() {
        return this.data;
    }

    @Override
    public void setData(String data) {
        this.data = data;
    }

    @Override
    public String getBaseURI() {
        StoredNode parent = this.getParentStoredNode();
        if (parent != null) {
            return parent.getBaseURI();
        }
        return this.getOwnerDocument().getBaseURI();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<?");
        buf.append(this.target);
        buf.append(" ");
        buf.append(this.data);
        buf.append(" ?>");
        return buf.toString();
    }

    @Override
    public byte[] serialize() {
        byte[] td = this.target.getBytes(StandardCharsets.UTF_8);
        byte[] dd = this.data.getBytes(StandardCharsets.UTF_8);
        int nodeIdLen = this.nodeId.size();
        byte[] d = new byte[td.length + dd.length + nodeIdLen + 7];
        int pos = 0;
        d[pos] = 64;
        ByteConversion.shortToByte((short)this.nodeId.units(), d, ++pos);
        this.nodeId.serialize(d, pos += 2);
        ByteConversion.intToByte(td.length, d, pos += nodeIdLen);
        System.arraycopy(td, 0, d, pos += 4, td.length);
        System.arraycopy(dd, 0, d, pos += td.length, dd.length);
        return d;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        int pos = start;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        int nodeIdLen = dln.size();
        int l = ByteConversion.byteToInt(data, pos += nodeIdLen);
        String target = new String(data, pos += 4, l, StandardCharsets.UTF_8);
        String cdata = new String(data, pos += l, len - (pos - start), StandardCharsets.UTF_8);
        ProcessingInstructionImpl pi = pooled ? (ProcessingInstructionImpl)NodePool.getInstance().borrowNode((short)7) : new ProcessingInstructionImpl();
        pi.setTarget(target);
        pi.data = cdata;
        pi.setNodeId(dln);
        return pi;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }
}

