/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.util.pool.NodePool;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class TextImpl
extends AbstractCharacterData
implements Text {
    public TextImpl() {
        super((short)3);
    }

    public TextImpl(String data) {
        super((short)3, data);
    }

    public TextImpl(NodeId nodeId, String data) {
        super((short)3, nodeId, data);
    }

    @Override
    public byte[] serialize() {
        int nodeIdLen = this.nodeId.size();
        byte[] data = ByteArrayPool.getByteArray(1 + nodeIdLen + 2 + this.cdata.UTF8Size());
        int pos = 0;
        data[pos] = 0;
        ByteConversion.shortToByte((short)this.nodeId.units(), data, ++pos);
        this.nodeId.serialize(data, pos += 2);
        this.cdata.UTF8Encode(data, pos += nodeIdLen);
        return data;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        TextImpl text = pooled ? (TextImpl)NodePool.getInstance().borrowNode((short)3) : new TextImpl();
        int pos = start;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        text.setNodeId(dln);
        int nodeIdLen = dln.size();
        text.cdata = UTF8.decode(data, pos += nodeIdLen, len - (1 + nodeIdLen + 2));
        return text;
    }

    @Override
    public String toString(boolean top) {
        if (top) {
            return "<exist:text xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" exist:id=\"" + this.getNodeId() + "\" exist:source=\"" + this.getOwnerDocument().getFileURI() + "\">" + this.getData() + "</exist:text>";
        }
        return this.toString();
    }

    @Override
    public String getWholeText() {
        return null;
    }

    @Override
    public boolean isElementContentWhitespace() {
        return false;
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        return null;
    }

    @Override
    public Text splitText(int offset) throws DOMException {
        return null;
    }

    @Override
    public String getBaseURI() {
        Node parent = this.getParentNode();
        if (parent != null) {
            return parent.getBaseURI();
        }
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return false;
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    @Override
    public Object getUserData(String key) {
        return null;
    }
}

